<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$currency_list = new currency_list();

// Run the page
$currency_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$currency_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$currency->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcurrencylist = currentForm = new ew.Form("fcurrencylist", "list");
fcurrencylist.formKeyCountName = '<?php echo $currency_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcurrencylist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcurrencylist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcurrencylist.lists["x_status"] = <?php echo $currency_list->status->Lookup->toClientList() ?>;
fcurrencylist.lists["x_status"].options = <?php echo JsonEncode($currency_list->status->options(FALSE, TRUE)) ?>;
fcurrencylist.lists["x_operator"] = <?php echo $currency_list->operator->Lookup->toClientList() ?>;
fcurrencylist.lists["x_operator"].options = <?php echo JsonEncode($currency_list->operator->lookupOptions()) ?>;
fcurrencylist.lists["x_default_currency"] = <?php echo $currency_list->default_currency->Lookup->toClientList() ?>;
fcurrencylist.lists["x_default_currency"].options = <?php echo JsonEncode($currency_list->default_currency->options(FALSE, TRUE)) ?>;

// Form object for search
var fcurrencylistsrch = currentSearchForm = new ew.Form("fcurrencylistsrch");

// Filters
fcurrencylistsrch.filterList = <?php echo $currency_list->getFilterList() ?>;

// Init search panel as collapsed
fcurrencylistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$currency->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($currency_list->TotalRecs > 0 && $currency_list->ExportOptions->visible()) { ?>
<?php $currency_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($currency_list->ImportOptions->visible()) { ?>
<?php $currency_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($currency_list->SearchOptions->visible()) { ?>
<?php $currency_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($currency_list->FilterOptions->visible()) { ?>
<?php $currency_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$currency_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$currency->isExport() && !$currency->CurrentAction) { ?>
<form name="fcurrencylistsrch" id="fcurrencylistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($currency_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fcurrencylistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="currency">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($currency_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($currency_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $currency_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($currency_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($currency_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($currency_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($currency_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $currency_list->showPageHeader(); ?>
<?php
$currency_list->showMessage();
?>
<?php if ($currency_list->TotalRecs > 0 || $currency->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($currency_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> currency">
<?php if (!$currency->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$currency->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($currency_list->Pager)) $currency_list->Pager = new PrevNextPager($currency_list->StartRec, $currency_list->DisplayRecs, $currency_list->TotalRecs, $currency_list->AutoHidePager) ?>
<?php if ($currency_list->Pager->RecordCount > 0 && $currency_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($currency_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $currency_list->pageUrl() ?>start=<?php echo $currency_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($currency_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $currency_list->pageUrl() ?>start=<?php echo $currency_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $currency_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($currency_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $currency_list->pageUrl() ?>start=<?php echo $currency_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($currency_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $currency_list->pageUrl() ?>start=<?php echo $currency_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $currency_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($currency_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $currency_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $currency_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $currency_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($currency_list->TotalRecs > 0 && (!$currency_list->AutoHidePageSizeSelector || $currency_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="currency">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($currency_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($currency_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($currency_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($currency_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($currency_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($currency->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $currency_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcurrencylist" id="fcurrencylist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($currency_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $currency_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="currency">
<div id="gmp_currency" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($currency_list->TotalRecs > 0 || $currency->isGridEdit()) { ?>
<table id="tbl_currencylist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$currency_list->RowType = ROWTYPE_HEADER;

// Render list options
$currency_list->renderListOptions();

// Render list options (header, left)
$currency_list->ListOptions->render("header", "left");
?>
<?php if ($currency->id->Visible) { // id ?>
	<?php if ($currency->sortUrl($currency->id) == "") { ?>
		<th data-name="id" class="<?php echo $currency->id->headerCellClass() ?>"><div id="elh_currency_id" class="currency_id"><div class="ew-table-header-caption"><?php echo $currency->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $currency->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $currency->SortUrl($currency->id) ?>',2);"><div id="elh_currency_id" class="currency_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $currency->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($currency->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($currency->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($currency->name->Visible) { // name ?>
	<?php if ($currency->sortUrl($currency->name) == "") { ?>
		<th data-name="name" class="<?php echo $currency->name->headerCellClass() ?>"><div id="elh_currency_name" class="currency_name"><div class="ew-table-header-caption"><?php echo $currency->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $currency->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $currency->SortUrl($currency->name) ?>',2);"><div id="elh_currency_name" class="currency_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $currency->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($currency->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($currency->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($currency->code->Visible) { // code ?>
	<?php if ($currency->sortUrl($currency->code) == "") { ?>
		<th data-name="code" class="<?php echo $currency->code->headerCellClass() ?>"><div id="elh_currency_code" class="currency_code"><div class="ew-table-header-caption"><?php echo $currency->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $currency->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $currency->SortUrl($currency->code) ?>',2);"><div id="elh_currency_code" class="currency_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $currency->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($currency->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($currency->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($currency->status->Visible) { // status ?>
	<?php if ($currency->sortUrl($currency->status) == "") { ?>
		<th data-name="status" class="<?php echo $currency->status->headerCellClass() ?>"><div id="elh_currency_status" class="currency_status"><div class="ew-table-header-caption"><?php echo $currency->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $currency->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $currency->SortUrl($currency->status) ?>',2);"><div id="elh_currency_status" class="currency_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $currency->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($currency->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($currency->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($currency->operator->Visible) { // operator ?>
	<?php if ($currency->sortUrl($currency->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $currency->operator->headerCellClass() ?>"><div id="elh_currency_operator" class="currency_operator"><div class="ew-table-header-caption"><?php echo $currency->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $currency->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $currency->SortUrl($currency->operator) ?>',2);"><div id="elh_currency_operator" class="currency_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $currency->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($currency->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($currency->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($currency->datetime->Visible) { // datetime ?>
	<?php if ($currency->sortUrl($currency->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $currency->datetime->headerCellClass() ?>"><div id="elh_currency_datetime" class="currency_datetime"><div class="ew-table-header-caption"><?php echo $currency->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $currency->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $currency->SortUrl($currency->datetime) ?>',2);"><div id="elh_currency_datetime" class="currency_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $currency->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($currency->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($currency->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($currency->symbol->Visible) { // symbol ?>
	<?php if ($currency->sortUrl($currency->symbol) == "") { ?>
		<th data-name="symbol" class="<?php echo $currency->symbol->headerCellClass() ?>"><div id="elh_currency_symbol" class="currency_symbol"><div class="ew-table-header-caption"><?php echo $currency->symbol->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="symbol" class="<?php echo $currency->symbol->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $currency->SortUrl($currency->symbol) ?>',2);"><div id="elh_currency_symbol" class="currency_symbol">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $currency->symbol->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($currency->symbol->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($currency->symbol->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($currency->default_currency->Visible) { // default_currency ?>
	<?php if ($currency->sortUrl($currency->default_currency) == "") { ?>
		<th data-name="default_currency" class="<?php echo $currency->default_currency->headerCellClass() ?>"><div id="elh_currency_default_currency" class="currency_default_currency"><div class="ew-table-header-caption"><?php echo $currency->default_currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="default_currency" class="<?php echo $currency->default_currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $currency->SortUrl($currency->default_currency) ?>',2);"><div id="elh_currency_default_currency" class="currency_default_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $currency->default_currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($currency->default_currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($currency->default_currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($currency->exchange_inr->Visible) { // exchange_inr ?>
	<?php if ($currency->sortUrl($currency->exchange_inr) == "") { ?>
		<th data-name="exchange_inr" class="<?php echo $currency->exchange_inr->headerCellClass() ?>"><div id="elh_currency_exchange_inr" class="currency_exchange_inr"><div class="ew-table-header-caption"><?php echo $currency->exchange_inr->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="exchange_inr" class="<?php echo $currency->exchange_inr->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $currency->SortUrl($currency->exchange_inr) ?>',2);"><div id="elh_currency_exchange_inr" class="currency_exchange_inr">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $currency->exchange_inr->caption() ?></span><span class="ew-table-header-sort"><?php if ($currency->exchange_inr->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($currency->exchange_inr->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$currency_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($currency->ExportAll && $currency->isExport()) {
	$currency_list->StopRec = $currency_list->TotalRecs;
} else {

	// Set the last record to display
	if ($currency_list->TotalRecs > $currency_list->StartRec + $currency_list->DisplayRecs - 1)
		$currency_list->StopRec = $currency_list->StartRec + $currency_list->DisplayRecs - 1;
	else
		$currency_list->StopRec = $currency_list->TotalRecs;
}
$currency_list->RecCnt = $currency_list->StartRec - 1;
if ($currency_list->Recordset && !$currency_list->Recordset->EOF) {
	$currency_list->Recordset->moveFirst();
	$selectLimit = $currency_list->UseSelectLimit;
	if (!$selectLimit && $currency_list->StartRec > 1)
		$currency_list->Recordset->move($currency_list->StartRec - 1);
} elseif (!$currency->AllowAddDeleteRow && $currency_list->StopRec == 0) {
	$currency_list->StopRec = $currency->GridAddRowCount;
}

// Initialize aggregate
$currency->RowType = ROWTYPE_AGGREGATEINIT;
$currency->resetAttributes();
$currency_list->renderRow();
while ($currency_list->RecCnt < $currency_list->StopRec) {
	$currency_list->RecCnt++;
	if ($currency_list->RecCnt >= $currency_list->StartRec) {
		$currency_list->RowCnt++;

		// Set up key count
		$currency_list->KeyCount = $currency_list->RowIndex;

		// Init row class and style
		$currency->resetAttributes();
		$currency->CssClass = "";
		if ($currency->isGridAdd()) {
		} else {
			$currency_list->loadRowValues($currency_list->Recordset); // Load row values
		}
		$currency->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$currency->RowAttrs = array_merge($currency->RowAttrs, array('data-rowindex'=>$currency_list->RowCnt, 'id'=>'r' . $currency_list->RowCnt . '_currency', 'data-rowtype'=>$currency->RowType));

		// Render row
		$currency_list->renderRow();

		// Render list options
		$currency_list->renderListOptions();
?>
	<tr<?php echo $currency->rowAttributes() ?>>
<?php

// Render list options (body, left)
$currency_list->ListOptions->render("body", "left", $currency_list->RowCnt);
?>
	<?php if ($currency->id->Visible) { // id ?>
		<td data-name="id"<?php echo $currency->id->cellAttributes() ?>>
<span id="el<?php echo $currency_list->RowCnt ?>_currency_id" class="currency_id">
<span<?php echo $currency->id->viewAttributes() ?>>
<?php echo $currency->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($currency->name->Visible) { // name ?>
		<td data-name="name"<?php echo $currency->name->cellAttributes() ?>>
<span id="el<?php echo $currency_list->RowCnt ?>_currency_name" class="currency_name">
<span<?php echo $currency->name->viewAttributes() ?>>
<?php echo $currency->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($currency->code->Visible) { // code ?>
		<td data-name="code"<?php echo $currency->code->cellAttributes() ?>>
<span id="el<?php echo $currency_list->RowCnt ?>_currency_code" class="currency_code">
<span<?php echo $currency->code->viewAttributes() ?>>
<?php echo $currency->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($currency->status->Visible) { // status ?>
		<td data-name="status"<?php echo $currency->status->cellAttributes() ?>>
<span id="el<?php echo $currency_list->RowCnt ?>_currency_status" class="currency_status">
<span<?php echo $currency->status->viewAttributes() ?>>
<?php echo $currency->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($currency->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $currency->operator->cellAttributes() ?>>
<span id="el<?php echo $currency_list->RowCnt ?>_currency_operator" class="currency_operator">
<span<?php echo $currency->operator->viewAttributes() ?>>
<?php echo $currency->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($currency->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $currency->datetime->cellAttributes() ?>>
<span id="el<?php echo $currency_list->RowCnt ?>_currency_datetime" class="currency_datetime">
<span<?php echo $currency->datetime->viewAttributes() ?>>
<?php echo $currency->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($currency->symbol->Visible) { // symbol ?>
		<td data-name="symbol"<?php echo $currency->symbol->cellAttributes() ?>>
<span id="el<?php echo $currency_list->RowCnt ?>_currency_symbol" class="currency_symbol">
<span<?php echo $currency->symbol->viewAttributes() ?>>
<?php echo $currency->symbol->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($currency->default_currency->Visible) { // default_currency ?>
		<td data-name="default_currency"<?php echo $currency->default_currency->cellAttributes() ?>>
<span id="el<?php echo $currency_list->RowCnt ?>_currency_default_currency" class="currency_default_currency">
<span<?php echo $currency->default_currency->viewAttributes() ?>>
<?php echo $currency->default_currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($currency->exchange_inr->Visible) { // exchange_inr ?>
		<td data-name="exchange_inr"<?php echo $currency->exchange_inr->cellAttributes() ?>>
<span id="el<?php echo $currency_list->RowCnt ?>_currency_exchange_inr" class="currency_exchange_inr">
<span<?php echo $currency->exchange_inr->viewAttributes() ?>>
<?php echo $currency->exchange_inr->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$currency_list->ListOptions->render("body", "right", $currency_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$currency->isGridAdd())
		$currency_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$currency->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($currency_list->Recordset)
	$currency_list->Recordset->Close();
?>
<?php if (!$currency->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$currency->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($currency_list->Pager)) $currency_list->Pager = new PrevNextPager($currency_list->StartRec, $currency_list->DisplayRecs, $currency_list->TotalRecs, $currency_list->AutoHidePager) ?>
<?php if ($currency_list->Pager->RecordCount > 0 && $currency_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($currency_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $currency_list->pageUrl() ?>start=<?php echo $currency_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($currency_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $currency_list->pageUrl() ?>start=<?php echo $currency_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $currency_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($currency_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $currency_list->pageUrl() ?>start=<?php echo $currency_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($currency_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $currency_list->pageUrl() ?>start=<?php echo $currency_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $currency_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($currency_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $currency_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $currency_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $currency_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($currency_list->TotalRecs > 0 && (!$currency_list->AutoHidePageSizeSelector || $currency_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="currency">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($currency_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($currency_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($currency_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($currency_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($currency_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($currency->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $currency_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($currency_list->TotalRecs == 0 && !$currency->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $currency_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$currency_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$currency->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$currency->isExport()) { ?>
<script>
ew.scrollableTable("gmp_currency", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$currency_list->terminate();
?>