<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$currency_view = new currency_view();

// Run the page
$currency_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$currency_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$currency->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fcurrencyview = currentForm = new ew.Form("fcurrencyview", "view");

// Form_CustomValidate event
fcurrencyview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcurrencyview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcurrencyview.lists["x_status"] = <?php echo $currency_view->status->Lookup->toClientList() ?>;
fcurrencyview.lists["x_status"].options = <?php echo JsonEncode($currency_view->status->options(FALSE, TRUE)) ?>;
fcurrencyview.lists["x_operator"] = <?php echo $currency_view->operator->Lookup->toClientList() ?>;
fcurrencyview.lists["x_operator"].options = <?php echo JsonEncode($currency_view->operator->lookupOptions()) ?>;
fcurrencyview.lists["x_default_currency"] = <?php echo $currency_view->default_currency->Lookup->toClientList() ?>;
fcurrencyview.lists["x_default_currency"].options = <?php echo JsonEncode($currency_view->default_currency->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$currency->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $currency_view->ExportOptions->render("body") ?>
<?php $currency_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $currency_view->showPageHeader(); ?>
<?php
$currency_view->showMessage();
?>
<form name="fcurrencyview" id="fcurrencyview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($currency_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $currency_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="currency">
<input type="hidden" name="modal" value="<?php echo (int)$currency_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($currency->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $currency_view->TableLeftColumnClass ?>"><span id="elh_currency_id"><?php echo $currency->id->caption() ?></span></td>
		<td data-name="id"<?php echo $currency->id->cellAttributes() ?>>
<span id="el_currency_id">
<span<?php echo $currency->id->viewAttributes() ?>>
<?php echo $currency->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($currency->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $currency_view->TableLeftColumnClass ?>"><span id="elh_currency_name"><?php echo $currency->name->caption() ?></span></td>
		<td data-name="name"<?php echo $currency->name->cellAttributes() ?>>
<span id="el_currency_name">
<span<?php echo $currency->name->viewAttributes() ?>>
<?php echo $currency->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($currency->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $currency_view->TableLeftColumnClass ?>"><span id="elh_currency_code"><?php echo $currency->code->caption() ?></span></td>
		<td data-name="code"<?php echo $currency->code->cellAttributes() ?>>
<span id="el_currency_code">
<span<?php echo $currency->code->viewAttributes() ?>>
<?php echo $currency->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($currency->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $currency_view->TableLeftColumnClass ?>"><span id="elh_currency_status"><?php echo $currency->status->caption() ?></span></td>
		<td data-name="status"<?php echo $currency->status->cellAttributes() ?>>
<span id="el_currency_status">
<span<?php echo $currency->status->viewAttributes() ?>>
<?php echo $currency->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($currency->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $currency_view->TableLeftColumnClass ?>"><span id="elh_currency_operator"><?php echo $currency->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $currency->operator->cellAttributes() ?>>
<span id="el_currency_operator">
<span<?php echo $currency->operator->viewAttributes() ?>>
<?php echo $currency->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($currency->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $currency_view->TableLeftColumnClass ?>"><span id="elh_currency_datetime"><?php echo $currency->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $currency->datetime->cellAttributes() ?>>
<span id="el_currency_datetime">
<span<?php echo $currency->datetime->viewAttributes() ?>>
<?php echo $currency->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($currency->symbol->Visible) { // symbol ?>
	<tr id="r_symbol">
		<td class="<?php echo $currency_view->TableLeftColumnClass ?>"><span id="elh_currency_symbol"><?php echo $currency->symbol->caption() ?></span></td>
		<td data-name="symbol"<?php echo $currency->symbol->cellAttributes() ?>>
<span id="el_currency_symbol">
<span<?php echo $currency->symbol->viewAttributes() ?>>
<?php echo $currency->symbol->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($currency->default_currency->Visible) { // default_currency ?>
	<tr id="r_default_currency">
		<td class="<?php echo $currency_view->TableLeftColumnClass ?>"><span id="elh_currency_default_currency"><?php echo $currency->default_currency->caption() ?></span></td>
		<td data-name="default_currency"<?php echo $currency->default_currency->cellAttributes() ?>>
<span id="el_currency_default_currency">
<span<?php echo $currency->default_currency->viewAttributes() ?>>
<?php echo $currency->default_currency->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($currency->exchange_inr->Visible) { // exchange_inr ?>
	<tr id="r_exchange_inr">
		<td class="<?php echo $currency_view->TableLeftColumnClass ?>"><span id="elh_currency_exchange_inr"><?php echo $currency->exchange_inr->caption() ?></span></td>
		<td data-name="exchange_inr"<?php echo $currency->exchange_inr->cellAttributes() ?>>
<span id="el_currency_exchange_inr">
<span<?php echo $currency->exchange_inr->viewAttributes() ?>>
<?php echo $currency->exchange_inr->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$currency_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$currency->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$currency_view->terminate();
?>