<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$customized_message_add = new customized_message_add();

// Run the page
$customized_message_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$customized_message_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fcustomized_messageadd = currentForm = new ew.Form("fcustomized_messageadd", "add");

// Validate form
fcustomized_messageadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($customized_message_add->reference->Required) { ?>
			elm = this.getElements("x" + infix + "_reference");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $customized_message->reference->caption(), $customized_message->reference->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($customized_message_add->message_type->Required) { ?>
			elm = this.getElements("x" + infix + "_message_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $customized_message->message_type->caption(), $customized_message->message_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($customized_message_add->wa_type->Required) { ?>
			elm = this.getElements("x" + infix + "_wa_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $customized_message->wa_type->caption(), $customized_message->wa_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($customized_message_add->wa_id->Required) { ?>
			elm = this.getElements("x" + infix + "_wa_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $customized_message->wa_id->caption(), $customized_message->wa_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($customized_message_add->mobile_no->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $customized_message->mobile_no->caption(), $customized_message->mobile_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($customized_message_add->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $customized_message->_email->caption(), $customized_message->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.checkEmail(elm.value))
				return this.onError(elm, "<?php echo JsEncode($customized_message->_email->errorMessage()) ?>");
		<?php if ($customized_message_add->subject->Required) { ?>
			elm = this.getElements("x" + infix + "_subject");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $customized_message->subject->caption(), $customized_message->subject->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($customized_message_add->message->Required) { ?>
			elm = this.getElements("x" + infix + "_message");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $customized_message->message->caption(), $customized_message->message->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($customized_message_add->sms->Required) { ?>
			elm = this.getElements("x" + infix + "_sms");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $customized_message->sms->caption(), $customized_message->sms->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($customized_message_add->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $customized_message->uploads->caption(), $customized_message->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($customized_message_add->b_type->Required) { ?>
			elm = this.getElements("x" + infix + "_b_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $customized_message->b_type->caption(), $customized_message->b_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($customized_message_add->b_1->Required) { ?>
			elm = this.getElements("x" + infix + "_b_1");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $customized_message->b_1->caption(), $customized_message->b_1->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($customized_message_add->b_2->Required) { ?>
			elm = this.getElements("x" + infix + "_b_2");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $customized_message->b_2->caption(), $customized_message->b_2->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($customized_message_add->b_3->Required) { ?>
			elm = this.getElements("x" + infix + "_b_3");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $customized_message->b_3->caption(), $customized_message->b_3->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($customized_message_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $customized_message->operator->caption(), $customized_message->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($customized_message_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $customized_message->datetime->caption(), $customized_message->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fcustomized_messageadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcustomized_messageadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcustomized_messageadd.lists["x_message_type"] = <?php echo $customized_message_add->message_type->Lookup->toClientList() ?>;
fcustomized_messageadd.lists["x_message_type"].options = <?php echo JsonEncode($customized_message_add->message_type->lookupOptions()) ?>;
fcustomized_messageadd.lists["x_wa_type"] = <?php echo $customized_message_add->wa_type->Lookup->toClientList() ?>;
fcustomized_messageadd.lists["x_wa_type"].options = <?php echo JsonEncode($customized_message_add->wa_type->lookupOptions()) ?>;
fcustomized_messageadd.lists["x_wa_id"] = <?php echo $customized_message_add->wa_id->Lookup->toClientList() ?>;
fcustomized_messageadd.lists["x_wa_id"].options = <?php echo JsonEncode($customized_message_add->wa_id->lookupOptions()) ?>;
fcustomized_messageadd.lists["x_b_type"] = <?php echo $customized_message_add->b_type->Lookup->toClientList() ?>;
fcustomized_messageadd.lists["x_b_type"].options = <?php echo JsonEncode($customized_message_add->b_type->options(FALSE, TRUE)) ?>;
fcustomized_messageadd.lists["x_operator"] = <?php echo $customized_message_add->operator->Lookup->toClientList() ?>;
fcustomized_messageadd.lists["x_operator"].options = <?php echo JsonEncode($customized_message_add->operator->lookupOptions()) ?>;
fcustomized_messageadd.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $customized_message_add->showPageHeader(); ?>
<?php
$customized_message_add->showMessage();
?>
<form name="fcustomized_messageadd" id="fcustomized_messageadd" class="<?php echo $customized_message_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($customized_message_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $customized_message_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="customized_message">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$customized_message_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($customized_message->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label id="elh_customized_message_reference" for="x_reference" class="<?php echo $customized_message_add->LeftColumnClass ?>"><?php echo $customized_message->reference->caption() ?><?php echo ($customized_message->reference->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $customized_message_add->RightColumnClass ?>"><div<?php echo $customized_message->reference->cellAttributes() ?>>
<span id="el_customized_message_reference">
<input type="text" data-table="customized_message" data-field="x_reference" name="x_reference" id="x_reference" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($customized_message->reference->getPlaceHolder()) ?>" value="<?php echo $customized_message->reference->EditValue ?>"<?php echo $customized_message->reference->editAttributes() ?>>
</span>
<?php echo $customized_message->reference->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($customized_message->message_type->Visible) { // message_type ?>
	<div id="r_message_type" class="form-group row">
		<label id="elh_customized_message_message_type" for="x_message_type" class="<?php echo $customized_message_add->LeftColumnClass ?>"><?php echo $customized_message->message_type->caption() ?><?php echo ($customized_message->message_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $customized_message_add->RightColumnClass ?>"><div<?php echo $customized_message->message_type->cellAttributes() ?>>
<span id="el_customized_message_message_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="customized_message" data-field="x_message_type" data-value-separator="<?php echo $customized_message->message_type->displayValueSeparatorAttribute() ?>" id="x_message_type" name="x_message_type"<?php echo $customized_message->message_type->editAttributes() ?>>
		<?php echo $customized_message->message_type->selectOptionListHtml("x_message_type") ?>
	</select>
</div>
<?php echo $customized_message->message_type->Lookup->getParamTag("p_x_message_type") ?>
</span>
<?php echo $customized_message->message_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($customized_message->wa_type->Visible) { // wa_type ?>
	<div id="r_wa_type" class="form-group row">
		<label id="elh_customized_message_wa_type" for="x_wa_type" class="<?php echo $customized_message_add->LeftColumnClass ?>"><?php echo $customized_message->wa_type->caption() ?><?php echo ($customized_message->wa_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $customized_message_add->RightColumnClass ?>"><div<?php echo $customized_message->wa_type->cellAttributes() ?>>
<span id="el_customized_message_wa_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="customized_message" data-field="x_wa_type" data-value-separator="<?php echo $customized_message->wa_type->displayValueSeparatorAttribute() ?>" id="x_wa_type" name="x_wa_type"<?php echo $customized_message->wa_type->editAttributes() ?>>
		<?php echo $customized_message->wa_type->selectOptionListHtml("x_wa_type") ?>
	</select>
</div>
<?php echo $customized_message->wa_type->Lookup->getParamTag("p_x_wa_type") ?>
</span>
<?php echo $customized_message->wa_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($customized_message->wa_id->Visible) { // wa_id ?>
	<div id="r_wa_id" class="form-group row">
		<label id="elh_customized_message_wa_id" for="x_wa_id" class="<?php echo $customized_message_add->LeftColumnClass ?>"><?php echo $customized_message->wa_id->caption() ?><?php echo ($customized_message->wa_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $customized_message_add->RightColumnClass ?>"><div<?php echo $customized_message->wa_id->cellAttributes() ?>>
<span id="el_customized_message_wa_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="customized_message" data-field="x_wa_id" data-value-separator="<?php echo $customized_message->wa_id->displayValueSeparatorAttribute() ?>" id="x_wa_id" name="x_wa_id"<?php echo $customized_message->wa_id->editAttributes() ?>>
		<?php echo $customized_message->wa_id->selectOptionListHtml("x_wa_id") ?>
	</select>
</div>
<?php echo $customized_message->wa_id->Lookup->getParamTag("p_x_wa_id") ?>
</span>
<?php echo $customized_message->wa_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($customized_message->mobile_no->Visible) { // mobile_no ?>
	<div id="r_mobile_no" class="form-group row">
		<label id="elh_customized_message_mobile_no" for="x_mobile_no" class="<?php echo $customized_message_add->LeftColumnClass ?>"><?php echo $customized_message->mobile_no->caption() ?><?php echo ($customized_message->mobile_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $customized_message_add->RightColumnClass ?>"><div<?php echo $customized_message->mobile_no->cellAttributes() ?>>
<span id="el_customized_message_mobile_no">
<input type="text" data-table="customized_message" data-field="x_mobile_no" name="x_mobile_no" id="x_mobile_no" placeholder="<?php echo HtmlEncode($customized_message->mobile_no->getPlaceHolder()) ?>" value="<?php echo $customized_message->mobile_no->EditValue ?>"<?php echo $customized_message->mobile_no->editAttributes() ?>>
</span>
<?php echo $customized_message->mobile_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($customized_message->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label id="elh_customized_message__email" for="x__email" class="<?php echo $customized_message_add->LeftColumnClass ?>"><?php echo $customized_message->_email->caption() ?><?php echo ($customized_message->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $customized_message_add->RightColumnClass ?>"><div<?php echo $customized_message->_email->cellAttributes() ?>>
<span id="el_customized_message__email">
<input type="text" data-table="customized_message" data-field="x__email" name="x__email" id="x__email" placeholder="<?php echo HtmlEncode($customized_message->_email->getPlaceHolder()) ?>" value="<?php echo $customized_message->_email->EditValue ?>"<?php echo $customized_message->_email->editAttributes() ?>>
</span>
<?php echo $customized_message->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($customized_message->subject->Visible) { // subject ?>
	<div id="r_subject" class="form-group row">
		<label id="elh_customized_message_subject" for="x_subject" class="<?php echo $customized_message_add->LeftColumnClass ?>"><?php echo $customized_message->subject->caption() ?><?php echo ($customized_message->subject->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $customized_message_add->RightColumnClass ?>"><div<?php echo $customized_message->subject->cellAttributes() ?>>
<span id="el_customized_message_subject">
<textarea data-table="customized_message" data-field="x_subject" name="x_subject" id="x_subject" cols="35" rows="4" placeholder="<?php echo HtmlEncode($customized_message->subject->getPlaceHolder()) ?>"<?php echo $customized_message->subject->editAttributes() ?>><?php echo $customized_message->subject->EditValue ?></textarea>
</span>
<?php echo $customized_message->subject->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($customized_message->message->Visible) { // message ?>
	<div id="r_message" class="form-group row">
		<label id="elh_customized_message_message" class="<?php echo $customized_message_add->LeftColumnClass ?>"><?php echo $customized_message->message->caption() ?><?php echo ($customized_message->message->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $customized_message_add->RightColumnClass ?>"><div<?php echo $customized_message->message->cellAttributes() ?>>
<span id="el_customized_message_message">
<?php AppendClass($customized_message->message->EditAttrs["class"], "editor"); ?>
<textarea data-table="customized_message" data-field="x_message" name="x_message" id="x_message" cols="35" rows="4" placeholder="<?php echo HtmlEncode($customized_message->message->getPlaceHolder()) ?>"<?php echo $customized_message->message->editAttributes() ?>><?php echo $customized_message->message->EditValue ?></textarea>
<script>
ew.createEditor("fcustomized_messageadd", "x_message", 0, 0, <?php echo ($customized_message->message->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $customized_message->message->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($customized_message->sms->Visible) { // sms ?>
	<div id="r_sms" class="form-group row">
		<label id="elh_customized_message_sms" for="x_sms" class="<?php echo $customized_message_add->LeftColumnClass ?>"><?php echo $customized_message->sms->caption() ?><?php echo ($customized_message->sms->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $customized_message_add->RightColumnClass ?>"><div<?php echo $customized_message->sms->cellAttributes() ?>>
<span id="el_customized_message_sms">
<textarea data-table="customized_message" data-field="x_sms" name="x_sms" id="x_sms" cols="35" rows="4" placeholder="<?php echo HtmlEncode($customized_message->sms->getPlaceHolder()) ?>"<?php echo $customized_message->sms->editAttributes() ?>><?php echo $customized_message->sms->EditValue ?></textarea>
</span>
<?php echo $customized_message->sms->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($customized_message->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_customized_message_uploads" class="<?php echo $customized_message_add->LeftColumnClass ?>"><?php echo $customized_message->uploads->caption() ?><?php echo ($customized_message->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $customized_message_add->RightColumnClass ?>"><div<?php echo $customized_message->uploads->cellAttributes() ?>>
<span id="el_customized_message_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $customized_message->uploads->title() ? $customized_message->uploads->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($customized_message->uploads->ReadOnly || $customized_message->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="customized_message" data-field="x_uploads" name="x_uploads" id="x_uploads" multiple="multiple"<?php echo $customized_message->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $customized_message->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="1000">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $customized_message->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $customized_message->uploads->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_uploads" id= "fc_x_uploads" value="<?php echo $customized_message->uploads->UploadMaxFileCount ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $customized_message->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($customized_message->b_type->Visible) { // b_type ?>
	<div id="r_b_type" class="form-group row">
		<label id="elh_customized_message_b_type" for="x_b_type" class="<?php echo $customized_message_add->LeftColumnClass ?>"><?php echo $customized_message->b_type->caption() ?><?php echo ($customized_message->b_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $customized_message_add->RightColumnClass ?>"><div<?php echo $customized_message->b_type->cellAttributes() ?>>
<span id="el_customized_message_b_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="customized_message" data-field="x_b_type" data-value-separator="<?php echo $customized_message->b_type->displayValueSeparatorAttribute() ?>" id="x_b_type" name="x_b_type"<?php echo $customized_message->b_type->editAttributes() ?>>
		<?php echo $customized_message->b_type->selectOptionListHtml("x_b_type") ?>
	</select>
</div>
</span>
<?php echo $customized_message->b_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($customized_message->b_1->Visible) { // b_1 ?>
	<div id="r_b_1" class="form-group row">
		<label id="elh_customized_message_b_1" for="x_b_1" class="<?php echo $customized_message_add->LeftColumnClass ?>"><?php echo $customized_message->b_1->caption() ?><?php echo ($customized_message->b_1->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $customized_message_add->RightColumnClass ?>"><div<?php echo $customized_message->b_1->cellAttributes() ?>>
<span id="el_customized_message_b_1">
<input type="text" data-table="customized_message" data-field="x_b_1" name="x_b_1" id="x_b_1" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($customized_message->b_1->getPlaceHolder()) ?>" value="<?php echo $customized_message->b_1->EditValue ?>"<?php echo $customized_message->b_1->editAttributes() ?>>
</span>
<?php echo $customized_message->b_1->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($customized_message->b_2->Visible) { // b_2 ?>
	<div id="r_b_2" class="form-group row">
		<label id="elh_customized_message_b_2" for="x_b_2" class="<?php echo $customized_message_add->LeftColumnClass ?>"><?php echo $customized_message->b_2->caption() ?><?php echo ($customized_message->b_2->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $customized_message_add->RightColumnClass ?>"><div<?php echo $customized_message->b_2->cellAttributes() ?>>
<span id="el_customized_message_b_2">
<input type="text" data-table="customized_message" data-field="x_b_2" name="x_b_2" id="x_b_2" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($customized_message->b_2->getPlaceHolder()) ?>" value="<?php echo $customized_message->b_2->EditValue ?>"<?php echo $customized_message->b_2->editAttributes() ?>>
</span>
<?php echo $customized_message->b_2->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($customized_message->b_3->Visible) { // b_3 ?>
	<div id="r_b_3" class="form-group row">
		<label id="elh_customized_message_b_3" for="x_b_3" class="<?php echo $customized_message_add->LeftColumnClass ?>"><?php echo $customized_message->b_3->caption() ?><?php echo ($customized_message->b_3->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $customized_message_add->RightColumnClass ?>"><div<?php echo $customized_message->b_3->cellAttributes() ?>>
<span id="el_customized_message_b_3">
<input type="text" data-table="customized_message" data-field="x_b_3" name="x_b_3" id="x_b_3" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($customized_message->b_3->getPlaceHolder()) ?>" value="<?php echo $customized_message->b_3->EditValue ?>"<?php echo $customized_message->b_3->editAttributes() ?>>
</span>
<?php echo $customized_message->b_3->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$customized_message_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $customized_message_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $customized_message_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$customized_message_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

	$("#r_mobile_no").hide();
	$("#r_sms").hide();
	$("#r_uploads").hide();		
	$("#r__email").show();		
	$("#r_subject").show();		
	$("#r_message").show();
	$("#r_wa_id").hide();		
	$("#r_wa_type").hide();		
	$("#r_b_type").hide();
	$("#r_b_1").hide();
	$("#r_b_2").hide();
	$("#r_b_3").hide();
	$("#r_b_4").hide();
</script>
<?php include_once "footer.php" ?>
<?php
$customized_message_add->terminate();
?>