<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$customized_message_list = new customized_message_list();

// Run the page
$customized_message_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$customized_message_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$customized_message->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fcustomized_messagelist = currentForm = new ew.Form("fcustomized_messagelist", "list");
fcustomized_messagelist.formKeyCountName = '<?php echo $customized_message_list->FormKeyCountName ?>';

// Form_CustomValidate event
fcustomized_messagelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcustomized_messagelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcustomized_messagelist.lists["x_message_type"] = <?php echo $customized_message_list->message_type->Lookup->toClientList() ?>;
fcustomized_messagelist.lists["x_message_type"].options = <?php echo JsonEncode($customized_message_list->message_type->lookupOptions()) ?>;
fcustomized_messagelist.lists["x_wa_type"] = <?php echo $customized_message_list->wa_type->Lookup->toClientList() ?>;
fcustomized_messagelist.lists["x_wa_type"].options = <?php echo JsonEncode($customized_message_list->wa_type->lookupOptions()) ?>;
fcustomized_messagelist.lists["x_wa_id"] = <?php echo $customized_message_list->wa_id->Lookup->toClientList() ?>;
fcustomized_messagelist.lists["x_wa_id"].options = <?php echo JsonEncode($customized_message_list->wa_id->lookupOptions()) ?>;
fcustomized_messagelist.lists["x_b_type"] = <?php echo $customized_message_list->b_type->Lookup->toClientList() ?>;
fcustomized_messagelist.lists["x_b_type"].options = <?php echo JsonEncode($customized_message_list->b_type->options(FALSE, TRUE)) ?>;
fcustomized_messagelist.lists["x_operator"] = <?php echo $customized_message_list->operator->Lookup->toClientList() ?>;
fcustomized_messagelist.lists["x_operator"].options = <?php echo JsonEncode($customized_message_list->operator->lookupOptions()) ?>;
fcustomized_messagelist.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fcustomized_messagelistsrch = currentSearchForm = new ew.Form("fcustomized_messagelistsrch");

// Filters
fcustomized_messagelistsrch.filterList = <?php echo $customized_message_list->getFilterList() ?>;

// Init search panel as collapsed
fcustomized_messagelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$customized_message->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($customized_message_list->TotalRecs > 0 && $customized_message_list->ExportOptions->visible()) { ?>
<?php $customized_message_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($customized_message_list->ImportOptions->visible()) { ?>
<?php $customized_message_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($customized_message_list->SearchOptions->visible()) { ?>
<?php $customized_message_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($customized_message_list->FilterOptions->visible()) { ?>
<?php $customized_message_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$customized_message_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$customized_message->isExport() && !$customized_message->CurrentAction) { ?>
<form name="fcustomized_messagelistsrch" id="fcustomized_messagelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($customized_message_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fcustomized_messagelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="customized_message">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($customized_message_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($customized_message_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $customized_message_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($customized_message_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($customized_message_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($customized_message_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($customized_message_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $customized_message_list->showPageHeader(); ?>
<?php
$customized_message_list->showMessage();
?>
<?php if ($customized_message_list->TotalRecs > 0 || $customized_message->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($customized_message_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> customized_message">
<?php if (!$customized_message->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$customized_message->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($customized_message_list->Pager)) $customized_message_list->Pager = new PrevNextPager($customized_message_list->StartRec, $customized_message_list->DisplayRecs, $customized_message_list->TotalRecs, $customized_message_list->AutoHidePager) ?>
<?php if ($customized_message_list->Pager->RecordCount > 0 && $customized_message_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($customized_message_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $customized_message_list->pageUrl() ?>start=<?php echo $customized_message_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($customized_message_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $customized_message_list->pageUrl() ?>start=<?php echo $customized_message_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $customized_message_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($customized_message_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $customized_message_list->pageUrl() ?>start=<?php echo $customized_message_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($customized_message_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $customized_message_list->pageUrl() ?>start=<?php echo $customized_message_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $customized_message_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($customized_message_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $customized_message_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $customized_message_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $customized_message_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($customized_message_list->TotalRecs > 0 && (!$customized_message_list->AutoHidePageSizeSelector || $customized_message_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="customized_message">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($customized_message_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($customized_message_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($customized_message_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($customized_message_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($customized_message_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($customized_message->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $customized_message_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fcustomized_messagelist" id="fcustomized_messagelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($customized_message_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $customized_message_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="customized_message">
<div id="gmp_customized_message" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($customized_message_list->TotalRecs > 0 || $customized_message->isGridEdit()) { ?>
<table id="tbl_customized_messagelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$customized_message_list->RowType = ROWTYPE_HEADER;

// Render list options
$customized_message_list->renderListOptions();

// Render list options (header, left)
$customized_message_list->ListOptions->render("header", "left");
?>
<?php if ($customized_message->id->Visible) { // id ?>
	<?php if ($customized_message->sortUrl($customized_message->id) == "") { ?>
		<th data-name="id" class="<?php echo $customized_message->id->headerCellClass() ?>"><div id="elh_customized_message_id" class="customized_message_id"><div class="ew-table-header-caption"><?php echo $customized_message->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $customized_message->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $customized_message->SortUrl($customized_message->id) ?>',2);"><div id="elh_customized_message_id" class="customized_message_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $customized_message->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($customized_message->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($customized_message->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($customized_message->reference->Visible) { // reference ?>
	<?php if ($customized_message->sortUrl($customized_message->reference) == "") { ?>
		<th data-name="reference" class="<?php echo $customized_message->reference->headerCellClass() ?>"><div id="elh_customized_message_reference" class="customized_message_reference"><div class="ew-table-header-caption"><?php echo $customized_message->reference->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reference" class="<?php echo $customized_message->reference->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $customized_message->SortUrl($customized_message->reference) ?>',2);"><div id="elh_customized_message_reference" class="customized_message_reference">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $customized_message->reference->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($customized_message->reference->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($customized_message->reference->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($customized_message->message_type->Visible) { // message_type ?>
	<?php if ($customized_message->sortUrl($customized_message->message_type) == "") { ?>
		<th data-name="message_type" class="<?php echo $customized_message->message_type->headerCellClass() ?>"><div id="elh_customized_message_message_type" class="customized_message_message_type"><div class="ew-table-header-caption"><?php echo $customized_message->message_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="message_type" class="<?php echo $customized_message->message_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $customized_message->SortUrl($customized_message->message_type) ?>',2);"><div id="elh_customized_message_message_type" class="customized_message_message_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $customized_message->message_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($customized_message->message_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($customized_message->message_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($customized_message->wa_type->Visible) { // wa_type ?>
	<?php if ($customized_message->sortUrl($customized_message->wa_type) == "") { ?>
		<th data-name="wa_type" class="<?php echo $customized_message->wa_type->headerCellClass() ?>"><div id="elh_customized_message_wa_type" class="customized_message_wa_type"><div class="ew-table-header-caption"><?php echo $customized_message->wa_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="wa_type" class="<?php echo $customized_message->wa_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $customized_message->SortUrl($customized_message->wa_type) ?>',2);"><div id="elh_customized_message_wa_type" class="customized_message_wa_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $customized_message->wa_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($customized_message->wa_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($customized_message->wa_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($customized_message->wa_id->Visible) { // wa_id ?>
	<?php if ($customized_message->sortUrl($customized_message->wa_id) == "") { ?>
		<th data-name="wa_id" class="<?php echo $customized_message->wa_id->headerCellClass() ?>"><div id="elh_customized_message_wa_id" class="customized_message_wa_id"><div class="ew-table-header-caption"><?php echo $customized_message->wa_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="wa_id" class="<?php echo $customized_message->wa_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $customized_message->SortUrl($customized_message->wa_id) ?>',2);"><div id="elh_customized_message_wa_id" class="customized_message_wa_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $customized_message->wa_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($customized_message->wa_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($customized_message->wa_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($customized_message->subject->Visible) { // subject ?>
	<?php if ($customized_message->sortUrl($customized_message->subject) == "") { ?>
		<th data-name="subject" class="<?php echo $customized_message->subject->headerCellClass() ?>"><div id="elh_customized_message_subject" class="customized_message_subject"><div class="ew-table-header-caption"><?php echo $customized_message->subject->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="subject" class="<?php echo $customized_message->subject->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $customized_message->SortUrl($customized_message->subject) ?>',2);"><div id="elh_customized_message_subject" class="customized_message_subject">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $customized_message->subject->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($customized_message->subject->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($customized_message->subject->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($customized_message->message->Visible) { // message ?>
	<?php if ($customized_message->sortUrl($customized_message->message) == "") { ?>
		<th data-name="message" class="<?php echo $customized_message->message->headerCellClass() ?>"><div id="elh_customized_message_message" class="customized_message_message"><div class="ew-table-header-caption"><?php echo $customized_message->message->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="message" class="<?php echo $customized_message->message->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $customized_message->SortUrl($customized_message->message) ?>',2);"><div id="elh_customized_message_message" class="customized_message_message">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $customized_message->message->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($customized_message->message->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($customized_message->message->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($customized_message->b_type->Visible) { // b_type ?>
	<?php if ($customized_message->sortUrl($customized_message->b_type) == "") { ?>
		<th data-name="b_type" class="<?php echo $customized_message->b_type->headerCellClass() ?>"><div id="elh_customized_message_b_type" class="customized_message_b_type"><div class="ew-table-header-caption"><?php echo $customized_message->b_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_type" class="<?php echo $customized_message->b_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $customized_message->SortUrl($customized_message->b_type) ?>',2);"><div id="elh_customized_message_b_type" class="customized_message_b_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $customized_message->b_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($customized_message->b_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($customized_message->b_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($customized_message->b_1->Visible) { // b_1 ?>
	<?php if ($customized_message->sortUrl($customized_message->b_1) == "") { ?>
		<th data-name="b_1" class="<?php echo $customized_message->b_1->headerCellClass() ?>"><div id="elh_customized_message_b_1" class="customized_message_b_1"><div class="ew-table-header-caption"><?php echo $customized_message->b_1->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_1" class="<?php echo $customized_message->b_1->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $customized_message->SortUrl($customized_message->b_1) ?>',2);"><div id="elh_customized_message_b_1" class="customized_message_b_1">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $customized_message->b_1->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($customized_message->b_1->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($customized_message->b_1->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($customized_message->b_2->Visible) { // b_2 ?>
	<?php if ($customized_message->sortUrl($customized_message->b_2) == "") { ?>
		<th data-name="b_2" class="<?php echo $customized_message->b_2->headerCellClass() ?>"><div id="elh_customized_message_b_2" class="customized_message_b_2"><div class="ew-table-header-caption"><?php echo $customized_message->b_2->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_2" class="<?php echo $customized_message->b_2->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $customized_message->SortUrl($customized_message->b_2) ?>',2);"><div id="elh_customized_message_b_2" class="customized_message_b_2">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $customized_message->b_2->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($customized_message->b_2->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($customized_message->b_2->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($customized_message->b_3->Visible) { // b_3 ?>
	<?php if ($customized_message->sortUrl($customized_message->b_3) == "") { ?>
		<th data-name="b_3" class="<?php echo $customized_message->b_3->headerCellClass() ?>"><div id="elh_customized_message_b_3" class="customized_message_b_3"><div class="ew-table-header-caption"><?php echo $customized_message->b_3->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_3" class="<?php echo $customized_message->b_3->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $customized_message->SortUrl($customized_message->b_3) ?>',2);"><div id="elh_customized_message_b_3" class="customized_message_b_3">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $customized_message->b_3->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($customized_message->b_3->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($customized_message->b_3->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($customized_message->operator->Visible) { // operator ?>
	<?php if ($customized_message->sortUrl($customized_message->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $customized_message->operator->headerCellClass() ?>"><div id="elh_customized_message_operator" class="customized_message_operator"><div class="ew-table-header-caption"><?php echo $customized_message->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $customized_message->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $customized_message->SortUrl($customized_message->operator) ?>',2);"><div id="elh_customized_message_operator" class="customized_message_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $customized_message->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($customized_message->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($customized_message->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($customized_message->datetime->Visible) { // datetime ?>
	<?php if ($customized_message->sortUrl($customized_message->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $customized_message->datetime->headerCellClass() ?>"><div id="elh_customized_message_datetime" class="customized_message_datetime"><div class="ew-table-header-caption"><?php echo $customized_message->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $customized_message->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $customized_message->SortUrl($customized_message->datetime) ?>',2);"><div id="elh_customized_message_datetime" class="customized_message_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $customized_message->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($customized_message->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($customized_message->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$customized_message_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($customized_message->ExportAll && $customized_message->isExport()) {
	$customized_message_list->StopRec = $customized_message_list->TotalRecs;
} else {

	// Set the last record to display
	if ($customized_message_list->TotalRecs > $customized_message_list->StartRec + $customized_message_list->DisplayRecs - 1)
		$customized_message_list->StopRec = $customized_message_list->StartRec + $customized_message_list->DisplayRecs - 1;
	else
		$customized_message_list->StopRec = $customized_message_list->TotalRecs;
}
$customized_message_list->RecCnt = $customized_message_list->StartRec - 1;
if ($customized_message_list->Recordset && !$customized_message_list->Recordset->EOF) {
	$customized_message_list->Recordset->moveFirst();
	$selectLimit = $customized_message_list->UseSelectLimit;
	if (!$selectLimit && $customized_message_list->StartRec > 1)
		$customized_message_list->Recordset->move($customized_message_list->StartRec - 1);
} elseif (!$customized_message->AllowAddDeleteRow && $customized_message_list->StopRec == 0) {
	$customized_message_list->StopRec = $customized_message->GridAddRowCount;
}

// Initialize aggregate
$customized_message->RowType = ROWTYPE_AGGREGATEINIT;
$customized_message->resetAttributes();
$customized_message_list->renderRow();
while ($customized_message_list->RecCnt < $customized_message_list->StopRec) {
	$customized_message_list->RecCnt++;
	if ($customized_message_list->RecCnt >= $customized_message_list->StartRec) {
		$customized_message_list->RowCnt++;

		// Set up key count
		$customized_message_list->KeyCount = $customized_message_list->RowIndex;

		// Init row class and style
		$customized_message->resetAttributes();
		$customized_message->CssClass = "";
		if ($customized_message->isGridAdd()) {
		} else {
			$customized_message_list->loadRowValues($customized_message_list->Recordset); // Load row values
		}
		$customized_message->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$customized_message->RowAttrs = array_merge($customized_message->RowAttrs, array('data-rowindex'=>$customized_message_list->RowCnt, 'id'=>'r' . $customized_message_list->RowCnt . '_customized_message', 'data-rowtype'=>$customized_message->RowType));

		// Render row
		$customized_message_list->renderRow();

		// Render list options
		$customized_message_list->renderListOptions();
?>
	<tr<?php echo $customized_message->rowAttributes() ?>>
<?php

// Render list options (body, left)
$customized_message_list->ListOptions->render("body", "left", $customized_message_list->RowCnt);
?>
	<?php if ($customized_message->id->Visible) { // id ?>
		<td data-name="id"<?php echo $customized_message->id->cellAttributes() ?>>
<span id="el<?php echo $customized_message_list->RowCnt ?>_customized_message_id" class="customized_message_id">
<span<?php echo $customized_message->id->viewAttributes() ?>>
<?php echo $customized_message->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($customized_message->reference->Visible) { // reference ?>
		<td data-name="reference"<?php echo $customized_message->reference->cellAttributes() ?>>
<span id="el<?php echo $customized_message_list->RowCnt ?>_customized_message_reference" class="customized_message_reference">
<span<?php echo $customized_message->reference->viewAttributes() ?>>
<?php echo $customized_message->reference->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($customized_message->message_type->Visible) { // message_type ?>
		<td data-name="message_type"<?php echo $customized_message->message_type->cellAttributes() ?>>
<span id="el<?php echo $customized_message_list->RowCnt ?>_customized_message_message_type" class="customized_message_message_type">
<span<?php echo $customized_message->message_type->viewAttributes() ?>>
<?php echo $customized_message->message_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($customized_message->wa_type->Visible) { // wa_type ?>
		<td data-name="wa_type"<?php echo $customized_message->wa_type->cellAttributes() ?>>
<span id="el<?php echo $customized_message_list->RowCnt ?>_customized_message_wa_type" class="customized_message_wa_type">
<span<?php echo $customized_message->wa_type->viewAttributes() ?>>
<?php echo $customized_message->wa_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($customized_message->wa_id->Visible) { // wa_id ?>
		<td data-name="wa_id"<?php echo $customized_message->wa_id->cellAttributes() ?>>
<span id="el<?php echo $customized_message_list->RowCnt ?>_customized_message_wa_id" class="customized_message_wa_id">
<span<?php echo $customized_message->wa_id->viewAttributes() ?>>
<?php echo $customized_message->wa_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($customized_message->subject->Visible) { // subject ?>
		<td data-name="subject"<?php echo $customized_message->subject->cellAttributes() ?>>
<span id="el<?php echo $customized_message_list->RowCnt ?>_customized_message_subject" class="customized_message_subject">
<span<?php echo $customized_message->subject->viewAttributes() ?>>
<?php echo $customized_message->subject->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($customized_message->message->Visible) { // message ?>
		<td data-name="message"<?php echo $customized_message->message->cellAttributes() ?>>
<span id="el<?php echo $customized_message_list->RowCnt ?>_customized_message_message" class="customized_message_message">
<span<?php echo $customized_message->message->viewAttributes() ?>>
<?php echo $customized_message->message->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($customized_message->b_type->Visible) { // b_type ?>
		<td data-name="b_type"<?php echo $customized_message->b_type->cellAttributes() ?>>
<span id="el<?php echo $customized_message_list->RowCnt ?>_customized_message_b_type" class="customized_message_b_type">
<span<?php echo $customized_message->b_type->viewAttributes() ?>>
<?php echo $customized_message->b_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($customized_message->b_1->Visible) { // b_1 ?>
		<td data-name="b_1"<?php echo $customized_message->b_1->cellAttributes() ?>>
<span id="el<?php echo $customized_message_list->RowCnt ?>_customized_message_b_1" class="customized_message_b_1">
<span<?php echo $customized_message->b_1->viewAttributes() ?>>
<?php echo $customized_message->b_1->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($customized_message->b_2->Visible) { // b_2 ?>
		<td data-name="b_2"<?php echo $customized_message->b_2->cellAttributes() ?>>
<span id="el<?php echo $customized_message_list->RowCnt ?>_customized_message_b_2" class="customized_message_b_2">
<span<?php echo $customized_message->b_2->viewAttributes() ?>>
<?php echo $customized_message->b_2->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($customized_message->b_3->Visible) { // b_3 ?>
		<td data-name="b_3"<?php echo $customized_message->b_3->cellAttributes() ?>>
<span id="el<?php echo $customized_message_list->RowCnt ?>_customized_message_b_3" class="customized_message_b_3">
<span<?php echo $customized_message->b_3->viewAttributes() ?>>
<?php echo $customized_message->b_3->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($customized_message->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $customized_message->operator->cellAttributes() ?>>
<span id="el<?php echo $customized_message_list->RowCnt ?>_customized_message_operator" class="customized_message_operator">
<span<?php echo $customized_message->operator->viewAttributes() ?>>
<?php echo $customized_message->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($customized_message->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $customized_message->datetime->cellAttributes() ?>>
<span id="el<?php echo $customized_message_list->RowCnt ?>_customized_message_datetime" class="customized_message_datetime">
<span<?php echo $customized_message->datetime->viewAttributes() ?>>
<?php echo $customized_message->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$customized_message_list->ListOptions->render("body", "right", $customized_message_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$customized_message->isGridAdd())
		$customized_message_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$customized_message->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($customized_message_list->Recordset)
	$customized_message_list->Recordset->Close();
?>
<?php if (!$customized_message->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$customized_message->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($customized_message_list->Pager)) $customized_message_list->Pager = new PrevNextPager($customized_message_list->StartRec, $customized_message_list->DisplayRecs, $customized_message_list->TotalRecs, $customized_message_list->AutoHidePager) ?>
<?php if ($customized_message_list->Pager->RecordCount > 0 && $customized_message_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($customized_message_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $customized_message_list->pageUrl() ?>start=<?php echo $customized_message_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($customized_message_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $customized_message_list->pageUrl() ?>start=<?php echo $customized_message_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $customized_message_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($customized_message_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $customized_message_list->pageUrl() ?>start=<?php echo $customized_message_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($customized_message_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $customized_message_list->pageUrl() ?>start=<?php echo $customized_message_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $customized_message_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($customized_message_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $customized_message_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $customized_message_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $customized_message_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($customized_message_list->TotalRecs > 0 && (!$customized_message_list->AutoHidePageSizeSelector || $customized_message_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="customized_message">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($customized_message_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($customized_message_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($customized_message_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($customized_message_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($customized_message_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($customized_message->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $customized_message_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($customized_message_list->TotalRecs == 0 && !$customized_message->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $customized_message_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$customized_message_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$customized_message->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$customized_message->isExport()) { ?>
<script>
ew.scrollableTable("gmp_customized_message", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$customized_message_list->terminate();
?>