<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$customized_message_search = new customized_message_search();

// Run the page
$customized_message_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$customized_message_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($customized_message_search->IsModal) { ?>
var fcustomized_messagesearch = currentAdvancedSearchForm = new ew.Form("fcustomized_messagesearch", "search");
<?php } else { ?>
var fcustomized_messagesearch = currentForm = new ew.Form("fcustomized_messagesearch", "search");
<?php } ?>

// Form_CustomValidate event
fcustomized_messagesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcustomized_messagesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcustomized_messagesearch.lists["x_message_type"] = <?php echo $customized_message_search->message_type->Lookup->toClientList() ?>;
fcustomized_messagesearch.lists["x_message_type"].options = <?php echo JsonEncode($customized_message_search->message_type->lookupOptions()) ?>;
fcustomized_messagesearch.lists["x_wa_type"] = <?php echo $customized_message_search->wa_type->Lookup->toClientList() ?>;
fcustomized_messagesearch.lists["x_wa_type"].options = <?php echo JsonEncode($customized_message_search->wa_type->lookupOptions()) ?>;
fcustomized_messagesearch.lists["x_wa_id"] = <?php echo $customized_message_search->wa_id->Lookup->toClientList() ?>;
fcustomized_messagesearch.lists["x_wa_id"].options = <?php echo JsonEncode($customized_message_search->wa_id->lookupOptions()) ?>;
fcustomized_messagesearch.lists["x_b_type"] = <?php echo $customized_message_search->b_type->Lookup->toClientList() ?>;
fcustomized_messagesearch.lists["x_b_type"].options = <?php echo JsonEncode($customized_message_search->b_type->options(FALSE, TRUE)) ?>;
fcustomized_messagesearch.lists["x_operator"] = <?php echo $customized_message_search->operator->Lookup->toClientList() ?>;
fcustomized_messagesearch.lists["x_operator"].options = <?php echo JsonEncode($customized_message_search->operator->lookupOptions()) ?>;
fcustomized_messagesearch.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

fcustomized_messagesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($customized_message->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($customized_message->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($customized_message->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $customized_message_search->showPageHeader(); ?>
<?php
$customized_message_search->showMessage();
?>
<form name="fcustomized_messagesearch" id="fcustomized_messagesearch" class="<?php echo $customized_message_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($customized_message_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $customized_message_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="customized_message">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$customized_message_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($customized_message->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message_id"><?php echo $customized_message->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->id->cellAttributes() ?>>
			<span id="el_customized_message_id">
<input type="text" data-table="customized_message" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($customized_message->id->getPlaceHolder()) ?>" value="<?php echo $customized_message->id->EditValue ?>"<?php echo $customized_message->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($customized_message->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label for="x_reference" class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message_reference"><?php echo $customized_message->reference->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_reference" id="z_reference" value="LIKE"></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->reference->cellAttributes() ?>>
			<span id="el_customized_message_reference">
<input type="text" data-table="customized_message" data-field="x_reference" name="x_reference" id="x_reference" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($customized_message->reference->getPlaceHolder()) ?>" value="<?php echo $customized_message->reference->EditValue ?>"<?php echo $customized_message->reference->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($customized_message->message_type->Visible) { // message_type ?>
	<div id="r_message_type" class="form-group row">
		<label for="x_message_type" class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message_message_type"><?php echo $customized_message->message_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_message_type" id="z_message_type" value="="></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->message_type->cellAttributes() ?>>
			<span id="el_customized_message_message_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="customized_message" data-field="x_message_type" data-value-separator="<?php echo $customized_message->message_type->displayValueSeparatorAttribute() ?>" id="x_message_type" name="x_message_type"<?php echo $customized_message->message_type->editAttributes() ?>>
		<?php echo $customized_message->message_type->selectOptionListHtml("x_message_type") ?>
	</select>
</div>
<?php echo $customized_message->message_type->Lookup->getParamTag("p_x_message_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($customized_message->wa_type->Visible) { // wa_type ?>
	<div id="r_wa_type" class="form-group row">
		<label for="x_wa_type" class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message_wa_type"><?php echo $customized_message->wa_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_wa_type" id="z_wa_type" value="="></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->wa_type->cellAttributes() ?>>
			<span id="el_customized_message_wa_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="customized_message" data-field="x_wa_type" data-value-separator="<?php echo $customized_message->wa_type->displayValueSeparatorAttribute() ?>" id="x_wa_type" name="x_wa_type"<?php echo $customized_message->wa_type->editAttributes() ?>>
		<?php echo $customized_message->wa_type->selectOptionListHtml("x_wa_type") ?>
	</select>
</div>
<?php echo $customized_message->wa_type->Lookup->getParamTag("p_x_wa_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($customized_message->wa_id->Visible) { // wa_id ?>
	<div id="r_wa_id" class="form-group row">
		<label for="x_wa_id" class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message_wa_id"><?php echo $customized_message->wa_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_wa_id" id="z_wa_id" value="="></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->wa_id->cellAttributes() ?>>
			<span id="el_customized_message_wa_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="customized_message" data-field="x_wa_id" data-value-separator="<?php echo $customized_message->wa_id->displayValueSeparatorAttribute() ?>" id="x_wa_id" name="x_wa_id"<?php echo $customized_message->wa_id->editAttributes() ?>>
		<?php echo $customized_message->wa_id->selectOptionListHtml("x_wa_id") ?>
	</select>
</div>
<?php echo $customized_message->wa_id->Lookup->getParamTag("p_x_wa_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($customized_message->mobile_no->Visible) { // mobile_no ?>
	<div id="r_mobile_no" class="form-group row">
		<label for="x_mobile_no" class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message_mobile_no"><?php echo $customized_message->mobile_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mobile_no" id="z_mobile_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->mobile_no->cellAttributes() ?>>
			<span id="el_customized_message_mobile_no">
<input type="text" data-table="customized_message" data-field="x_mobile_no" name="x_mobile_no" id="x_mobile_no" placeholder="<?php echo HtmlEncode($customized_message->mobile_no->getPlaceHolder()) ?>" value="<?php echo $customized_message->mobile_no->EditValue ?>"<?php echo $customized_message->mobile_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($customized_message->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label for="x__email" class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message__email"><?php echo $customized_message->_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__email" id="z__email" value="LIKE"></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->_email->cellAttributes() ?>>
			<span id="el_customized_message__email">
<input type="text" data-table="customized_message" data-field="x__email" name="x__email" id="x__email" placeholder="<?php echo HtmlEncode($customized_message->_email->getPlaceHolder()) ?>" value="<?php echo $customized_message->_email->EditValue ?>"<?php echo $customized_message->_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($customized_message->subject->Visible) { // subject ?>
	<div id="r_subject" class="form-group row">
		<label for="x_subject" class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message_subject"><?php echo $customized_message->subject->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_subject" id="z_subject" value="LIKE"></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->subject->cellAttributes() ?>>
			<span id="el_customized_message_subject">
<input type="text" data-table="customized_message" data-field="x_subject" name="x_subject" id="x_subject" maxlength="150" placeholder="<?php echo HtmlEncode($customized_message->subject->getPlaceHolder()) ?>" value="<?php echo $customized_message->subject->EditValue ?>"<?php echo $customized_message->subject->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($customized_message->message->Visible) { // message ?>
	<div id="r_message" class="form-group row">
		<label class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message_message"><?php echo $customized_message->message->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_message" id="z_message" value="LIKE"></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->message->cellAttributes() ?>>
			<span id="el_customized_message_message">
<input type="text" data-table="customized_message" data-field="x_message" name="x_message" id="x_message" maxlength="255" placeholder="<?php echo HtmlEncode($customized_message->message->getPlaceHolder()) ?>" value="<?php echo $customized_message->message->EditValue ?>"<?php echo $customized_message->message->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($customized_message->sms->Visible) { // sms ?>
	<div id="r_sms" class="form-group row">
		<label for="x_sms" class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message_sms"><?php echo $customized_message->sms->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sms" id="z_sms" value="LIKE"></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->sms->cellAttributes() ?>>
			<span id="el_customized_message_sms">
<input type="text" data-table="customized_message" data-field="x_sms" name="x_sms" id="x_sms" size="35" placeholder="<?php echo HtmlEncode($customized_message->sms->getPlaceHolder()) ?>" value="<?php echo $customized_message->sms->EditValue ?>"<?php echo $customized_message->sms->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($customized_message->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message_uploads"><?php echo $customized_message->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->uploads->cellAttributes() ?>>
			<span id="el_customized_message_uploads">
<input type="text" data-table="customized_message" data-field="x_uploads" name="x_uploads" id="x_uploads" placeholder="<?php echo HtmlEncode($customized_message->uploads->getPlaceHolder()) ?>" value="<?php echo $customized_message->uploads->EditValue ?>"<?php echo $customized_message->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($customized_message->b_type->Visible) { // b_type ?>
	<div id="r_b_type" class="form-group row">
		<label for="x_b_type" class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message_b_type"><?php echo $customized_message->b_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_b_type" id="z_b_type" value="="></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->b_type->cellAttributes() ?>>
			<span id="el_customized_message_b_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="customized_message" data-field="x_b_type" data-value-separator="<?php echo $customized_message->b_type->displayValueSeparatorAttribute() ?>" id="x_b_type" name="x_b_type"<?php echo $customized_message->b_type->editAttributes() ?>>
		<?php echo $customized_message->b_type->selectOptionListHtml("x_b_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($customized_message->b_1->Visible) { // b_1 ?>
	<div id="r_b_1" class="form-group row">
		<label for="x_b_1" class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message_b_1"><?php echo $customized_message->b_1->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_1" id="z_b_1" value="LIKE"></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->b_1->cellAttributes() ?>>
			<span id="el_customized_message_b_1">
<input type="text" data-table="customized_message" data-field="x_b_1" name="x_b_1" id="x_b_1" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($customized_message->b_1->getPlaceHolder()) ?>" value="<?php echo $customized_message->b_1->EditValue ?>"<?php echo $customized_message->b_1->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($customized_message->b_2->Visible) { // b_2 ?>
	<div id="r_b_2" class="form-group row">
		<label for="x_b_2" class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message_b_2"><?php echo $customized_message->b_2->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_2" id="z_b_2" value="LIKE"></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->b_2->cellAttributes() ?>>
			<span id="el_customized_message_b_2">
<input type="text" data-table="customized_message" data-field="x_b_2" name="x_b_2" id="x_b_2" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($customized_message->b_2->getPlaceHolder()) ?>" value="<?php echo $customized_message->b_2->EditValue ?>"<?php echo $customized_message->b_2->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($customized_message->b_3->Visible) { // b_3 ?>
	<div id="r_b_3" class="form-group row">
		<label for="x_b_3" class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message_b_3"><?php echo $customized_message->b_3->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_3" id="z_b_3" value="LIKE"></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->b_3->cellAttributes() ?>>
			<span id="el_customized_message_b_3">
<input type="text" data-table="customized_message" data-field="x_b_3" name="x_b_3" id="x_b_3" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($customized_message->b_3->getPlaceHolder()) ?>" value="<?php echo $customized_message->b_3->EditValue ?>"<?php echo $customized_message->b_3->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($customized_message->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message_operator"><?php echo $customized_message->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->operator->cellAttributes() ?>>
			<span id="el_customized_message_operator">
<?php
$wrkonchange = "" . trim(@$customized_message->operator->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$customized_message->operator->EditAttrs["onchange"] = "";
?>
<span id="as_x_operator" class="text-nowrap" style="z-index: 8820">
	<input type="text" class="form-control" name="sv_x_operator" id="sv_x_operator" value="<?php echo RemoveHtml($customized_message->operator->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($customized_message->operator->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($customized_message->operator->getPlaceHolder()) ?>"<?php echo $customized_message->operator->editAttributes() ?>>
</span>
<input type="hidden" data-table="customized_message" data-field="x_operator" data-value-separator="<?php echo $customized_message->operator->displayValueSeparatorAttribute() ?>" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($customized_message->operator->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fcustomized_messagesearch.createAutoSuggest({"id":"x_operator","forceSelect":false});
</script>
<?php echo $customized_message->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($customized_message->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $customized_message_search->LeftColumnClass ?>"><span id="elh_customized_message_datetime"><?php echo $customized_message->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $customized_message_search->RightColumnClass ?>"><div<?php echo $customized_message->datetime->cellAttributes() ?>>
			<span id="el_customized_message_datetime">
<input type="text" data-table="customized_message" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($customized_message->datetime->getPlaceHolder()) ?>" value="<?php echo $customized_message->datetime->EditValue ?>"<?php echo $customized_message->datetime->editAttributes() ?>>
<?php if (!$customized_message->datetime->ReadOnly && !$customized_message->datetime->Disabled && !isset($customized_message->datetime->EditAttrs["readonly"]) && !isset($customized_message->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fcustomized_messagesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$customized_message_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $customized_message_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$customized_message_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$customized_message_search->terminate();
?>