<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$customized_message_view = new customized_message_view();

// Run the page
$customized_message_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$customized_message_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$customized_message->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fcustomized_messageview = currentForm = new ew.Form("fcustomized_messageview", "view");

// Form_CustomValidate event
fcustomized_messageview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fcustomized_messageview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fcustomized_messageview.lists["x_message_type"] = <?php echo $customized_message_view->message_type->Lookup->toClientList() ?>;
fcustomized_messageview.lists["x_message_type"].options = <?php echo JsonEncode($customized_message_view->message_type->lookupOptions()) ?>;
fcustomized_messageview.lists["x_wa_type"] = <?php echo $customized_message_view->wa_type->Lookup->toClientList() ?>;
fcustomized_messageview.lists["x_wa_type"].options = <?php echo JsonEncode($customized_message_view->wa_type->lookupOptions()) ?>;
fcustomized_messageview.lists["x_wa_id"] = <?php echo $customized_message_view->wa_id->Lookup->toClientList() ?>;
fcustomized_messageview.lists["x_wa_id"].options = <?php echo JsonEncode($customized_message_view->wa_id->lookupOptions()) ?>;
fcustomized_messageview.lists["x_b_type"] = <?php echo $customized_message_view->b_type->Lookup->toClientList() ?>;
fcustomized_messageview.lists["x_b_type"].options = <?php echo JsonEncode($customized_message_view->b_type->options(FALSE, TRUE)) ?>;
fcustomized_messageview.lists["x_operator"] = <?php echo $customized_message_view->operator->Lookup->toClientList() ?>;
fcustomized_messageview.lists["x_operator"].options = <?php echo JsonEncode($customized_message_view->operator->lookupOptions()) ?>;
fcustomized_messageview.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$customized_message->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $customized_message_view->ExportOptions->render("body") ?>
<?php $customized_message_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $customized_message_view->showPageHeader(); ?>
<?php
$customized_message_view->showMessage();
?>
<form name="fcustomized_messageview" id="fcustomized_messageview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($customized_message_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $customized_message_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="customized_message">
<input type="hidden" name="modal" value="<?php echo (int)$customized_message_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($customized_message->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message_id"><?php echo $customized_message->id->caption() ?></span></td>
		<td data-name="id"<?php echo $customized_message->id->cellAttributes() ?>>
<span id="el_customized_message_id">
<span<?php echo $customized_message->id->viewAttributes() ?>>
<?php echo $customized_message->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($customized_message->reference->Visible) { // reference ?>
	<tr id="r_reference">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message_reference"><?php echo $customized_message->reference->caption() ?></span></td>
		<td data-name="reference"<?php echo $customized_message->reference->cellAttributes() ?>>
<span id="el_customized_message_reference">
<span<?php echo $customized_message->reference->viewAttributes() ?>>
<?php echo $customized_message->reference->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($customized_message->message_type->Visible) { // message_type ?>
	<tr id="r_message_type">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message_message_type"><?php echo $customized_message->message_type->caption() ?></span></td>
		<td data-name="message_type"<?php echo $customized_message->message_type->cellAttributes() ?>>
<span id="el_customized_message_message_type">
<span<?php echo $customized_message->message_type->viewAttributes() ?>>
<?php echo $customized_message->message_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($customized_message->wa_type->Visible) { // wa_type ?>
	<tr id="r_wa_type">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message_wa_type"><?php echo $customized_message->wa_type->caption() ?></span></td>
		<td data-name="wa_type"<?php echo $customized_message->wa_type->cellAttributes() ?>>
<span id="el_customized_message_wa_type">
<span<?php echo $customized_message->wa_type->viewAttributes() ?>>
<?php echo $customized_message->wa_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($customized_message->wa_id->Visible) { // wa_id ?>
	<tr id="r_wa_id">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message_wa_id"><?php echo $customized_message->wa_id->caption() ?></span></td>
		<td data-name="wa_id"<?php echo $customized_message->wa_id->cellAttributes() ?>>
<span id="el_customized_message_wa_id">
<span<?php echo $customized_message->wa_id->viewAttributes() ?>>
<?php echo $customized_message->wa_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($customized_message->mobile_no->Visible) { // mobile_no ?>
	<tr id="r_mobile_no">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message_mobile_no"><?php echo $customized_message->mobile_no->caption() ?></span></td>
		<td data-name="mobile_no"<?php echo $customized_message->mobile_no->cellAttributes() ?>>
<span id="el_customized_message_mobile_no">
<span<?php echo $customized_message->mobile_no->viewAttributes() ?>>
<?php echo $customized_message->mobile_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($customized_message->_email->Visible) { // email ?>
	<tr id="r__email">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message__email"><?php echo $customized_message->_email->caption() ?></span></td>
		<td data-name="_email"<?php echo $customized_message->_email->cellAttributes() ?>>
<span id="el_customized_message__email">
<span<?php echo $customized_message->_email->viewAttributes() ?>>
<?php echo $customized_message->_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($customized_message->subject->Visible) { // subject ?>
	<tr id="r_subject">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message_subject"><?php echo $customized_message->subject->caption() ?></span></td>
		<td data-name="subject"<?php echo $customized_message->subject->cellAttributes() ?>>
<span id="el_customized_message_subject">
<span<?php echo $customized_message->subject->viewAttributes() ?>>
<?php echo $customized_message->subject->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($customized_message->message->Visible) { // message ?>
	<tr id="r_message">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message_message"><?php echo $customized_message->message->caption() ?></span></td>
		<td data-name="message"<?php echo $customized_message->message->cellAttributes() ?>>
<span id="el_customized_message_message">
<span<?php echo $customized_message->message->viewAttributes() ?>>
<?php echo $customized_message->message->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($customized_message->sms->Visible) { // sms ?>
	<tr id="r_sms">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message_sms"><?php echo $customized_message->sms->caption() ?></span></td>
		<td data-name="sms"<?php echo $customized_message->sms->cellAttributes() ?>>
<span id="el_customized_message_sms">
<span<?php echo $customized_message->sms->viewAttributes() ?>>
<?php echo $customized_message->sms->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($customized_message->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message_uploads"><?php echo $customized_message->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $customized_message->uploads->cellAttributes() ?>>
<span id="el_customized_message_uploads">
<span<?php echo $customized_message->uploads->viewAttributes() ?>>
<?php echo GetFileViewTag($customized_message->uploads, $customized_message->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($customized_message->b_type->Visible) { // b_type ?>
	<tr id="r_b_type">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message_b_type"><?php echo $customized_message->b_type->caption() ?></span></td>
		<td data-name="b_type"<?php echo $customized_message->b_type->cellAttributes() ?>>
<span id="el_customized_message_b_type">
<span<?php echo $customized_message->b_type->viewAttributes() ?>>
<?php echo $customized_message->b_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($customized_message->b_1->Visible) { // b_1 ?>
	<tr id="r_b_1">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message_b_1"><?php echo $customized_message->b_1->caption() ?></span></td>
		<td data-name="b_1"<?php echo $customized_message->b_1->cellAttributes() ?>>
<span id="el_customized_message_b_1">
<span<?php echo $customized_message->b_1->viewAttributes() ?>>
<?php echo $customized_message->b_1->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($customized_message->b_2->Visible) { // b_2 ?>
	<tr id="r_b_2">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message_b_2"><?php echo $customized_message->b_2->caption() ?></span></td>
		<td data-name="b_2"<?php echo $customized_message->b_2->cellAttributes() ?>>
<span id="el_customized_message_b_2">
<span<?php echo $customized_message->b_2->viewAttributes() ?>>
<?php echo $customized_message->b_2->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($customized_message->b_3->Visible) { // b_3 ?>
	<tr id="r_b_3">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message_b_3"><?php echo $customized_message->b_3->caption() ?></span></td>
		<td data-name="b_3"<?php echo $customized_message->b_3->cellAttributes() ?>>
<span id="el_customized_message_b_3">
<span<?php echo $customized_message->b_3->viewAttributes() ?>>
<?php echo $customized_message->b_3->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($customized_message->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message_operator"><?php echo $customized_message->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $customized_message->operator->cellAttributes() ?>>
<span id="el_customized_message_operator">
<span<?php echo $customized_message->operator->viewAttributes() ?>>
<?php echo $customized_message->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($customized_message->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $customized_message_view->TableLeftColumnClass ?>"><span id="elh_customized_message_datetime"><?php echo $customized_message->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $customized_message->datetime->cellAttributes() ?>>
<span id="el_customized_message_datetime">
<span<?php echo $customized_message->datetime->viewAttributes() ?>>
<?php echo $customized_message->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$customized_message_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$customized_message->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$customized_message_view->terminate();
?>