<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$d_03_add = new d_03_add();

// Run the page
$d_03_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$d_03_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fd_03add = currentForm = new ew.Form("fd_03add", "add");

// Validate form
fd_03add.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($d_03_add->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $d_03->item->caption(), $d_03->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($d_03_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $d_03->grp->caption(), $d_03->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($d_03_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $d_03->status->caption(), $d_03->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($d_03_add->opeartor->Required) { ?>
			elm = this.getElements("x" + infix + "_opeartor");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $d_03->opeartor->caption(), $d_03->opeartor->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($d_03_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $d_03->datetime->caption(), $d_03->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fd_03add.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fd_03add.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fd_03add.lists["x_grp"] = <?php echo $d_03_add->grp->Lookup->toClientList() ?>;
fd_03add.lists["x_grp"].options = <?php echo JsonEncode($d_03_add->grp->lookupOptions()) ?>;
fd_03add.lists["x_status"] = <?php echo $d_03_add->status->Lookup->toClientList() ?>;
fd_03add.lists["x_status"].options = <?php echo JsonEncode($d_03_add->status->options(FALSE, TRUE)) ?>;
fd_03add.lists["x_opeartor"] = <?php echo $d_03_add->opeartor->Lookup->toClientList() ?>;
fd_03add.lists["x_opeartor"].options = <?php echo JsonEncode($d_03_add->opeartor->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $d_03_add->showPageHeader(); ?>
<?php
$d_03_add->showMessage();
?>
<form name="fd_03add" id="fd_03add" class="<?php echo $d_03_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($d_03_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $d_03_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="d_03">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$d_03_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($d_03->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_d_03_item" for="x_item" class="<?php echo $d_03_add->LeftColumnClass ?>"><?php echo $d_03->item->caption() ?><?php echo ($d_03->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $d_03_add->RightColumnClass ?>"><div<?php echo $d_03->item->cellAttributes() ?>>
<span id="el_d_03_item">
<input type="text" data-table="d_03" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($d_03->item->getPlaceHolder()) ?>" value="<?php echo $d_03->item->EditValue ?>"<?php echo $d_03->item->editAttributes() ?>>
</span>
<?php echo $d_03->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($d_03->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_d_03_grp" for="x_grp" class="<?php echo $d_03_add->LeftColumnClass ?>"><?php echo $d_03->grp->caption() ?><?php echo ($d_03->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $d_03_add->RightColumnClass ?>"><div<?php echo $d_03->grp->cellAttributes() ?>>
<span id="el_d_03_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="d_03" data-field="x_grp" data-value-separator="<?php echo $d_03->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $d_03->grp->editAttributes() ?>>
		<?php echo $d_03->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $d_03->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $d_03->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($d_03->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_d_03_status" for="x_status" class="<?php echo $d_03_add->LeftColumnClass ?>"><?php echo $d_03->status->caption() ?><?php echo ($d_03->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $d_03_add->RightColumnClass ?>"><div<?php echo $d_03->status->cellAttributes() ?>>
<span id="el_d_03_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="d_03" data-field="x_status" data-value-separator="<?php echo $d_03->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $d_03->status->editAttributes() ?>>
		<?php echo $d_03->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $d_03->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$d_03_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $d_03_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $d_03_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$d_03_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$d_03_add->terminate();
?>