<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$d_04_search = new d_04_search();

// Run the page
$d_04_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$d_04_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($d_04_search->IsModal) { ?>
var fd_04search = currentAdvancedSearchForm = new ew.Form("fd_04search", "search");
<?php } else { ?>
var fd_04search = currentForm = new ew.Form("fd_04search", "search");
<?php } ?>

// Form_CustomValidate event
fd_04search.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fd_04search.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fd_04search.lists["x_grp"] = <?php echo $d_04_search->grp->Lookup->toClientList() ?>;
fd_04search.lists["x_grp"].options = <?php echo JsonEncode($d_04_search->grp->lookupOptions()) ?>;
fd_04search.lists["x_status"] = <?php echo $d_04_search->status->Lookup->toClientList() ?>;
fd_04search.lists["x_status"].options = <?php echo JsonEncode($d_04_search->status->options(FALSE, TRUE)) ?>;
fd_04search.lists["x_opeartor"] = <?php echo $d_04_search->opeartor->Lookup->toClientList() ?>;
fd_04search.lists["x_opeartor"].options = <?php echo JsonEncode($d_04_search->opeartor->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fd_04search.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($d_04->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $d_04_search->showPageHeader(); ?>
<?php
$d_04_search->showMessage();
?>
<form name="fd_04search" id="fd_04search" class="<?php echo $d_04_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($d_04_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $d_04_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="d_04">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$d_04_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($d_04->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $d_04_search->LeftColumnClass ?>"><span id="elh_d_04_id"><?php echo $d_04->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $d_04_search->RightColumnClass ?>"><div<?php echo $d_04->id->cellAttributes() ?>>
			<span id="el_d_04_id">
<input type="text" data-table="d_04" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($d_04->id->getPlaceHolder()) ?>" value="<?php echo $d_04->id->EditValue ?>"<?php echo $d_04->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($d_04->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label for="x_item" class="<?php echo $d_04_search->LeftColumnClass ?>"><span id="elh_d_04_item"><?php echo $d_04->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		</label>
		<div class="<?php echo $d_04_search->RightColumnClass ?>"><div<?php echo $d_04->item->cellAttributes() ?>>
			<span id="el_d_04_item">
<input type="text" data-table="d_04" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($d_04->item->getPlaceHolder()) ?>" value="<?php echo $d_04->item->EditValue ?>"<?php echo $d_04->item->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($d_04->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $d_04_search->LeftColumnClass ?>"><span id="elh_d_04_grp"><?php echo $d_04->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $d_04_search->RightColumnClass ?>"><div<?php echo $d_04->grp->cellAttributes() ?>>
			<span id="el_d_04_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="d_04" data-field="x_grp" data-value-separator="<?php echo $d_04->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $d_04->grp->editAttributes() ?>>
		<?php echo $d_04->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $d_04->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($d_04->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $d_04_search->LeftColumnClass ?>"><span id="elh_d_04_status"><?php echo $d_04->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $d_04_search->RightColumnClass ?>"><div<?php echo $d_04->status->cellAttributes() ?>>
			<span id="el_d_04_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="d_04" data-field="x_status" data-value-separator="<?php echo $d_04->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $d_04->status->editAttributes() ?>>
		<?php echo $d_04->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($d_04->opeartor->Visible) { // opeartor ?>
	<div id="r_opeartor" class="form-group row">
		<label for="x_opeartor" class="<?php echo $d_04_search->LeftColumnClass ?>"><span id="elh_d_04_opeartor"><?php echo $d_04->opeartor->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_opeartor" id="z_opeartor" value="="></span>
		</label>
		<div class="<?php echo $d_04_search->RightColumnClass ?>"><div<?php echo $d_04->opeartor->cellAttributes() ?>>
			<span id="el_d_04_opeartor">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="d_04" data-field="x_opeartor" data-value-separator="<?php echo $d_04->opeartor->displayValueSeparatorAttribute() ?>" id="x_opeartor" name="x_opeartor"<?php echo $d_04->opeartor->editAttributes() ?>>
		<?php echo $d_04->opeartor->selectOptionListHtml("x_opeartor") ?>
	</select>
</div>
<?php echo $d_04->opeartor->Lookup->getParamTag("p_x_opeartor") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($d_04->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $d_04_search->LeftColumnClass ?>"><span id="elh_d_04_datetime"><?php echo $d_04->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $d_04_search->RightColumnClass ?>"><div<?php echo $d_04->datetime->cellAttributes() ?>>
			<span id="el_d_04_datetime">
<input type="text" data-table="d_04" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($d_04->datetime->getPlaceHolder()) ?>" value="<?php echo $d_04->datetime->EditValue ?>"<?php echo $d_04->datetime->editAttributes() ?>>
<?php if (!$d_04->datetime->ReadOnly && !$d_04->datetime->Disabled && !isset($d_04->datetime->EditAttrs["readonly"]) && !isset($d_04->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fd_04search", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$d_04_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $d_04_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$d_04_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$d_04_search->terminate();
?>