<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$d_06_addopt = new d_06_addopt();

// Run the page
$d_06_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$d_06_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fd_06addopt = currentForm = new ew.Form("fd_06addopt", "addopt");

// Validate form
fd_06addopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($d_06_addopt->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $d_06->item->caption(), $d_06->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($d_06_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $d_06->grp->caption(), $d_06->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($d_06_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $d_06->status->caption(), $d_06->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($d_06_addopt->opeartor->Required) { ?>
			elm = this.getElements("x" + infix + "_opeartor");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $d_06->opeartor->caption(), $d_06->opeartor->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($d_06_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $d_06->datetime->caption(), $d_06->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fd_06addopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fd_06addopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fd_06addopt.lists["x_grp"] = <?php echo $d_06_addopt->grp->Lookup->toClientList() ?>;
fd_06addopt.lists["x_grp"].options = <?php echo JsonEncode($d_06_addopt->grp->lookupOptions()) ?>;
fd_06addopt.lists["x_status"] = <?php echo $d_06_addopt->status->Lookup->toClientList() ?>;
fd_06addopt.lists["x_status"].options = <?php echo JsonEncode($d_06_addopt->status->options(FALSE, TRUE)) ?>;
fd_06addopt.lists["x_opeartor"] = <?php echo $d_06_addopt->opeartor->Lookup->toClientList() ?>;
fd_06addopt.lists["x_opeartor"].options = <?php echo JsonEncode($d_06_addopt->opeartor->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $d_06_addopt->showPageHeader(); ?>
<?php
$d_06_addopt->showMessage();
?>
<form name="fd_06addopt" id="fd_06addopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($d_06_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $d_06_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $d_06_addopt->TableVar ?>">
<?php if ($d_06->item->Visible) { // item ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_item"><?php echo $d_06->item->caption() ?><?php echo ($d_06->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="d_06" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($d_06->item->getPlaceHolder()) ?>" value="<?php echo $d_06->item->EditValue ?>"<?php echo $d_06->item->editAttributes() ?>>
<?php echo $d_06->item->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($d_06->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $d_06->grp->caption() ?><?php echo ($d_06->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="d_06" data-field="x_grp" data-value-separator="<?php echo $d_06->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $d_06->grp->editAttributes() ?>>
		<?php echo $d_06->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $d_06->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $d_06->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($d_06->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $d_06->status->caption() ?><?php echo ($d_06->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="d_06" data-field="x_status" data-value-separator="<?php echo $d_06->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $d_06->status->editAttributes() ?>>
		<?php echo $d_06->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $d_06->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($d_06->opeartor->Visible) { // opeartor ?>
	<input type="hidden" data-table="d_06" data-field="x_opeartor" name="x_opeartor" id="x_opeartor" value="<?php echo HtmlEncode($d_06->opeartor->CurrentValue) ?>">
<?php } ?>
<?php if ($d_06->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="d_06" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($d_06->datetime->CurrentValue) ?>">
	<?php if (!$d_06->datetime->ReadOnly && !$d_06->datetime->Disabled && !isset($d_06->datetime->EditAttrs["readonly"]) && !isset($d_06->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fd_06addopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
</form>
<?php
$d_06_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$d_06_addopt->terminate();
?>