<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$dashboard_edit = new dashboard_edit();

// Run the page
$dashboard_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$dashboard_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fdashboardedit = currentForm = new ew.Form("fdashboardedit", "edit");

// Validate form
fdashboardedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($dashboard_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $dashboard->id->caption(), $dashboard->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($dashboard_edit->item_group->Required) { ?>
			elm = this.getElements("x" + infix + "_item_group");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $dashboard->item_group->caption(), $dashboard->item_group->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($dashboard_edit->icon->Required) { ?>
			elm = this.getElements("x" + infix + "_icon");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $dashboard->icon->caption(), $dashboard->icon->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($dashboard_edit->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $dashboard->image->caption(), $dashboard->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($dashboard_edit->title->Required) { ?>
			elm = this.getElements("x" + infix + "_title");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $dashboard->title->caption(), $dashboard->title->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($dashboard_edit->sub_title->Required) { ?>
			elm = this.getElements("x" + infix + "_sub_title");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $dashboard->sub_title->caption(), $dashboard->sub_title->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($dashboard_edit->url_link->Required) { ?>
			elm = this.getElements("x" + infix + "_url_link");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $dashboard->url_link->caption(), $dashboard->url_link->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($dashboard_edit->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $dashboard->code->caption(), $dashboard->code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($dashboard_edit->order_by->Required) { ?>
			elm = this.getElements("x" + infix + "_order_by");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $dashboard->order_by->caption(), $dashboard->order_by->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_order_by");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($dashboard->order_by->errorMessage()) ?>");
		<?php if ($dashboard_edit->user_level->Required) { ?>
			elm = this.getElements("x" + infix + "_user_level[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $dashboard->user_level->caption(), $dashboard->user_level->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($dashboard_edit->group_by->Required) { ?>
			elm = this.getElements("x" + infix + "_group_by[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $dashboard->group_by->caption(), $dashboard->group_by->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($dashboard_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $dashboard->status->caption(), $dashboard->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($dashboard_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $dashboard->operator->caption(), $dashboard->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($dashboard_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $dashboard->datetime->caption(), $dashboard->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($dashboard_edit->target_window->Required) { ?>
			elm = this.getElements("x" + infix + "_target_window");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $dashboard->target_window->caption(), $dashboard->target_window->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($dashboard_edit->sub_group_by->Required) { ?>
			elm = this.getElements("x" + infix + "_sub_group_by");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $dashboard->sub_group_by->caption(), $dashboard->sub_group_by->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fdashboardedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdashboardedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fdashboardedit.lists["x_item_group"] = <?php echo $dashboard_edit->item_group->Lookup->toClientList() ?>;
fdashboardedit.lists["x_item_group"].options = <?php echo JsonEncode($dashboard_edit->item_group->options(FALSE, TRUE)) ?>;
fdashboardedit.lists["x_user_level[]"] = <?php echo $dashboard_edit->user_level->Lookup->toClientList() ?>;
fdashboardedit.lists["x_user_level[]"].options = <?php echo JsonEncode($dashboard_edit->user_level->lookupOptions()) ?>;
fdashboardedit.lists["x_group_by[]"] = <?php echo $dashboard_edit->group_by->Lookup->toClientList() ?>;
fdashboardedit.lists["x_group_by[]"].options = <?php echo JsonEncode($dashboard_edit->group_by->lookupOptions()) ?>;
fdashboardedit.lists["x_status"] = <?php echo $dashboard_edit->status->Lookup->toClientList() ?>;
fdashboardedit.lists["x_status"].options = <?php echo JsonEncode($dashboard_edit->status->options(FALSE, TRUE)) ?>;
fdashboardedit.lists["x_operator"] = <?php echo $dashboard_edit->operator->Lookup->toClientList() ?>;
fdashboardedit.lists["x_operator"].options = <?php echo JsonEncode($dashboard_edit->operator->lookupOptions()) ?>;
fdashboardedit.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $dashboard_edit->showPageHeader(); ?>
<?php
$dashboard_edit->showMessage();
?>
<form name="fdashboardedit" id="fdashboardedit" class="<?php echo $dashboard_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($dashboard_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $dashboard_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="dashboard">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$dashboard_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($dashboard->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_dashboard_id" class="<?php echo $dashboard_edit->LeftColumnClass ?>"><?php echo $dashboard->id->caption() ?><?php echo ($dashboard->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $dashboard_edit->RightColumnClass ?>"><div<?php echo $dashboard->id->cellAttributes() ?>>
<span id="el_dashboard_id">
<span<?php echo $dashboard->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($dashboard->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="dashboard" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($dashboard->id->CurrentValue) ?>">
<?php echo $dashboard->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($dashboard->item_group->Visible) { // item_group ?>
	<div id="r_item_group" class="form-group row">
		<label id="elh_dashboard_item_group" for="x_item_group" class="<?php echo $dashboard_edit->LeftColumnClass ?>"><?php echo $dashboard->item_group->caption() ?><?php echo ($dashboard->item_group->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $dashboard_edit->RightColumnClass ?>"><div<?php echo $dashboard->item_group->cellAttributes() ?>>
<span id="el_dashboard_item_group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="dashboard" data-field="x_item_group" data-value-separator="<?php echo $dashboard->item_group->displayValueSeparatorAttribute() ?>" id="x_item_group" name="x_item_group"<?php echo $dashboard->item_group->editAttributes() ?>>
		<?php echo $dashboard->item_group->selectOptionListHtml("x_item_group") ?>
	</select>
</div>
</span>
<?php echo $dashboard->item_group->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($dashboard->icon->Visible) { // icon ?>
	<div id="r_icon" class="form-group row">
		<label id="elh_dashboard_icon" for="x_icon" class="<?php echo $dashboard_edit->LeftColumnClass ?>"><?php echo $dashboard->icon->caption() ?><?php echo ($dashboard->icon->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $dashboard_edit->RightColumnClass ?>"><div<?php echo $dashboard->icon->cellAttributes() ?>>
<span id="el_dashboard_icon">
<input type="text" data-table="dashboard" data-field="x_icon" name="x_icon" id="x_icon" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($dashboard->icon->getPlaceHolder()) ?>" value="<?php echo $dashboard->icon->EditValue ?>"<?php echo $dashboard->icon->editAttributes() ?>>
</span>
<?php echo $dashboard->icon->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($dashboard->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_dashboard_image" class="<?php echo $dashboard_edit->LeftColumnClass ?>"><?php echo $dashboard->image->caption() ?><?php echo ($dashboard->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $dashboard_edit->RightColumnClass ?>"><div<?php echo $dashboard->image->cellAttributes() ?>>
<span id="el_dashboard_image">
<div id="fd_x_image">
<span title="<?php echo $dashboard->image->title() ? $dashboard->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($dashboard->image->ReadOnly || $dashboard->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="dashboard" data-field="x_image" name="x_image" id="x_image"<?php echo $dashboard->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $dashboard->image->Upload->FileName ?>">
<?php if (Post("fa_x_image") == "0") { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="96">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $dashboard->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $dashboard->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $dashboard->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($dashboard->title->Visible) { // title ?>
	<div id="r_title" class="form-group row">
		<label id="elh_dashboard_title" for="x_title" class="<?php echo $dashboard_edit->LeftColumnClass ?>"><?php echo $dashboard->title->caption() ?><?php echo ($dashboard->title->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $dashboard_edit->RightColumnClass ?>"><div<?php echo $dashboard->title->cellAttributes() ?>>
<span id="el_dashboard_title">
<input type="text" data-table="dashboard" data-field="x_title" name="x_title" id="x_title" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($dashboard->title->getPlaceHolder()) ?>" value="<?php echo $dashboard->title->EditValue ?>"<?php echo $dashboard->title->editAttributes() ?>>
</span>
<?php echo $dashboard->title->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($dashboard->sub_title->Visible) { // sub_title ?>
	<div id="r_sub_title" class="form-group row">
		<label id="elh_dashboard_sub_title" for="x_sub_title" class="<?php echo $dashboard_edit->LeftColumnClass ?>"><?php echo $dashboard->sub_title->caption() ?><?php echo ($dashboard->sub_title->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $dashboard_edit->RightColumnClass ?>"><div<?php echo $dashboard->sub_title->cellAttributes() ?>>
<span id="el_dashboard_sub_title">
<textarea data-table="dashboard" data-field="x_sub_title" name="x_sub_title" id="x_sub_title" cols="35" rows="4" placeholder="<?php echo HtmlEncode($dashboard->sub_title->getPlaceHolder()) ?>"<?php echo $dashboard->sub_title->editAttributes() ?>><?php echo $dashboard->sub_title->EditValue ?></textarea>
</span>
<?php echo $dashboard->sub_title->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($dashboard->url_link->Visible) { // url_link ?>
	<div id="r_url_link" class="form-group row">
		<label id="elh_dashboard_url_link" for="x_url_link" class="<?php echo $dashboard_edit->LeftColumnClass ?>"><?php echo $dashboard->url_link->caption() ?><?php echo ($dashboard->url_link->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $dashboard_edit->RightColumnClass ?>"><div<?php echo $dashboard->url_link->cellAttributes() ?>>
<span id="el_dashboard_url_link">
<input type="text" data-table="dashboard" data-field="x_url_link" name="x_url_link" id="x_url_link" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($dashboard->url_link->getPlaceHolder()) ?>" value="<?php echo $dashboard->url_link->EditValue ?>"<?php echo $dashboard->url_link->editAttributes() ?>>
</span>
<?php echo $dashboard->url_link->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($dashboard->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_dashboard_code" for="x_code" class="<?php echo $dashboard_edit->LeftColumnClass ?>"><?php echo $dashboard->code->caption() ?><?php echo ($dashboard->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $dashboard_edit->RightColumnClass ?>"><div<?php echo $dashboard->code->cellAttributes() ?>>
<span id="el_dashboard_code">
<textarea data-table="dashboard" data-field="x_code" name="x_code" id="x_code" cols="35" rows="4" placeholder="<?php echo HtmlEncode($dashboard->code->getPlaceHolder()) ?>"<?php echo $dashboard->code->editAttributes() ?>><?php echo $dashboard->code->EditValue ?></textarea>
</span>
<?php echo $dashboard->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($dashboard->order_by->Visible) { // order_by ?>
	<div id="r_order_by" class="form-group row">
		<label id="elh_dashboard_order_by" for="x_order_by" class="<?php echo $dashboard_edit->LeftColumnClass ?>"><?php echo $dashboard->order_by->caption() ?><?php echo ($dashboard->order_by->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $dashboard_edit->RightColumnClass ?>"><div<?php echo $dashboard->order_by->cellAttributes() ?>>
<span id="el_dashboard_order_by">
<input type="text" data-table="dashboard" data-field="x_order_by" name="x_order_by" id="x_order_by" size="30" placeholder="<?php echo HtmlEncode($dashboard->order_by->getPlaceHolder()) ?>" value="<?php echo $dashboard->order_by->EditValue ?>"<?php echo $dashboard->order_by->editAttributes() ?>>
</span>
<?php echo $dashboard->order_by->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($dashboard->user_level->Visible) { // user_level ?>
	<div id="r_user_level" class="form-group row">
		<label id="elh_dashboard_user_level" class="<?php echo $dashboard_edit->LeftColumnClass ?>"><?php echo $dashboard->user_level->caption() ?><?php echo ($dashboard->user_level->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $dashboard_edit->RightColumnClass ?>"><div<?php echo $dashboard->user_level->cellAttributes() ?>>
<span id="el_dashboard_user_level">
<div id="tp_x_user_level" class="ew-template"><input type="checkbox" class="form-check-input" data-table="dashboard" data-field="x_user_level" data-value-separator="<?php echo $dashboard->user_level->displayValueSeparatorAttribute() ?>" name="x_user_level[]" id="x_user_level[]" value="{value}"<?php echo $dashboard->user_level->editAttributes() ?>></div>
<div id="dsl_x_user_level" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $dashboard->user_level->checkBoxListHtml(FALSE, "x_user_level[]") ?>
</div></div>
<?php echo $dashboard->user_level->Lookup->getParamTag("p_x_user_level") ?>
</span>
<?php echo $dashboard->user_level->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($dashboard->group_by->Visible) { // group_by ?>
	<div id="r_group_by" class="form-group row">
		<label id="elh_dashboard_group_by" class="<?php echo $dashboard_edit->LeftColumnClass ?>"><?php echo $dashboard->group_by->caption() ?><?php echo ($dashboard->group_by->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $dashboard_edit->RightColumnClass ?>"><div<?php echo $dashboard->group_by->cellAttributes() ?>>
<span id="el_dashboard_group_by">
<div id="tp_x_group_by" class="ew-template"><input type="checkbox" class="form-check-input" data-table="dashboard" data-field="x_group_by" data-value-separator="<?php echo $dashboard->group_by->displayValueSeparatorAttribute() ?>" name="x_group_by[]" id="x_group_by[]" value="{value}"<?php echo $dashboard->group_by->editAttributes() ?>></div>
<div id="dsl_x_group_by" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $dashboard->group_by->checkBoxListHtml(FALSE, "x_group_by[]") ?>
</div></div>
<?php echo $dashboard->group_by->Lookup->getParamTag("p_x_group_by") ?>
</span>
<?php echo $dashboard->group_by->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($dashboard->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_dashboard_status" for="x_status" class="<?php echo $dashboard_edit->LeftColumnClass ?>"><?php echo $dashboard->status->caption() ?><?php echo ($dashboard->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $dashboard_edit->RightColumnClass ?>"><div<?php echo $dashboard->status->cellAttributes() ?>>
<span id="el_dashboard_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="dashboard" data-field="x_status" data-value-separator="<?php echo $dashboard->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $dashboard->status->editAttributes() ?>>
		<?php echo $dashboard->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $dashboard->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($dashboard->target_window->Visible) { // target_window ?>
	<div id="r_target_window" class="form-group row">
		<label id="elh_dashboard_target_window" for="x_target_window" class="<?php echo $dashboard_edit->LeftColumnClass ?>"><?php echo $dashboard->target_window->caption() ?><?php echo ($dashboard->target_window->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $dashboard_edit->RightColumnClass ?>"><div<?php echo $dashboard->target_window->cellAttributes() ?>>
<span id="el_dashboard_target_window">
<input type="text" data-table="dashboard" data-field="x_target_window" name="x_target_window" id="x_target_window" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($dashboard->target_window->getPlaceHolder()) ?>" value="<?php echo $dashboard->target_window->EditValue ?>"<?php echo $dashboard->target_window->editAttributes() ?>>
</span>
<?php echo $dashboard->target_window->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($dashboard->sub_group_by->Visible) { // sub_group_by ?>
	<div id="r_sub_group_by" class="form-group row">
		<label id="elh_dashboard_sub_group_by" for="x_sub_group_by" class="<?php echo $dashboard_edit->LeftColumnClass ?>"><?php echo $dashboard->sub_group_by->caption() ?><?php echo ($dashboard->sub_group_by->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $dashboard_edit->RightColumnClass ?>"><div<?php echo $dashboard->sub_group_by->cellAttributes() ?>>
<span id="el_dashboard_sub_group_by">
<input type="text" data-table="dashboard" data-field="x_sub_group_by" name="x_sub_group_by" id="x_sub_group_by" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($dashboard->sub_group_by->getPlaceHolder()) ?>" value="<?php echo $dashboard->sub_group_by->EditValue ?>"<?php echo $dashboard->sub_group_by->editAttributes() ?>>
</span>
<?php echo $dashboard->sub_group_by->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$dashboard_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $dashboard_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $dashboard_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$dashboard_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$dashboard_edit->terminate();
?>