<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$dashboard_list = new dashboard_list();

// Run the page
$dashboard_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$dashboard_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$dashboard->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fdashboardlist = currentForm = new ew.Form("fdashboardlist", "list");
fdashboardlist.formKeyCountName = '<?php echo $dashboard_list->FormKeyCountName ?>';

// Form_CustomValidate event
fdashboardlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdashboardlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fdashboardlist.lists["x_item_group"] = <?php echo $dashboard_list->item_group->Lookup->toClientList() ?>;
fdashboardlist.lists["x_item_group"].options = <?php echo JsonEncode($dashboard_list->item_group->options(FALSE, TRUE)) ?>;
fdashboardlist.lists["x_user_level[]"] = <?php echo $dashboard_list->user_level->Lookup->toClientList() ?>;
fdashboardlist.lists["x_user_level[]"].options = <?php echo JsonEncode($dashboard_list->user_level->lookupOptions()) ?>;
fdashboardlist.lists["x_group_by[]"] = <?php echo $dashboard_list->group_by->Lookup->toClientList() ?>;
fdashboardlist.lists["x_group_by[]"].options = <?php echo JsonEncode($dashboard_list->group_by->lookupOptions()) ?>;
fdashboardlist.lists["x_status"] = <?php echo $dashboard_list->status->Lookup->toClientList() ?>;
fdashboardlist.lists["x_status"].options = <?php echo JsonEncode($dashboard_list->status->options(FALSE, TRUE)) ?>;
fdashboardlist.lists["x_operator"] = <?php echo $dashboard_list->operator->Lookup->toClientList() ?>;
fdashboardlist.lists["x_operator"].options = <?php echo JsonEncode($dashboard_list->operator->lookupOptions()) ?>;
fdashboardlist.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fdashboardlistsrch = currentSearchForm = new ew.Form("fdashboardlistsrch");

// Validate function for search
fdashboardlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fdashboardlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdashboardlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fdashboardlistsrch.lists["x_item_group"] = <?php echo $dashboard_list->item_group->Lookup->toClientList() ?>;
fdashboardlistsrch.lists["x_item_group"].options = <?php echo JsonEncode($dashboard_list->item_group->options(FALSE, TRUE)) ?>;

// Filters
fdashboardlistsrch.filterList = <?php echo $dashboard_list->getFilterList() ?>;

// Init search panel as collapsed
fdashboardlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$dashboard->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($dashboard_list->TotalRecs > 0 && $dashboard_list->ExportOptions->visible()) { ?>
<?php $dashboard_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($dashboard_list->ImportOptions->visible()) { ?>
<?php $dashboard_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($dashboard_list->SearchOptions->visible()) { ?>
<?php $dashboard_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($dashboard_list->FilterOptions->visible()) { ?>
<?php $dashboard_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$dashboard_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$dashboard->isExport() && !$dashboard->CurrentAction) { ?>
<form name="fdashboardlistsrch" id="fdashboardlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($dashboard_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fdashboardlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="dashboard">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$dashboard_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$dashboard->RowType = ROWTYPE_SEARCH;

// Render row
$dashboard->resetAttributes();
$dashboard_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($dashboard->item_group->Visible) { // item_group ?>
	<div id="xsc_item_group" class="ew-cell form-group">
		<label for="x_item_group" class="ew-search-caption ew-label"><?php echo $dashboard->item_group->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_item_group" id="z_item_group" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="dashboard" data-field="x_item_group" data-value-separator="<?php echo $dashboard->item_group->displayValueSeparatorAttribute() ?>" id="x_item_group" name="x_item_group"<?php echo $dashboard->item_group->editAttributes() ?>>
		<?php echo $dashboard->item_group->selectOptionListHtml("x_item_group") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($dashboard->title->Visible) { // title ?>
	<div id="xsc_title" class="ew-cell form-group">
		<label for="x_title" class="ew-search-caption ew-label"><?php echo $dashboard->title->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_title" id="z_title" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="dashboard" data-field="x_title" name="x_title" id="x_title" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($dashboard->title->getPlaceHolder()) ?>" value="<?php echo $dashboard->title->EditValue ?>"<?php echo $dashboard->title->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($dashboard_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($dashboard_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $dashboard_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($dashboard_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($dashboard_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($dashboard_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($dashboard_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $dashboard_list->showPageHeader(); ?>
<?php
$dashboard_list->showMessage();
?>
<?php if ($dashboard_list->TotalRecs > 0 || $dashboard->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($dashboard_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> dashboard">
<?php if (!$dashboard->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$dashboard->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($dashboard_list->Pager)) $dashboard_list->Pager = new PrevNextPager($dashboard_list->StartRec, $dashboard_list->DisplayRecs, $dashboard_list->TotalRecs, $dashboard_list->AutoHidePager) ?>
<?php if ($dashboard_list->Pager->RecordCount > 0 && $dashboard_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($dashboard_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $dashboard_list->pageUrl() ?>start=<?php echo $dashboard_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($dashboard_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $dashboard_list->pageUrl() ?>start=<?php echo $dashboard_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $dashboard_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($dashboard_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $dashboard_list->pageUrl() ?>start=<?php echo $dashboard_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($dashboard_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $dashboard_list->pageUrl() ?>start=<?php echo $dashboard_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $dashboard_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($dashboard_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $dashboard_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $dashboard_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $dashboard_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($dashboard_list->TotalRecs > 0 && (!$dashboard_list->AutoHidePageSizeSelector || $dashboard_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="dashboard">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($dashboard_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($dashboard_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($dashboard_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($dashboard_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($dashboard_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($dashboard->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $dashboard_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fdashboardlist" id="fdashboardlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($dashboard_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $dashboard_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="dashboard">
<div id="gmp_dashboard" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($dashboard_list->TotalRecs > 0 || $dashboard->isGridEdit()) { ?>
<table id="tbl_dashboardlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$dashboard_list->RowType = ROWTYPE_HEADER;

// Render list options
$dashboard_list->renderListOptions();

// Render list options (header, left)
$dashboard_list->ListOptions->render("header", "left");
?>
<?php if ($dashboard->id->Visible) { // id ?>
	<?php if ($dashboard->sortUrl($dashboard->id) == "") { ?>
		<th data-name="id" class="<?php echo $dashboard->id->headerCellClass() ?>"><div id="elh_dashboard_id" class="dashboard_id"><div class="ew-table-header-caption"><?php echo $dashboard->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $dashboard->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dashboard->SortUrl($dashboard->id) ?>',2);"><div id="elh_dashboard_id" class="dashboard_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dashboard->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($dashboard->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dashboard->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dashboard->item_group->Visible) { // item_group ?>
	<?php if ($dashboard->sortUrl($dashboard->item_group) == "") { ?>
		<th data-name="item_group" class="<?php echo $dashboard->item_group->headerCellClass() ?>"><div id="elh_dashboard_item_group" class="dashboard_item_group"><div class="ew-table-header-caption"><?php echo $dashboard->item_group->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item_group" class="<?php echo $dashboard->item_group->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dashboard->SortUrl($dashboard->item_group) ?>',2);"><div id="elh_dashboard_item_group" class="dashboard_item_group">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dashboard->item_group->caption() ?></span><span class="ew-table-header-sort"><?php if ($dashboard->item_group->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dashboard->item_group->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dashboard->icon->Visible) { // icon ?>
	<?php if ($dashboard->sortUrl($dashboard->icon) == "") { ?>
		<th data-name="icon" class="<?php echo $dashboard->icon->headerCellClass() ?>"><div id="elh_dashboard_icon" class="dashboard_icon"><div class="ew-table-header-caption"><?php echo $dashboard->icon->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="icon" class="<?php echo $dashboard->icon->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dashboard->SortUrl($dashboard->icon) ?>',2);"><div id="elh_dashboard_icon" class="dashboard_icon">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dashboard->icon->caption() ?></span><span class="ew-table-header-sort"><?php if ($dashboard->icon->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dashboard->icon->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dashboard->image->Visible) { // image ?>
	<?php if ($dashboard->sortUrl($dashboard->image) == "") { ?>
		<th data-name="image" class="<?php echo $dashboard->image->headerCellClass() ?>"><div id="elh_dashboard_image" class="dashboard_image"><div class="ew-table-header-caption"><?php echo $dashboard->image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="image" class="<?php echo $dashboard->image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dashboard->SortUrl($dashboard->image) ?>',2);"><div id="elh_dashboard_image" class="dashboard_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dashboard->image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($dashboard->image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dashboard->image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dashboard->title->Visible) { // title ?>
	<?php if ($dashboard->sortUrl($dashboard->title) == "") { ?>
		<th data-name="title" class="<?php echo $dashboard->title->headerCellClass() ?>"><div id="elh_dashboard_title" class="dashboard_title"><div class="ew-table-header-caption"><?php echo $dashboard->title->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="title" class="<?php echo $dashboard->title->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dashboard->SortUrl($dashboard->title) ?>',2);"><div id="elh_dashboard_title" class="dashboard_title">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dashboard->title->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($dashboard->title->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dashboard->title->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dashboard->url_link->Visible) { // url_link ?>
	<?php if ($dashboard->sortUrl($dashboard->url_link) == "") { ?>
		<th data-name="url_link" class="<?php echo $dashboard->url_link->headerCellClass() ?>"><div id="elh_dashboard_url_link" class="dashboard_url_link"><div class="ew-table-header-caption"><?php echo $dashboard->url_link->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url_link" class="<?php echo $dashboard->url_link->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dashboard->SortUrl($dashboard->url_link) ?>',2);"><div id="elh_dashboard_url_link" class="dashboard_url_link">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dashboard->url_link->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($dashboard->url_link->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dashboard->url_link->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dashboard->order_by->Visible) { // order_by ?>
	<?php if ($dashboard->sortUrl($dashboard->order_by) == "") { ?>
		<th data-name="order_by" class="<?php echo $dashboard->order_by->headerCellClass() ?>"><div id="elh_dashboard_order_by" class="dashboard_order_by"><div class="ew-table-header-caption"><?php echo $dashboard->order_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_by" class="<?php echo $dashboard->order_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dashboard->SortUrl($dashboard->order_by) ?>',2);"><div id="elh_dashboard_order_by" class="dashboard_order_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dashboard->order_by->caption() ?></span><span class="ew-table-header-sort"><?php if ($dashboard->order_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dashboard->order_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dashboard->user_level->Visible) { // user_level ?>
	<?php if ($dashboard->sortUrl($dashboard->user_level) == "") { ?>
		<th data-name="user_level" class="<?php echo $dashboard->user_level->headerCellClass() ?>"><div id="elh_dashboard_user_level" class="dashboard_user_level"><div class="ew-table-header-caption"><?php echo $dashboard->user_level->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="user_level" class="<?php echo $dashboard->user_level->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dashboard->SortUrl($dashboard->user_level) ?>',2);"><div id="elh_dashboard_user_level" class="dashboard_user_level">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dashboard->user_level->caption() ?></span><span class="ew-table-header-sort"><?php if ($dashboard->user_level->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dashboard->user_level->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dashboard->group_by->Visible) { // group_by ?>
	<?php if ($dashboard->sortUrl($dashboard->group_by) == "") { ?>
		<th data-name="group_by" class="<?php echo $dashboard->group_by->headerCellClass() ?>"><div id="elh_dashboard_group_by" class="dashboard_group_by"><div class="ew-table-header-caption"><?php echo $dashboard->group_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="group_by" class="<?php echo $dashboard->group_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dashboard->SortUrl($dashboard->group_by) ?>',2);"><div id="elh_dashboard_group_by" class="dashboard_group_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dashboard->group_by->caption() ?></span><span class="ew-table-header-sort"><?php if ($dashboard->group_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dashboard->group_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dashboard->status->Visible) { // status ?>
	<?php if ($dashboard->sortUrl($dashboard->status) == "") { ?>
		<th data-name="status" class="<?php echo $dashboard->status->headerCellClass() ?>"><div id="elh_dashboard_status" class="dashboard_status"><div class="ew-table-header-caption"><?php echo $dashboard->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $dashboard->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dashboard->SortUrl($dashboard->status) ?>',2);"><div id="elh_dashboard_status" class="dashboard_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dashboard->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($dashboard->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dashboard->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dashboard->operator->Visible) { // operator ?>
	<?php if ($dashboard->sortUrl($dashboard->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $dashboard->operator->headerCellClass() ?>"><div id="elh_dashboard_operator" class="dashboard_operator"><div class="ew-table-header-caption"><?php echo $dashboard->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $dashboard->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dashboard->SortUrl($dashboard->operator) ?>',2);"><div id="elh_dashboard_operator" class="dashboard_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dashboard->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($dashboard->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dashboard->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dashboard->datetime->Visible) { // datetime ?>
	<?php if ($dashboard->sortUrl($dashboard->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $dashboard->datetime->headerCellClass() ?>"><div id="elh_dashboard_datetime" class="dashboard_datetime"><div class="ew-table-header-caption"><?php echo $dashboard->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $dashboard->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dashboard->SortUrl($dashboard->datetime) ?>',2);"><div id="elh_dashboard_datetime" class="dashboard_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dashboard->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($dashboard->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dashboard->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dashboard->target_window->Visible) { // target_window ?>
	<?php if ($dashboard->sortUrl($dashboard->target_window) == "") { ?>
		<th data-name="target_window" class="<?php echo $dashboard->target_window->headerCellClass() ?>"><div id="elh_dashboard_target_window" class="dashboard_target_window"><div class="ew-table-header-caption"><?php echo $dashboard->target_window->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="target_window" class="<?php echo $dashboard->target_window->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dashboard->SortUrl($dashboard->target_window) ?>',2);"><div id="elh_dashboard_target_window" class="dashboard_target_window">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dashboard->target_window->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($dashboard->target_window->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dashboard->target_window->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dashboard->sub_group_by->Visible) { // sub_group_by ?>
	<?php if ($dashboard->sortUrl($dashboard->sub_group_by) == "") { ?>
		<th data-name="sub_group_by" class="<?php echo $dashboard->sub_group_by->headerCellClass() ?>"><div id="elh_dashboard_sub_group_by" class="dashboard_sub_group_by"><div class="ew-table-header-caption"><?php echo $dashboard->sub_group_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sub_group_by" class="<?php echo $dashboard->sub_group_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dashboard->SortUrl($dashboard->sub_group_by) ?>',2);"><div id="elh_dashboard_sub_group_by" class="dashboard_sub_group_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dashboard->sub_group_by->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($dashboard->sub_group_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dashboard->sub_group_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$dashboard_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($dashboard->ExportAll && $dashboard->isExport()) {
	$dashboard_list->StopRec = $dashboard_list->TotalRecs;
} else {

	// Set the last record to display
	if ($dashboard_list->TotalRecs > $dashboard_list->StartRec + $dashboard_list->DisplayRecs - 1)
		$dashboard_list->StopRec = $dashboard_list->StartRec + $dashboard_list->DisplayRecs - 1;
	else
		$dashboard_list->StopRec = $dashboard_list->TotalRecs;
}
$dashboard_list->RecCnt = $dashboard_list->StartRec - 1;
if ($dashboard_list->Recordset && !$dashboard_list->Recordset->EOF) {
	$dashboard_list->Recordset->moveFirst();
	$selectLimit = $dashboard_list->UseSelectLimit;
	if (!$selectLimit && $dashboard_list->StartRec > 1)
		$dashboard_list->Recordset->move($dashboard_list->StartRec - 1);
} elseif (!$dashboard->AllowAddDeleteRow && $dashboard_list->StopRec == 0) {
	$dashboard_list->StopRec = $dashboard->GridAddRowCount;
}

// Initialize aggregate
$dashboard->RowType = ROWTYPE_AGGREGATEINIT;
$dashboard->resetAttributes();
$dashboard_list->renderRow();
while ($dashboard_list->RecCnt < $dashboard_list->StopRec) {
	$dashboard_list->RecCnt++;
	if ($dashboard_list->RecCnt >= $dashboard_list->StartRec) {
		$dashboard_list->RowCnt++;

		// Set up key count
		$dashboard_list->KeyCount = $dashboard_list->RowIndex;

		// Init row class and style
		$dashboard->resetAttributes();
		$dashboard->CssClass = "";
		if ($dashboard->isGridAdd()) {
		} else {
			$dashboard_list->loadRowValues($dashboard_list->Recordset); // Load row values
		}
		$dashboard->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$dashboard->RowAttrs = array_merge($dashboard->RowAttrs, array('data-rowindex'=>$dashboard_list->RowCnt, 'id'=>'r' . $dashboard_list->RowCnt . '_dashboard', 'data-rowtype'=>$dashboard->RowType));

		// Render row
		$dashboard_list->renderRow();

		// Render list options
		$dashboard_list->renderListOptions();
?>
	<tr<?php echo $dashboard->rowAttributes() ?>>
<?php

// Render list options (body, left)
$dashboard_list->ListOptions->render("body", "left", $dashboard_list->RowCnt);
?>
	<?php if ($dashboard->id->Visible) { // id ?>
		<td data-name="id"<?php echo $dashboard->id->cellAttributes() ?>>
<span id="el<?php echo $dashboard_list->RowCnt ?>_dashboard_id" class="dashboard_id">
<span<?php echo $dashboard->id->viewAttributes() ?>>
<?php echo $dashboard->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dashboard->item_group->Visible) { // item_group ?>
		<td data-name="item_group"<?php echo $dashboard->item_group->cellAttributes() ?>>
<span id="el<?php echo $dashboard_list->RowCnt ?>_dashboard_item_group" class="dashboard_item_group">
<span<?php echo $dashboard->item_group->viewAttributes() ?>>
<?php echo $dashboard->item_group->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dashboard->icon->Visible) { // icon ?>
		<td data-name="icon"<?php echo $dashboard->icon->cellAttributes() ?>>
<span id="el<?php echo $dashboard_list->RowCnt ?>_dashboard_icon" class="dashboard_icon">
<span<?php echo $dashboard->icon->viewAttributes() ?>>
<?php echo $dashboard->icon->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dashboard->image->Visible) { // image ?>
		<td data-name="image"<?php echo $dashboard->image->cellAttributes() ?>>
<span id="el<?php echo $dashboard_list->RowCnt ?>_dashboard_image" class="dashboard_image">
<span<?php echo $dashboard->image->viewAttributes() ?>>
<?php echo GetFileViewTag($dashboard->image, $dashboard->image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($dashboard->title->Visible) { // title ?>
		<td data-name="title"<?php echo $dashboard->title->cellAttributes() ?>>
<span id="el<?php echo $dashboard_list->RowCnt ?>_dashboard_title" class="dashboard_title">
<span<?php echo $dashboard->title->viewAttributes() ?>>
<?php echo $dashboard->title->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dashboard->url_link->Visible) { // url_link ?>
		<td data-name="url_link"<?php echo $dashboard->url_link->cellAttributes() ?>>
<span id="el<?php echo $dashboard_list->RowCnt ?>_dashboard_url_link" class="dashboard_url_link">
<span<?php echo $dashboard->url_link->viewAttributes() ?>>
<?php echo $dashboard->url_link->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dashboard->order_by->Visible) { // order_by ?>
		<td data-name="order_by"<?php echo $dashboard->order_by->cellAttributes() ?>>
<span id="el<?php echo $dashboard_list->RowCnt ?>_dashboard_order_by" class="dashboard_order_by">
<span<?php echo $dashboard->order_by->viewAttributes() ?>>
<?php echo $dashboard->order_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dashboard->user_level->Visible) { // user_level ?>
		<td data-name="user_level"<?php echo $dashboard->user_level->cellAttributes() ?>>
<span id="el<?php echo $dashboard_list->RowCnt ?>_dashboard_user_level" class="dashboard_user_level">
<span<?php echo $dashboard->user_level->viewAttributes() ?>>
<?php echo $dashboard->user_level->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dashboard->group_by->Visible) { // group_by ?>
		<td data-name="group_by"<?php echo $dashboard->group_by->cellAttributes() ?>>
<span id="el<?php echo $dashboard_list->RowCnt ?>_dashboard_group_by" class="dashboard_group_by">
<span<?php echo $dashboard->group_by->viewAttributes() ?>>
<?php echo $dashboard->group_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dashboard->status->Visible) { // status ?>
		<td data-name="status"<?php echo $dashboard->status->cellAttributes() ?>>
<span id="el<?php echo $dashboard_list->RowCnt ?>_dashboard_status" class="dashboard_status">
<span<?php echo $dashboard->status->viewAttributes() ?>>
<?php echo $dashboard->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dashboard->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $dashboard->operator->cellAttributes() ?>>
<span id="el<?php echo $dashboard_list->RowCnt ?>_dashboard_operator" class="dashboard_operator">
<span<?php echo $dashboard->operator->viewAttributes() ?>>
<?php echo $dashboard->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dashboard->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $dashboard->datetime->cellAttributes() ?>>
<span id="el<?php echo $dashboard_list->RowCnt ?>_dashboard_datetime" class="dashboard_datetime">
<span<?php echo $dashboard->datetime->viewAttributes() ?>>
<?php echo $dashboard->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dashboard->target_window->Visible) { // target_window ?>
		<td data-name="target_window"<?php echo $dashboard->target_window->cellAttributes() ?>>
<span id="el<?php echo $dashboard_list->RowCnt ?>_dashboard_target_window" class="dashboard_target_window">
<span<?php echo $dashboard->target_window->viewAttributes() ?>>
<?php echo $dashboard->target_window->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dashboard->sub_group_by->Visible) { // sub_group_by ?>
		<td data-name="sub_group_by"<?php echo $dashboard->sub_group_by->cellAttributes() ?>>
<span id="el<?php echo $dashboard_list->RowCnt ?>_dashboard_sub_group_by" class="dashboard_sub_group_by">
<span<?php echo $dashboard->sub_group_by->viewAttributes() ?>>
<?php echo $dashboard->sub_group_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$dashboard_list->ListOptions->render("body", "right", $dashboard_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$dashboard->isGridAdd())
		$dashboard_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$dashboard->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($dashboard_list->Recordset)
	$dashboard_list->Recordset->Close();
?>
<?php if (!$dashboard->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$dashboard->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($dashboard_list->Pager)) $dashboard_list->Pager = new PrevNextPager($dashboard_list->StartRec, $dashboard_list->DisplayRecs, $dashboard_list->TotalRecs, $dashboard_list->AutoHidePager) ?>
<?php if ($dashboard_list->Pager->RecordCount > 0 && $dashboard_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($dashboard_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $dashboard_list->pageUrl() ?>start=<?php echo $dashboard_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($dashboard_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $dashboard_list->pageUrl() ?>start=<?php echo $dashboard_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $dashboard_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($dashboard_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $dashboard_list->pageUrl() ?>start=<?php echo $dashboard_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($dashboard_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $dashboard_list->pageUrl() ?>start=<?php echo $dashboard_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $dashboard_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($dashboard_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $dashboard_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $dashboard_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $dashboard_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($dashboard_list->TotalRecs > 0 && (!$dashboard_list->AutoHidePageSizeSelector || $dashboard_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="dashboard">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($dashboard_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($dashboard_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($dashboard_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($dashboard_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($dashboard_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($dashboard->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $dashboard_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($dashboard_list->TotalRecs == 0 && !$dashboard->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $dashboard_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$dashboard_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$dashboard->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$dashboard->isExport()) { ?>
<script>
ew.scrollableTable("gmp_dashboard", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$dashboard_list->terminate();
?>