<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$dashboard_search = new dashboard_search();

// Run the page
$dashboard_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$dashboard_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($dashboard_search->IsModal) { ?>
var fdashboardsearch = currentAdvancedSearchForm = new ew.Form("fdashboardsearch", "search");
<?php } else { ?>
var fdashboardsearch = currentForm = new ew.Form("fdashboardsearch", "search");
<?php } ?>

// Form_CustomValidate event
fdashboardsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdashboardsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fdashboardsearch.lists["x_item_group"] = <?php echo $dashboard_search->item_group->Lookup->toClientList() ?>;
fdashboardsearch.lists["x_item_group"].options = <?php echo JsonEncode($dashboard_search->item_group->options(FALSE, TRUE)) ?>;
fdashboardsearch.lists["x_user_level[]"] = <?php echo $dashboard_search->user_level->Lookup->toClientList() ?>;
fdashboardsearch.lists["x_user_level[]"].options = <?php echo JsonEncode($dashboard_search->user_level->lookupOptions()) ?>;
fdashboardsearch.lists["x_status"] = <?php echo $dashboard_search->status->Lookup->toClientList() ?>;
fdashboardsearch.lists["x_status"].options = <?php echo JsonEncode($dashboard_search->status->options(FALSE, TRUE)) ?>;
fdashboardsearch.lists["x_operator"] = <?php echo $dashboard_search->operator->Lookup->toClientList() ?>;
fdashboardsearch.lists["x_operator"].options = <?php echo JsonEncode($dashboard_search->operator->lookupOptions()) ?>;
fdashboardsearch.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

fdashboardsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($dashboard->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_order_by");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($dashboard->order_by->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($dashboard->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($dashboard->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $dashboard_search->showPageHeader(); ?>
<?php
$dashboard_search->showMessage();
?>
<form name="fdashboardsearch" id="fdashboardsearch" class="<?php echo $dashboard_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($dashboard_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $dashboard_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="dashboard">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$dashboard_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($dashboard->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $dashboard_search->LeftColumnClass ?>"><span id="elh_dashboard_id"><?php echo $dashboard->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $dashboard_search->RightColumnClass ?>"><div<?php echo $dashboard->id->cellAttributes() ?>>
			<span id="el_dashboard_id">
<input type="text" data-table="dashboard" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($dashboard->id->getPlaceHolder()) ?>" value="<?php echo $dashboard->id->EditValue ?>"<?php echo $dashboard->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($dashboard->item_group->Visible) { // item_group ?>
	<div id="r_item_group" class="form-group row">
		<label for="x_item_group" class="<?php echo $dashboard_search->LeftColumnClass ?>"><span id="elh_dashboard_item_group"><?php echo $dashboard->item_group->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_item_group" id="z_item_group" value="="></span>
		</label>
		<div class="<?php echo $dashboard_search->RightColumnClass ?>"><div<?php echo $dashboard->item_group->cellAttributes() ?>>
			<span id="el_dashboard_item_group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="dashboard" data-field="x_item_group" data-value-separator="<?php echo $dashboard->item_group->displayValueSeparatorAttribute() ?>" id="x_item_group" name="x_item_group"<?php echo $dashboard->item_group->editAttributes() ?>>
		<?php echo $dashboard->item_group->selectOptionListHtml("x_item_group") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($dashboard->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $dashboard_search->LeftColumnClass ?>"><span id="elh_dashboard_image"><?php echo $dashboard->image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_image" id="z_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $dashboard_search->RightColumnClass ?>"><div<?php echo $dashboard->image->cellAttributes() ?>>
			<span id="el_dashboard_image">
<input type="text" data-table="dashboard" data-field="x_image" name="x_image" id="x_image" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($dashboard->image->getPlaceHolder()) ?>" value="<?php echo $dashboard->image->EditValue ?>"<?php echo $dashboard->image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($dashboard->title->Visible) { // title ?>
	<div id="r_title" class="form-group row">
		<label for="x_title" class="<?php echo $dashboard_search->LeftColumnClass ?>"><span id="elh_dashboard_title"><?php echo $dashboard->title->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_title" id="z_title" value="LIKE"></span>
		</label>
		<div class="<?php echo $dashboard_search->RightColumnClass ?>"><div<?php echo $dashboard->title->cellAttributes() ?>>
			<span id="el_dashboard_title">
<input type="text" data-table="dashboard" data-field="x_title" name="x_title" id="x_title" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($dashboard->title->getPlaceHolder()) ?>" value="<?php echo $dashboard->title->EditValue ?>"<?php echo $dashboard->title->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($dashboard->sub_title->Visible) { // sub_title ?>
	<div id="r_sub_title" class="form-group row">
		<label for="x_sub_title" class="<?php echo $dashboard_search->LeftColumnClass ?>"><span id="elh_dashboard_sub_title"><?php echo $dashboard->sub_title->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sub_title" id="z_sub_title" value="LIKE"></span>
		</label>
		<div class="<?php echo $dashboard_search->RightColumnClass ?>"><div<?php echo $dashboard->sub_title->cellAttributes() ?>>
			<span id="el_dashboard_sub_title">
<input type="text" data-table="dashboard" data-field="x_sub_title" name="x_sub_title" id="x_sub_title" size="35" placeholder="<?php echo HtmlEncode($dashboard->sub_title->getPlaceHolder()) ?>" value="<?php echo $dashboard->sub_title->EditValue ?>"<?php echo $dashboard->sub_title->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($dashboard->url_link->Visible) { // url_link ?>
	<div id="r_url_link" class="form-group row">
		<label for="x_url_link" class="<?php echo $dashboard_search->LeftColumnClass ?>"><span id="elh_dashboard_url_link"><?php echo $dashboard->url_link->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_url_link" id="z_url_link" value="LIKE"></span>
		</label>
		<div class="<?php echo $dashboard_search->RightColumnClass ?>"><div<?php echo $dashboard->url_link->cellAttributes() ?>>
			<span id="el_dashboard_url_link">
<input type="text" data-table="dashboard" data-field="x_url_link" name="x_url_link" id="x_url_link" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($dashboard->url_link->getPlaceHolder()) ?>" value="<?php echo $dashboard->url_link->EditValue ?>"<?php echo $dashboard->url_link->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($dashboard->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $dashboard_search->LeftColumnClass ?>"><span id="elh_dashboard_code"><?php echo $dashboard->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code" id="z_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $dashboard_search->RightColumnClass ?>"><div<?php echo $dashboard->code->cellAttributes() ?>>
			<span id="el_dashboard_code">
<input type="text" data-table="dashboard" data-field="x_code" name="x_code" id="x_code" size="35" placeholder="<?php echo HtmlEncode($dashboard->code->getPlaceHolder()) ?>" value="<?php echo $dashboard->code->EditValue ?>"<?php echo $dashboard->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($dashboard->order_by->Visible) { // order_by ?>
	<div id="r_order_by" class="form-group row">
		<label for="x_order_by" class="<?php echo $dashboard_search->LeftColumnClass ?>"><span id="elh_dashboard_order_by"><?php echo $dashboard->order_by->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_by" id="z_order_by" value="="></span>
		</label>
		<div class="<?php echo $dashboard_search->RightColumnClass ?>"><div<?php echo $dashboard->order_by->cellAttributes() ?>>
			<span id="el_dashboard_order_by">
<input type="text" data-table="dashboard" data-field="x_order_by" name="x_order_by" id="x_order_by" size="30" placeholder="<?php echo HtmlEncode($dashboard->order_by->getPlaceHolder()) ?>" value="<?php echo $dashboard->order_by->EditValue ?>"<?php echo $dashboard->order_by->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($dashboard->user_level->Visible) { // user_level ?>
	<div id="r_user_level" class="form-group row">
		<label class="<?php echo $dashboard_search->LeftColumnClass ?>"><span id="elh_dashboard_user_level"><?php echo $dashboard->user_level->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_user_level" id="z_user_level" value="="></span>
		</label>
		<div class="<?php echo $dashboard_search->RightColumnClass ?>"><div<?php echo $dashboard->user_level->cellAttributes() ?>>
			<span id="el_dashboard_user_level">
<div id="tp_x_user_level" class="ew-template"><input type="checkbox" class="form-check-input" data-table="dashboard" data-field="x_user_level" data-value-separator="<?php echo $dashboard->user_level->displayValueSeparatorAttribute() ?>" name="x_user_level[]" id="x_user_level[]" value="{value}"<?php echo $dashboard->user_level->editAttributes() ?>></div>
<div id="dsl_x_user_level" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $dashboard->user_level->checkBoxListHtml(FALSE, "x_user_level[]") ?>
</div></div>
<?php echo $dashboard->user_level->Lookup->getParamTag("p_x_user_level") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($dashboard->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $dashboard_search->LeftColumnClass ?>"><span id="elh_dashboard_status"><?php echo $dashboard->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $dashboard_search->RightColumnClass ?>"><div<?php echo $dashboard->status->cellAttributes() ?>>
			<span id="el_dashboard_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="dashboard" data-field="x_status" data-value-separator="<?php echo $dashboard->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $dashboard->status->editAttributes() ?>>
		<?php echo $dashboard->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($dashboard->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label class="<?php echo $dashboard_search->LeftColumnClass ?>"><span id="elh_dashboard_operator"><?php echo $dashboard->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $dashboard_search->RightColumnClass ?>"><div<?php echo $dashboard->operator->cellAttributes() ?>>
			<span id="el_dashboard_operator">
<?php
$wrkonchange = "" . trim(@$dashboard->operator->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$dashboard->operator->EditAttrs["onchange"] = "";
?>
<span id="as_x_operator" class="text-nowrap" style="z-index: 8870">
	<input type="text" class="form-control" name="sv_x_operator" id="sv_x_operator" value="<?php echo RemoveHtml($dashboard->operator->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($dashboard->operator->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($dashboard->operator->getPlaceHolder()) ?>"<?php echo $dashboard->operator->editAttributes() ?>>
</span>
<input type="hidden" data-table="dashboard" data-field="x_operator" data-value-separator="<?php echo $dashboard->operator->displayValueSeparatorAttribute() ?>" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($dashboard->operator->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fdashboardsearch.createAutoSuggest({"id":"x_operator","forceSelect":false});
</script>
<?php echo $dashboard->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($dashboard->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $dashboard_search->LeftColumnClass ?>"><span id="elh_dashboard_datetime"><?php echo $dashboard->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $dashboard_search->RightColumnClass ?>"><div<?php echo $dashboard->datetime->cellAttributes() ?>>
			<span id="el_dashboard_datetime">
<input type="text" data-table="dashboard" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($dashboard->datetime->getPlaceHolder()) ?>" value="<?php echo $dashboard->datetime->EditValue ?>"<?php echo $dashboard->datetime->editAttributes() ?>>
<?php if (!$dashboard->datetime->ReadOnly && !$dashboard->datetime->Disabled && !isset($dashboard->datetime->EditAttrs["readonly"]) && !isset($dashboard->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fdashboardsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($dashboard->target_window->Visible) { // target_window ?>
	<div id="r_target_window" class="form-group row">
		<label for="x_target_window" class="<?php echo $dashboard_search->LeftColumnClass ?>"><span id="elh_dashboard_target_window"><?php echo $dashboard->target_window->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_target_window" id="z_target_window" value="LIKE"></span>
		</label>
		<div class="<?php echo $dashboard_search->RightColumnClass ?>"><div<?php echo $dashboard->target_window->cellAttributes() ?>>
			<span id="el_dashboard_target_window">
<input type="text" data-table="dashboard" data-field="x_target_window" name="x_target_window" id="x_target_window" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($dashboard->target_window->getPlaceHolder()) ?>" value="<?php echo $dashboard->target_window->EditValue ?>"<?php echo $dashboard->target_window->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($dashboard->sub_group_by->Visible) { // sub_group_by ?>
	<div id="r_sub_group_by" class="form-group row">
		<label for="x_sub_group_by" class="<?php echo $dashboard_search->LeftColumnClass ?>"><span id="elh_dashboard_sub_group_by"><?php echo $dashboard->sub_group_by->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sub_group_by" id="z_sub_group_by" value="LIKE"></span>
		</label>
		<div class="<?php echo $dashboard_search->RightColumnClass ?>"><div<?php echo $dashboard->sub_group_by->cellAttributes() ?>>
			<span id="el_dashboard_sub_group_by">
<input type="text" data-table="dashboard" data-field="x_sub_group_by" name="x_sub_group_by" id="x_sub_group_by" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($dashboard->sub_group_by->getPlaceHolder()) ?>" value="<?php echo $dashboard->sub_group_by->EditValue ?>"<?php echo $dashboard->sub_group_by->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$dashboard_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $dashboard_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$dashboard_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$dashboard_search->terminate();
?>