<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$dashboard_view = new dashboard_view();

// Run the page
$dashboard_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$dashboard_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$dashboard->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fdashboardview = currentForm = new ew.Form("fdashboardview", "view");

// Form_CustomValidate event
fdashboardview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdashboardview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fdashboardview.lists["x_item_group"] = <?php echo $dashboard_view->item_group->Lookup->toClientList() ?>;
fdashboardview.lists["x_item_group"].options = <?php echo JsonEncode($dashboard_view->item_group->options(FALSE, TRUE)) ?>;
fdashboardview.lists["x_user_level[]"] = <?php echo $dashboard_view->user_level->Lookup->toClientList() ?>;
fdashboardview.lists["x_user_level[]"].options = <?php echo JsonEncode($dashboard_view->user_level->lookupOptions()) ?>;
fdashboardview.lists["x_group_by[]"] = <?php echo $dashboard_view->group_by->Lookup->toClientList() ?>;
fdashboardview.lists["x_group_by[]"].options = <?php echo JsonEncode($dashboard_view->group_by->lookupOptions()) ?>;
fdashboardview.lists["x_status"] = <?php echo $dashboard_view->status->Lookup->toClientList() ?>;
fdashboardview.lists["x_status"].options = <?php echo JsonEncode($dashboard_view->status->options(FALSE, TRUE)) ?>;
fdashboardview.lists["x_operator"] = <?php echo $dashboard_view->operator->Lookup->toClientList() ?>;
fdashboardview.lists["x_operator"].options = <?php echo JsonEncode($dashboard_view->operator->lookupOptions()) ?>;
fdashboardview.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$dashboard->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $dashboard_view->ExportOptions->render("body") ?>
<?php $dashboard_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $dashboard_view->showPageHeader(); ?>
<?php
$dashboard_view->showMessage();
?>
<form name="fdashboardview" id="fdashboardview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($dashboard_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $dashboard_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="dashboard">
<input type="hidden" name="modal" value="<?php echo (int)$dashboard_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($dashboard->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $dashboard_view->TableLeftColumnClass ?>"><span id="elh_dashboard_id"><?php echo $dashboard->id->caption() ?></span></td>
		<td data-name="id"<?php echo $dashboard->id->cellAttributes() ?>>
<span id="el_dashboard_id">
<span<?php echo $dashboard->id->viewAttributes() ?>>
<?php echo $dashboard->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($dashboard->item_group->Visible) { // item_group ?>
	<tr id="r_item_group">
		<td class="<?php echo $dashboard_view->TableLeftColumnClass ?>"><span id="elh_dashboard_item_group"><?php echo $dashboard->item_group->caption() ?></span></td>
		<td data-name="item_group"<?php echo $dashboard->item_group->cellAttributes() ?>>
<span id="el_dashboard_item_group">
<span<?php echo $dashboard->item_group->viewAttributes() ?>>
<?php echo $dashboard->item_group->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($dashboard->icon->Visible) { // icon ?>
	<tr id="r_icon">
		<td class="<?php echo $dashboard_view->TableLeftColumnClass ?>"><span id="elh_dashboard_icon"><?php echo $dashboard->icon->caption() ?></span></td>
		<td data-name="icon"<?php echo $dashboard->icon->cellAttributes() ?>>
<span id="el_dashboard_icon">
<span<?php echo $dashboard->icon->viewAttributes() ?>>
<?php echo $dashboard->icon->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($dashboard->image->Visible) { // image ?>
	<tr id="r_image">
		<td class="<?php echo $dashboard_view->TableLeftColumnClass ?>"><span id="elh_dashboard_image"><?php echo $dashboard->image->caption() ?></span></td>
		<td data-name="image"<?php echo $dashboard->image->cellAttributes() ?>>
<span id="el_dashboard_image">
<span<?php echo $dashboard->image->viewAttributes() ?>>
<?php echo GetFileViewTag($dashboard->image, $dashboard->image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($dashboard->title->Visible) { // title ?>
	<tr id="r_title">
		<td class="<?php echo $dashboard_view->TableLeftColumnClass ?>"><span id="elh_dashboard_title"><?php echo $dashboard->title->caption() ?></span></td>
		<td data-name="title"<?php echo $dashboard->title->cellAttributes() ?>>
<span id="el_dashboard_title">
<span<?php echo $dashboard->title->viewAttributes() ?>>
<?php echo $dashboard->title->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($dashboard->sub_title->Visible) { // sub_title ?>
	<tr id="r_sub_title">
		<td class="<?php echo $dashboard_view->TableLeftColumnClass ?>"><span id="elh_dashboard_sub_title"><?php echo $dashboard->sub_title->caption() ?></span></td>
		<td data-name="sub_title"<?php echo $dashboard->sub_title->cellAttributes() ?>>
<span id="el_dashboard_sub_title">
<span<?php echo $dashboard->sub_title->viewAttributes() ?>>
<?php echo $dashboard->sub_title->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($dashboard->url_link->Visible) { // url_link ?>
	<tr id="r_url_link">
		<td class="<?php echo $dashboard_view->TableLeftColumnClass ?>"><span id="elh_dashboard_url_link"><?php echo $dashboard->url_link->caption() ?></span></td>
		<td data-name="url_link"<?php echo $dashboard->url_link->cellAttributes() ?>>
<span id="el_dashboard_url_link">
<span<?php echo $dashboard->url_link->viewAttributes() ?>>
<?php echo $dashboard->url_link->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($dashboard->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $dashboard_view->TableLeftColumnClass ?>"><span id="elh_dashboard_code"><?php echo $dashboard->code->caption() ?></span></td>
		<td data-name="code"<?php echo $dashboard->code->cellAttributes() ?>>
<span id="el_dashboard_code">
<span<?php echo $dashboard->code->viewAttributes() ?>>
<?php echo $dashboard->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($dashboard->order_by->Visible) { // order_by ?>
	<tr id="r_order_by">
		<td class="<?php echo $dashboard_view->TableLeftColumnClass ?>"><span id="elh_dashboard_order_by"><?php echo $dashboard->order_by->caption() ?></span></td>
		<td data-name="order_by"<?php echo $dashboard->order_by->cellAttributes() ?>>
<span id="el_dashboard_order_by">
<span<?php echo $dashboard->order_by->viewAttributes() ?>>
<?php echo $dashboard->order_by->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($dashboard->user_level->Visible) { // user_level ?>
	<tr id="r_user_level">
		<td class="<?php echo $dashboard_view->TableLeftColumnClass ?>"><span id="elh_dashboard_user_level"><?php echo $dashboard->user_level->caption() ?></span></td>
		<td data-name="user_level"<?php echo $dashboard->user_level->cellAttributes() ?>>
<span id="el_dashboard_user_level">
<span<?php echo $dashboard->user_level->viewAttributes() ?>>
<?php echo $dashboard->user_level->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($dashboard->group_by->Visible) { // group_by ?>
	<tr id="r_group_by">
		<td class="<?php echo $dashboard_view->TableLeftColumnClass ?>"><span id="elh_dashboard_group_by"><?php echo $dashboard->group_by->caption() ?></span></td>
		<td data-name="group_by"<?php echo $dashboard->group_by->cellAttributes() ?>>
<span id="el_dashboard_group_by">
<span<?php echo $dashboard->group_by->viewAttributes() ?>>
<?php echo $dashboard->group_by->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($dashboard->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $dashboard_view->TableLeftColumnClass ?>"><span id="elh_dashboard_status"><?php echo $dashboard->status->caption() ?></span></td>
		<td data-name="status"<?php echo $dashboard->status->cellAttributes() ?>>
<span id="el_dashboard_status">
<span<?php echo $dashboard->status->viewAttributes() ?>>
<?php echo $dashboard->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($dashboard->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $dashboard_view->TableLeftColumnClass ?>"><span id="elh_dashboard_operator"><?php echo $dashboard->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $dashboard->operator->cellAttributes() ?>>
<span id="el_dashboard_operator">
<span<?php echo $dashboard->operator->viewAttributes() ?>>
<?php echo $dashboard->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($dashboard->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $dashboard_view->TableLeftColumnClass ?>"><span id="elh_dashboard_datetime"><?php echo $dashboard->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $dashboard->datetime->cellAttributes() ?>>
<span id="el_dashboard_datetime">
<span<?php echo $dashboard->datetime->viewAttributes() ?>>
<?php echo $dashboard->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($dashboard->target_window->Visible) { // target_window ?>
	<tr id="r_target_window">
		<td class="<?php echo $dashboard_view->TableLeftColumnClass ?>"><span id="elh_dashboard_target_window"><?php echo $dashboard->target_window->caption() ?></span></td>
		<td data-name="target_window"<?php echo $dashboard->target_window->cellAttributes() ?>>
<span id="el_dashboard_target_window">
<span<?php echo $dashboard->target_window->viewAttributes() ?>>
<?php echo $dashboard->target_window->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($dashboard->sub_group_by->Visible) { // sub_group_by ?>
	<tr id="r_sub_group_by">
		<td class="<?php echo $dashboard_view->TableLeftColumnClass ?>"><span id="elh_dashboard_sub_group_by"><?php echo $dashboard->sub_group_by->caption() ?></span></td>
		<td data-name="sub_group_by"<?php echo $dashboard->sub_group_by->cellAttributes() ?>>
<span id="el_dashboard_sub_group_by">
<span<?php echo $dashboard->sub_group_by->viewAttributes() ?>>
<?php echo $dashboard->sub_group_by->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$dashboard_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$dashboard->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$dashboard_view->terminate();
?>