<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$description_edit = new description_edit();

// Run the page
$description_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$description_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fdescriptionedit = currentForm = new ew.Form("fdescriptionedit", "edit");

// Validate form
fdescriptionedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($description_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $description->id->caption(), $description->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($description_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $description->grp->caption(), $description->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($description_edit->d_n->Required) { ?>
			elm = this.getElements("x" + infix + "_d_n[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $description->d_n->caption(), $description->d_n->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($description_edit->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $description->item->caption(), $description->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($description_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $description->status->caption(), $description->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($description_edit->opeartor->Required) { ?>
			elm = this.getElements("x" + infix + "_opeartor");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $description->opeartor->caption(), $description->opeartor->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($description_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $description->datetime->caption(), $description->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fdescriptionedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdescriptionedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fdescriptionedit.lists["x_grp[]"] = <?php echo $description_edit->grp->Lookup->toClientList() ?>;
fdescriptionedit.lists["x_grp[]"].options = <?php echo JsonEncode($description_edit->grp->lookupOptions()) ?>;
fdescriptionedit.lists["x_d_n[]"] = <?php echo $description_edit->d_n->Lookup->toClientList() ?>;
fdescriptionedit.lists["x_d_n[]"].options = <?php echo JsonEncode($description_edit->d_n->lookupOptions()) ?>;
fdescriptionedit.lists["x_status"] = <?php echo $description_edit->status->Lookup->toClientList() ?>;
fdescriptionedit.lists["x_status"].options = <?php echo JsonEncode($description_edit->status->options(FALSE, TRUE)) ?>;
fdescriptionedit.lists["x_opeartor"] = <?php echo $description_edit->opeartor->Lookup->toClientList() ?>;
fdescriptionedit.lists["x_opeartor"].options = <?php echo JsonEncode($description_edit->opeartor->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $description_edit->showPageHeader(); ?>
<?php
$description_edit->showMessage();
?>
<form name="fdescriptionedit" id="fdescriptionedit" class="<?php echo $description_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($description_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $description_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="description">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$description_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($description->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_description_id" class="<?php echo $description_edit->LeftColumnClass ?>"><?php echo $description->id->caption() ?><?php echo ($description->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $description_edit->RightColumnClass ?>"><div<?php echo $description->id->cellAttributes() ?>>
<span id="el_description_id">
<span<?php echo $description->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($description->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="description" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($description->id->CurrentValue) ?>">
<?php echo $description->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($description->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_description_grp" class="<?php echo $description_edit->LeftColumnClass ?>"><?php echo $description->grp->caption() ?><?php echo ($description->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $description_edit->RightColumnClass ?>"><div<?php echo $description->grp->cellAttributes() ?>>
<span id="el_description_grp">
<?php $description->grp->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$description->grp->EditAttrs["onclick"]; ?>
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="description" data-field="x_grp" data-value-separator="<?php echo $description->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $description->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $description->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $description->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $description->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($description->d_n->Visible) { // d_n ?>
	<div id="r_d_n" class="form-group row">
		<label id="elh_description_d_n" class="<?php echo $description_edit->LeftColumnClass ?>"><?php echo $description->d_n->caption() ?><?php echo ($description->d_n->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $description_edit->RightColumnClass ?>"><div<?php echo $description->d_n->cellAttributes() ?>>
<span id="el_description_d_n">
<div id="tp_x_d_n" class="ew-template"><input type="checkbox" class="form-check-input" data-table="description" data-field="x_d_n" data-value-separator="<?php echo $description->d_n->displayValueSeparatorAttribute() ?>" name="x_d_n[]" id="x_d_n[]" value="{value}"<?php echo $description->d_n->editAttributes() ?>></div>
<div id="dsl_x_d_n" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $description->d_n->checkBoxListHtml(FALSE, "x_d_n[]") ?>
</div></div>
<?php echo $description->d_n->Lookup->getParamTag("p_x_d_n") ?>
</span>
<?php echo $description->d_n->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($description->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_description_item" for="x_item" class="<?php echo $description_edit->LeftColumnClass ?>"><?php echo $description->item->caption() ?><?php echo ($description->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $description_edit->RightColumnClass ?>"><div<?php echo $description->item->cellAttributes() ?>>
<span id="el_description_item">
<input type="text" data-table="description" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($description->item->getPlaceHolder()) ?>" value="<?php echo $description->item->EditValue ?>"<?php echo $description->item->editAttributes() ?>>
</span>
<?php echo $description->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($description->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_description_status" for="x_status" class="<?php echo $description_edit->LeftColumnClass ?>"><?php echo $description->status->caption() ?><?php echo ($description->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $description_edit->RightColumnClass ?>"><div<?php echo $description->status->cellAttributes() ?>>
<span id="el_description_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="description" data-field="x_status" data-value-separator="<?php echo $description->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $description->status->editAttributes() ?>>
		<?php echo $description->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $description->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$description_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $description_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $description_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$description_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$description_edit->terminate();
?>