<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$description_list = new description_list();

// Run the page
$description_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$description_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$description->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fdescriptionlist = currentForm = new ew.Form("fdescriptionlist", "list");
fdescriptionlist.formKeyCountName = '<?php echo $description_list->FormKeyCountName ?>';

// Form_CustomValidate event
fdescriptionlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdescriptionlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fdescriptionlist.lists["x_grp[]"] = <?php echo $description_list->grp->Lookup->toClientList() ?>;
fdescriptionlist.lists["x_grp[]"].options = <?php echo JsonEncode($description_list->grp->lookupOptions()) ?>;
fdescriptionlist.lists["x_status"] = <?php echo $description_list->status->Lookup->toClientList() ?>;
fdescriptionlist.lists["x_status"].options = <?php echo JsonEncode($description_list->status->options(FALSE, TRUE)) ?>;
fdescriptionlist.lists["x_opeartor"] = <?php echo $description_list->opeartor->Lookup->toClientList() ?>;
fdescriptionlist.lists["x_opeartor"].options = <?php echo JsonEncode($description_list->opeartor->lookupOptions()) ?>;

// Form object for search
var fdescriptionlistsrch = currentSearchForm = new ew.Form("fdescriptionlistsrch");

// Filters
fdescriptionlistsrch.filterList = <?php echo $description_list->getFilterList() ?>;

// Init search panel as collapsed
fdescriptionlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$description->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($description_list->TotalRecs > 0 && $description_list->ExportOptions->visible()) { ?>
<?php $description_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($description_list->ImportOptions->visible()) { ?>
<?php $description_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($description_list->SearchOptions->visible()) { ?>
<?php $description_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($description_list->FilterOptions->visible()) { ?>
<?php $description_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$description_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$description->isExport() && !$description->CurrentAction) { ?>
<form name="fdescriptionlistsrch" id="fdescriptionlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($description_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fdescriptionlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="description">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($description_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($description_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $description_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($description_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($description_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($description_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($description_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $description_list->showPageHeader(); ?>
<?php
$description_list->showMessage();
?>
<?php if ($description_list->TotalRecs > 0 || $description->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($description_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> description">
<?php if (!$description->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$description->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($description_list->Pager)) $description_list->Pager = new PrevNextPager($description_list->StartRec, $description_list->DisplayRecs, $description_list->TotalRecs, $description_list->AutoHidePager) ?>
<?php if ($description_list->Pager->RecordCount > 0 && $description_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($description_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $description_list->pageUrl() ?>start=<?php echo $description_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($description_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $description_list->pageUrl() ?>start=<?php echo $description_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $description_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($description_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $description_list->pageUrl() ?>start=<?php echo $description_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($description_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $description_list->pageUrl() ?>start=<?php echo $description_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $description_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($description_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $description_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $description_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $description_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($description_list->TotalRecs > 0 && (!$description_list->AutoHidePageSizeSelector || $description_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="description">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($description_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($description_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($description_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($description_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($description_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($description->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $description_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fdescriptionlist" id="fdescriptionlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($description_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $description_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="description">
<div id="gmp_description" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($description_list->TotalRecs > 0 || $description->isGridEdit()) { ?>
<table id="tbl_descriptionlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$description_list->RowType = ROWTYPE_HEADER;

// Render list options
$description_list->renderListOptions();

// Render list options (header, left)
$description_list->ListOptions->render("header", "left");
?>
<?php if ($description->id->Visible) { // id ?>
	<?php if ($description->sortUrl($description->id) == "") { ?>
		<th data-name="id" class="<?php echo $description->id->headerCellClass() ?>"><div id="elh_description_id" class="description_id"><div class="ew-table-header-caption"><?php echo $description->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $description->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $description->SortUrl($description->id) ?>',2);"><div id="elh_description_id" class="description_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $description->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($description->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($description->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($description->grp->Visible) { // grp ?>
	<?php if ($description->sortUrl($description->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $description->grp->headerCellClass() ?>"><div id="elh_description_grp" class="description_grp"><div class="ew-table-header-caption"><?php echo $description->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $description->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $description->SortUrl($description->grp) ?>',2);"><div id="elh_description_grp" class="description_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $description->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($description->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($description->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($description->d_n_text->Visible) { // d_n_text ?>
	<?php if ($description->sortUrl($description->d_n_text) == "") { ?>
		<th data-name="d_n_text" class="<?php echo $description->d_n_text->headerCellClass() ?>"><div id="elh_description_d_n_text" class="description_d_n_text"><div class="ew-table-header-caption"><?php echo $description->d_n_text->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_n_text" class="<?php echo $description->d_n_text->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $description->SortUrl($description->d_n_text) ?>',2);"><div id="elh_description_d_n_text" class="description_d_n_text">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $description->d_n_text->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($description->d_n_text->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($description->d_n_text->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($description->item->Visible) { // item ?>
	<?php if ($description->sortUrl($description->item) == "") { ?>
		<th data-name="item" class="<?php echo $description->item->headerCellClass() ?>"><div id="elh_description_item" class="description_item"><div class="ew-table-header-caption"><?php echo $description->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $description->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $description->SortUrl($description->item) ?>',2);"><div id="elh_description_item" class="description_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $description->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($description->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($description->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($description->status->Visible) { // status ?>
	<?php if ($description->sortUrl($description->status) == "") { ?>
		<th data-name="status" class="<?php echo $description->status->headerCellClass() ?>"><div id="elh_description_status" class="description_status"><div class="ew-table-header-caption"><?php echo $description->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $description->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $description->SortUrl($description->status) ?>',2);"><div id="elh_description_status" class="description_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $description->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($description->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($description->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($description->opeartor->Visible) { // opeartor ?>
	<?php if ($description->sortUrl($description->opeartor) == "") { ?>
		<th data-name="opeartor" class="<?php echo $description->opeartor->headerCellClass() ?>"><div id="elh_description_opeartor" class="description_opeartor"><div class="ew-table-header-caption"><?php echo $description->opeartor->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="opeartor" class="<?php echo $description->opeartor->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $description->SortUrl($description->opeartor) ?>',2);"><div id="elh_description_opeartor" class="description_opeartor">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $description->opeartor->caption() ?></span><span class="ew-table-header-sort"><?php if ($description->opeartor->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($description->opeartor->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($description->datetime->Visible) { // datetime ?>
	<?php if ($description->sortUrl($description->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $description->datetime->headerCellClass() ?>"><div id="elh_description_datetime" class="description_datetime"><div class="ew-table-header-caption"><?php echo $description->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $description->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $description->SortUrl($description->datetime) ?>',2);"><div id="elh_description_datetime" class="description_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $description->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($description->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($description->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$description_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($description->ExportAll && $description->isExport()) {
	$description_list->StopRec = $description_list->TotalRecs;
} else {

	// Set the last record to display
	if ($description_list->TotalRecs > $description_list->StartRec + $description_list->DisplayRecs - 1)
		$description_list->StopRec = $description_list->StartRec + $description_list->DisplayRecs - 1;
	else
		$description_list->StopRec = $description_list->TotalRecs;
}
$description_list->RecCnt = $description_list->StartRec - 1;
if ($description_list->Recordset && !$description_list->Recordset->EOF) {
	$description_list->Recordset->moveFirst();
	$selectLimit = $description_list->UseSelectLimit;
	if (!$selectLimit && $description_list->StartRec > 1)
		$description_list->Recordset->move($description_list->StartRec - 1);
} elseif (!$description->AllowAddDeleteRow && $description_list->StopRec == 0) {
	$description_list->StopRec = $description->GridAddRowCount;
}

// Initialize aggregate
$description->RowType = ROWTYPE_AGGREGATEINIT;
$description->resetAttributes();
$description_list->renderRow();
while ($description_list->RecCnt < $description_list->StopRec) {
	$description_list->RecCnt++;
	if ($description_list->RecCnt >= $description_list->StartRec) {
		$description_list->RowCnt++;

		// Set up key count
		$description_list->KeyCount = $description_list->RowIndex;

		// Init row class and style
		$description->resetAttributes();
		$description->CssClass = "";
		if ($description->isGridAdd()) {
		} else {
			$description_list->loadRowValues($description_list->Recordset); // Load row values
		}
		$description->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$description->RowAttrs = array_merge($description->RowAttrs, array('data-rowindex'=>$description_list->RowCnt, 'id'=>'r' . $description_list->RowCnt . '_description', 'data-rowtype'=>$description->RowType));

		// Render row
		$description_list->renderRow();

		// Render list options
		$description_list->renderListOptions();
?>
	<tr<?php echo $description->rowAttributes() ?>>
<?php

// Render list options (body, left)
$description_list->ListOptions->render("body", "left", $description_list->RowCnt);
?>
	<?php if ($description->id->Visible) { // id ?>
		<td data-name="id"<?php echo $description->id->cellAttributes() ?>>
<span id="el<?php echo $description_list->RowCnt ?>_description_id" class="description_id">
<span<?php echo $description->id->viewAttributes() ?>>
<?php echo $description->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($description->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $description->grp->cellAttributes() ?>>
<span id="el<?php echo $description_list->RowCnt ?>_description_grp" class="description_grp">
<span<?php echo $description->grp->viewAttributes() ?>>
<?php echo $description->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($description->d_n_text->Visible) { // d_n_text ?>
		<td data-name="d_n_text"<?php echo $description->d_n_text->cellAttributes() ?>>
<span id="el<?php echo $description_list->RowCnt ?>_description_d_n_text" class="description_d_n_text">
<span<?php echo $description->d_n_text->viewAttributes() ?>>
<?php echo $description->d_n_text->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($description->item->Visible) { // item ?>
		<td data-name="item"<?php echo $description->item->cellAttributes() ?>>
<span id="el<?php echo $description_list->RowCnt ?>_description_item" class="description_item">
<span<?php echo $description->item->viewAttributes() ?>>
<?php echo $description->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($description->status->Visible) { // status ?>
		<td data-name="status"<?php echo $description->status->cellAttributes() ?>>
<span id="el<?php echo $description_list->RowCnt ?>_description_status" class="description_status">
<span<?php echo $description->status->viewAttributes() ?>>
<?php echo $description->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($description->opeartor->Visible) { // opeartor ?>
		<td data-name="opeartor"<?php echo $description->opeartor->cellAttributes() ?>>
<span id="el<?php echo $description_list->RowCnt ?>_description_opeartor" class="description_opeartor">
<span<?php echo $description->opeartor->viewAttributes() ?>>
<?php echo $description->opeartor->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($description->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $description->datetime->cellAttributes() ?>>
<span id="el<?php echo $description_list->RowCnt ?>_description_datetime" class="description_datetime">
<span<?php echo $description->datetime->viewAttributes() ?>>
<?php echo $description->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$description_list->ListOptions->render("body", "right", $description_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$description->isGridAdd())
		$description_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$description->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($description_list->Recordset)
	$description_list->Recordset->Close();
?>
<?php if (!$description->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$description->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($description_list->Pager)) $description_list->Pager = new PrevNextPager($description_list->StartRec, $description_list->DisplayRecs, $description_list->TotalRecs, $description_list->AutoHidePager) ?>
<?php if ($description_list->Pager->RecordCount > 0 && $description_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($description_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $description_list->pageUrl() ?>start=<?php echo $description_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($description_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $description_list->pageUrl() ?>start=<?php echo $description_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $description_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($description_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $description_list->pageUrl() ?>start=<?php echo $description_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($description_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $description_list->pageUrl() ?>start=<?php echo $description_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $description_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($description_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $description_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $description_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $description_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($description_list->TotalRecs > 0 && (!$description_list->AutoHidePageSizeSelector || $description_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="description">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($description_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($description_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($description_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($description_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($description_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($description->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $description_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($description_list->TotalRecs == 0 && !$description->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $description_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$description_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$description->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$description->isExport()) { ?>
<script>
ew.scrollableTable("gmp_description", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$description_list->terminate();
?>