<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$description_search = new description_search();

// Run the page
$description_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$description_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($description_search->IsModal) { ?>
var fdescriptionsearch = currentAdvancedSearchForm = new ew.Form("fdescriptionsearch", "search");
<?php } else { ?>
var fdescriptionsearch = currentForm = new ew.Form("fdescriptionsearch", "search");
<?php } ?>

// Form_CustomValidate event
fdescriptionsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdescriptionsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fdescriptionsearch.lists["x_grp[]"] = <?php echo $description_search->grp->Lookup->toClientList() ?>;
fdescriptionsearch.lists["x_grp[]"].options = <?php echo JsonEncode($description_search->grp->lookupOptions()) ?>;
fdescriptionsearch.lists["x_status"] = <?php echo $description_search->status->Lookup->toClientList() ?>;
fdescriptionsearch.lists["x_status"].options = <?php echo JsonEncode($description_search->status->options(FALSE, TRUE)) ?>;
fdescriptionsearch.lists["x_opeartor"] = <?php echo $description_search->opeartor->Lookup->toClientList() ?>;
fdescriptionsearch.lists["x_opeartor"].options = <?php echo JsonEncode($description_search->opeartor->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fdescriptionsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($description->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($description->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $description_search->showPageHeader(); ?>
<?php
$description_search->showMessage();
?>
<form name="fdescriptionsearch" id="fdescriptionsearch" class="<?php echo $description_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($description_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $description_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="description">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$description_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($description->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $description_search->LeftColumnClass ?>"><span id="elh_description_id"><?php echo $description->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $description_search->RightColumnClass ?>"><div<?php echo $description->id->cellAttributes() ?>>
			<span id="el_description_id">
<input type="text" data-table="description" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($description->id->getPlaceHolder()) ?>" value="<?php echo $description->id->EditValue ?>"<?php echo $description->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($description->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label class="<?php echo $description_search->LeftColumnClass ?>"><span id="elh_description_grp"><?php echo $description->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $description_search->RightColumnClass ?>"><div<?php echo $description->grp->cellAttributes() ?>>
			<span id="el_description_grp">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="description" data-field="x_grp" data-value-separator="<?php echo $description->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $description->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $description->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $description->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($description->d_n_text->Visible) { // d_n_text ?>
	<div id="r_d_n_text" class="form-group row">
		<label for="x_d_n_text" class="<?php echo $description_search->LeftColumnClass ?>"><span id="elh_description_d_n_text"><?php echo $description->d_n_text->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_d_n_text" id="z_d_n_text" value="LIKE"></span>
		</label>
		<div class="<?php echo $description_search->RightColumnClass ?>"><div<?php echo $description->d_n_text->cellAttributes() ?>>
			<span id="el_description_d_n_text">
<input type="text" data-table="description" data-field="x_d_n_text" name="x_d_n_text" id="x_d_n_text" size="35" placeholder="<?php echo HtmlEncode($description->d_n_text->getPlaceHolder()) ?>" value="<?php echo $description->d_n_text->EditValue ?>"<?php echo $description->d_n_text->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($description->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label for="x_item" class="<?php echo $description_search->LeftColumnClass ?>"><span id="elh_description_item"><?php echo $description->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		</label>
		<div class="<?php echo $description_search->RightColumnClass ?>"><div<?php echo $description->item->cellAttributes() ?>>
			<span id="el_description_item">
<input type="text" data-table="description" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($description->item->getPlaceHolder()) ?>" value="<?php echo $description->item->EditValue ?>"<?php echo $description->item->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($description->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $description_search->LeftColumnClass ?>"><span id="elh_description_status"><?php echo $description->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $description_search->RightColumnClass ?>"><div<?php echo $description->status->cellAttributes() ?>>
			<span id="el_description_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="description" data-field="x_status" data-value-separator="<?php echo $description->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $description->status->editAttributes() ?>>
		<?php echo $description->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($description->opeartor->Visible) { // opeartor ?>
	<div id="r_opeartor" class="form-group row">
		<label for="x_opeartor" class="<?php echo $description_search->LeftColumnClass ?>"><span id="elh_description_opeartor"><?php echo $description->opeartor->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_opeartor" id="z_opeartor" value="="></span>
		</label>
		<div class="<?php echo $description_search->RightColumnClass ?>"><div<?php echo $description->opeartor->cellAttributes() ?>>
			<span id="el_description_opeartor">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="description" data-field="x_opeartor" data-value-separator="<?php echo $description->opeartor->displayValueSeparatorAttribute() ?>" id="x_opeartor" name="x_opeartor"<?php echo $description->opeartor->editAttributes() ?>>
		<?php echo $description->opeartor->selectOptionListHtml("x_opeartor") ?>
	</select>
</div>
<?php echo $description->opeartor->Lookup->getParamTag("p_x_opeartor") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($description->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $description_search->LeftColumnClass ?>"><span id="elh_description_datetime"><?php echo $description->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $description_search->RightColumnClass ?>"><div<?php echo $description->datetime->cellAttributes() ?>>
			<span id="el_description_datetime">
<input type="text" data-table="description" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($description->datetime->getPlaceHolder()) ?>" value="<?php echo $description->datetime->EditValue ?>"<?php echo $description->datetime->editAttributes() ?>>
<?php if (!$description->datetime->ReadOnly && !$description->datetime->Disabled && !isset($description->datetime->EditAttrs["readonly"]) && !isset($description->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fdescriptionsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$description_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $description_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$description_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$description_search->terminate();
?>