<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$description_view = new description_view();

// Run the page
$description_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$description_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$description->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fdescriptionview = currentForm = new ew.Form("fdescriptionview", "view");

// Form_CustomValidate event
fdescriptionview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdescriptionview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fdescriptionview.lists["x_grp[]"] = <?php echo $description_view->grp->Lookup->toClientList() ?>;
fdescriptionview.lists["x_grp[]"].options = <?php echo JsonEncode($description_view->grp->lookupOptions()) ?>;
fdescriptionview.lists["x_status"] = <?php echo $description_view->status->Lookup->toClientList() ?>;
fdescriptionview.lists["x_status"].options = <?php echo JsonEncode($description_view->status->options(FALSE, TRUE)) ?>;
fdescriptionview.lists["x_opeartor"] = <?php echo $description_view->opeartor->Lookup->toClientList() ?>;
fdescriptionview.lists["x_opeartor"].options = <?php echo JsonEncode($description_view->opeartor->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$description->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $description_view->ExportOptions->render("body") ?>
<?php $description_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $description_view->showPageHeader(); ?>
<?php
$description_view->showMessage();
?>
<form name="fdescriptionview" id="fdescriptionview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($description_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $description_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="description">
<input type="hidden" name="modal" value="<?php echo (int)$description_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($description->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $description_view->TableLeftColumnClass ?>"><span id="elh_description_id"><?php echo $description->id->caption() ?></span></td>
		<td data-name="id"<?php echo $description->id->cellAttributes() ?>>
<span id="el_description_id">
<span<?php echo $description->id->viewAttributes() ?>>
<?php echo $description->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($description->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $description_view->TableLeftColumnClass ?>"><span id="elh_description_grp"><?php echo $description->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $description->grp->cellAttributes() ?>>
<span id="el_description_grp">
<span<?php echo $description->grp->viewAttributes() ?>>
<?php echo $description->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($description->d_n_text->Visible) { // d_n_text ?>
	<tr id="r_d_n_text">
		<td class="<?php echo $description_view->TableLeftColumnClass ?>"><span id="elh_description_d_n_text"><?php echo $description->d_n_text->caption() ?></span></td>
		<td data-name="d_n_text"<?php echo $description->d_n_text->cellAttributes() ?>>
<span id="el_description_d_n_text">
<span<?php echo $description->d_n_text->viewAttributes() ?>>
<?php echo $description->d_n_text->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($description->item->Visible) { // item ?>
	<tr id="r_item">
		<td class="<?php echo $description_view->TableLeftColumnClass ?>"><span id="elh_description_item"><?php echo $description->item->caption() ?></span></td>
		<td data-name="item"<?php echo $description->item->cellAttributes() ?>>
<span id="el_description_item">
<span<?php echo $description->item->viewAttributes() ?>>
<?php echo $description->item->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($description->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $description_view->TableLeftColumnClass ?>"><span id="elh_description_status"><?php echo $description->status->caption() ?></span></td>
		<td data-name="status"<?php echo $description->status->cellAttributes() ?>>
<span id="el_description_status">
<span<?php echo $description->status->viewAttributes() ?>>
<?php echo $description->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($description->opeartor->Visible) { // opeartor ?>
	<tr id="r_opeartor">
		<td class="<?php echo $description_view->TableLeftColumnClass ?>"><span id="elh_description_opeartor"><?php echo $description->opeartor->caption() ?></span></td>
		<td data-name="opeartor"<?php echo $description->opeartor->cellAttributes() ?>>
<span id="el_description_opeartor">
<span<?php echo $description->opeartor->viewAttributes() ?>>
<?php echo $description->opeartor->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($description->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $description_view->TableLeftColumnClass ?>"><span id="elh_description_datetime"><?php echo $description->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $description->datetime->cellAttributes() ?>>
<span id="el_description_datetime">
<span<?php echo $description->datetime->viewAttributes() ?>>
<?php echo $description->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$description_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$description->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$description_view->terminate();
?>