<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$download_delete = new download_delete();

// Run the page
$download_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$download_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fdownloaddelete = currentForm = new ew.Form("fdownloaddelete", "delete");

// Form_CustomValidate event
fdownloaddelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdownloaddelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $download_delete->showPageHeader(); ?>
<?php
$download_delete->showMessage();
?>
<form name="fdownloaddelete" id="fdownloaddelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($download_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $download_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="download">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($download_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($download->id->Visible) { // id ?>
		<th class="<?php echo $download->id->headerCellClass() ?>"><span id="elh_download_id" class="download_id"><?php echo $download->id->caption() ?></span></th>
<?php } ?>
<?php if ($download->description->Visible) { // description ?>
		<th class="<?php echo $download->description->headerCellClass() ?>"><span id="elh_download_description" class="download_description"><?php echo $download->description->caption() ?></span></th>
<?php } ?>
<?php if ($download->items->Visible) { // items ?>
		<th class="<?php echo $download->items->headerCellClass() ?>"><span id="elh_download_items" class="download_items"><?php echo $download->items->caption() ?></span></th>
<?php } ?>
<?php if ($download->remarks->Visible) { // remarks ?>
		<th class="<?php echo $download->remarks->headerCellClass() ?>"><span id="elh_download_remarks" class="download_remarks"><?php echo $download->remarks->caption() ?></span></th>
<?php } ?>
<?php if ($download->operator->Visible) { // operator ?>
		<th class="<?php echo $download->operator->headerCellClass() ?>"><span id="elh_download_operator" class="download_operator"><?php echo $download->operator->caption() ?></span></th>
<?php } ?>
<?php if ($download->datetime->Visible) { // datetime ?>
		<th class="<?php echo $download->datetime->headerCellClass() ?>"><span id="elh_download_datetime" class="download_datetime"><?php echo $download->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$download_delete->RecCnt = 0;
$i = 0;
while (!$download_delete->Recordset->EOF) {
	$download_delete->RecCnt++;
	$download_delete->RowCnt++;

	// Set row properties
	$download->resetAttributes();
	$download->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$download_delete->loadRowValues($download_delete->Recordset);

	// Render row
	$download_delete->renderRow();
?>
	<tr<?php echo $download->rowAttributes() ?>>
<?php if ($download->id->Visible) { // id ?>
		<td<?php echo $download->id->cellAttributes() ?>>
<span id="el<?php echo $download_delete->RowCnt ?>_download_id" class="download_id">
<span<?php echo $download->id->viewAttributes() ?>>
<?php echo $download->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($download->description->Visible) { // description ?>
		<td<?php echo $download->description->cellAttributes() ?>>
<span id="el<?php echo $download_delete->RowCnt ?>_download_description" class="download_description">
<span<?php echo $download->description->viewAttributes() ?>>
<?php echo $download->description->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($download->items->Visible) { // items ?>
		<td<?php echo $download->items->cellAttributes() ?>>
<span id="el<?php echo $download_delete->RowCnt ?>_download_items" class="download_items">
<span>
<?php echo GetFileViewTag($download->items, $download->items->getViewValue()) ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($download->remarks->Visible) { // remarks ?>
		<td<?php echo $download->remarks->cellAttributes() ?>>
<span id="el<?php echo $download_delete->RowCnt ?>_download_remarks" class="download_remarks">
<span<?php echo $download->remarks->viewAttributes() ?>>
<?php echo $download->remarks->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($download->operator->Visible) { // operator ?>
		<td<?php echo $download->operator->cellAttributes() ?>>
<span id="el<?php echo $download_delete->RowCnt ?>_download_operator" class="download_operator">
<span<?php echo $download->operator->viewAttributes() ?>>
<?php echo $download->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($download->datetime->Visible) { // datetime ?>
		<td<?php echo $download->datetime->cellAttributes() ?>>
<span id="el<?php echo $download_delete->RowCnt ?>_download_datetime" class="download_datetime">
<span<?php echo $download->datetime->viewAttributes() ?>>
<?php echo $download->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$download_delete->Recordset->moveNext();
}
$download_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $download_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$download_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$download_delete->terminate();
?>