<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$download_edit = new download_edit();

// Run the page
$download_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$download_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fdownloadedit = currentForm = new ew.Form("fdownloadedit", "edit");

// Validate form
fdownloadedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($download_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $download->id->caption(), $download->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($download_edit->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $download->description->caption(), $download->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($download_edit->items->Required) { ?>
			felm = this.getElements("x" + infix + "_items");
			elm = this.getElements("fn_x" + infix + "_items");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $download->items->caption(), $download->items->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($download_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $download->remarks->caption(), $download->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($download_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $download->operator->caption(), $download->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($download_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $download->datetime->caption(), $download->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fdownloadedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdownloadedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $download_edit->showPageHeader(); ?>
<?php
$download_edit->showMessage();
?>
<form name="fdownloadedit" id="fdownloadedit" class="<?php echo $download_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($download_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $download_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="download">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$download_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($download->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_download_id" class="<?php echo $download_edit->LeftColumnClass ?>"><?php echo $download->id->caption() ?><?php echo ($download->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $download_edit->RightColumnClass ?>"><div<?php echo $download->id->cellAttributes() ?>>
<span id="el_download_id">
<span<?php echo $download->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($download->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="download" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($download->id->CurrentValue) ?>">
<?php echo $download->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($download->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_download_description" for="x_description" class="<?php echo $download_edit->LeftColumnClass ?>"><?php echo $download->description->caption() ?><?php echo ($download->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $download_edit->RightColumnClass ?>"><div<?php echo $download->description->cellAttributes() ?>>
<span id="el_download_description">
<input type="text" data-table="download" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($download->description->getPlaceHolder()) ?>" value="<?php echo $download->description->EditValue ?>"<?php echo $download->description->editAttributes() ?>>
</span>
<?php echo $download->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($download->items->Visible) { // items ?>
	<div id="r_items" class="form-group row">
		<label id="elh_download_items" class="<?php echo $download_edit->LeftColumnClass ?>"><?php echo $download->items->caption() ?><?php echo ($download->items->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $download_edit->RightColumnClass ?>"><div<?php echo $download->items->cellAttributes() ?>>
<span id="el_download_items">
<div id="fd_x_items">
<span title="<?php echo $download->items->title() ? $download->items->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($download->items->ReadOnly || $download->items->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="download" data-field="x_items" name="x_items" id="x_items" multiple="multiple"<?php echo $download->items->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_items" id= "fn_x_items" value="<?php echo $download->items->Upload->FileName ?>">
<?php if (Post("fa_x_items") == "0") { ?>
<input type="hidden" name="fa_x_items" id= "fa_x_items" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_items" id= "fa_x_items" value="1">
<?php } ?>
<input type="hidden" name="fs_x_items" id= "fs_x_items" value="255">
<input type="hidden" name="fx_x_items" id= "fx_x_items" value="<?php echo $download->items->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_items" id= "fm_x_items" value="<?php echo $download->items->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_items" id= "fc_x_items" value="<?php echo $download->items->UploadMaxFileCount ?>">
</div>
<table id="ft_x_items" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $download->items->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($download->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_download_remarks" for="x_remarks" class="<?php echo $download_edit->LeftColumnClass ?>"><?php echo $download->remarks->caption() ?><?php echo ($download->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $download_edit->RightColumnClass ?>"><div<?php echo $download->remarks->cellAttributes() ?>>
<span id="el_download_remarks">
<textarea data-table="download" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($download->remarks->getPlaceHolder()) ?>"<?php echo $download->remarks->editAttributes() ?>><?php echo $download->remarks->EditValue ?></textarea>
</span>
<?php echo $download->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$download_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $download_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $download_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$download_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$download_edit->terminate();
?>