<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$download_list = new download_list();

// Run the page
$download_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$download_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$download->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fdownloadlist = currentForm = new ew.Form("fdownloadlist", "list");
fdownloadlist.formKeyCountName = '<?php echo $download_list->FormKeyCountName ?>';

// Form_CustomValidate event
fdownloadlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdownloadlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fdownloadlistsrch = currentSearchForm = new ew.Form("fdownloadlistsrch");

// Filters
fdownloadlistsrch.filterList = <?php echo $download_list->getFilterList() ?>;

// Init search panel as collapsed
fdownloadlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$download->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($download_list->TotalRecs > 0 && $download_list->ExportOptions->visible()) { ?>
<?php $download_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($download_list->ImportOptions->visible()) { ?>
<?php $download_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($download_list->SearchOptions->visible()) { ?>
<?php $download_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($download_list->FilterOptions->visible()) { ?>
<?php $download_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$download_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$download->isExport() && !$download->CurrentAction) { ?>
<form name="fdownloadlistsrch" id="fdownloadlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($download_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fdownloadlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="download">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($download_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($download_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $download_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($download_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($download_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($download_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($download_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $download_list->showPageHeader(); ?>
<?php
$download_list->showMessage();
?>
<?php if ($download_list->TotalRecs > 0 || $download->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($download_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> download">
<?php if (!$download->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$download->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($download_list->Pager)) $download_list->Pager = new PrevNextPager($download_list->StartRec, $download_list->DisplayRecs, $download_list->TotalRecs, $download_list->AutoHidePager) ?>
<?php if ($download_list->Pager->RecordCount > 0 && $download_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($download_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $download_list->pageUrl() ?>start=<?php echo $download_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($download_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $download_list->pageUrl() ?>start=<?php echo $download_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $download_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($download_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $download_list->pageUrl() ?>start=<?php echo $download_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($download_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $download_list->pageUrl() ?>start=<?php echo $download_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $download_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($download_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $download_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $download_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $download_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($download_list->TotalRecs > 0 && (!$download_list->AutoHidePageSizeSelector || $download_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="download">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($download_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($download_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($download_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($download_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($download_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($download->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $download_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fdownloadlist" id="fdownloadlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($download_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $download_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="download">
<div id="gmp_download" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($download_list->TotalRecs > 0 || $download->isGridEdit()) { ?>
<table id="tbl_downloadlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$download_list->RowType = ROWTYPE_HEADER;

// Render list options
$download_list->renderListOptions();

// Render list options (header, left)
$download_list->ListOptions->render("header", "left");
?>
<?php if ($download->id->Visible) { // id ?>
	<?php if ($download->sortUrl($download->id) == "") { ?>
		<th data-name="id" class="<?php echo $download->id->headerCellClass() ?>"><div id="elh_download_id" class="download_id"><div class="ew-table-header-caption"><?php echo $download->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $download->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $download->SortUrl($download->id) ?>',2);"><div id="elh_download_id" class="download_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $download->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($download->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($download->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($download->description->Visible) { // description ?>
	<?php if ($download->sortUrl($download->description) == "") { ?>
		<th data-name="description" class="<?php echo $download->description->headerCellClass() ?>"><div id="elh_download_description" class="download_description"><div class="ew-table-header-caption"><?php echo $download->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $download->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $download->SortUrl($download->description) ?>',2);"><div id="elh_download_description" class="download_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $download->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($download->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($download->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($download->items->Visible) { // items ?>
	<?php if ($download->sortUrl($download->items) == "") { ?>
		<th data-name="items" class="<?php echo $download->items->headerCellClass() ?>"><div id="elh_download_items" class="download_items"><div class="ew-table-header-caption"><?php echo $download->items->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="items" class="<?php echo $download->items->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $download->SortUrl($download->items) ?>',2);"><div id="elh_download_items" class="download_items">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $download->items->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($download->items->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($download->items->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($download->remarks->Visible) { // remarks ?>
	<?php if ($download->sortUrl($download->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $download->remarks->headerCellClass() ?>"><div id="elh_download_remarks" class="download_remarks"><div class="ew-table-header-caption"><?php echo $download->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $download->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $download->SortUrl($download->remarks) ?>',2);"><div id="elh_download_remarks" class="download_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $download->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($download->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($download->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($download->operator->Visible) { // operator ?>
	<?php if ($download->sortUrl($download->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $download->operator->headerCellClass() ?>"><div id="elh_download_operator" class="download_operator"><div class="ew-table-header-caption"><?php echo $download->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $download->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $download->SortUrl($download->operator) ?>',2);"><div id="elh_download_operator" class="download_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $download->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($download->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($download->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($download->datetime->Visible) { // datetime ?>
	<?php if ($download->sortUrl($download->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $download->datetime->headerCellClass() ?>"><div id="elh_download_datetime" class="download_datetime"><div class="ew-table-header-caption"><?php echo $download->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $download->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $download->SortUrl($download->datetime) ?>',2);"><div id="elh_download_datetime" class="download_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $download->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($download->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($download->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$download_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($download->ExportAll && $download->isExport()) {
	$download_list->StopRec = $download_list->TotalRecs;
} else {

	// Set the last record to display
	if ($download_list->TotalRecs > $download_list->StartRec + $download_list->DisplayRecs - 1)
		$download_list->StopRec = $download_list->StartRec + $download_list->DisplayRecs - 1;
	else
		$download_list->StopRec = $download_list->TotalRecs;
}
$download_list->RecCnt = $download_list->StartRec - 1;
if ($download_list->Recordset && !$download_list->Recordset->EOF) {
	$download_list->Recordset->moveFirst();
	$selectLimit = $download_list->UseSelectLimit;
	if (!$selectLimit && $download_list->StartRec > 1)
		$download_list->Recordset->move($download_list->StartRec - 1);
} elseif (!$download->AllowAddDeleteRow && $download_list->StopRec == 0) {
	$download_list->StopRec = $download->GridAddRowCount;
}

// Initialize aggregate
$download->RowType = ROWTYPE_AGGREGATEINIT;
$download->resetAttributes();
$download_list->renderRow();
while ($download_list->RecCnt < $download_list->StopRec) {
	$download_list->RecCnt++;
	if ($download_list->RecCnt >= $download_list->StartRec) {
		$download_list->RowCnt++;

		// Set up key count
		$download_list->KeyCount = $download_list->RowIndex;

		// Init row class and style
		$download->resetAttributes();
		$download->CssClass = "";
		if ($download->isGridAdd()) {
		} else {
			$download_list->loadRowValues($download_list->Recordset); // Load row values
		}
		$download->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$download->RowAttrs = array_merge($download->RowAttrs, array('data-rowindex'=>$download_list->RowCnt, 'id'=>'r' . $download_list->RowCnt . '_download', 'data-rowtype'=>$download->RowType));

		// Render row
		$download_list->renderRow();

		// Render list options
		$download_list->renderListOptions();
?>
	<tr<?php echo $download->rowAttributes() ?>>
<?php

// Render list options (body, left)
$download_list->ListOptions->render("body", "left", $download_list->RowCnt);
?>
	<?php if ($download->id->Visible) { // id ?>
		<td data-name="id"<?php echo $download->id->cellAttributes() ?>>
<span id="el<?php echo $download_list->RowCnt ?>_download_id" class="download_id">
<span<?php echo $download->id->viewAttributes() ?>>
<?php echo $download->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($download->description->Visible) { // description ?>
		<td data-name="description"<?php echo $download->description->cellAttributes() ?>>
<span id="el<?php echo $download_list->RowCnt ?>_download_description" class="download_description">
<span<?php echo $download->description->viewAttributes() ?>>
<?php echo $download->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($download->items->Visible) { // items ?>
		<td data-name="items"<?php echo $download->items->cellAttributes() ?>>
<span id="el<?php echo $download_list->RowCnt ?>_download_items" class="download_items">
<span>
<?php echo GetFileViewTag($download->items, $download->items->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($download->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $download->remarks->cellAttributes() ?>>
<span id="el<?php echo $download_list->RowCnt ?>_download_remarks" class="download_remarks">
<span<?php echo $download->remarks->viewAttributes() ?>>
<?php echo $download->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($download->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $download->operator->cellAttributes() ?>>
<span id="el<?php echo $download_list->RowCnt ?>_download_operator" class="download_operator">
<span<?php echo $download->operator->viewAttributes() ?>>
<?php echo $download->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($download->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $download->datetime->cellAttributes() ?>>
<span id="el<?php echo $download_list->RowCnt ?>_download_datetime" class="download_datetime">
<span<?php echo $download->datetime->viewAttributes() ?>>
<?php echo $download->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$download_list->ListOptions->render("body", "right", $download_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$download->isGridAdd())
		$download_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$download->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($download_list->Recordset)
	$download_list->Recordset->Close();
?>
<?php if (!$download->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$download->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($download_list->Pager)) $download_list->Pager = new PrevNextPager($download_list->StartRec, $download_list->DisplayRecs, $download_list->TotalRecs, $download_list->AutoHidePager) ?>
<?php if ($download_list->Pager->RecordCount > 0 && $download_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($download_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $download_list->pageUrl() ?>start=<?php echo $download_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($download_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $download_list->pageUrl() ?>start=<?php echo $download_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $download_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($download_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $download_list->pageUrl() ?>start=<?php echo $download_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($download_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $download_list->pageUrl() ?>start=<?php echo $download_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $download_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($download_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $download_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $download_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $download_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($download_list->TotalRecs > 0 && (!$download_list->AutoHidePageSizeSelector || $download_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="download">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($download_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($download_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($download_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($download_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($download_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($download->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $download_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($download_list->TotalRecs == 0 && !$download->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $download_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$download_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$download->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$download->isExport()) { ?>
<script>
ew.scrollableTable("gmp_download", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$download_list->terminate();
?>