<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$download_search = new download_search();

// Run the page
$download_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$download_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($download_search->IsModal) { ?>
var fdownloadsearch = currentAdvancedSearchForm = new ew.Form("fdownloadsearch", "search");
<?php } else { ?>
var fdownloadsearch = currentForm = new ew.Form("fdownloadsearch", "search");
<?php } ?>

// Form_CustomValidate event
fdownloadsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdownloadsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search
// Validate function for search

fdownloadsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($download->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($download->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($download->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $download_search->showPageHeader(); ?>
<?php
$download_search->showMessage();
?>
<form name="fdownloadsearch" id="fdownloadsearch" class="<?php echo $download_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($download_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $download_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="download">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$download_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($download->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $download_search->LeftColumnClass ?>"><span id="elh_download_id"><?php echo $download->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $download_search->RightColumnClass ?>"><div<?php echo $download->id->cellAttributes() ?>>
			<span id="el_download_id">
<input type="text" data-table="download" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($download->id->getPlaceHolder()) ?>" value="<?php echo $download->id->EditValue ?>"<?php echo $download->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($download->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label for="x_description" class="<?php echo $download_search->LeftColumnClass ?>"><span id="elh_download_description"><?php echo $download->description->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description" id="z_description" value="LIKE"></span>
		</label>
		<div class="<?php echo $download_search->RightColumnClass ?>"><div<?php echo $download->description->cellAttributes() ?>>
			<span id="el_download_description">
<input type="text" data-table="download" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($download->description->getPlaceHolder()) ?>" value="<?php echo $download->description->EditValue ?>"<?php echo $download->description->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($download->items->Visible) { // items ?>
	<div id="r_items" class="form-group row">
		<label class="<?php echo $download_search->LeftColumnClass ?>"><span id="elh_download_items"><?php echo $download->items->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_items" id="z_items" value="LIKE"></span>
		</label>
		<div class="<?php echo $download_search->RightColumnClass ?>"><div<?php echo $download->items->cellAttributes() ?>>
			<span id="el_download_items">
<input type="text" data-table="download" data-field="x_items" name="x_items" id="x_items" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($download->items->getPlaceHolder()) ?>" value="<?php echo $download->items->EditValue ?>"<?php echo $download->items->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($download->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $download_search->LeftColumnClass ?>"><span id="elh_download_remarks"><?php echo $download->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $download_search->RightColumnClass ?>"><div<?php echo $download->remarks->cellAttributes() ?>>
			<span id="el_download_remarks">
<input type="text" data-table="download" data-field="x_remarks" name="x_remarks" id="x_remarks" size="35" placeholder="<?php echo HtmlEncode($download->remarks->getPlaceHolder()) ?>" value="<?php echo $download->remarks->EditValue ?>"<?php echo $download->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($download->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $download_search->LeftColumnClass ?>"><span id="elh_download_operator"><?php echo $download->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $download_search->RightColumnClass ?>"><div<?php echo $download->operator->cellAttributes() ?>>
			<span id="el_download_operator">
<input type="text" data-table="download" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($download->operator->getPlaceHolder()) ?>" value="<?php echo $download->operator->EditValue ?>"<?php echo $download->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($download->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $download_search->LeftColumnClass ?>"><span id="elh_download_datetime"><?php echo $download->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $download_search->RightColumnClass ?>"><div<?php echo $download->datetime->cellAttributes() ?>>
			<span id="el_download_datetime">
<input type="text" data-table="download" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($download->datetime->getPlaceHolder()) ?>" value="<?php echo $download->datetime->EditValue ?>"<?php echo $download->datetime->editAttributes() ?>>
<?php if (!$download->datetime->ReadOnly && !$download->datetime->Disabled && !isset($download->datetime->EditAttrs["readonly"]) && !isset($download->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fdownloadsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$download_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $download_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$download_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$download_search->terminate();
?>