<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$download_view = new download_view();

// Run the page
$download_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$download_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$download->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fdownloadview = currentForm = new ew.Form("fdownloadview", "view");

// Form_CustomValidate event
fdownloadview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdownloadview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$download->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $download_view->ExportOptions->render("body") ?>
<?php $download_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $download_view->showPageHeader(); ?>
<?php
$download_view->showMessage();
?>
<form name="fdownloadview" id="fdownloadview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($download_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $download_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="download">
<input type="hidden" name="modal" value="<?php echo (int)$download_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($download->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $download_view->TableLeftColumnClass ?>"><span id="elh_download_id"><?php echo $download->id->caption() ?></span></td>
		<td data-name="id"<?php echo $download->id->cellAttributes() ?>>
<span id="el_download_id">
<span<?php echo $download->id->viewAttributes() ?>>
<?php echo $download->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($download->description->Visible) { // description ?>
	<tr id="r_description">
		<td class="<?php echo $download_view->TableLeftColumnClass ?>"><span id="elh_download_description"><?php echo $download->description->caption() ?></span></td>
		<td data-name="description"<?php echo $download->description->cellAttributes() ?>>
<span id="el_download_description">
<span<?php echo $download->description->viewAttributes() ?>>
<?php echo $download->description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($download->items->Visible) { // items ?>
	<tr id="r_items">
		<td class="<?php echo $download_view->TableLeftColumnClass ?>"><span id="elh_download_items"><?php echo $download->items->caption() ?></span></td>
		<td data-name="items"<?php echo $download->items->cellAttributes() ?>>
<span id="el_download_items">
<span>
<?php echo GetFileViewTag($download->items, $download->items->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($download->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $download_view->TableLeftColumnClass ?>"><span id="elh_download_remarks"><?php echo $download->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $download->remarks->cellAttributes() ?>>
<span id="el_download_remarks">
<span<?php echo $download->remarks->viewAttributes() ?>>
<?php echo $download->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($download->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $download_view->TableLeftColumnClass ?>"><span id="elh_download_operator"><?php echo $download->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $download->operator->cellAttributes() ?>>
<span id="el_download_operator">
<span<?php echo $download->operator->viewAttributes() ?>>
<?php echo $download->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($download->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $download_view->TableLeftColumnClass ?>"><span id="elh_download_datetime"><?php echo $download->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $download->datetime->cellAttributes() ?>>
<span id="el_download_datetime">
<span<?php echo $download->datetime->viewAttributes() ?>>
<?php echo $download->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$download_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$download->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$download_view->terminate();
?>