<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 
?>
<?php include_once "autoload.php" ?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$dummy = new dummy();

// Run the page
$dummy->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();
?>
<?php include_once "header.php" ?>
<?php

$detail = ExecuteRow("SELECT `id`, `description`, `type`, `w_cm`, `l_cm`, `gutter_cm`, `top_margin`, `bottom_margin`, `left_margin`, `right_margin`, `gripper`, `no_of_col`, `no_of_row`, `plate_w`, `plate_h`, `plate_margin`,  `operator`, `datetime` FROM `p_dummy` WHERE `id` = 1 limit 1");
$page = '';
$page2 = '';
$html = '';
$print = '';
$w = $detail['w_cm'] ;
$h = $detail['l_cm'];
$tm = $detail['top_margin'];
$bm = $detail['bottom_margin'];
$lm = $detail['left_margin'];
$rm = $detail['right_margin'];
$col = $detail['no_of_col'];
$row = $detail['no_of_row'];
$gutter = ($detail['gutter_cm']);
$platew = $detail['plate_w'];
$plateh = $detail['plate_h'];
$pm = $detail['plate_margin'];
$gripper = $detail['gripper'];

$spw = (($w - $gripper) - ($detail['gutter_cm']*$col/2) - ($rm*$col/2) - ($lm*$col/2))/$col;
$sph = ($h/$col - $lm - $rm);
$p = 32;
$sp = 1;
$pis = $col * $row * 2;
$s = 0;
$pn = 1; 
$plm = ($plateh - $h) / 2;
for ($s=0; $s<$p; $s = $s+$pis)
{
$plate = '
	<div style="width: '.$platew.'cm; height: '.$plateh.'cm; background-color:'.color().';">
		<div style="width: '.$pm.'cm; height: '.$plateh.'cm; float: left; font-size: 24pt; text-align: right; background-color:'.color().';"><hr style="width:98%; border:1px solid; margin-top: '.($plateh/2).'cm;" />'.$pn.'~1
		</div>';
$sheet = '
		<div style="width: '.$w.'cm; height: '.$h.'cm; margin-top:'.$plm.'cm; float:left; background-color:'.color().'">
			<div style="width: '.$gripper.'cm; height: '.$h.'cm; float: left; background-color:'.color().';">
			</div>';
	if (($col == 2) || ($col == 4)) 
	{
$page = '
			<div style="width: '.(($w-$gripper)/$row*2).'cm; float: left; height: '.($h/$col).'cm; background-color:'.color().'">';	
$page .= '
				<div style="height: '.$sph.'cm; width: '.$spw.'cm; float: left; margin-left: '.$bm.'cm; margin-top: '.$tm.'cm; margin-bottom: '.$lm.'cm; margin-right: 0cm; background-color:'.color().'"><img src="132/132_page-'.str_pad(($s+5),4,"0", STR_PAD_LEFT).'.jpg" style="height:'.$sph.'cm; width:'.$spw.'cm; transform: rotate(180deg)"  alt="" />
				</div>';
$page .= '		
				<div style="height: '.$sph.'cm; width: '.$gutter.'cm; float: left; margin-top: '.$tm.'cm; margin-bottom: '.$bm.'cm; background-color:'.color().'">
				</div>';
$page .= '
				<div style="height: '.$sph.'cm; width: '.$spw.'cm; float: left; margin-right: '.$bm.'cm; margin-top: '.$tm.'cm; margin-bottom: '.$lm.'cm; background-color:'.color().'"><img src="132/132_page-'.str_pad(($s+4),4,"0", STR_PAD_LEFT).'.jpg" style="height:'.$sph.'cm; width:'.$spw.'cm; transform: rotate(180deg);" alt="" />
				</div>
			</div>';
	}

	if (($row == 2) || ($row == 4)) 
	{
$page .= '
			<div style="width: '.(($w-$gripper)/$row*2).'cm; float: left; height: '.($h/$col).'cm; background-color:'.color().'">';	
$page .= '
				<div style="height: '.$sph.'cm; width: '.$spw.'cm; float: left; margin-left: '.$bm.'cm; margin-top: '.$tm.'cm; margin-bottom: '.$lm.'cm; margin-right: 0cm; background-color:'.color().'"><img src="132/132_page-'.str_pad(($s+8),4,"0", STR_PAD_LEFT).'.jpg" style="height:'.$sph.'cm; width:'.$spw.'cm;" alt="" />
				</div>';
$page .= '		
				<div style="height: '.$sph.'cm; width: '.$gutter.'cm; float: left; margin-top: '.$tm.'cm; margin-bottom: '.$bm.'cm; background-color:'.color().'">
				</div>';
$page .= '
				<div style="height: '.$sph.'cm; width: '.$spw.'cm; float: left; margin-right: '.$bm.'cm; margin-top: '.$tm.'cm; margin-bottom: '.$lm.'cm; background-color:'.color().'"><img src="132/132_page-'.str_pad(($s+1),4,"0", STR_PAD_LEFT).'.jpg" style="height:'.$sph.'cm; width:'.$spw.'cm;" alt="" />
				</div>
			</div>	';
	}
	
$html = $plate . $sheet . $page; 
$html .= '	
		</div>
	</div>
	<div style="page-break-after: always;">
	</div>';
unset ($plate, $sheet, $page);	

//Plate Back
$plate2 = '
	<div style="width: '.$platew.'cm; height: '.$plateh.'cm; background-color:'.color().';">
		<div style="width: '.$pm.'cm; height: '.$plateh.'cm; float: left; font-size: 24pt; text-align: right; background-color:'.color().';"><hr style="width:98%; border:solid; margin-top: '.($plateh/2).'cm;" />'.$pn.'~2
		</div>';
$sheet2 = '
		<div style="width: '.$w.'cm; height: '.$h.'cm; margin-top:'.$plm.'cm; float:left; background-color:'.color().'">
			<div style="width: '.$gripper.'cm; height: '.$h.'cm; float: left; background-color:'.color().';">
			</div>';
	if (($col == 2) || ($col == 4)) 
	{
$page2 = '
			<div style="width: '.(($w-$gripper)/$row*2).'cm; float: left; height: '.($h/$col).'cm; background-color:'.color().'">';	
$page2 .= '
				<div style="height: '.$sph.'cm; width: '.$spw.'cm; float: left; margin-left: '.$bm.'cm; margin-top: '.$tm.'cm; margin-bottom: '.$lm.'cm; margin-right: 0cm; background-color:'.color().'"><img src="132/132_page-'.str_pad(($s+6),4,"0", STR_PAD_LEFT).'.jpg" style="height:'.$sph.'cm; width:'.$spw.'cm; transform: rotate(180deg)"  alt="" />
				</div>';
$page2 .= '		
				<div style="height: '.$sph.'cm; width: '.$gutter.'cm; float: left; margin-top: '.$tm.'cm; margin-bottom: '.$bm.'cm; background-color:'.color().'">
				</div>';
$page2 .= '
				<div style="height: '.$sph.'cm; width: '.$spw.'cm; float: left; margin-right: '.$bm.'cm; margin-top: '.$tm.'cm; margin-bottom: '.$lm.'cm; background-color:'.color().'"><img src="132/132_page-'.str_pad(($s+2),4,"0", STR_PAD_LEFT).'.jpg" style="height:'.$sph.'cm; width:'.$spw.'cm; transform: rotate(180deg);" alt="" />
				</div>
			</div>	';
	}

	if (($row == 2) || ($row == 4)) 
	{
$page2 .= '
			<div style="width: '.(($w-$gripper)/$row*2).'cm; float: left; height: '.($h/$col).'cm; background-color:'.color().'">';	
$page2 .= '
				<div style="height: '.$sph.'cm; width: '.$spw.'cm; float: left; margin-left: '.$bm.'cm; margin-top: '.$tm.'cm; margin-bottom: '.$lm.'cm; margin-right: 0cm; background-color:'.color().'"><img src="132/132_page-'.str_pad(($s+6),4,"0", STR_PAD_LEFT).'.jpg" style="height:'.$sph.'cm; width:'.$spw.'cm;" alt="" />
				</div>';
$page2 .= '		
				<div style="height: '.$sph.'cm; width: '.$gutter.'cm; float: left; margin-top: '.$tm.'cm; margin-bottom: '.$bm.'cm; background-color:'.color().'">
				</div>';
$page2 .= '
				<div style="height: '.$sph.'cm; width: '.$spw.'cm; float: left; margin-right: '.$bm.'cm; margin-top: '.$tm.'cm; margin-bottom: '.$lm.'cm; background-color:'.color().'"><img src="132/132_page-'.str_pad(($s+3),4,"0", STR_PAD_LEFT).'.jpg" style="height:'.$sph.'cm; width:'.$spw.'cm;" alt="" />
				</div>
			</div>';
	}
	
$html2 = $plate2 . $sheet2 . $page2; 
	
$html2 .= '	
		</div>
	</div>
	<div style="page-break-after: always;"></div>';
$print .= $html . $html2; 
unset ($plate2, $sheet2, $page2, $html, $html2);
$pn++;		
}
echo $print;
//ExportPDF($print,'aa.pdf',$size=(0,0,3816,4680));
ExportPDF($print, 'aa.pdf', $size=array('size'=>'A4', 'orientation'=>'landscape')); 
function color()
{
	return 'rgb(' . rand(100,255) . ', ' . rand(100,255) . ', ' . rand(100,255) . ')';
}
?>
<?php if (DEBUG_ENABLED) echo GetDebugMessage(); ?>
<?php include_once "footer.php" ?>
<?php
$dummy->terminate();
?>