<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$dyeing_dw_list = new dyeing_dw_list();

// Run the page
$dyeing_dw_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$dyeing_dw_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$dyeing_dw->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fdyeing_dwlist = currentForm = new ew.Form("fdyeing_dwlist", "list");
fdyeing_dwlist.formKeyCountName = '<?php echo $dyeing_dw_list->FormKeyCountName ?>';

// Form_CustomValidate event
fdyeing_dwlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdyeing_dwlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fdyeing_dwlist.lists["x_product"] = <?php echo $dyeing_dw_list->product->Lookup->toClientList() ?>;
fdyeing_dwlist.lists["x_product"].options = <?php echo JsonEncode($dyeing_dw_list->product->lookupOptions()) ?>;
fdyeing_dwlist.lists["x_rid"] = <?php echo $dyeing_dw_list->rid->Lookup->toClientList() ?>;
fdyeing_dwlist.lists["x_rid"].options = <?php echo JsonEncode($dyeing_dw_list->rid->lookupOptions()) ?>;
fdyeing_dwlist.lists["x_dyeing_type"] = <?php echo $dyeing_dw_list->dyeing_type->Lookup->toClientList() ?>;
fdyeing_dwlist.lists["x_dyeing_type"].options = <?php echo JsonEncode($dyeing_dw_list->dyeing_type->lookupOptions()) ?>;
fdyeing_dwlist.lists["x_packing_type"] = <?php echo $dyeing_dw_list->packing_type->Lookup->toClientList() ?>;
fdyeing_dwlist.lists["x_packing_type"].options = <?php echo JsonEncode($dyeing_dw_list->packing_type->lookupOptions()) ?>;
fdyeing_dwlist.lists["x_godown"] = <?php echo $dyeing_dw_list->godown->Lookup->toClientList() ?>;
fdyeing_dwlist.lists["x_godown"].options = <?php echo JsonEncode($dyeing_dw_list->godown->lookupOptions()) ?>;

// Form object for search
var fdyeing_dwlistsrch = currentSearchForm = new ew.Form("fdyeing_dwlistsrch");

// Validate function for search
fdyeing_dwlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fdyeing_dwlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdyeing_dwlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fdyeing_dwlistsrch.lists["x_product"] = <?php echo $dyeing_dw_list->product->Lookup->toClientList() ?>;
fdyeing_dwlistsrch.lists["x_product"].options = <?php echo JsonEncode($dyeing_dw_list->product->lookupOptions()) ?>;
fdyeing_dwlistsrch.lists["x_rid"] = <?php echo $dyeing_dw_list->rid->Lookup->toClientList() ?>;
fdyeing_dwlistsrch.lists["x_rid"].options = <?php echo JsonEncode($dyeing_dw_list->rid->lookupOptions()) ?>;

// Filters
fdyeing_dwlistsrch.filterList = <?php echo $dyeing_dw_list->getFilterList() ?>;

// Init search panel as collapsed
fdyeing_dwlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$dyeing_dw->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($dyeing_dw_list->TotalRecs > 0 && $dyeing_dw_list->ExportOptions->visible()) { ?>
<?php $dyeing_dw_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($dyeing_dw_list->ImportOptions->visible()) { ?>
<?php $dyeing_dw_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($dyeing_dw_list->SearchOptions->visible()) { ?>
<?php $dyeing_dw_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($dyeing_dw_list->FilterOptions->visible()) { ?>
<?php $dyeing_dw_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$dyeing_dw->isExport() || EXPORT_MASTER_RECORD && $dyeing_dw->isExport("print")) { ?>
<?php
if ($dyeing_dw_list->DbMasterFilter <> "" && $dyeing_dw->getCurrentMasterTable() == "dyeing_process_shortage") {
	if ($dyeing_dw_list->MasterRecordExists) {
		include_once "dyeing_process_shortagemaster.php";
	}
}
?>
<?php } ?>
<?php
$dyeing_dw_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$dyeing_dw->isExport() && !$dyeing_dw->CurrentAction) { ?>
<form name="fdyeing_dwlistsrch" id="fdyeing_dwlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($dyeing_dw_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fdyeing_dwlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="dyeing_dw">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$dyeing_dw_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$dyeing_dw->RowType = ROWTYPE_SEARCH;

// Render row
$dyeing_dw->resetAttributes();
$dyeing_dw_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($dyeing_dw->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $dyeing_dw->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<?php $dyeing_dw->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$dyeing_dw->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="dyeing_dw" data-field="x_product" data-value-separator="<?php echo $dyeing_dw->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $dyeing_dw->product->editAttributes() ?>>
		<?php echo $dyeing_dw->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $dyeing_dw->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($dyeing_dw->rid->Visible) { // rid ?>
	<div id="xsc_rid" class="ew-cell form-group">
		<label for="x_rid" class="ew-search-caption ew-label"><?php echo $dyeing_dw->rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="dyeing_dw" data-field="x_rid" data-value-separator="<?php echo $dyeing_dw->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $dyeing_dw->rid->editAttributes() ?>>
		<?php echo $dyeing_dw->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $dyeing_dw->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $dyeing_dw_list->showPageHeader(); ?>
<?php
$dyeing_dw_list->showMessage();
?>
<?php if ($dyeing_dw_list->TotalRecs > 0 || $dyeing_dw->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($dyeing_dw_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> dyeing_dw">
<?php if (!$dyeing_dw->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$dyeing_dw->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($dyeing_dw_list->Pager)) $dyeing_dw_list->Pager = new PrevNextPager($dyeing_dw_list->StartRec, $dyeing_dw_list->DisplayRecs, $dyeing_dw_list->TotalRecs, $dyeing_dw_list->AutoHidePager) ?>
<?php if ($dyeing_dw_list->Pager->RecordCount > 0 && $dyeing_dw_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($dyeing_dw_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $dyeing_dw_list->pageUrl() ?>start=<?php echo $dyeing_dw_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($dyeing_dw_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $dyeing_dw_list->pageUrl() ?>start=<?php echo $dyeing_dw_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $dyeing_dw_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($dyeing_dw_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $dyeing_dw_list->pageUrl() ?>start=<?php echo $dyeing_dw_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($dyeing_dw_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $dyeing_dw_list->pageUrl() ?>start=<?php echo $dyeing_dw_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $dyeing_dw_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($dyeing_dw_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $dyeing_dw_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $dyeing_dw_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $dyeing_dw_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($dyeing_dw_list->TotalRecs > 0 && (!$dyeing_dw_list->AutoHidePageSizeSelector || $dyeing_dw_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="dyeing_dw">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($dyeing_dw_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($dyeing_dw_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($dyeing_dw_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($dyeing_dw_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($dyeing_dw_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($dyeing_dw->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $dyeing_dw_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fdyeing_dwlist" id="fdyeing_dwlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($dyeing_dw_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $dyeing_dw_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="dyeing_dw">
<?php if ($dyeing_dw->getCurrentMasterTable() == "dyeing_process_shortage" && $dyeing_dw->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="dyeing_process_shortage">
<input type="hidden" name="fk_tmp_lot" value="<?php echo $dyeing_dw->tmp_lot->getSessionValue() ?>">
<?php } ?>
<div id="gmp_dyeing_dw" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($dyeing_dw_list->TotalRecs > 0 || $dyeing_dw->isGridEdit()) { ?>
<table id="tbl_dyeing_dwlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$dyeing_dw_list->RowType = ROWTYPE_HEADER;

// Render list options
$dyeing_dw_list->renderListOptions();

// Render list options (header, left)
$dyeing_dw_list->ListOptions->render("header", "left");
?>
<?php if ($dyeing_dw->id->Visible) { // id ?>
	<?php if ($dyeing_dw->sortUrl($dyeing_dw->id) == "") { ?>
		<th data-name="id" class="<?php echo $dyeing_dw->id->headerCellClass() ?>"><div id="elh_dyeing_dw_id" class="dyeing_dw_id"><div class="ew-table-header-caption"><?php echo $dyeing_dw->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $dyeing_dw->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_dw->SortUrl($dyeing_dw->id) ?>',2);"><div id="elh_dyeing_dw_id" class="dyeing_dw_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_dw->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_dw->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_dw->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_dw->dated->Visible) { // dated ?>
	<?php if ($dyeing_dw->sortUrl($dyeing_dw->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $dyeing_dw->dated->headerCellClass() ?>"><div id="elh_dyeing_dw_dated" class="dyeing_dw_dated"><div class="ew-table-header-caption"><?php echo $dyeing_dw->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $dyeing_dw->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_dw->SortUrl($dyeing_dw->dated) ?>',2);"><div id="elh_dyeing_dw_dated" class="dyeing_dw_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_dw->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_dw->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_dw->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_dw->product->Visible) { // product ?>
	<?php if ($dyeing_dw->sortUrl($dyeing_dw->product) == "") { ?>
		<th data-name="product" class="<?php echo $dyeing_dw->product->headerCellClass() ?>"><div id="elh_dyeing_dw_product" class="dyeing_dw_product"><div class="ew-table-header-caption"><?php echo $dyeing_dw->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $dyeing_dw->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_dw->SortUrl($dyeing_dw->product) ?>',2);"><div id="elh_dyeing_dw_product" class="dyeing_dw_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_dw->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_dw->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_dw->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_dw->rid->Visible) { // rid ?>
	<?php if ($dyeing_dw->sortUrl($dyeing_dw->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $dyeing_dw->rid->headerCellClass() ?>"><div id="elh_dyeing_dw_rid" class="dyeing_dw_rid"><div class="ew-table-header-caption"><?php echo $dyeing_dw->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $dyeing_dw->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_dw->SortUrl($dyeing_dw->rid) ?>',2);"><div id="elh_dyeing_dw_rid" class="dyeing_dw_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_dw->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_dw->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_dw->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_dw->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($dyeing_dw->sortUrl($dyeing_dw->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $dyeing_dw->tmp_lot->headerCellClass() ?>"><div id="elh_dyeing_dw_tmp_lot" class="dyeing_dw_tmp_lot"><div class="ew-table-header-caption"><?php echo $dyeing_dw->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $dyeing_dw->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_dw->SortUrl($dyeing_dw->tmp_lot) ?>',2);"><div id="elh_dyeing_dw_tmp_lot" class="dyeing_dw_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_dw->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_dw->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_dw->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_dw->dyeing_type->Visible) { // dyeing_type ?>
	<?php if ($dyeing_dw->sortUrl($dyeing_dw->dyeing_type) == "") { ?>
		<th data-name="dyeing_type" class="<?php echo $dyeing_dw->dyeing_type->headerCellClass() ?>"><div id="elh_dyeing_dw_dyeing_type" class="dyeing_dw_dyeing_type"><div class="ew-table-header-caption"><?php echo $dyeing_dw->dyeing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dyeing_type" class="<?php echo $dyeing_dw->dyeing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_dw->SortUrl($dyeing_dw->dyeing_type) ?>',2);"><div id="elh_dyeing_dw_dyeing_type" class="dyeing_dw_dyeing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_dw->dyeing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_dw->dyeing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_dw->dyeing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_dw->IN->Visible) { // IN ?>
	<?php if ($dyeing_dw->sortUrl($dyeing_dw->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $dyeing_dw->IN->headerCellClass() ?>"><div id="elh_dyeing_dw_IN" class="dyeing_dw_IN"><div class="ew-table-header-caption"><?php echo $dyeing_dw->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $dyeing_dw->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_dw->SortUrl($dyeing_dw->IN) ?>',2);"><div id="elh_dyeing_dw_IN" class="dyeing_dw_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_dw->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_dw->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_dw->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_dw->packets->Visible) { // packets ?>
	<?php if ($dyeing_dw->sortUrl($dyeing_dw->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $dyeing_dw->packets->headerCellClass() ?>"><div id="elh_dyeing_dw_packets" class="dyeing_dw_packets"><div class="ew-table-header-caption"><?php echo $dyeing_dw->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $dyeing_dw->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_dw->SortUrl($dyeing_dw->packets) ?>',2);"><div id="elh_dyeing_dw_packets" class="dyeing_dw_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_dw->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_dw->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_dw->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_dw->packing_type->Visible) { // packing_type ?>
	<?php if ($dyeing_dw->sortUrl($dyeing_dw->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $dyeing_dw->packing_type->headerCellClass() ?>"><div id="elh_dyeing_dw_packing_type" class="dyeing_dw_packing_type"><div class="ew-table-header-caption"><?php echo $dyeing_dw->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $dyeing_dw->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_dw->SortUrl($dyeing_dw->packing_type) ?>',2);"><div id="elh_dyeing_dw_packing_type" class="dyeing_dw_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_dw->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_dw->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_dw->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_dw->godown->Visible) { // godown ?>
	<?php if ($dyeing_dw->sortUrl($dyeing_dw->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $dyeing_dw->godown->headerCellClass() ?>"><div id="elh_dyeing_dw_godown" class="dyeing_dw_godown"><div class="ew-table-header-caption"><?php echo $dyeing_dw->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $dyeing_dw->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_dw->SortUrl($dyeing_dw->godown) ?>',2);"><div id="elh_dyeing_dw_godown" class="dyeing_dw_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_dw->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_dw->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_dw->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$dyeing_dw_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($dyeing_dw->ExportAll && $dyeing_dw->isExport()) {
	$dyeing_dw_list->StopRec = $dyeing_dw_list->TotalRecs;
} else {

	// Set the last record to display
	if ($dyeing_dw_list->TotalRecs > $dyeing_dw_list->StartRec + $dyeing_dw_list->DisplayRecs - 1)
		$dyeing_dw_list->StopRec = $dyeing_dw_list->StartRec + $dyeing_dw_list->DisplayRecs - 1;
	else
		$dyeing_dw_list->StopRec = $dyeing_dw_list->TotalRecs;
}
$dyeing_dw_list->RecCnt = $dyeing_dw_list->StartRec - 1;
if ($dyeing_dw_list->Recordset && !$dyeing_dw_list->Recordset->EOF) {
	$dyeing_dw_list->Recordset->moveFirst();
	$selectLimit = $dyeing_dw_list->UseSelectLimit;
	if (!$selectLimit && $dyeing_dw_list->StartRec > 1)
		$dyeing_dw_list->Recordset->move($dyeing_dw_list->StartRec - 1);
} elseif (!$dyeing_dw->AllowAddDeleteRow && $dyeing_dw_list->StopRec == 0) {
	$dyeing_dw_list->StopRec = $dyeing_dw->GridAddRowCount;
}

// Initialize aggregate
$dyeing_dw->RowType = ROWTYPE_AGGREGATEINIT;
$dyeing_dw->resetAttributes();
$dyeing_dw_list->renderRow();
while ($dyeing_dw_list->RecCnt < $dyeing_dw_list->StopRec) {
	$dyeing_dw_list->RecCnt++;
	if ($dyeing_dw_list->RecCnt >= $dyeing_dw_list->StartRec) {
		$dyeing_dw_list->RowCnt++;

		// Set up key count
		$dyeing_dw_list->KeyCount = $dyeing_dw_list->RowIndex;

		// Init row class and style
		$dyeing_dw->resetAttributes();
		$dyeing_dw->CssClass = "";
		if ($dyeing_dw->isGridAdd()) {
		} else {
			$dyeing_dw_list->loadRowValues($dyeing_dw_list->Recordset); // Load row values
		}
		$dyeing_dw->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$dyeing_dw->RowAttrs = array_merge($dyeing_dw->RowAttrs, array('data-rowindex'=>$dyeing_dw_list->RowCnt, 'id'=>'r' . $dyeing_dw_list->RowCnt . '_dyeing_dw', 'data-rowtype'=>$dyeing_dw->RowType));

		// Render row
		$dyeing_dw_list->renderRow();

		// Render list options
		$dyeing_dw_list->renderListOptions();
?>
	<tr<?php echo $dyeing_dw->rowAttributes() ?>>
<?php

// Render list options (body, left)
$dyeing_dw_list->ListOptions->render("body", "left", $dyeing_dw_list->RowCnt);
?>
	<?php if ($dyeing_dw->id->Visible) { // id ?>
		<td data-name="id"<?php echo $dyeing_dw->id->cellAttributes() ?>>
<span id="el<?php echo $dyeing_dw_list->RowCnt ?>_dyeing_dw_id" class="dyeing_dw_id">
<span<?php echo $dyeing_dw->id->viewAttributes() ?>>
<?php echo $dyeing_dw->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_dw->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $dyeing_dw->dated->cellAttributes() ?>>
<span id="el<?php echo $dyeing_dw_list->RowCnt ?>_dyeing_dw_dated" class="dyeing_dw_dated">
<span<?php echo $dyeing_dw->dated->viewAttributes() ?>>
<?php if ((!EmptyString($dyeing_dw->dated->getViewValue())) && $dyeing_dw->dated->linkAttributes() <> "") { ?>
<a<?php echo $dyeing_dw->dated->linkAttributes() ?>><?php echo $dyeing_dw->dated->getViewValue() ?></a>
<?php } else { ?>
<?php echo $dyeing_dw->dated->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_dw->product->Visible) { // product ?>
		<td data-name="product"<?php echo $dyeing_dw->product->cellAttributes() ?>>
<span id="el<?php echo $dyeing_dw_list->RowCnt ?>_dyeing_dw_product" class="dyeing_dw_product">
<span<?php echo $dyeing_dw->product->viewAttributes() ?>>
<?php if ((!EmptyString($dyeing_dw->product->getViewValue())) && $dyeing_dw->product->linkAttributes() <> "") { ?>
<a<?php echo $dyeing_dw->product->linkAttributes() ?>><?php echo $dyeing_dw->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $dyeing_dw->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_dw->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $dyeing_dw->rid->cellAttributes() ?>>
<span id="el<?php echo $dyeing_dw_list->RowCnt ?>_dyeing_dw_rid" class="dyeing_dw_rid">
<span<?php echo $dyeing_dw->rid->viewAttributes() ?>>
<?php if ((!EmptyString($dyeing_dw->rid->getViewValue())) && $dyeing_dw->rid->linkAttributes() <> "") { ?>
<a<?php echo $dyeing_dw->rid->linkAttributes() ?>><?php echo $dyeing_dw->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $dyeing_dw->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_dw->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $dyeing_dw->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $dyeing_dw_list->RowCnt ?>_dyeing_dw_tmp_lot" class="dyeing_dw_tmp_lot">
<span<?php echo $dyeing_dw->tmp_lot->viewAttributes() ?>>
<?php if ((!EmptyString($dyeing_dw->tmp_lot->getViewValue())) && $dyeing_dw->tmp_lot->linkAttributes() <> "") { ?>
<a<?php echo $dyeing_dw->tmp_lot->linkAttributes() ?>><?php echo $dyeing_dw->tmp_lot->getViewValue() ?></a>
<?php } else { ?>
<?php echo $dyeing_dw->tmp_lot->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_dw->dyeing_type->Visible) { // dyeing_type ?>
		<td data-name="dyeing_type"<?php echo $dyeing_dw->dyeing_type->cellAttributes() ?>>
<span id="el<?php echo $dyeing_dw_list->RowCnt ?>_dyeing_dw_dyeing_type" class="dyeing_dw_dyeing_type">
<span<?php echo $dyeing_dw->dyeing_type->viewAttributes() ?>>
<?php if ((!EmptyString($dyeing_dw->dyeing_type->getViewValue())) && $dyeing_dw->dyeing_type->linkAttributes() <> "") { ?>
<a<?php echo $dyeing_dw->dyeing_type->linkAttributes() ?>><?php echo $dyeing_dw->dyeing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $dyeing_dw->dyeing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_dw->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $dyeing_dw->IN->cellAttributes() ?>>
<span id="el<?php echo $dyeing_dw_list->RowCnt ?>_dyeing_dw_IN" class="dyeing_dw_IN">
<span<?php echo $dyeing_dw->IN->viewAttributes() ?>>
<?php echo $dyeing_dw->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_dw->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $dyeing_dw->packets->cellAttributes() ?>>
<span id="el<?php echo $dyeing_dw_list->RowCnt ?>_dyeing_dw_packets" class="dyeing_dw_packets">
<span<?php echo $dyeing_dw->packets->viewAttributes() ?>>
<?php echo $dyeing_dw->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_dw->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $dyeing_dw->packing_type->cellAttributes() ?>>
<span id="el<?php echo $dyeing_dw_list->RowCnt ?>_dyeing_dw_packing_type" class="dyeing_dw_packing_type">
<span<?php echo $dyeing_dw->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($dyeing_dw->packing_type->getViewValue())) && $dyeing_dw->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $dyeing_dw->packing_type->linkAttributes() ?>><?php echo $dyeing_dw->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $dyeing_dw->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_dw->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $dyeing_dw->godown->cellAttributes() ?>>
<span id="el<?php echo $dyeing_dw_list->RowCnt ?>_dyeing_dw_godown" class="dyeing_dw_godown">
<span<?php echo $dyeing_dw->godown->viewAttributes() ?>>
<?php if ((!EmptyString($dyeing_dw->godown->getViewValue())) && $dyeing_dw->godown->linkAttributes() <> "") { ?>
<a<?php echo $dyeing_dw->godown->linkAttributes() ?>><?php echo $dyeing_dw->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $dyeing_dw->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$dyeing_dw_list->ListOptions->render("body", "right", $dyeing_dw_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$dyeing_dw->isGridAdd())
		$dyeing_dw_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$dyeing_dw->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($dyeing_dw_list->Recordset)
	$dyeing_dw_list->Recordset->Close();
?>
<?php if (!$dyeing_dw->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$dyeing_dw->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($dyeing_dw_list->Pager)) $dyeing_dw_list->Pager = new PrevNextPager($dyeing_dw_list->StartRec, $dyeing_dw_list->DisplayRecs, $dyeing_dw_list->TotalRecs, $dyeing_dw_list->AutoHidePager) ?>
<?php if ($dyeing_dw_list->Pager->RecordCount > 0 && $dyeing_dw_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($dyeing_dw_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $dyeing_dw_list->pageUrl() ?>start=<?php echo $dyeing_dw_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($dyeing_dw_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $dyeing_dw_list->pageUrl() ?>start=<?php echo $dyeing_dw_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $dyeing_dw_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($dyeing_dw_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $dyeing_dw_list->pageUrl() ?>start=<?php echo $dyeing_dw_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($dyeing_dw_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $dyeing_dw_list->pageUrl() ?>start=<?php echo $dyeing_dw_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $dyeing_dw_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($dyeing_dw_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $dyeing_dw_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $dyeing_dw_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $dyeing_dw_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($dyeing_dw_list->TotalRecs > 0 && (!$dyeing_dw_list->AutoHidePageSizeSelector || $dyeing_dw_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="dyeing_dw">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($dyeing_dw_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($dyeing_dw_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($dyeing_dw_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($dyeing_dw_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($dyeing_dw_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($dyeing_dw->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $dyeing_dw_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($dyeing_dw_list->TotalRecs == 0 && !$dyeing_dw->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $dyeing_dw_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$dyeing_dw_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$dyeing_dw->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$dyeing_dw->isExport()) { ?>
<script>
ew.scrollableTable("gmp_dyeing_dw", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$dyeing_dw_list->terminate();
?>