<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$dyeing_table_list = new dyeing_table_list();

// Run the page
$dyeing_table_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$dyeing_table_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$dyeing_table->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fdyeing_tablelist = currentForm = new ew.Form("fdyeing_tablelist", "list");
fdyeing_tablelist.formKeyCountName = '<?php echo $dyeing_table_list->FormKeyCountName ?>';

// Form_CustomValidate event
fdyeing_tablelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fdyeing_tablelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fdyeing_tablelist.lists["x_rid"] = <?php echo $dyeing_table_list->rid->Lookup->toClientList() ?>;
fdyeing_tablelist.lists["x_rid"].options = <?php echo JsonEncode($dyeing_table_list->rid->lookupOptions()) ?>;
fdyeing_tablelist.lists["x_product"] = <?php echo $dyeing_table_list->product->Lookup->toClientList() ?>;
fdyeing_tablelist.lists["x_product"].options = <?php echo JsonEncode($dyeing_table_list->product->lookupOptions()) ?>;
fdyeing_tablelist.lists["x_dyeing_type"] = <?php echo $dyeing_table_list->dyeing_type->Lookup->toClientList() ?>;
fdyeing_tablelist.lists["x_dyeing_type"].options = <?php echo JsonEncode($dyeing_table_list->dyeing_type->lookupOptions()) ?>;
fdyeing_tablelist.lists["x_packing_type"] = <?php echo $dyeing_table_list->packing_type->Lookup->toClientList() ?>;
fdyeing_tablelist.lists["x_packing_type"].options = <?php echo JsonEncode($dyeing_table_list->packing_type->lookupOptions()) ?>;
fdyeing_tablelist.lists["x_quantity_avg_act"] = <?php echo $dyeing_table_list->quantity_avg_act->Lookup->toClientList() ?>;
fdyeing_tablelist.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($dyeing_table_list->quantity_avg_act->options(FALSE, TRUE)) ?>;
fdyeing_tablelist.lists["x_godown"] = <?php echo $dyeing_table_list->godown->Lookup->toClientList() ?>;
fdyeing_tablelist.lists["x_godown"].options = <?php echo JsonEncode($dyeing_table_list->godown->lookupOptions()) ?>;
fdyeing_tablelist.lists["x_employee_id[]"] = <?php echo $dyeing_table_list->employee_id->Lookup->toClientList() ?>;
fdyeing_tablelist.lists["x_employee_id[]"].options = <?php echo JsonEncode($dyeing_table_list->employee_id->lookupOptions()) ?>;
fdyeing_tablelist.lists["x_next_process"] = <?php echo $dyeing_table_list->next_process->Lookup->toClientList() ?>;
fdyeing_tablelist.lists["x_next_process"].options = <?php echo JsonEncode($dyeing_table_list->next_process->lookupOptions()) ?>;
fdyeing_tablelist.lists["x_next_godown"] = <?php echo $dyeing_table_list->next_godown->Lookup->toClientList() ?>;
fdyeing_tablelist.lists["x_next_godown"].options = <?php echo JsonEncode($dyeing_table_list->next_godown->lookupOptions()) ?>;
fdyeing_tablelist.lists["x_operator"] = <?php echo $dyeing_table_list->operator->Lookup->toClientList() ?>;
fdyeing_tablelist.lists["x_operator"].options = <?php echo JsonEncode($dyeing_table_list->operator->lookupOptions()) ?>;

// Form object for search
var fdyeing_tablelistsrch = currentSearchForm = new ew.Form("fdyeing_tablelistsrch");

// Filters
fdyeing_tablelistsrch.filterList = <?php echo $dyeing_table_list->getFilterList() ?>;

// Init search panel as collapsed
fdyeing_tablelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$dyeing_table->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($dyeing_table_list->TotalRecs > 0 && $dyeing_table_list->ExportOptions->visible()) { ?>
<?php $dyeing_table_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($dyeing_table_list->ImportOptions->visible()) { ?>
<?php $dyeing_table_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($dyeing_table_list->SearchOptions->visible()) { ?>
<?php $dyeing_table_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($dyeing_table_list->FilterOptions->visible()) { ?>
<?php $dyeing_table_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$dyeing_table_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$dyeing_table->isExport() && !$dyeing_table->CurrentAction) { ?>
<form name="fdyeing_tablelistsrch" id="fdyeing_tablelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($dyeing_table_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fdyeing_tablelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="dyeing_table">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($dyeing_table_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($dyeing_table_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $dyeing_table_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($dyeing_table_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($dyeing_table_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($dyeing_table_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($dyeing_table_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $dyeing_table_list->showPageHeader(); ?>
<?php
$dyeing_table_list->showMessage();
?>
<?php if ($dyeing_table_list->TotalRecs > 0 || $dyeing_table->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($dyeing_table_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> dyeing_table">
<?php if (!$dyeing_table->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$dyeing_table->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($dyeing_table_list->Pager)) $dyeing_table_list->Pager = new PrevNextPager($dyeing_table_list->StartRec, $dyeing_table_list->DisplayRecs, $dyeing_table_list->TotalRecs, $dyeing_table_list->AutoHidePager) ?>
<?php if ($dyeing_table_list->Pager->RecordCount > 0 && $dyeing_table_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($dyeing_table_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $dyeing_table_list->pageUrl() ?>start=<?php echo $dyeing_table_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($dyeing_table_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $dyeing_table_list->pageUrl() ?>start=<?php echo $dyeing_table_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $dyeing_table_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($dyeing_table_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $dyeing_table_list->pageUrl() ?>start=<?php echo $dyeing_table_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($dyeing_table_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $dyeing_table_list->pageUrl() ?>start=<?php echo $dyeing_table_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $dyeing_table_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($dyeing_table_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $dyeing_table_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $dyeing_table_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $dyeing_table_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($dyeing_table_list->TotalRecs > 0 && (!$dyeing_table_list->AutoHidePageSizeSelector || $dyeing_table_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="dyeing_table">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($dyeing_table_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($dyeing_table_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($dyeing_table_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($dyeing_table_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($dyeing_table_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($dyeing_table->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $dyeing_table_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fdyeing_tablelist" id="fdyeing_tablelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($dyeing_table_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $dyeing_table_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="dyeing_table">
<div id="gmp_dyeing_table" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($dyeing_table_list->TotalRecs > 0 || $dyeing_table->isGridEdit()) { ?>
<table id="tbl_dyeing_tablelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$dyeing_table_list->RowType = ROWTYPE_HEADER;

// Render list options
$dyeing_table_list->renderListOptions();

// Render list options (header, left)
$dyeing_table_list->ListOptions->render("header", "left");
?>
<?php if ($dyeing_table->id->Visible) { // id ?>
	<?php if ($dyeing_table->sortUrl($dyeing_table->id) == "") { ?>
		<th data-name="id" class="<?php echo $dyeing_table->id->headerCellClass() ?>"><div id="elh_dyeing_table_id" class="dyeing_table_id"><div class="ew-table-header-caption"><?php echo $dyeing_table->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $dyeing_table->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_table->SortUrl($dyeing_table->id) ?>',2);"><div id="elh_dyeing_table_id" class="dyeing_table_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_table->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_table->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_table->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_table->rid->Visible) { // rid ?>
	<?php if ($dyeing_table->sortUrl($dyeing_table->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $dyeing_table->rid->headerCellClass() ?>"><div id="elh_dyeing_table_rid" class="dyeing_table_rid"><div class="ew-table-header-caption"><?php echo $dyeing_table->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $dyeing_table->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_table->SortUrl($dyeing_table->rid) ?>',2);"><div id="elh_dyeing_table_rid" class="dyeing_table_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_table->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_table->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_table->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_table->product->Visible) { // product ?>
	<?php if ($dyeing_table->sortUrl($dyeing_table->product) == "") { ?>
		<th data-name="product" class="<?php echo $dyeing_table->product->headerCellClass() ?>"><div id="elh_dyeing_table_product" class="dyeing_table_product"><div class="ew-table-header-caption"><?php echo $dyeing_table->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $dyeing_table->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_table->SortUrl($dyeing_table->product) ?>',2);"><div id="elh_dyeing_table_product" class="dyeing_table_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_table->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_table->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_table->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_table->dyeing_type->Visible) { // dyeing_type ?>
	<?php if ($dyeing_table->sortUrl($dyeing_table->dyeing_type) == "") { ?>
		<th data-name="dyeing_type" class="<?php echo $dyeing_table->dyeing_type->headerCellClass() ?>"><div id="elh_dyeing_table_dyeing_type" class="dyeing_table_dyeing_type"><div class="ew-table-header-caption"><?php echo $dyeing_table->dyeing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dyeing_type" class="<?php echo $dyeing_table->dyeing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_table->SortUrl($dyeing_table->dyeing_type) ?>',2);"><div id="elh_dyeing_table_dyeing_type" class="dyeing_table_dyeing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_table->dyeing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_table->dyeing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_table->dyeing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_table->packing_type->Visible) { // packing_type ?>
	<?php if ($dyeing_table->sortUrl($dyeing_table->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $dyeing_table->packing_type->headerCellClass() ?>"><div id="elh_dyeing_table_packing_type" class="dyeing_table_packing_type"><div class="ew-table-header-caption"><?php echo $dyeing_table->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $dyeing_table->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_table->SortUrl($dyeing_table->packing_type) ?>',2);"><div id="elh_dyeing_table_packing_type" class="dyeing_table_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_table->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_table->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_table->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_table->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<?php if ($dyeing_table->sortUrl($dyeing_table->quantity_avg_act) == "") { ?>
		<th data-name="quantity_avg_act" class="<?php echo $dyeing_table->quantity_avg_act->headerCellClass() ?>"><div id="elh_dyeing_table_quantity_avg_act" class="dyeing_table_quantity_avg_act"><div class="ew-table-header-caption"><?php echo $dyeing_table->quantity_avg_act->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity_avg_act" class="<?php echo $dyeing_table->quantity_avg_act->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_table->SortUrl($dyeing_table->quantity_avg_act) ?>',2);"><div id="elh_dyeing_table_quantity_avg_act" class="dyeing_table_quantity_avg_act">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_table->quantity_avg_act->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_table->quantity_avg_act->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_table->quantity_avg_act->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_table->packets->Visible) { // packets ?>
	<?php if ($dyeing_table->sortUrl($dyeing_table->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $dyeing_table->packets->headerCellClass() ?>"><div id="elh_dyeing_table_packets" class="dyeing_table_packets"><div class="ew-table-header-caption"><?php echo $dyeing_table->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $dyeing_table->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_table->SortUrl($dyeing_table->packets) ?>',2);"><div id="elh_dyeing_table_packets" class="dyeing_table_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_table->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_table->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_table->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_table->quantity->Visible) { // quantity ?>
	<?php if ($dyeing_table->sortUrl($dyeing_table->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $dyeing_table->quantity->headerCellClass() ?>"><div id="elh_dyeing_table_quantity" class="dyeing_table_quantity"><div class="ew-table-header-caption"><?php echo $dyeing_table->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $dyeing_table->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_table->SortUrl($dyeing_table->quantity) ?>',2);"><div id="elh_dyeing_table_quantity" class="dyeing_table_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_table->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_table->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_table->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_table->godown->Visible) { // godown ?>
	<?php if ($dyeing_table->sortUrl($dyeing_table->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $dyeing_table->godown->headerCellClass() ?>"><div id="elh_dyeing_table_godown" class="dyeing_table_godown"><div class="ew-table-header-caption"><?php echo $dyeing_table->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $dyeing_table->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_table->SortUrl($dyeing_table->godown) ?>',2);"><div id="elh_dyeing_table_godown" class="dyeing_table_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_table->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_table->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_table->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_table->dated->Visible) { // dated ?>
	<?php if ($dyeing_table->sortUrl($dyeing_table->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $dyeing_table->dated->headerCellClass() ?>"><div id="elh_dyeing_table_dated" class="dyeing_table_dated"><div class="ew-table-header-caption"><?php echo $dyeing_table->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $dyeing_table->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_table->SortUrl($dyeing_table->dated) ?>',2);"><div id="elh_dyeing_table_dated" class="dyeing_table_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_table->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_table->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_table->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_table->employee_id->Visible) { // employee_id ?>
	<?php if ($dyeing_table->sortUrl($dyeing_table->employee_id) == "") { ?>
		<th data-name="employee_id" class="<?php echo $dyeing_table->employee_id->headerCellClass() ?>"><div id="elh_dyeing_table_employee_id" class="dyeing_table_employee_id"><div class="ew-table-header-caption"><?php echo $dyeing_table->employee_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_id" class="<?php echo $dyeing_table->employee_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_table->SortUrl($dyeing_table->employee_id) ?>',2);"><div id="elh_dyeing_table_employee_id" class="dyeing_table_employee_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_table->employee_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_table->employee_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_table->employee_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_table->next_process->Visible) { // next_process ?>
	<?php if ($dyeing_table->sortUrl($dyeing_table->next_process) == "") { ?>
		<th data-name="next_process" class="<?php echo $dyeing_table->next_process->headerCellClass() ?>"><div id="elh_dyeing_table_next_process" class="dyeing_table_next_process"><div class="ew-table-header-caption"><?php echo $dyeing_table->next_process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="next_process" class="<?php echo $dyeing_table->next_process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_table->SortUrl($dyeing_table->next_process) ?>',2);"><div id="elh_dyeing_table_next_process" class="dyeing_table_next_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_table->next_process->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_table->next_process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_table->next_process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_table->next_godown->Visible) { // next_godown ?>
	<?php if ($dyeing_table->sortUrl($dyeing_table->next_godown) == "") { ?>
		<th data-name="next_godown" class="<?php echo $dyeing_table->next_godown->headerCellClass() ?>"><div id="elh_dyeing_table_next_godown" class="dyeing_table_next_godown"><div class="ew-table-header-caption"><?php echo $dyeing_table->next_godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="next_godown" class="<?php echo $dyeing_table->next_godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_table->SortUrl($dyeing_table->next_godown) ?>',2);"><div id="elh_dyeing_table_next_godown" class="dyeing_table_next_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_table->next_godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_table->next_godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_table->next_godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_table->remarks->Visible) { // remarks ?>
	<?php if ($dyeing_table->sortUrl($dyeing_table->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $dyeing_table->remarks->headerCellClass() ?>"><div id="elh_dyeing_table_remarks" class="dyeing_table_remarks"><div class="ew-table-header-caption"><?php echo $dyeing_table->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $dyeing_table->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_table->SortUrl($dyeing_table->remarks) ?>',2);"><div id="elh_dyeing_table_remarks" class="dyeing_table_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_table->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($dyeing_table->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_table->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_table->operator->Visible) { // operator ?>
	<?php if ($dyeing_table->sortUrl($dyeing_table->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $dyeing_table->operator->headerCellClass() ?>"><div id="elh_dyeing_table_operator" class="dyeing_table_operator"><div class="ew-table-header-caption"><?php echo $dyeing_table->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $dyeing_table->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_table->SortUrl($dyeing_table->operator) ?>',2);"><div id="elh_dyeing_table_operator" class="dyeing_table_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_table->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_table->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_table->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($dyeing_table->datetime->Visible) { // datetime ?>
	<?php if ($dyeing_table->sortUrl($dyeing_table->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $dyeing_table->datetime->headerCellClass() ?>"><div id="elh_dyeing_table_datetime" class="dyeing_table_datetime"><div class="ew-table-header-caption"><?php echo $dyeing_table->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $dyeing_table->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $dyeing_table->SortUrl($dyeing_table->datetime) ?>',2);"><div id="elh_dyeing_table_datetime" class="dyeing_table_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $dyeing_table->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($dyeing_table->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($dyeing_table->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$dyeing_table_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($dyeing_table->ExportAll && $dyeing_table->isExport()) {
	$dyeing_table_list->StopRec = $dyeing_table_list->TotalRecs;
} else {

	// Set the last record to display
	if ($dyeing_table_list->TotalRecs > $dyeing_table_list->StartRec + $dyeing_table_list->DisplayRecs - 1)
		$dyeing_table_list->StopRec = $dyeing_table_list->StartRec + $dyeing_table_list->DisplayRecs - 1;
	else
		$dyeing_table_list->StopRec = $dyeing_table_list->TotalRecs;
}
$dyeing_table_list->RecCnt = $dyeing_table_list->StartRec - 1;
if ($dyeing_table_list->Recordset && !$dyeing_table_list->Recordset->EOF) {
	$dyeing_table_list->Recordset->moveFirst();
	$selectLimit = $dyeing_table_list->UseSelectLimit;
	if (!$selectLimit && $dyeing_table_list->StartRec > 1)
		$dyeing_table_list->Recordset->move($dyeing_table_list->StartRec - 1);
} elseif (!$dyeing_table->AllowAddDeleteRow && $dyeing_table_list->StopRec == 0) {
	$dyeing_table_list->StopRec = $dyeing_table->GridAddRowCount;
}

// Initialize aggregate
$dyeing_table->RowType = ROWTYPE_AGGREGATEINIT;
$dyeing_table->resetAttributes();
$dyeing_table_list->renderRow();
while ($dyeing_table_list->RecCnt < $dyeing_table_list->StopRec) {
	$dyeing_table_list->RecCnt++;
	if ($dyeing_table_list->RecCnt >= $dyeing_table_list->StartRec) {
		$dyeing_table_list->RowCnt++;

		// Set up key count
		$dyeing_table_list->KeyCount = $dyeing_table_list->RowIndex;

		// Init row class and style
		$dyeing_table->resetAttributes();
		$dyeing_table->CssClass = "";
		if ($dyeing_table->isGridAdd()) {
		} else {
			$dyeing_table_list->loadRowValues($dyeing_table_list->Recordset); // Load row values
		}
		$dyeing_table->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$dyeing_table->RowAttrs = array_merge($dyeing_table->RowAttrs, array('data-rowindex'=>$dyeing_table_list->RowCnt, 'id'=>'r' . $dyeing_table_list->RowCnt . '_dyeing_table', 'data-rowtype'=>$dyeing_table->RowType));

		// Render row
		$dyeing_table_list->renderRow();

		// Render list options
		$dyeing_table_list->renderListOptions();
?>
	<tr<?php echo $dyeing_table->rowAttributes() ?>>
<?php

// Render list options (body, left)
$dyeing_table_list->ListOptions->render("body", "left", $dyeing_table_list->RowCnt);
?>
	<?php if ($dyeing_table->id->Visible) { // id ?>
		<td data-name="id"<?php echo $dyeing_table->id->cellAttributes() ?>>
<span id="el<?php echo $dyeing_table_list->RowCnt ?>_dyeing_table_id" class="dyeing_table_id">
<span<?php echo $dyeing_table->id->viewAttributes() ?>>
<?php echo $dyeing_table->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_table->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $dyeing_table->rid->cellAttributes() ?>>
<span id="el<?php echo $dyeing_table_list->RowCnt ?>_dyeing_table_rid" class="dyeing_table_rid">
<span<?php echo $dyeing_table->rid->viewAttributes() ?>>
<?php if ((!EmptyString($dyeing_table->rid->getViewValue())) && $dyeing_table->rid->linkAttributes() <> "") { ?>
<a<?php echo $dyeing_table->rid->linkAttributes() ?>><?php echo $dyeing_table->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $dyeing_table->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_table->product->Visible) { // product ?>
		<td data-name="product"<?php echo $dyeing_table->product->cellAttributes() ?>>
<span id="el<?php echo $dyeing_table_list->RowCnt ?>_dyeing_table_product" class="dyeing_table_product">
<span<?php echo $dyeing_table->product->viewAttributes() ?>>
<?php if ((!EmptyString($dyeing_table->product->getViewValue())) && $dyeing_table->product->linkAttributes() <> "") { ?>
<a<?php echo $dyeing_table->product->linkAttributes() ?>><?php echo $dyeing_table->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $dyeing_table->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_table->dyeing_type->Visible) { // dyeing_type ?>
		<td data-name="dyeing_type"<?php echo $dyeing_table->dyeing_type->cellAttributes() ?>>
<span id="el<?php echo $dyeing_table_list->RowCnt ?>_dyeing_table_dyeing_type" class="dyeing_table_dyeing_type">
<span<?php echo $dyeing_table->dyeing_type->viewAttributes() ?>>
<?php echo $dyeing_table->dyeing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_table->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $dyeing_table->packing_type->cellAttributes() ?>>
<span id="el<?php echo $dyeing_table_list->RowCnt ?>_dyeing_table_packing_type" class="dyeing_table_packing_type">
<span<?php echo $dyeing_table->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($dyeing_table->packing_type->getViewValue())) && $dyeing_table->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $dyeing_table->packing_type->linkAttributes() ?>><?php echo $dyeing_table->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $dyeing_table->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_table->quantity_avg_act->Visible) { // quantity_avg_act ?>
		<td data-name="quantity_avg_act"<?php echo $dyeing_table->quantity_avg_act->cellAttributes() ?>>
<span id="el<?php echo $dyeing_table_list->RowCnt ?>_dyeing_table_quantity_avg_act" class="dyeing_table_quantity_avg_act">
<span<?php echo $dyeing_table->quantity_avg_act->viewAttributes() ?>>
<?php echo $dyeing_table->quantity_avg_act->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_table->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $dyeing_table->packets->cellAttributes() ?>>
<span id="el<?php echo $dyeing_table_list->RowCnt ?>_dyeing_table_packets" class="dyeing_table_packets">
<span<?php echo $dyeing_table->packets->viewAttributes() ?>>
<?php echo $dyeing_table->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_table->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $dyeing_table->quantity->cellAttributes() ?>>
<span id="el<?php echo $dyeing_table_list->RowCnt ?>_dyeing_table_quantity" class="dyeing_table_quantity">
<span<?php echo $dyeing_table->quantity->viewAttributes() ?>>
<?php echo $dyeing_table->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_table->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $dyeing_table->godown->cellAttributes() ?>>
<span id="el<?php echo $dyeing_table_list->RowCnt ?>_dyeing_table_godown" class="dyeing_table_godown">
<span<?php echo $dyeing_table->godown->viewAttributes() ?>>
<?php if ((!EmptyString($dyeing_table->godown->getViewValue())) && $dyeing_table->godown->linkAttributes() <> "") { ?>
<a<?php echo $dyeing_table->godown->linkAttributes() ?>><?php echo $dyeing_table->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $dyeing_table->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_table->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $dyeing_table->dated->cellAttributes() ?>>
<span id="el<?php echo $dyeing_table_list->RowCnt ?>_dyeing_table_dated" class="dyeing_table_dated">
<span<?php echo $dyeing_table->dated->viewAttributes() ?>>
<?php echo $dyeing_table->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_table->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id"<?php echo $dyeing_table->employee_id->cellAttributes() ?>>
<span id="el<?php echo $dyeing_table_list->RowCnt ?>_dyeing_table_employee_id" class="dyeing_table_employee_id">
<span<?php echo $dyeing_table->employee_id->viewAttributes() ?>>
<?php if ((!EmptyString($dyeing_table->employee_id->getViewValue())) && $dyeing_table->employee_id->linkAttributes() <> "") { ?>
<a<?php echo $dyeing_table->employee_id->linkAttributes() ?>><?php echo $dyeing_table->employee_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $dyeing_table->employee_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_table->next_process->Visible) { // next_process ?>
		<td data-name="next_process"<?php echo $dyeing_table->next_process->cellAttributes() ?>>
<span id="el<?php echo $dyeing_table_list->RowCnt ?>_dyeing_table_next_process" class="dyeing_table_next_process">
<span<?php echo $dyeing_table->next_process->viewAttributes() ?>>
<?php if ((!EmptyString($dyeing_table->next_process->getViewValue())) && $dyeing_table->next_process->linkAttributes() <> "") { ?>
<a<?php echo $dyeing_table->next_process->linkAttributes() ?>><?php echo $dyeing_table->next_process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $dyeing_table->next_process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_table->next_godown->Visible) { // next_godown ?>
		<td data-name="next_godown"<?php echo $dyeing_table->next_godown->cellAttributes() ?>>
<span id="el<?php echo $dyeing_table_list->RowCnt ?>_dyeing_table_next_godown" class="dyeing_table_next_godown">
<span<?php echo $dyeing_table->next_godown->viewAttributes() ?>>
<?php echo $dyeing_table->next_godown->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_table->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $dyeing_table->remarks->cellAttributes() ?>>
<span id="el<?php echo $dyeing_table_list->RowCnt ?>_dyeing_table_remarks" class="dyeing_table_remarks">
<span<?php echo $dyeing_table->remarks->viewAttributes() ?>>
<?php echo $dyeing_table->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_table->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $dyeing_table->operator->cellAttributes() ?>>
<span id="el<?php echo $dyeing_table_list->RowCnt ?>_dyeing_table_operator" class="dyeing_table_operator">
<span<?php echo $dyeing_table->operator->viewAttributes() ?>>
<?php echo $dyeing_table->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($dyeing_table->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $dyeing_table->datetime->cellAttributes() ?>>
<span id="el<?php echo $dyeing_table_list->RowCnt ?>_dyeing_table_datetime" class="dyeing_table_datetime">
<span<?php echo $dyeing_table->datetime->viewAttributes() ?>>
<?php echo $dyeing_table->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$dyeing_table_list->ListOptions->render("body", "right", $dyeing_table_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$dyeing_table->isGridAdd())
		$dyeing_table_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$dyeing_table->RowType = ROWTYPE_AGGREGATE;
$dyeing_table->resetAttributes();
$dyeing_table_list->renderRow();
?>
<?php if ($dyeing_table_list->TotalRecs > 0 && !$dyeing_table->isGridAdd() && !$dyeing_table->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$dyeing_table_list->renderListOptions();

// Render list options (footer, left)
$dyeing_table_list->ListOptions->render("footer", "left");
?>
	<?php if ($dyeing_table->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $dyeing_table->id->footerCellClass() ?>"><span id="elf_dyeing_table_id" class="dyeing_table_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($dyeing_table->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $dyeing_table->rid->footerCellClass() ?>"><span id="elf_dyeing_table_rid" class="dyeing_table_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($dyeing_table->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $dyeing_table->product->footerCellClass() ?>"><span id="elf_dyeing_table_product" class="dyeing_table_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($dyeing_table->dyeing_type->Visible) { // dyeing_type ?>
		<td data-name="dyeing_type" class="<?php echo $dyeing_table->dyeing_type->footerCellClass() ?>"><span id="elf_dyeing_table_dyeing_type" class="dyeing_table_dyeing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($dyeing_table->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $dyeing_table->packing_type->footerCellClass() ?>"><span id="elf_dyeing_table_packing_type" class="dyeing_table_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($dyeing_table->quantity_avg_act->Visible) { // quantity_avg_act ?>
		<td data-name="quantity_avg_act" class="<?php echo $dyeing_table->quantity_avg_act->footerCellClass() ?>"><span id="elf_dyeing_table_quantity_avg_act" class="dyeing_table_quantity_avg_act">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($dyeing_table->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $dyeing_table->packets->footerCellClass() ?>"><span id="elf_dyeing_table_packets" class="dyeing_table_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($dyeing_table->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $dyeing_table->quantity->footerCellClass() ?>"><span id="elf_dyeing_table_quantity" class="dyeing_table_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $dyeing_table->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($dyeing_table->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $dyeing_table->godown->footerCellClass() ?>"><span id="elf_dyeing_table_godown" class="dyeing_table_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($dyeing_table->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $dyeing_table->dated->footerCellClass() ?>"><span id="elf_dyeing_table_dated" class="dyeing_table_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($dyeing_table->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id" class="<?php echo $dyeing_table->employee_id->footerCellClass() ?>"><span id="elf_dyeing_table_employee_id" class="dyeing_table_employee_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($dyeing_table->next_process->Visible) { // next_process ?>
		<td data-name="next_process" class="<?php echo $dyeing_table->next_process->footerCellClass() ?>"><span id="elf_dyeing_table_next_process" class="dyeing_table_next_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($dyeing_table->next_godown->Visible) { // next_godown ?>
		<td data-name="next_godown" class="<?php echo $dyeing_table->next_godown->footerCellClass() ?>"><span id="elf_dyeing_table_next_godown" class="dyeing_table_next_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($dyeing_table->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $dyeing_table->remarks->footerCellClass() ?>"><span id="elf_dyeing_table_remarks" class="dyeing_table_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($dyeing_table->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $dyeing_table->operator->footerCellClass() ?>"><span id="elf_dyeing_table_operator" class="dyeing_table_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($dyeing_table->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $dyeing_table->datetime->footerCellClass() ?>"><span id="elf_dyeing_table_datetime" class="dyeing_table_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$dyeing_table_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$dyeing_table->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($dyeing_table_list->Recordset)
	$dyeing_table_list->Recordset->Close();
?>
<?php if (!$dyeing_table->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$dyeing_table->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($dyeing_table_list->Pager)) $dyeing_table_list->Pager = new PrevNextPager($dyeing_table_list->StartRec, $dyeing_table_list->DisplayRecs, $dyeing_table_list->TotalRecs, $dyeing_table_list->AutoHidePager) ?>
<?php if ($dyeing_table_list->Pager->RecordCount > 0 && $dyeing_table_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($dyeing_table_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $dyeing_table_list->pageUrl() ?>start=<?php echo $dyeing_table_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($dyeing_table_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $dyeing_table_list->pageUrl() ?>start=<?php echo $dyeing_table_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $dyeing_table_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($dyeing_table_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $dyeing_table_list->pageUrl() ?>start=<?php echo $dyeing_table_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($dyeing_table_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $dyeing_table_list->pageUrl() ?>start=<?php echo $dyeing_table_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $dyeing_table_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($dyeing_table_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $dyeing_table_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $dyeing_table_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $dyeing_table_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($dyeing_table_list->TotalRecs > 0 && (!$dyeing_table_list->AutoHidePageSizeSelector || $dyeing_table_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="dyeing_table">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($dyeing_table_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($dyeing_table_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($dyeing_table_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($dyeing_table_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($dyeing_table_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($dyeing_table->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $dyeing_table_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($dyeing_table_list->TotalRecs == 0 && !$dyeing_table->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $dyeing_table_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$dyeing_table_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$dyeing_table->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$dyeing_table->isExport()) { ?>
<script>
ew.scrollableTable("gmp_dyeing_table", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$dyeing_table_list->terminate();
?>