<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 
?>
<?php include_once "autoload.php" ?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$emi_calculator = new emi_calculator();

// Run the page
$emi_calculator->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();
?>
<?php include_once "header.php" ?>
<?php
$html = '';
isset($_POST['la']) ? $la = $_POST['la'] : (isset($_GET['la']) ? $la = $_GET['la'] : $la = 100000);
isset($_POST['lp']) ? $lp = $_POST['lp'] : (isset($_GET['lp']) ? $lp = $_GET['lp'] : $lp = 365);
isset($_POST['ir']) ? $ir = $_POST['ir'] : (isset($_GET['ir']) ? $ir = $_GET['ir'] : $ir = 20);
isset($_POST['pt']) ? $pt = $_POST['pt'] : (isset($_GET['pt']) ? $pt = $_GET['pt'] : $pt = 30);
isset($_POST['account']) ? $account = $_POST['account'] : $account = 0;
isset($_POST['account']) ? $desc = $la . '_' . $lp . '_' . $ir . '_' . $pt : $desc = '0';
echo $lr;

$html .= ' 
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.2.0/chart.min.js">
</script>
<form method="POST">
	<div class="container">
		<div class="header">
			<h1 style="color: #6258A8">Loan EMI Calculator</h1>
			<button>
				<i class="bi bi-list"></i>
			</button>
		</div>
			
		<div class="sub-container">
			<div class="view">
				<div class="details">
					<div>
						<div class="detail">
							<p style="color: #9088D2">Amount</p>
							<p id="loan-amt-text" style="color: #6258A8"></p>
						</div>
						<input type="range" name="la" id="loan-amount" min="0" max="2000000" step="1000" value="'.$la.'">
					</div>
					<div>
						<div class="detail">
							<p style="color: #9088D2">Length</p>
							<p id="loan-period-text" style="color: #6258A8"></p>
						</div>
						<input type="range" name="lp" id="loan-period" min="1" max="3650" step="1" value="'.$lp.'">
					</div>
					<div>
						<div class="detail">
							<p style="color: #9088D2">% Interest</p>
							<p id="interest-rate-text" style="color: #6258A8"></p>
						</div>
						<input type="range" name="ir" id="interest-rate" min="1" max="200" step="0.1" value="'.$ir.'">
					</div>
					<div>
						<div class="detail">
							<p style="color: #9088D2">Payment Tenure (Days)</p>
							<p id="payment-tenure-text" style="color: #6258A8"></p>
						</div>
						<input type="range" name="pt" id="payment-tenure" min="1" max="90" step="1" value="'.$pt.'">
					</div>
				</div><br><br>
				<label for="account">Account ID:</label><br>
			        <input type="text" name="account" id="account" required><br><br>
			        <input type="submit" name="submit" value="Submit"><br><br>
				<div class="footer">
					<p id="price-container"><span id="price">0</span>/mo</p>
				</div>			
			</div>
			<div class="breakup">
				<canvas id="pieChart"></canvas>
			</div>
		</div>

		<div>
			<div class="loan-details">
				<div class="chart-details">
					<p style="color: #9088D2">Principal</p>
					<p id="cp" style="color: #130F31; font-size: 17px;"></p>
				</div>
			<div class="chart-details">
				<p style="color: #9088D2">Total EMI\'s</p>
				<p id="cemi" style="color: #130F31; font-size: 17px;"></p>
			</div>
			<div class="chart-details">
				<p style="color: #9088D2">Interest</p>
				<p id="ci" style="color: #130F31; font-size: 17px;"></p>
			</div>
			<div class="chart-details">
				<p style="color: #9088D2">Total Payable</p>
				<p id="ct" style="color: #130F31; font-size: 17px;"></p>
			</div>
		</div>
		<!--
		<div>
			<canvas id="lineChart" height="200px" width="100%"></canvas>
		</div>
		-->
		<div class="chart-details">
			<p style="color: #9088D2">Interest Calculation Table</p>
			<p id="Table" style="color: #130F31; font-size: 12px;"></p>
		</div>
	</div>	
</form>	';
echo $html;
?>	
<style>
body {
  font-family: "Open Sans", sans-serif;
  font-size: 15px;
  height: 100%;
  width: 100%;
  justify-content: center;
  align-items: center;
  background-color: #bab5e3;
}

.container {
  height: auto;
  width: 100%;
  border-radius: 20px;
  padding: 20px;
  margin: 50px 0;
  background-image: linear-gradient(to bottom left, #e4dfec, white, white);
}
.sub-container {
  display: flex;
  width: 100%;
  gap: 0px;
  height: max-content;
}

.header {
  width: 100%;
  height: auto;
  display: flex;
  align-items: center;
  justify-content: space-between;
  margin-bottom: 30px;
}

.header button {
  height: max-content;
  width: max-content;
  padding: 10px;
  border: none;
  background-color: transparent;
  font-size: 35px;
  color: #9088d2;
}

.header button:hover {
  cursor: pointer;
}

.view,
.breakup {
  width: 100%;
}
.details input {
  width: 100%;
}

.detail {
  display: flex;
  justify-content: space-between;
}

.footer {
  display: flex;
  justify-content: space-between;
}

/*----- Styling the sliders ----*/
input[type="range"] {
  -webkit-appearance: none;
  margin: 10px 0;
  width: 100%;
}

input[type="range"]:focus {
  outline: none;
}

input[type="range"]::-webkit-slider-runnable-track {
  width: 100%;
  height: 6px;
  cursor: pointer;
  background: #9088d2;
  border-radius: 10px;
}

input[type="range"]::-webkit-slider-thumb {
  box-shadow: 2px 2px 5px #b3b3b3, -1px -1px 3px grey;
  border: 5px solid #ffffff;
  height: 20px;
  width: 20px;
  border-radius: 50%;
  background: #9088d2;
  cursor: pointer;
  margin-top: -6px;
  -webkit-appearance: none;
}

input[type="range"]:focus::-webkit-slider-runnable-track {
  background: #b3b3b3;
}

input[type="range"]::-moz-range-track {
  width: 100%;
  height: 6px;
  cursor: pointer;
  background: #9088d2;
  border-color: transparent;
  border-width: 16px 0;
  color: transparent;
  border-radius: 10px;
}

input[type="range"]::-moz-range-thumb {
  box-shadow: 2px 2px 5px #b3b3b3, -1px -1px 3px grey;
  border: 5px solid #ffffff;
  height: 20px;
  width: 20px;
  border-radius: 50%;
  background: #9088d2;
  cursor: pointer;
  margin-top: -6px;
}

input[type="range"]::-ms-track {
  width: 100%;
  height: 6px;
  cursor: pointer;
  background: #9088d2;
  border-color: transparent;
  border-width: 16px 0;
  color: transparent;
  border-radius: 10px;
}

input[type="range"]::-ms-fill-lower {
  background: #9088d2;
  border-radius: 5px;
}

input[type="range"]::-ms-fill-upper {
  background: #9088d2;
  border-radius: 5px;
}

input[type="range"]::-ms-thumb {
  box-shadow: 2px 2px 5px #b3b3b3, -1px -1px 3px grey;
  border: 5px solid #ffffff;
  height: 20px;
  width: 20px;
  border-radius: 50%;
  background: #9088d2;
  cursor: pointer;
  margin-top: -6px;
}

input[type="range"]:focus::-ms-fill-lower {
  background: #9088d2;
}

input[type="range"]:focus::-ms-fill-upper {
  background: #9088d2;
}

#price {
  color: #130f31;
  font-size: 25px;
}

.loan-details {
  width: 90%;
  display: flex;
  justify-content: space-between;
  gap: 30px;
}

#price-container {
  color: #9088d2;
  margin-top: 50px;
}

#price-container::before {
  content: "Monthly Payable:";
  font-size: 12px;
  display: block;
}
</style>

<script>
var P, R, N, T, pie, line, Tab, Balance, i, PD;
var loan_amt_slider = document.getElementById("loan-amount");
var int_rate_slider = document.getElementById("interest-rate");
var loan_period_slider = document.getElementById("loan-period");
var payment_tenure_slider = document.getElementById("payment-tenure");

// update loan amount
loan_amt_slider.addEventListener("input", (self) => {
  document.querySelector("#loan-amt-text").innerText =
	 "₹ " + parseInt(self.target.value).toLocaleString("en-US");
  P = parseFloat(self.target.value);
  displayDetails();
});

// update Rate of Interest
int_rate_slider.addEventListener("input", (self) => {
  document.querySelector("#interest-rate-text").innerText =
	self.target.value + "%";
  R = parseFloat(self.target.value);
  displayDetails();
});

// update loan period
loan_period_slider.addEventListener("input", (self) => {
  N = parseFloat(self.target.value);
  document.querySelector("#loan-period-text").innerText =
	self.target.value + " days OR "+ (N/365*12).toFixed(2) +" months";
  displayDetails();
});

// update payment tenure
payment_tenure_slider.addEventListener("input", (self) => {
  document.querySelector("#payment-tenure-text").innerText =
	self.target.value + " days";
  T = parseFloat(self.target.value);
  displayDetails();
});
// calculate total Interest payable
function calculateLoanDetails(p, r, emi) 
{
  /*
	p: principal
	r: rate of interest
	emi: monthly emi
  */
	let account = <?= $account ?>;
	let desc = <?= "'$desc'" ?>;
	let totalInterest = 0;
	let yearlyInterest = [];
	let yearPrincipal = [];
	let years = [];
	let year = 1;
	let [counter, principal, interes, i] = [0, 0, 0, 0];
	if (account > 0)
	{
		$.getJSON("apcajaxes.php?d_emitrs="+account);
	}
	Tab = '<table width="100%" border="1px" cellspacing="0" cellpadding="1" ><tbody><tr><th height ="10"  valign="top" style="text-align: left; font-size:14px; color:red">Sr. No.</th><th height ="10"  valign="top" style="text-align: left; font-size:14px; color:red">Principal</th><th height ="10"  valign="top" style="text-align: left; font-size:14px; color:red">EMI</th><th height ="10"  valign="top" style="text-align: left; font-size:14px; color:red">Interest Deposited</th><th height ="10"  valign="top" style="text-align: left; font-size:14px; color:red">Principal Deposited</th><th height ="10"  valign="top" style="text-align: left; font-size:14px; color:red">Balance</th></tr>';
	while (p > 0) 
	{
		PR = parseInt(p);
		let interest_a = p * parseFloat(r);
		let interest = interest_a.toFixed(0); 
		p = parseInt(p) - (parseInt(emi) - parseInt(interest));
		totalInterest += parseInt(interest);
		principal += parseFloat(emi) - interest;
		interes += interest;
		(PR < emi) ? emi = ((parseInt(PR))+(parseInt(interest))) : '';	
		Balance = (parseInt(PR))-(parseInt(emi))+(parseInt(interest));
		PD = emi - interest;

		i++;
		Tab += '<tr><th height ="10"  valign="top" style="text-align: left; font-size:14px;">'+i+'</th><th height ="10"  valign="top" style="text-align: left; font-size:12px">'+PR+'</th><th height ="10"  valign="top" style="text-align: left; font-size:12px">'+emi+'</th><th height ="10"  valign="top" style="text-align: left; font-size:12px">'+interest+'</th><th height ="10"  valign="top" style="text-align: left; font-size:12px">'+PD+'</th><th height ="10"  valign="top" style="text-align: left; font-size:12px">'+Balance+'</th></tr>';

		if (account > 0)
		{			$.getJSON("apcajaxes.php?emitrs="+account+"&i="+i+"&pr="+PR+"&emi="+emi+"&ir="+interest+"&pd="+PD+"&balance="+Balance+"&desc="+desc);
		}
	  
		if (++counter == 12) 
		{
		years.push(year++);
		yearlyInterest.push(parseInt(interes));
		yearPrincipal.push(parseInt(principal));
		counter = 0;
		}
	}
	Tab += '</tbody></table>'
	line.data.datasets[0].data = yearPrincipal;
	line.data.datasets[1].data = yearlyInterest;
	line.data.labels = years;
	return totalInterest;
}

// calculate details
function displayDetails() 
{
	let r = parseFloat(R) / 100 / 365 * T;
	let n = parseFloat((N/T).toFixed(2)) * 1;
	let num = parseFloat(P) * r * Math.pow(1 + r, n);
	let denom = Math.pow(1 + r, n) - 1;
	let emi = (parseFloat(num) / parseFloat(denom)).toFixed(0);

	let payabaleInterest = calculateLoanDetails(P, r, emi);

	let opts = '{style: "decimal", currency: "US"}';

	document.querySelector("#cp").innerText =
	"₹ " + parseFloat(P).toLocaleString("en-US", opts) ;

	document.querySelector("#cemi").innerText =
	"Total No. of EMI's : " + parseFloat(N/T).toLocaleString("en-US", opts) ;

	document.querySelector("#ci").innerText =
	"₹ " + parseFloat(payabaleInterest).toLocaleString("en-US", opts);

	document.querySelector("#ct").innerText =
	"₹ " + parseFloat(parseFloat(P) + parseFloat(payabaleInterest)).toLocaleString("en-US", opts);

	document.querySelector("#price").innerText =
	"₹ " + parseFloat(emi).toFixed(0);

	document.querySelector("#Table").innerHTML =
	Tab;

	pie.data.datasets[0].data[0] = P;
	pie.data.datasets[0].data[1] = payabaleInterest;
	pie.update();
	line.update();
}

// Initialize everything
function initialize() 
{
	document.querySelector("#loan-amt-text").innerText =
	"₹ " + parseInt(loan_amt_slider.value).toLocaleString("en-US");
	P = parseFloat(document.getElementById("loan-amount").value);

	document.querySelector("#interest-rate-text").innerText =
	int_rate_slider.value + "%";
	R = parseFloat(document.getElementById("interest-rate").value);

	document.querySelector("#loan-period-text").innerText =
	loan_period_slider.value + "days OR " +(loan_period_slider.value/365*12).toFixed(2) +" months" ;
	N = parseFloat(document.getElementById("loan-period").value);

	document.querySelector("#payment-tenure-text").innerText =
	payment_tenure_slider.value + " days";
	T = parseFloat(document.getElementById("payment-tenure").value);

	line = new Chart(document.getElementById("lineChart"), 
	{
		data: 
		{
		  datasets: 
		[
			{
				type: "line",
				label: "Yearly Principal paid",
				borderColor: "rgb(54, 162, 235)",
				data: []
			},
			{
				type: "line",
				label: "Yearly Interest paid",
				borderColor: "rgb(255, 99, 132)",
				data: []
			}
		],
		  labels: []
		},
		options: 
		{
			plugins: {
				title: {
					display: true,
					text: "Yearly Payment Breakdown"
				}
			},
			scales: 
			{
			x: 
			{
				title: {
					color: "grey",
					display: true,
					text: "Years Passed"
				}
			},
			y: {
				title: {
					color: "grey",
					display: true,
					text: "Money in Rs."
					}
				}
			}
		}
	});
  
	pie = new Chart(document.getElementById("pieChart"), 
	{
		type: "pie",
		data: 
		{
			labels: ["Principal", "Interest"],
			datasets: 
			[
				{
					label: "Home Loan Details",
					data: [0, 0],
					backgroundColor: ["rgb(54, 162, 235)", "rgb(255, 99, 132)"],
					hoverOffset: 4
				}
			]
		},
		options: 
		{
			plugins: {
				title: {
					display: true,
					text: "Payment Breakup"
				}
			}
		}
	});
	  displayDetails();
}
initialize();
</script>
<?php if (DEBUG_ENABLED) echo GetDebugMessage(); ?>
<?php include_once "footer.php" ?>
<?php
$emi_calculator->terminate();
?>