<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$emp_payment_hs_list = new emp_payment_hs_list();

// Run the page
$emp_payment_hs_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$emp_payment_hs_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$emp_payment_hs->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var femp_payment_hslist = currentForm = new ew.Form("femp_payment_hslist", "list");
femp_payment_hslist.formKeyCountName = '<?php echo $emp_payment_hs_list->FormKeyCountName ?>';

// Form_CustomValidate event
femp_payment_hslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
femp_payment_hslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
femp_payment_hslist.lists["x_emp_name"] = <?php echo $emp_payment_hs_list->emp_name->Lookup->toClientList() ?>;
femp_payment_hslist.lists["x_emp_name"].options = <?php echo JsonEncode($emp_payment_hs_list->emp_name->lookupOptions()) ?>;

// Form object for search
var femp_payment_hslistsrch = currentSearchForm = new ew.Form("femp_payment_hslistsrch");

// Filters
femp_payment_hslistsrch.filterList = <?php echo $emp_payment_hs_list->getFilterList() ?>;

// Init search panel as collapsed
femp_payment_hslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$emp_payment_hs->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($emp_payment_hs_list->TotalRecs > 0 && $emp_payment_hs_list->ExportOptions->visible()) { ?>
<?php $emp_payment_hs_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($emp_payment_hs_list->ImportOptions->visible()) { ?>
<?php $emp_payment_hs_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($emp_payment_hs_list->SearchOptions->visible()) { ?>
<?php $emp_payment_hs_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($emp_payment_hs_list->FilterOptions->visible()) { ?>
<?php $emp_payment_hs_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$emp_payment_hs_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$emp_payment_hs->isExport() && !$emp_payment_hs->CurrentAction) { ?>
<form name="femp_payment_hslistsrch" id="femp_payment_hslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($emp_payment_hs_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="femp_payment_hslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="emp_payment_hs">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($emp_payment_hs_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($emp_payment_hs_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $emp_payment_hs_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($emp_payment_hs_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($emp_payment_hs_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($emp_payment_hs_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($emp_payment_hs_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $emp_payment_hs_list->showPageHeader(); ?>
<?php
$emp_payment_hs_list->showMessage();
?>
<?php if ($emp_payment_hs_list->TotalRecs > 0 || $emp_payment_hs->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($emp_payment_hs_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> emp_payment_hs">
<?php if (!$emp_payment_hs->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$emp_payment_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($emp_payment_hs_list->Pager)) $emp_payment_hs_list->Pager = new PrevNextPager($emp_payment_hs_list->StartRec, $emp_payment_hs_list->DisplayRecs, $emp_payment_hs_list->TotalRecs, $emp_payment_hs_list->AutoHidePager) ?>
<?php if ($emp_payment_hs_list->Pager->RecordCount > 0 && $emp_payment_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($emp_payment_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $emp_payment_hs_list->pageUrl() ?>start=<?php echo $emp_payment_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($emp_payment_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $emp_payment_hs_list->pageUrl() ?>start=<?php echo $emp_payment_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $emp_payment_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($emp_payment_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $emp_payment_hs_list->pageUrl() ?>start=<?php echo $emp_payment_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($emp_payment_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $emp_payment_hs_list->pageUrl() ?>start=<?php echo $emp_payment_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $emp_payment_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($emp_payment_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $emp_payment_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $emp_payment_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $emp_payment_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($emp_payment_hs_list->TotalRecs > 0 && (!$emp_payment_hs_list->AutoHidePageSizeSelector || $emp_payment_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="emp_payment_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($emp_payment_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($emp_payment_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($emp_payment_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($emp_payment_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($emp_payment_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($emp_payment_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $emp_payment_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="femp_payment_hslist" id="femp_payment_hslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($emp_payment_hs_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $emp_payment_hs_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="emp_payment_hs">
<div id="gmp_emp_payment_hs" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($emp_payment_hs_list->TotalRecs > 0 || $emp_payment_hs->isGridEdit()) { ?>
<table id="tbl_emp_payment_hslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$emp_payment_hs_list->RowType = ROWTYPE_HEADER;

// Render list options
$emp_payment_hs_list->renderListOptions();

// Render list options (header, left)
$emp_payment_hs_list->ListOptions->render("header", "left");
?>
<?php if ($emp_payment_hs->JobCard->Visible) { // JobCard ?>
	<?php if ($emp_payment_hs->sortUrl($emp_payment_hs->JobCard) == "") { ?>
		<th data-name="JobCard" class="<?php echo $emp_payment_hs->JobCard->headerCellClass() ?>"><div id="elh_emp_payment_hs_JobCard" class="emp_payment_hs_JobCard"><div class="ew-table-header-caption"><?php echo $emp_payment_hs->JobCard->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="JobCard" class="<?php echo $emp_payment_hs->JobCard->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $emp_payment_hs->SortUrl($emp_payment_hs->JobCard) ?>',2);"><div id="elh_emp_payment_hs_JobCard" class="emp_payment_hs_JobCard">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $emp_payment_hs->JobCard->caption() ?></span><span class="ew-table-header-sort"><?php if ($emp_payment_hs->JobCard->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($emp_payment_hs->JobCard->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($emp_payment_hs->emp_name->Visible) { // emp_name ?>
	<?php if ($emp_payment_hs->sortUrl($emp_payment_hs->emp_name) == "") { ?>
		<th data-name="emp_name" class="<?php echo $emp_payment_hs->emp_name->headerCellClass() ?>"><div id="elh_emp_payment_hs_emp_name" class="emp_payment_hs_emp_name"><div class="ew-table-header-caption"><?php echo $emp_payment_hs->emp_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emp_name" class="<?php echo $emp_payment_hs->emp_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $emp_payment_hs->SortUrl($emp_payment_hs->emp_name) ?>',2);"><div id="elh_emp_payment_hs_emp_name" class="emp_payment_hs_emp_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $emp_payment_hs->emp_name->caption() ?></span><span class="ew-table-header-sort"><?php if ($emp_payment_hs->emp_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($emp_payment_hs->emp_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($emp_payment_hs->TotalPaidAmount->Visible) { // TotalPaidAmount ?>
	<?php if ($emp_payment_hs->sortUrl($emp_payment_hs->TotalPaidAmount) == "") { ?>
		<th data-name="TotalPaidAmount" class="<?php echo $emp_payment_hs->TotalPaidAmount->headerCellClass() ?>"><div id="elh_emp_payment_hs_TotalPaidAmount" class="emp_payment_hs_TotalPaidAmount"><div class="ew-table-header-caption"><?php echo $emp_payment_hs->TotalPaidAmount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TotalPaidAmount" class="<?php echo $emp_payment_hs->TotalPaidAmount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $emp_payment_hs->SortUrl($emp_payment_hs->TotalPaidAmount) ?>',2);"><div id="elh_emp_payment_hs_TotalPaidAmount" class="emp_payment_hs_TotalPaidAmount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $emp_payment_hs->TotalPaidAmount->caption() ?></span><span class="ew-table-header-sort"><?php if ($emp_payment_hs->TotalPaidAmount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($emp_payment_hs->TotalPaidAmount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($emp_payment_hs->PaidAmount->Visible) { // PaidAmount ?>
	<?php if ($emp_payment_hs->sortUrl($emp_payment_hs->PaidAmount) == "") { ?>
		<th data-name="PaidAmount" class="<?php echo $emp_payment_hs->PaidAmount->headerCellClass() ?>"><div id="elh_emp_payment_hs_PaidAmount" class="emp_payment_hs_PaidAmount"><div class="ew-table-header-caption"><?php echo $emp_payment_hs->PaidAmount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PaidAmount" class="<?php echo $emp_payment_hs->PaidAmount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $emp_payment_hs->SortUrl($emp_payment_hs->PaidAmount) ?>',2);"><div id="elh_emp_payment_hs_PaidAmount" class="emp_payment_hs_PaidAmount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $emp_payment_hs->PaidAmount->caption() ?></span><span class="ew-table-header-sort"><?php if ($emp_payment_hs->PaidAmount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($emp_payment_hs->PaidAmount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($emp_payment_hs->BalanceAmount->Visible) { // BalanceAmount ?>
	<?php if ($emp_payment_hs->sortUrl($emp_payment_hs->BalanceAmount) == "") { ?>
		<th data-name="BalanceAmount" class="<?php echo $emp_payment_hs->BalanceAmount->headerCellClass() ?>"><div id="elh_emp_payment_hs_BalanceAmount" class="emp_payment_hs_BalanceAmount"><div class="ew-table-header-caption"><?php echo $emp_payment_hs->BalanceAmount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="BalanceAmount" class="<?php echo $emp_payment_hs->BalanceAmount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $emp_payment_hs->SortUrl($emp_payment_hs->BalanceAmount) ?>',2);"><div id="elh_emp_payment_hs_BalanceAmount" class="emp_payment_hs_BalanceAmount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $emp_payment_hs->BalanceAmount->caption() ?></span><span class="ew-table-header-sort"><?php if ($emp_payment_hs->BalanceAmount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($emp_payment_hs->BalanceAmount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($emp_payment_hs->TotalShortage->Visible) { // TotalShortage ?>
	<?php if ($emp_payment_hs->sortUrl($emp_payment_hs->TotalShortage) == "") { ?>
		<th data-name="TotalShortage" class="<?php echo $emp_payment_hs->TotalShortage->headerCellClass() ?>"><div id="elh_emp_payment_hs_TotalShortage" class="emp_payment_hs_TotalShortage"><div class="ew-table-header-caption"><?php echo $emp_payment_hs->TotalShortage->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TotalShortage" class="<?php echo $emp_payment_hs->TotalShortage->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $emp_payment_hs->SortUrl($emp_payment_hs->TotalShortage) ?>',2);"><div id="elh_emp_payment_hs_TotalShortage" class="emp_payment_hs_TotalShortage">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $emp_payment_hs->TotalShortage->caption() ?></span><span class="ew-table-header-sort"><?php if ($emp_payment_hs->TotalShortage->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($emp_payment_hs->TotalShortage->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($emp_payment_hs->TotalShortageAmount->Visible) { // TotalShortageAmount ?>
	<?php if ($emp_payment_hs->sortUrl($emp_payment_hs->TotalShortageAmount) == "") { ?>
		<th data-name="TotalShortageAmount" class="<?php echo $emp_payment_hs->TotalShortageAmount->headerCellClass() ?>"><div id="elh_emp_payment_hs_TotalShortageAmount" class="emp_payment_hs_TotalShortageAmount"><div class="ew-table-header-caption"><?php echo $emp_payment_hs->TotalShortageAmount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TotalShortageAmount" class="<?php echo $emp_payment_hs->TotalShortageAmount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $emp_payment_hs->SortUrl($emp_payment_hs->TotalShortageAmount) ?>',2);"><div id="elh_emp_payment_hs_TotalShortageAmount" class="emp_payment_hs_TotalShortageAmount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $emp_payment_hs->TotalShortageAmount->caption() ?></span><span class="ew-table-header-sort"><?php if ($emp_payment_hs->TotalShortageAmount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($emp_payment_hs->TotalShortageAmount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$emp_payment_hs_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($emp_payment_hs->ExportAll && $emp_payment_hs->isExport()) {
	$emp_payment_hs_list->StopRec = $emp_payment_hs_list->TotalRecs;
} else {

	// Set the last record to display
	if ($emp_payment_hs_list->TotalRecs > $emp_payment_hs_list->StartRec + $emp_payment_hs_list->DisplayRecs - 1)
		$emp_payment_hs_list->StopRec = $emp_payment_hs_list->StartRec + $emp_payment_hs_list->DisplayRecs - 1;
	else
		$emp_payment_hs_list->StopRec = $emp_payment_hs_list->TotalRecs;
}
$emp_payment_hs_list->RecCnt = $emp_payment_hs_list->StartRec - 1;
if ($emp_payment_hs_list->Recordset && !$emp_payment_hs_list->Recordset->EOF) {
	$emp_payment_hs_list->Recordset->moveFirst();
	$selectLimit = $emp_payment_hs_list->UseSelectLimit;
	if (!$selectLimit && $emp_payment_hs_list->StartRec > 1)
		$emp_payment_hs_list->Recordset->move($emp_payment_hs_list->StartRec - 1);
} elseif (!$emp_payment_hs->AllowAddDeleteRow && $emp_payment_hs_list->StopRec == 0) {
	$emp_payment_hs_list->StopRec = $emp_payment_hs->GridAddRowCount;
}

// Initialize aggregate
$emp_payment_hs->RowType = ROWTYPE_AGGREGATEINIT;
$emp_payment_hs->resetAttributes();
$emp_payment_hs_list->renderRow();
while ($emp_payment_hs_list->RecCnt < $emp_payment_hs_list->StopRec) {
	$emp_payment_hs_list->RecCnt++;
	if ($emp_payment_hs_list->RecCnt >= $emp_payment_hs_list->StartRec) {
		$emp_payment_hs_list->RowCnt++;

		// Set up key count
		$emp_payment_hs_list->KeyCount = $emp_payment_hs_list->RowIndex;

		// Init row class and style
		$emp_payment_hs->resetAttributes();
		$emp_payment_hs->CssClass = "";
		if ($emp_payment_hs->isGridAdd()) {
		} else {
			$emp_payment_hs_list->loadRowValues($emp_payment_hs_list->Recordset); // Load row values
		}
		$emp_payment_hs->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$emp_payment_hs->RowAttrs = array_merge($emp_payment_hs->RowAttrs, array('data-rowindex'=>$emp_payment_hs_list->RowCnt, 'id'=>'r' . $emp_payment_hs_list->RowCnt . '_emp_payment_hs', 'data-rowtype'=>$emp_payment_hs->RowType));

		// Render row
		$emp_payment_hs_list->renderRow();

		// Render list options
		$emp_payment_hs_list->renderListOptions();
?>
	<tr<?php echo $emp_payment_hs->rowAttributes() ?>>
<?php

// Render list options (body, left)
$emp_payment_hs_list->ListOptions->render("body", "left", $emp_payment_hs_list->RowCnt);
?>
	<?php if ($emp_payment_hs->JobCard->Visible) { // JobCard ?>
		<td data-name="JobCard"<?php echo $emp_payment_hs->JobCard->cellAttributes() ?>>
<span id="el<?php echo $emp_payment_hs_list->RowCnt ?>_emp_payment_hs_JobCard" class="emp_payment_hs_JobCard">
<span<?php echo $emp_payment_hs->JobCard->viewAttributes() ?>>
<?php echo $emp_payment_hs->JobCard->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($emp_payment_hs->emp_name->Visible) { // emp_name ?>
		<td data-name="emp_name"<?php echo $emp_payment_hs->emp_name->cellAttributes() ?>>
<span id="el<?php echo $emp_payment_hs_list->RowCnt ?>_emp_payment_hs_emp_name" class="emp_payment_hs_emp_name">
<span<?php echo $emp_payment_hs->emp_name->viewAttributes() ?>>
<?php echo $emp_payment_hs->emp_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($emp_payment_hs->TotalPaidAmount->Visible) { // TotalPaidAmount ?>
		<td data-name="TotalPaidAmount"<?php echo $emp_payment_hs->TotalPaidAmount->cellAttributes() ?>>
<span id="el<?php echo $emp_payment_hs_list->RowCnt ?>_emp_payment_hs_TotalPaidAmount" class="emp_payment_hs_TotalPaidAmount">
<span<?php echo $emp_payment_hs->TotalPaidAmount->viewAttributes() ?>>
<?php echo $emp_payment_hs->TotalPaidAmount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($emp_payment_hs->PaidAmount->Visible) { // PaidAmount ?>
		<td data-name="PaidAmount"<?php echo $emp_payment_hs->PaidAmount->cellAttributes() ?>>
<span id="el<?php echo $emp_payment_hs_list->RowCnt ?>_emp_payment_hs_PaidAmount" class="emp_payment_hs_PaidAmount">
<span<?php echo $emp_payment_hs->PaidAmount->viewAttributes() ?>>
<?php echo $emp_payment_hs->PaidAmount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($emp_payment_hs->BalanceAmount->Visible) { // BalanceAmount ?>
		<td data-name="BalanceAmount"<?php echo $emp_payment_hs->BalanceAmount->cellAttributes() ?>>
<span id="el<?php echo $emp_payment_hs_list->RowCnt ?>_emp_payment_hs_BalanceAmount" class="emp_payment_hs_BalanceAmount">
<span<?php echo $emp_payment_hs->BalanceAmount->viewAttributes() ?>>
<?php echo $emp_payment_hs->BalanceAmount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($emp_payment_hs->TotalShortage->Visible) { // TotalShortage ?>
		<td data-name="TotalShortage"<?php echo $emp_payment_hs->TotalShortage->cellAttributes() ?>>
<span id="el<?php echo $emp_payment_hs_list->RowCnt ?>_emp_payment_hs_TotalShortage" class="emp_payment_hs_TotalShortage">
<span<?php echo $emp_payment_hs->TotalShortage->viewAttributes() ?>>
<?php echo $emp_payment_hs->TotalShortage->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($emp_payment_hs->TotalShortageAmount->Visible) { // TotalShortageAmount ?>
		<td data-name="TotalShortageAmount"<?php echo $emp_payment_hs->TotalShortageAmount->cellAttributes() ?>>
<span id="el<?php echo $emp_payment_hs_list->RowCnt ?>_emp_payment_hs_TotalShortageAmount" class="emp_payment_hs_TotalShortageAmount">
<span<?php echo $emp_payment_hs->TotalShortageAmount->viewAttributes() ?>>
<?php echo $emp_payment_hs->TotalShortageAmount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$emp_payment_hs_list->ListOptions->render("body", "right", $emp_payment_hs_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$emp_payment_hs->isGridAdd())
		$emp_payment_hs_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$emp_payment_hs->RowType = ROWTYPE_AGGREGATE;
$emp_payment_hs->resetAttributes();
$emp_payment_hs_list->renderRow();
?>
<?php if ($emp_payment_hs_list->TotalRecs > 0 && !$emp_payment_hs->isGridAdd() && !$emp_payment_hs->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$emp_payment_hs_list->renderListOptions();

// Render list options (footer, left)
$emp_payment_hs_list->ListOptions->render("footer", "left");
?>
	<?php if ($emp_payment_hs->JobCard->Visible) { // JobCard ?>
		<td data-name="JobCard" class="<?php echo $emp_payment_hs->JobCard->footerCellClass() ?>"><span id="elf_emp_payment_hs_JobCard" class="emp_payment_hs_JobCard">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($emp_payment_hs->emp_name->Visible) { // emp_name ?>
		<td data-name="emp_name" class="<?php echo $emp_payment_hs->emp_name->footerCellClass() ?>"><span id="elf_emp_payment_hs_emp_name" class="emp_payment_hs_emp_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($emp_payment_hs->TotalPaidAmount->Visible) { // TotalPaidAmount ?>
		<td data-name="TotalPaidAmount" class="<?php echo $emp_payment_hs->TotalPaidAmount->footerCellClass() ?>"><span id="elf_emp_payment_hs_TotalPaidAmount" class="emp_payment_hs_TotalPaidAmount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $emp_payment_hs->TotalPaidAmount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($emp_payment_hs->PaidAmount->Visible) { // PaidAmount ?>
		<td data-name="PaidAmount" class="<?php echo $emp_payment_hs->PaidAmount->footerCellClass() ?>"><span id="elf_emp_payment_hs_PaidAmount" class="emp_payment_hs_PaidAmount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $emp_payment_hs->PaidAmount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($emp_payment_hs->BalanceAmount->Visible) { // BalanceAmount ?>
		<td data-name="BalanceAmount" class="<?php echo $emp_payment_hs->BalanceAmount->footerCellClass() ?>"><span id="elf_emp_payment_hs_BalanceAmount" class="emp_payment_hs_BalanceAmount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $emp_payment_hs->BalanceAmount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($emp_payment_hs->TotalShortage->Visible) { // TotalShortage ?>
		<td data-name="TotalShortage" class="<?php echo $emp_payment_hs->TotalShortage->footerCellClass() ?>"><span id="elf_emp_payment_hs_TotalShortage" class="emp_payment_hs_TotalShortage">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $emp_payment_hs->TotalShortage->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($emp_payment_hs->TotalShortageAmount->Visible) { // TotalShortageAmount ?>
		<td data-name="TotalShortageAmount" class="<?php echo $emp_payment_hs->TotalShortageAmount->footerCellClass() ?>"><span id="elf_emp_payment_hs_TotalShortageAmount" class="emp_payment_hs_TotalShortageAmount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $emp_payment_hs->TotalShortageAmount->ViewValue ?></span>
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$emp_payment_hs_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$emp_payment_hs->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($emp_payment_hs_list->Recordset)
	$emp_payment_hs_list->Recordset->Close();
?>
<?php if (!$emp_payment_hs->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$emp_payment_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($emp_payment_hs_list->Pager)) $emp_payment_hs_list->Pager = new PrevNextPager($emp_payment_hs_list->StartRec, $emp_payment_hs_list->DisplayRecs, $emp_payment_hs_list->TotalRecs, $emp_payment_hs_list->AutoHidePager) ?>
<?php if ($emp_payment_hs_list->Pager->RecordCount > 0 && $emp_payment_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($emp_payment_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $emp_payment_hs_list->pageUrl() ?>start=<?php echo $emp_payment_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($emp_payment_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $emp_payment_hs_list->pageUrl() ?>start=<?php echo $emp_payment_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $emp_payment_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($emp_payment_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $emp_payment_hs_list->pageUrl() ?>start=<?php echo $emp_payment_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($emp_payment_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $emp_payment_hs_list->pageUrl() ?>start=<?php echo $emp_payment_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $emp_payment_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($emp_payment_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $emp_payment_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $emp_payment_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $emp_payment_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($emp_payment_hs_list->TotalRecs > 0 && (!$emp_payment_hs_list->AutoHidePageSizeSelector || $emp_payment_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="emp_payment_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($emp_payment_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($emp_payment_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($emp_payment_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($emp_payment_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($emp_payment_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($emp_payment_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $emp_payment_hs_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($emp_payment_hs_list->TotalRecs == 0 && !$emp_payment_hs->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $emp_payment_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$emp_payment_hs_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$emp_payment_hs->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$emp_payment_hs->isExport()) { ?>
<script>
ew.scrollableTable("gmp_emp_payment_hs", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$emp_payment_hs_list->terminate();
?>