<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$fe_setup_edit = new fe_setup_edit();

// Run the page
$fe_setup_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$fe_setup_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var ffe_setupedit = currentForm = new ew.Form("ffe_setupedit", "edit");

// Validate form
ffe_setupedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($fe_setup_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $fe_setup->id->caption(), $fe_setup->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($fe_setup->id->errorMessage()) ?>");
		<?php if ($fe_setup_edit->product_image->Required) { ?>
			elm = this.getElements("x" + infix + "_product_image");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $fe_setup->product_image->caption(), $fe_setup->product_image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($fe_setup_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $fe_setup->operator->caption(), $fe_setup->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($fe_setup->operator->errorMessage()) ?>");
		<?php if ($fe_setup_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $fe_setup->datetime->caption(), $fe_setup->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($fe_setup->datetime->errorMessage()) ?>");
		<?php if ($fe_setup_edit->product_group->Required) { ?>
			elm = this.getElements("x" + infix + "_product_group");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $fe_setup->product_group->caption(), $fe_setup->product_group->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product_group");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($fe_setup->product_group->errorMessage()) ?>");
		<?php if ($fe_setup_edit->product_category->Required) { ?>
			elm = this.getElements("x" + infix + "_product_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $fe_setup->product_category->caption(), $fe_setup->product_category->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_product_category");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($fe_setup->product_category->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ffe_setupedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ffe_setupedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ffe_setupedit.lists["x_product_image"] = <?php echo $fe_setup_edit->product_image->Lookup->toClientList() ?>;
ffe_setupedit.lists["x_product_image"].options = <?php echo JsonEncode($fe_setup_edit->product_image->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $fe_setup_edit->showPageHeader(); ?>
<?php
$fe_setup_edit->showMessage();
?>
<form name="ffe_setupedit" id="ffe_setupedit" class="<?php echo $fe_setup_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($fe_setup_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $fe_setup_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="fe_setup">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$fe_setup_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($fe_setup->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_fe_setup_id" for="x_id" class="<?php echo $fe_setup_edit->LeftColumnClass ?>"><?php echo $fe_setup->id->caption() ?><?php echo ($fe_setup->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $fe_setup_edit->RightColumnClass ?>"><div<?php echo $fe_setup->id->cellAttributes() ?>>
<span id="el_fe_setup_id">
<span<?php echo $fe_setup->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($fe_setup->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="fe_setup" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($fe_setup->id->CurrentValue) ?>">
<?php echo $fe_setup->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($fe_setup->product_image->Visible) { // product_image ?>
	<div id="r_product_image" class="form-group row">
		<label id="elh_fe_setup_product_image" for="x_product_image" class="<?php echo $fe_setup_edit->LeftColumnClass ?>"><?php echo $fe_setup->product_image->caption() ?><?php echo ($fe_setup->product_image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $fe_setup_edit->RightColumnClass ?>"><div<?php echo $fe_setup->product_image->cellAttributes() ?>>
<span id="el_fe_setup_product_image">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="fe_setup" data-field="x_product_image" data-value-separator="<?php echo $fe_setup->product_image->displayValueSeparatorAttribute() ?>" id="x_product_image" name="x_product_image"<?php echo $fe_setup->product_image->editAttributes() ?>>
		<?php echo $fe_setup->product_image->selectOptionListHtml("x_product_image") ?>
	</select>
</div>
</span>
<?php echo $fe_setup->product_image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($fe_setup->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label id="elh_fe_setup_operator" for="x_operator" class="<?php echo $fe_setup_edit->LeftColumnClass ?>"><?php echo $fe_setup->operator->caption() ?><?php echo ($fe_setup->operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $fe_setup_edit->RightColumnClass ?>"><div<?php echo $fe_setup->operator->cellAttributes() ?>>
<span id="el_fe_setup_operator">
<input type="text" data-table="fe_setup" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($fe_setup->operator->getPlaceHolder()) ?>" value="<?php echo $fe_setup->operator->EditValue ?>"<?php echo $fe_setup->operator->editAttributes() ?>>
</span>
<?php echo $fe_setup->operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($fe_setup->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label id="elh_fe_setup_datetime" for="x_datetime" class="<?php echo $fe_setup_edit->LeftColumnClass ?>"><?php echo $fe_setup->datetime->caption() ?><?php echo ($fe_setup->datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $fe_setup_edit->RightColumnClass ?>"><div<?php echo $fe_setup->datetime->cellAttributes() ?>>
<span id="el_fe_setup_datetime">
<input type="text" data-table="fe_setup" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($fe_setup->datetime->getPlaceHolder()) ?>" value="<?php echo $fe_setup->datetime->EditValue ?>"<?php echo $fe_setup->datetime->editAttributes() ?>>
<?php if (!$fe_setup->datetime->ReadOnly && !$fe_setup->datetime->Disabled && !isset($fe_setup->datetime->EditAttrs["readonly"]) && !isset($fe_setup->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ffe_setupedit", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $fe_setup->datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($fe_setup->product_group->Visible) { // product_group ?>
	<div id="r_product_group" class="form-group row">
		<label id="elh_fe_setup_product_group" for="x_product_group" class="<?php echo $fe_setup_edit->LeftColumnClass ?>"><?php echo $fe_setup->product_group->caption() ?><?php echo ($fe_setup->product_group->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $fe_setup_edit->RightColumnClass ?>"><div<?php echo $fe_setup->product_group->cellAttributes() ?>>
<span id="el_fe_setup_product_group">
<input type="text" data-table="fe_setup" data-field="x_product_group" name="x_product_group" id="x_product_group" size="30" placeholder="<?php echo HtmlEncode($fe_setup->product_group->getPlaceHolder()) ?>" value="<?php echo $fe_setup->product_group->EditValue ?>"<?php echo $fe_setup->product_group->editAttributes() ?>>
</span>
<?php echo $fe_setup->product_group->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($fe_setup->product_category->Visible) { // product_category ?>
	<div id="r_product_category" class="form-group row">
		<label id="elh_fe_setup_product_category" for="x_product_category" class="<?php echo $fe_setup_edit->LeftColumnClass ?>"><?php echo $fe_setup->product_category->caption() ?><?php echo ($fe_setup->product_category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $fe_setup_edit->RightColumnClass ?>"><div<?php echo $fe_setup->product_category->cellAttributes() ?>>
<span id="el_fe_setup_product_category">
<input type="text" data-table="fe_setup" data-field="x_product_category" name="x_product_category" id="x_product_category" size="30" placeholder="<?php echo HtmlEncode($fe_setup->product_category->getPlaceHolder()) ?>" value="<?php echo $fe_setup->product_category->EditValue ?>"<?php echo $fe_setup->product_category->editAttributes() ?>>
</span>
<?php echo $fe_setup->product_category->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$fe_setup_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $fe_setup_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $fe_setup_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$fe_setup_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$fe_setup_edit->terminate();
?>