<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$fe_setup_view = new fe_setup_view();

// Run the page
$fe_setup_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$fe_setup_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$fe_setup->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ffe_setupview = currentForm = new ew.Form("ffe_setupview", "view");

// Form_CustomValidate event
ffe_setupview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ffe_setupview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ffe_setupview.lists["x_product_image"] = <?php echo $fe_setup_view->product_image->Lookup->toClientList() ?>;
ffe_setupview.lists["x_product_image"].options = <?php echo JsonEncode($fe_setup_view->product_image->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$fe_setup->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $fe_setup_view->ExportOptions->render("body") ?>
<?php $fe_setup_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $fe_setup_view->showPageHeader(); ?>
<?php
$fe_setup_view->showMessage();
?>
<form name="ffe_setupview" id="ffe_setupview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($fe_setup_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $fe_setup_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="fe_setup">
<input type="hidden" name="modal" value="<?php echo (int)$fe_setup_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($fe_setup->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $fe_setup_view->TableLeftColumnClass ?>"><span id="elh_fe_setup_id"><?php echo $fe_setup->id->caption() ?></span></td>
		<td data-name="id"<?php echo $fe_setup->id->cellAttributes() ?>>
<span id="el_fe_setup_id">
<span<?php echo $fe_setup->id->viewAttributes() ?>>
<?php echo $fe_setup->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($fe_setup->product_image->Visible) { // product_image ?>
	<tr id="r_product_image">
		<td class="<?php echo $fe_setup_view->TableLeftColumnClass ?>"><span id="elh_fe_setup_product_image"><?php echo $fe_setup->product_image->caption() ?></span></td>
		<td data-name="product_image"<?php echo $fe_setup->product_image->cellAttributes() ?>>
<span id="el_fe_setup_product_image">
<span<?php echo $fe_setup->product_image->viewAttributes() ?>>
<?php echo $fe_setup->product_image->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($fe_setup->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $fe_setup_view->TableLeftColumnClass ?>"><span id="elh_fe_setup_operator"><?php echo $fe_setup->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $fe_setup->operator->cellAttributes() ?>>
<span id="el_fe_setup_operator">
<span<?php echo $fe_setup->operator->viewAttributes() ?>>
<?php echo $fe_setup->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($fe_setup->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $fe_setup_view->TableLeftColumnClass ?>"><span id="elh_fe_setup_datetime"><?php echo $fe_setup->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $fe_setup->datetime->cellAttributes() ?>>
<span id="el_fe_setup_datetime">
<span<?php echo $fe_setup->datetime->viewAttributes() ?>>
<?php echo $fe_setup->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($fe_setup->product_group->Visible) { // product_group ?>
	<tr id="r_product_group">
		<td class="<?php echo $fe_setup_view->TableLeftColumnClass ?>"><span id="elh_fe_setup_product_group"><?php echo $fe_setup->product_group->caption() ?></span></td>
		<td data-name="product_group"<?php echo $fe_setup->product_group->cellAttributes() ?>>
<span id="el_fe_setup_product_group">
<span<?php echo $fe_setup->product_group->viewAttributes() ?>>
<?php echo $fe_setup->product_group->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($fe_setup->product_category->Visible) { // product_category ?>
	<tr id="r_product_category">
		<td class="<?php echo $fe_setup_view->TableLeftColumnClass ?>"><span id="elh_fe_setup_product_category"><?php echo $fe_setup->product_category->caption() ?></span></td>
		<td data-name="product_category"<?php echo $fe_setup->product_category->cellAttributes() ?>>
<span id="el_fe_setup_product_category">
<span<?php echo $fe_setup->product_category->viewAttributes() ?>>
<?php echo $fe_setup->product_category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$fe_setup_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$fe_setup->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$fe_setup_view->terminate();
?>