<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$gallery_misc_list = new gallery_misc_list();

// Run the page
$gallery_misc_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$gallery_misc_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$gallery_misc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fgallery_misclist = currentForm = new ew.Form("fgallery_misclist", "list");
fgallery_misclist.formKeyCountName = '<?php echo $gallery_misc_list->FormKeyCountName ?>';

// Form_CustomValidate event
fgallery_misclist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgallery_misclist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgallery_misclist.lists["x_grp"] = <?php echo $gallery_misc_list->grp->Lookup->toClientList() ?>;
fgallery_misclist.lists["x_grp"].options = <?php echo JsonEncode($gallery_misc_list->grp->lookupOptions()) ?>;
fgallery_misclist.lists["x_status"] = <?php echo $gallery_misc_list->status->Lookup->toClientList() ?>;
fgallery_misclist.lists["x_status"].options = <?php echo JsonEncode($gallery_misc_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fgallery_misclistsrch = currentSearchForm = new ew.Form("fgallery_misclistsrch");

// Filters
fgallery_misclistsrch.filterList = <?php echo $gallery_misc_list->getFilterList() ?>;

// Init search panel as collapsed
fgallery_misclistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$gallery_misc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($gallery_misc_list->TotalRecs > 0 && $gallery_misc_list->ExportOptions->visible()) { ?>
<?php $gallery_misc_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($gallery_misc_list->ImportOptions->visible()) { ?>
<?php $gallery_misc_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($gallery_misc_list->SearchOptions->visible()) { ?>
<?php $gallery_misc_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($gallery_misc_list->FilterOptions->visible()) { ?>
<?php $gallery_misc_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$gallery_misc_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$gallery_misc->isExport() && !$gallery_misc->CurrentAction) { ?>
<form name="fgallery_misclistsrch" id="fgallery_misclistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($gallery_misc_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fgallery_misclistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="gallery_misc">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($gallery_misc_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($gallery_misc_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $gallery_misc_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($gallery_misc_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($gallery_misc_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($gallery_misc_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($gallery_misc_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $gallery_misc_list->showPageHeader(); ?>
<?php
$gallery_misc_list->showMessage();
?>
<?php if ($gallery_misc_list->TotalRecs > 0 || $gallery_misc->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($gallery_misc_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> gallery_misc">
<?php if (!$gallery_misc->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$gallery_misc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($gallery_misc_list->Pager)) $gallery_misc_list->Pager = new PrevNextPager($gallery_misc_list->StartRec, $gallery_misc_list->DisplayRecs, $gallery_misc_list->TotalRecs, $gallery_misc_list->AutoHidePager) ?>
<?php if ($gallery_misc_list->Pager->RecordCount > 0 && $gallery_misc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($gallery_misc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $gallery_misc_list->pageUrl() ?>start=<?php echo $gallery_misc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($gallery_misc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $gallery_misc_list->pageUrl() ?>start=<?php echo $gallery_misc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $gallery_misc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($gallery_misc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $gallery_misc_list->pageUrl() ?>start=<?php echo $gallery_misc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($gallery_misc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $gallery_misc_list->pageUrl() ?>start=<?php echo $gallery_misc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $gallery_misc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($gallery_misc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $gallery_misc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $gallery_misc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $gallery_misc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($gallery_misc_list->TotalRecs > 0 && (!$gallery_misc_list->AutoHidePageSizeSelector || $gallery_misc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="gallery_misc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($gallery_misc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($gallery_misc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($gallery_misc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($gallery_misc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($gallery_misc_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($gallery_misc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $gallery_misc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fgallery_misclist" id="fgallery_misclist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($gallery_misc_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $gallery_misc_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="gallery_misc">
<div id="gmp_gallery_misc" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($gallery_misc_list->TotalRecs > 0 || $gallery_misc->isGridEdit()) { ?>
<table id="tbl_gallery_misclist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$gallery_misc_list->RowType = ROWTYPE_HEADER;

// Render list options
$gallery_misc_list->renderListOptions();

// Render list options (header, left)
$gallery_misc_list->ListOptions->render("header", "left");
?>
<?php if ($gallery_misc->id->Visible) { // id ?>
	<?php if ($gallery_misc->sortUrl($gallery_misc->id) == "") { ?>
		<th data-name="id" class="<?php echo $gallery_misc->id->headerCellClass() ?>"><div id="elh_gallery_misc_id" class="gallery_misc_id"><div class="ew-table-header-caption"><?php echo $gallery_misc->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $gallery_misc->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gallery_misc->SortUrl($gallery_misc->id) ?>',2);"><div id="elh_gallery_misc_id" class="gallery_misc_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gallery_misc->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($gallery_misc->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gallery_misc->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gallery_misc->item->Visible) { // item ?>
	<?php if ($gallery_misc->sortUrl($gallery_misc->item) == "") { ?>
		<th data-name="item" class="<?php echo $gallery_misc->item->headerCellClass() ?>"><div id="elh_gallery_misc_item" class="gallery_misc_item"><div class="ew-table-header-caption"><?php echo $gallery_misc->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $gallery_misc->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gallery_misc->SortUrl($gallery_misc->item) ?>',2);"><div id="elh_gallery_misc_item" class="gallery_misc_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gallery_misc->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($gallery_misc->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gallery_misc->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gallery_misc->grp->Visible) { // grp ?>
	<?php if ($gallery_misc->sortUrl($gallery_misc->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $gallery_misc->grp->headerCellClass() ?>"><div id="elh_gallery_misc_grp" class="gallery_misc_grp"><div class="ew-table-header-caption"><?php echo $gallery_misc->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $gallery_misc->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gallery_misc->SortUrl($gallery_misc->grp) ?>',2);"><div id="elh_gallery_misc_grp" class="gallery_misc_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gallery_misc->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($gallery_misc->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gallery_misc->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gallery_misc->status->Visible) { // status ?>
	<?php if ($gallery_misc->sortUrl($gallery_misc->status) == "") { ?>
		<th data-name="status" class="<?php echo $gallery_misc->status->headerCellClass() ?>"><div id="elh_gallery_misc_status" class="gallery_misc_status"><div class="ew-table-header-caption"><?php echo $gallery_misc->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $gallery_misc->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gallery_misc->SortUrl($gallery_misc->status) ?>',2);"><div id="elh_gallery_misc_status" class="gallery_misc_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gallery_misc->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($gallery_misc->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gallery_misc->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gallery_misc->operator->Visible) { // operator ?>
	<?php if ($gallery_misc->sortUrl($gallery_misc->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $gallery_misc->operator->headerCellClass() ?>"><div id="elh_gallery_misc_operator" class="gallery_misc_operator"><div class="ew-table-header-caption"><?php echo $gallery_misc->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $gallery_misc->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gallery_misc->SortUrl($gallery_misc->operator) ?>',2);"><div id="elh_gallery_misc_operator" class="gallery_misc_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gallery_misc->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($gallery_misc->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gallery_misc->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gallery_misc->datetime->Visible) { // datetime ?>
	<?php if ($gallery_misc->sortUrl($gallery_misc->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $gallery_misc->datetime->headerCellClass() ?>"><div id="elh_gallery_misc_datetime" class="gallery_misc_datetime"><div class="ew-table-header-caption"><?php echo $gallery_misc->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $gallery_misc->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gallery_misc->SortUrl($gallery_misc->datetime) ?>',2);"><div id="elh_gallery_misc_datetime" class="gallery_misc_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gallery_misc->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($gallery_misc->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gallery_misc->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$gallery_misc_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($gallery_misc->ExportAll && $gallery_misc->isExport()) {
	$gallery_misc_list->StopRec = $gallery_misc_list->TotalRecs;
} else {

	// Set the last record to display
	if ($gallery_misc_list->TotalRecs > $gallery_misc_list->StartRec + $gallery_misc_list->DisplayRecs - 1)
		$gallery_misc_list->StopRec = $gallery_misc_list->StartRec + $gallery_misc_list->DisplayRecs - 1;
	else
		$gallery_misc_list->StopRec = $gallery_misc_list->TotalRecs;
}
$gallery_misc_list->RecCnt = $gallery_misc_list->StartRec - 1;
if ($gallery_misc_list->Recordset && !$gallery_misc_list->Recordset->EOF) {
	$gallery_misc_list->Recordset->moveFirst();
	$selectLimit = $gallery_misc_list->UseSelectLimit;
	if (!$selectLimit && $gallery_misc_list->StartRec > 1)
		$gallery_misc_list->Recordset->move($gallery_misc_list->StartRec - 1);
} elseif (!$gallery_misc->AllowAddDeleteRow && $gallery_misc_list->StopRec == 0) {
	$gallery_misc_list->StopRec = $gallery_misc->GridAddRowCount;
}

// Initialize aggregate
$gallery_misc->RowType = ROWTYPE_AGGREGATEINIT;
$gallery_misc->resetAttributes();
$gallery_misc_list->renderRow();
while ($gallery_misc_list->RecCnt < $gallery_misc_list->StopRec) {
	$gallery_misc_list->RecCnt++;
	if ($gallery_misc_list->RecCnt >= $gallery_misc_list->StartRec) {
		$gallery_misc_list->RowCnt++;

		// Set up key count
		$gallery_misc_list->KeyCount = $gallery_misc_list->RowIndex;

		// Init row class and style
		$gallery_misc->resetAttributes();
		$gallery_misc->CssClass = "";
		if ($gallery_misc->isGridAdd()) {
		} else {
			$gallery_misc_list->loadRowValues($gallery_misc_list->Recordset); // Load row values
		}
		$gallery_misc->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$gallery_misc->RowAttrs = array_merge($gallery_misc->RowAttrs, array('data-rowindex'=>$gallery_misc_list->RowCnt, 'id'=>'r' . $gallery_misc_list->RowCnt . '_gallery_misc', 'data-rowtype'=>$gallery_misc->RowType));

		// Render row
		$gallery_misc_list->renderRow();

		// Render list options
		$gallery_misc_list->renderListOptions();
?>
	<tr<?php echo $gallery_misc->rowAttributes() ?>>
<?php

// Render list options (body, left)
$gallery_misc_list->ListOptions->render("body", "left", $gallery_misc_list->RowCnt);
?>
	<?php if ($gallery_misc->id->Visible) { // id ?>
		<td data-name="id"<?php echo $gallery_misc->id->cellAttributes() ?>>
<span id="el<?php echo $gallery_misc_list->RowCnt ?>_gallery_misc_id" class="gallery_misc_id">
<span<?php echo $gallery_misc->id->viewAttributes() ?>>
<?php echo $gallery_misc->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gallery_misc->item->Visible) { // item ?>
		<td data-name="item"<?php echo $gallery_misc->item->cellAttributes() ?>>
<span id="el<?php echo $gallery_misc_list->RowCnt ?>_gallery_misc_item" class="gallery_misc_item">
<span<?php echo $gallery_misc->item->viewAttributes() ?>>
<?php echo $gallery_misc->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gallery_misc->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $gallery_misc->grp->cellAttributes() ?>>
<span id="el<?php echo $gallery_misc_list->RowCnt ?>_gallery_misc_grp" class="gallery_misc_grp">
<span<?php echo $gallery_misc->grp->viewAttributes() ?>>
<?php echo $gallery_misc->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gallery_misc->status->Visible) { // status ?>
		<td data-name="status"<?php echo $gallery_misc->status->cellAttributes() ?>>
<span id="el<?php echo $gallery_misc_list->RowCnt ?>_gallery_misc_status" class="gallery_misc_status">
<span<?php echo $gallery_misc->status->viewAttributes() ?>>
<?php echo $gallery_misc->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gallery_misc->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $gallery_misc->operator->cellAttributes() ?>>
<span id="el<?php echo $gallery_misc_list->RowCnt ?>_gallery_misc_operator" class="gallery_misc_operator">
<span<?php echo $gallery_misc->operator->viewAttributes() ?>>
<?php echo $gallery_misc->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gallery_misc->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $gallery_misc->datetime->cellAttributes() ?>>
<span id="el<?php echo $gallery_misc_list->RowCnt ?>_gallery_misc_datetime" class="gallery_misc_datetime">
<span<?php echo $gallery_misc->datetime->viewAttributes() ?>>
<?php echo $gallery_misc->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$gallery_misc_list->ListOptions->render("body", "right", $gallery_misc_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$gallery_misc->isGridAdd())
		$gallery_misc_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$gallery_misc->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($gallery_misc_list->Recordset)
	$gallery_misc_list->Recordset->Close();
?>
<?php if (!$gallery_misc->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$gallery_misc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($gallery_misc_list->Pager)) $gallery_misc_list->Pager = new PrevNextPager($gallery_misc_list->StartRec, $gallery_misc_list->DisplayRecs, $gallery_misc_list->TotalRecs, $gallery_misc_list->AutoHidePager) ?>
<?php if ($gallery_misc_list->Pager->RecordCount > 0 && $gallery_misc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($gallery_misc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $gallery_misc_list->pageUrl() ?>start=<?php echo $gallery_misc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($gallery_misc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $gallery_misc_list->pageUrl() ?>start=<?php echo $gallery_misc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $gallery_misc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($gallery_misc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $gallery_misc_list->pageUrl() ?>start=<?php echo $gallery_misc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($gallery_misc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $gallery_misc_list->pageUrl() ?>start=<?php echo $gallery_misc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $gallery_misc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($gallery_misc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $gallery_misc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $gallery_misc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $gallery_misc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($gallery_misc_list->TotalRecs > 0 && (!$gallery_misc_list->AutoHidePageSizeSelector || $gallery_misc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="gallery_misc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($gallery_misc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($gallery_misc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($gallery_misc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($gallery_misc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($gallery_misc_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($gallery_misc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $gallery_misc_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($gallery_misc_list->TotalRecs == 0 && !$gallery_misc->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $gallery_misc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$gallery_misc_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$gallery_misc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$gallery_misc_list->terminate();
?>