<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$gallery_delete = new gallery_delete();

// Run the page
$gallery_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$gallery_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fgallerydelete = currentForm = new ew.Form("fgallerydelete", "delete");

// Form_CustomValidate event
fgallerydelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgallerydelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgallerydelete.lists["x_type"] = <?php echo $gallery_delete->type->Lookup->toClientList() ?>;
fgallerydelete.lists["x_type"].options = <?php echo JsonEncode($gallery_delete->type->options(FALSE, TRUE)) ?>;
fgallerydelete.lists["x_category[]"] = <?php echo $gallery_delete->category->Lookup->toClientList() ?>;
fgallerydelete.lists["x_category[]"].options = <?php echo JsonEncode($gallery_delete->category->lookupOptions()) ?>;
fgallerydelete.lists["x_grp"] = <?php echo $gallery_delete->grp->Lookup->toClientList() ?>;
fgallerydelete.lists["x_grp"].options = <?php echo JsonEncode($gallery_delete->grp->lookupOptions()) ?>;
fgallerydelete.autoSuggests["x_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $gallery_delete->showPageHeader(); ?>
<?php
$gallery_delete->showMessage();
?>
<form name="fgallerydelete" id="fgallerydelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($gallery_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $gallery_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="gallery">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($gallery_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($gallery->id->Visible) { // id ?>
		<th class="<?php echo $gallery->id->headerCellClass() ?>"><span id="elh_gallery_id" class="gallery_id"><?php echo $gallery->id->caption() ?></span></th>
<?php } ?>
<?php if ($gallery->type->Visible) { // type ?>
		<th class="<?php echo $gallery->type->headerCellClass() ?>"><span id="elh_gallery_type" class="gallery_type"><?php echo $gallery->type->caption() ?></span></th>
<?php } ?>
<?php if ($gallery->category->Visible) { // category ?>
		<th class="<?php echo $gallery->category->headerCellClass() ?>"><span id="elh_gallery_category" class="gallery_category"><?php echo $gallery->category->caption() ?></span></th>
<?php } ?>
<?php if ($gallery->grp->Visible) { // grp ?>
		<th class="<?php echo $gallery->grp->headerCellClass() ?>"><span id="elh_gallery_grp" class="gallery_grp"><?php echo $gallery->grp->caption() ?></span></th>
<?php } ?>
<?php if ($gallery->date->Visible) { // date ?>
		<th class="<?php echo $gallery->date->headerCellClass() ?>"><span id="elh_gallery_date" class="gallery_date"><?php echo $gallery->date->caption() ?></span></th>
<?php } ?>
<?php if ($gallery->description->Visible) { // description ?>
		<th class="<?php echo $gallery->description->headerCellClass() ?>"><span id="elh_gallery_description" class="gallery_description"><?php echo $gallery->description->caption() ?></span></th>
<?php } ?>
<?php if ($gallery->image->Visible) { // image ?>
		<th class="<?php echo $gallery->image->headerCellClass() ?>"><span id="elh_gallery_image" class="gallery_image"><?php echo $gallery->image->caption() ?></span></th>
<?php } ?>
<?php if ($gallery->video_link->Visible) { // video_link ?>
		<th class="<?php echo $gallery->video_link->headerCellClass() ?>"><span id="elh_gallery_video_link" class="gallery_video_link"><?php echo $gallery->video_link->caption() ?></span></th>
<?php } ?>
<?php if ($gallery->operator->Visible) { // operator ?>
		<th class="<?php echo $gallery->operator->headerCellClass() ?>"><span id="elh_gallery_operator" class="gallery_operator"><?php echo $gallery->operator->caption() ?></span></th>
<?php } ?>
<?php if ($gallery->datetime->Visible) { // datetime ?>
		<th class="<?php echo $gallery->datetime->headerCellClass() ?>"><span id="elh_gallery_datetime" class="gallery_datetime"><?php echo $gallery->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$gallery_delete->RecCnt = 0;
$i = 0;
while (!$gallery_delete->Recordset->EOF) {
	$gallery_delete->RecCnt++;
	$gallery_delete->RowCnt++;

	// Set row properties
	$gallery->resetAttributes();
	$gallery->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$gallery_delete->loadRowValues($gallery_delete->Recordset);

	// Render row
	$gallery_delete->renderRow();
?>
	<tr<?php echo $gallery->rowAttributes() ?>>
<?php if ($gallery->id->Visible) { // id ?>
		<td<?php echo $gallery->id->cellAttributes() ?>>
<span id="el<?php echo $gallery_delete->RowCnt ?>_gallery_id" class="gallery_id">
<span<?php echo $gallery->id->viewAttributes() ?>>
<?php echo $gallery->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($gallery->type->Visible) { // type ?>
		<td<?php echo $gallery->type->cellAttributes() ?>>
<span id="el<?php echo $gallery_delete->RowCnt ?>_gallery_type" class="gallery_type">
<span<?php echo $gallery->type->viewAttributes() ?>>
<?php echo $gallery->type->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($gallery->category->Visible) { // category ?>
		<td<?php echo $gallery->category->cellAttributes() ?>>
<span id="el<?php echo $gallery_delete->RowCnt ?>_gallery_category" class="gallery_category">
<span<?php echo $gallery->category->viewAttributes() ?>>
<?php echo $gallery->category->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($gallery->grp->Visible) { // grp ?>
		<td<?php echo $gallery->grp->cellAttributes() ?>>
<span id="el<?php echo $gallery_delete->RowCnt ?>_gallery_grp" class="gallery_grp">
<span<?php echo $gallery->grp->viewAttributes() ?>>
<?php echo $gallery->grp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($gallery->date->Visible) { // date ?>
		<td<?php echo $gallery->date->cellAttributes() ?>>
<span id="el<?php echo $gallery_delete->RowCnt ?>_gallery_date" class="gallery_date">
<span<?php echo $gallery->date->viewAttributes() ?>>
<?php echo $gallery->date->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($gallery->description->Visible) { // description ?>
		<td<?php echo $gallery->description->cellAttributes() ?>>
<span id="el<?php echo $gallery_delete->RowCnt ?>_gallery_description" class="gallery_description">
<span<?php echo $gallery->description->viewAttributes() ?>>
<?php echo $gallery->description->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($gallery->image->Visible) { // image ?>
		<td<?php echo $gallery->image->cellAttributes() ?>>
<span id="el<?php echo $gallery_delete->RowCnt ?>_gallery_image" class="gallery_image">
<span>
<?php echo GetFileViewTag($gallery->image, $gallery->image->getViewValue()) ?>
</span>
</span>
</td>
<?php } ?>
<?php if ($gallery->video_link->Visible) { // video_link ?>
		<td<?php echo $gallery->video_link->cellAttributes() ?>>
<span id="el<?php echo $gallery_delete->RowCnt ?>_gallery_video_link" class="gallery_video_link">
<span<?php echo $gallery->video_link->viewAttributes() ?>>
<?php echo $gallery->video_link->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($gallery->operator->Visible) { // operator ?>
		<td<?php echo $gallery->operator->cellAttributes() ?>>
<span id="el<?php echo $gallery_delete->RowCnt ?>_gallery_operator" class="gallery_operator">
<span<?php echo $gallery->operator->viewAttributes() ?>>
<?php echo $gallery->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($gallery->datetime->Visible) { // datetime ?>
		<td<?php echo $gallery->datetime->cellAttributes() ?>>
<span id="el<?php echo $gallery_delete->RowCnt ?>_gallery_datetime" class="gallery_datetime">
<span<?php echo $gallery->datetime->viewAttributes() ?>>
<?php echo $gallery->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$gallery_delete->Recordset->moveNext();
}
$gallery_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $gallery_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$gallery_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$gallery_delete->terminate();
?>