<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$gallery_edit = new gallery_edit();

// Run the page
$gallery_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$gallery_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fgalleryedit = currentForm = new ew.Form("fgalleryedit", "edit");

// Validate form
fgalleryedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($gallery_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $gallery->id->caption(), $gallery->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($gallery_edit->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $gallery->type->caption(), $gallery->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($gallery_edit->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $gallery->category->caption(), $gallery->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($gallery_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $gallery->grp->caption(), $gallery->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($gallery_edit->date->Required) { ?>
			elm = this.getElements("x" + infix + "_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $gallery->date->caption(), $gallery->date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($gallery->date->errorMessage()) ?>");
		<?php if ($gallery_edit->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $gallery->description->caption(), $gallery->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($gallery_edit->detailed_description->Required) { ?>
			elm = this.getElements("x" + infix + "_detailed_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $gallery->detailed_description->caption(), $gallery->detailed_description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($gallery_edit->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $gallery->image->caption(), $gallery->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($gallery_edit->video_link->Required) { ?>
			elm = this.getElements("x" + infix + "_video_link");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $gallery->video_link->caption(), $gallery->video_link->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($gallery_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $gallery->operator->caption(), $gallery->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($gallery_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $gallery->datetime->caption(), $gallery->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fgalleryedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgalleryedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgalleryedit.lists["x_type"] = <?php echo $gallery_edit->type->Lookup->toClientList() ?>;
fgalleryedit.lists["x_type"].options = <?php echo JsonEncode($gallery_edit->type->options(FALSE, TRUE)) ?>;
fgalleryedit.lists["x_category[]"] = <?php echo $gallery_edit->category->Lookup->toClientList() ?>;
fgalleryedit.lists["x_category[]"].options = <?php echo JsonEncode($gallery_edit->category->lookupOptions()) ?>;
fgalleryedit.lists["x_grp"] = <?php echo $gallery_edit->grp->Lookup->toClientList() ?>;
fgalleryedit.lists["x_grp"].options = <?php echo JsonEncode($gallery_edit->grp->lookupOptions()) ?>;
fgalleryedit.autoSuggests["x_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $gallery_edit->showPageHeader(); ?>
<?php
$gallery_edit->showMessage();
?>
<form name="fgalleryedit" id="fgalleryedit" class="<?php echo $gallery_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($gallery_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $gallery_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="gallery">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$gallery_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($gallery->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_gallery_id" class="<?php echo $gallery_edit->LeftColumnClass ?>"><?php echo $gallery->id->caption() ?><?php echo ($gallery->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $gallery_edit->RightColumnClass ?>"><div<?php echo $gallery->id->cellAttributes() ?>>
<span id="el_gallery_id">
<span<?php echo $gallery->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($gallery->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="gallery" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($gallery->id->CurrentValue) ?>">
<?php echo $gallery->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($gallery->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_gallery_type" for="x_type" class="<?php echo $gallery_edit->LeftColumnClass ?>"><?php echo $gallery->type->caption() ?><?php echo ($gallery->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $gallery_edit->RightColumnClass ?>"><div<?php echo $gallery->type->cellAttributes() ?>>
<span id="el_gallery_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gallery" data-field="x_type" data-value-separator="<?php echo $gallery->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $gallery->type->editAttributes() ?>>
		<?php echo $gallery->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
<?php echo $gallery->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($gallery->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_gallery_category" for="x_category" class="<?php echo $gallery_edit->LeftColumnClass ?>"><?php echo $gallery->category->caption() ?><?php echo ($gallery->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $gallery_edit->RightColumnClass ?>"><div<?php echo $gallery->category->cellAttributes() ?>>
<span id="el_gallery_category">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_category"><?php echo strval($gallery->category->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($gallery->category->ViewValue) : $gallery->category->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($gallery->category->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($gallery->category->ReadOnly || $gallery->category->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_category[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "gallery_misc") && !$gallery->category->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_category" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $gallery->category->caption() ?>" data-title="<?php echo $gallery->category->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_category[]',url:'gallery_miscaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
	</div>
</div>
<?php echo $gallery->category->Lookup->getParamTag("p_x_category") ?>
<input type="hidden" data-table="gallery" data-field="x_category" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $gallery->category->displayValueSeparatorAttribute() ?>" name="x_category[]" id="x_category[]" value="<?php echo $gallery->category->CurrentValue ?>"<?php echo $gallery->category->editAttributes() ?>>
</span>
<?php echo $gallery->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($gallery->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_gallery_grp" class="<?php echo $gallery_edit->LeftColumnClass ?>"><?php echo $gallery->grp->caption() ?><?php echo ($gallery->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $gallery_edit->RightColumnClass ?>"><div<?php echo $gallery->grp->cellAttributes() ?>>
<span id="el_gallery_grp">
<?php
$wrkonchange = "" . trim(@$gallery->grp->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$gallery->grp->EditAttrs["onchange"] = "";
?>
<span id="as_x_grp" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_grp" id="sv_x_grp" value="<?php echo RemoveHtml($gallery->grp->EditValue) ?>" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($gallery->grp->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($gallery->grp->getPlaceHolder()) ?>"<?php echo $gallery->grp->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($gallery->grp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_grp',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($gallery->grp->ReadOnly || $gallery->grp->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="gallery" data-field="x_grp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $gallery->grp->displayValueSeparatorAttribute() ?>" name="x_grp" id="x_grp" value="<?php echo HtmlEncode($gallery->grp->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fgalleryedit.createAutoSuggest({"id":"x_grp","forceSelect":false});
</script>
<?php echo $gallery->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $gallery->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($gallery->date->Visible) { // date ?>
	<div id="r_date" class="form-group row">
		<label id="elh_gallery_date" for="x_date" class="<?php echo $gallery_edit->LeftColumnClass ?>"><?php echo $gallery->date->caption() ?><?php echo ($gallery->date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $gallery_edit->RightColumnClass ?>"><div<?php echo $gallery->date->cellAttributes() ?>>
<span id="el_gallery_date">
<input type="text" data-table="gallery" data-field="x_date" name="x_date" id="x_date" placeholder="<?php echo HtmlEncode($gallery->date->getPlaceHolder()) ?>" value="<?php echo $gallery->date->EditValue ?>"<?php echo $gallery->date->editAttributes() ?>>
<?php if (!$gallery->date->ReadOnly && !$gallery->date->Disabled && !isset($gallery->date->EditAttrs["readonly"]) && !isset($gallery->date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fgalleryedit", "x_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $gallery->date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($gallery->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_gallery_description" for="x_description" class="<?php echo $gallery_edit->LeftColumnClass ?>"><?php echo $gallery->description->caption() ?><?php echo ($gallery->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $gallery_edit->RightColumnClass ?>"><div<?php echo $gallery->description->cellAttributes() ?>>
<span id="el_gallery_description">
<input type="text" data-table="gallery" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="252" placeholder="<?php echo HtmlEncode($gallery->description->getPlaceHolder()) ?>" value="<?php echo $gallery->description->EditValue ?>"<?php echo $gallery->description->editAttributes() ?>>
</span>
<?php echo $gallery->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($gallery->detailed_description->Visible) { // detailed_description ?>
	<div id="r_detailed_description" class="form-group row">
		<label id="elh_gallery_detailed_description" for="x_detailed_description" class="<?php echo $gallery_edit->LeftColumnClass ?>"><?php echo $gallery->detailed_description->caption() ?><?php echo ($gallery->detailed_description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $gallery_edit->RightColumnClass ?>"><div<?php echo $gallery->detailed_description->cellAttributes() ?>>
<span id="el_gallery_detailed_description">
<textarea data-table="gallery" data-field="x_detailed_description" name="x_detailed_description" id="x_detailed_description" cols="35" rows="4" placeholder="<?php echo HtmlEncode($gallery->detailed_description->getPlaceHolder()) ?>"<?php echo $gallery->detailed_description->editAttributes() ?>><?php echo $gallery->detailed_description->EditValue ?></textarea>
</span>
<?php echo $gallery->detailed_description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($gallery->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_gallery_image" class="<?php echo $gallery_edit->LeftColumnClass ?>"><?php echo $gallery->image->caption() ?><?php echo ($gallery->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $gallery_edit->RightColumnClass ?>"><div<?php echo $gallery->image->cellAttributes() ?>>
<span id="el_gallery_image">
<div id="fd_x_image">
<span title="<?php echo $gallery->image->title() ? $gallery->image->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($gallery->image->ReadOnly || $gallery->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="gallery" data-field="x_image" name="x_image" id="x_image" multiple="multiple"<?php echo $gallery->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $gallery->image->Upload->FileName ?>">
<?php if (Post("fa_x_image") == "0") { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="16777215">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $gallery->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $gallery->image->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_image" id= "fc_x_image" value="<?php echo $gallery->image->UploadMaxFileCount ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $gallery->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($gallery->video_link->Visible) { // video_link ?>
	<div id="r_video_link" class="form-group row">
		<label id="elh_gallery_video_link" for="x_video_link" class="<?php echo $gallery_edit->LeftColumnClass ?>"><?php echo $gallery->video_link->caption() ?><?php echo ($gallery->video_link->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $gallery_edit->RightColumnClass ?>"><div<?php echo $gallery->video_link->cellAttributes() ?>>
<span id="el_gallery_video_link">
<textarea data-table="gallery" data-field="x_video_link" name="x_video_link" id="x_video_link" cols="35" rows="4" placeholder="<?php echo HtmlEncode($gallery->video_link->getPlaceHolder()) ?>"<?php echo $gallery->video_link->editAttributes() ?>><?php echo $gallery->video_link->EditValue ?></textarea>
</span>
<?php echo $gallery->video_link->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$gallery_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $gallery_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $gallery_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$gallery_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$gallery_edit->terminate();
?>