<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$gallery_list = new gallery_list();

// Run the page
$gallery_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$gallery_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$gallery->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fgallerylist = currentForm = new ew.Form("fgallerylist", "list");
fgallerylist.formKeyCountName = '<?php echo $gallery_list->FormKeyCountName ?>';

// Form_CustomValidate event
fgallerylist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgallerylist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgallerylist.lists["x_type"] = <?php echo $gallery_list->type->Lookup->toClientList() ?>;
fgallerylist.lists["x_type"].options = <?php echo JsonEncode($gallery_list->type->options(FALSE, TRUE)) ?>;
fgallerylist.lists["x_category[]"] = <?php echo $gallery_list->category->Lookup->toClientList() ?>;
fgallerylist.lists["x_category[]"].options = <?php echo JsonEncode($gallery_list->category->lookupOptions()) ?>;
fgallerylist.lists["x_grp"] = <?php echo $gallery_list->grp->Lookup->toClientList() ?>;
fgallerylist.lists["x_grp"].options = <?php echo JsonEncode($gallery_list->grp->lookupOptions()) ?>;
fgallerylist.autoSuggests["x_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fgallerylistsrch = currentSearchForm = new ew.Form("fgallerylistsrch");

// Filters
fgallerylistsrch.filterList = <?php echo $gallery_list->getFilterList() ?>;

// Init search panel as collapsed
fgallerylistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$gallery->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($gallery_list->TotalRecs > 0 && $gallery_list->ExportOptions->visible()) { ?>
<?php $gallery_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($gallery_list->ImportOptions->visible()) { ?>
<?php $gallery_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($gallery_list->SearchOptions->visible()) { ?>
<?php $gallery_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($gallery_list->FilterOptions->visible()) { ?>
<?php $gallery_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$gallery_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$gallery->isExport() && !$gallery->CurrentAction) { ?>
<form name="fgallerylistsrch" id="fgallerylistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($gallery_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fgallerylistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="gallery">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($gallery_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($gallery_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $gallery_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($gallery_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($gallery_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($gallery_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($gallery_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $gallery_list->showPageHeader(); ?>
<?php
$gallery_list->showMessage();
?>
<?php if ($gallery_list->TotalRecs > 0 || $gallery->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($gallery_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> gallery">
<?php if (!$gallery->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$gallery->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($gallery_list->Pager)) $gallery_list->Pager = new PrevNextPager($gallery_list->StartRec, $gallery_list->DisplayRecs, $gallery_list->TotalRecs, $gallery_list->AutoHidePager) ?>
<?php if ($gallery_list->Pager->RecordCount > 0 && $gallery_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($gallery_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $gallery_list->pageUrl() ?>start=<?php echo $gallery_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($gallery_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $gallery_list->pageUrl() ?>start=<?php echo $gallery_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $gallery_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($gallery_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $gallery_list->pageUrl() ?>start=<?php echo $gallery_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($gallery_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $gallery_list->pageUrl() ?>start=<?php echo $gallery_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $gallery_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($gallery_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $gallery_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $gallery_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $gallery_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($gallery_list->TotalRecs > 0 && (!$gallery_list->AutoHidePageSizeSelector || $gallery_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="gallery">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($gallery_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($gallery_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($gallery_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($gallery_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($gallery_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($gallery->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $gallery_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fgallerylist" id="fgallerylist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($gallery_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $gallery_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="gallery">
<div id="gmp_gallery" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($gallery_list->TotalRecs > 0 || $gallery->isGridEdit()) { ?>
<table id="tbl_gallerylist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$gallery_list->RowType = ROWTYPE_HEADER;

// Render list options
$gallery_list->renderListOptions();

// Render list options (header, left)
$gallery_list->ListOptions->render("header", "left");
?>
<?php if ($gallery->id->Visible) { // id ?>
	<?php if ($gallery->sortUrl($gallery->id) == "") { ?>
		<th data-name="id" class="<?php echo $gallery->id->headerCellClass() ?>"><div id="elh_gallery_id" class="gallery_id"><div class="ew-table-header-caption"><?php echo $gallery->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $gallery->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gallery->SortUrl($gallery->id) ?>',2);"><div id="elh_gallery_id" class="gallery_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gallery->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($gallery->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gallery->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gallery->type->Visible) { // type ?>
	<?php if ($gallery->sortUrl($gallery->type) == "") { ?>
		<th data-name="type" class="<?php echo $gallery->type->headerCellClass() ?>"><div id="elh_gallery_type" class="gallery_type"><div class="ew-table-header-caption"><?php echo $gallery->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $gallery->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gallery->SortUrl($gallery->type) ?>',2);"><div id="elh_gallery_type" class="gallery_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gallery->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($gallery->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gallery->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gallery->category->Visible) { // category ?>
	<?php if ($gallery->sortUrl($gallery->category) == "") { ?>
		<th data-name="category" class="<?php echo $gallery->category->headerCellClass() ?>"><div id="elh_gallery_category" class="gallery_category"><div class="ew-table-header-caption"><?php echo $gallery->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $gallery->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gallery->SortUrl($gallery->category) ?>',2);"><div id="elh_gallery_category" class="gallery_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gallery->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($gallery->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gallery->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gallery->grp->Visible) { // grp ?>
	<?php if ($gallery->sortUrl($gallery->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $gallery->grp->headerCellClass() ?>"><div id="elh_gallery_grp" class="gallery_grp"><div class="ew-table-header-caption"><?php echo $gallery->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $gallery->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gallery->SortUrl($gallery->grp) ?>',2);"><div id="elh_gallery_grp" class="gallery_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gallery->grp->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($gallery->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gallery->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gallery->date->Visible) { // date ?>
	<?php if ($gallery->sortUrl($gallery->date) == "") { ?>
		<th data-name="date" class="<?php echo $gallery->date->headerCellClass() ?>"><div id="elh_gallery_date" class="gallery_date"><div class="ew-table-header-caption"><?php echo $gallery->date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="date" class="<?php echo $gallery->date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gallery->SortUrl($gallery->date) ?>',2);"><div id="elh_gallery_date" class="gallery_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gallery->date->caption() ?></span><span class="ew-table-header-sort"><?php if ($gallery->date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gallery->date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gallery->description->Visible) { // description ?>
	<?php if ($gallery->sortUrl($gallery->description) == "") { ?>
		<th data-name="description" class="<?php echo $gallery->description->headerCellClass() ?>"><div id="elh_gallery_description" class="gallery_description"><div class="ew-table-header-caption"><?php echo $gallery->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $gallery->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gallery->SortUrl($gallery->description) ?>',2);"><div id="elh_gallery_description" class="gallery_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gallery->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($gallery->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gallery->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gallery->image->Visible) { // image ?>
	<?php if ($gallery->sortUrl($gallery->image) == "") { ?>
		<th data-name="image" class="<?php echo $gallery->image->headerCellClass() ?>"><div id="elh_gallery_image" class="gallery_image"><div class="ew-table-header-caption"><?php echo $gallery->image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="image" class="<?php echo $gallery->image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gallery->SortUrl($gallery->image) ?>',2);"><div id="elh_gallery_image" class="gallery_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gallery->image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($gallery->image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gallery->image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gallery->video_link->Visible) { // video_link ?>
	<?php if ($gallery->sortUrl($gallery->video_link) == "") { ?>
		<th data-name="video_link" class="<?php echo $gallery->video_link->headerCellClass() ?>"><div id="elh_gallery_video_link" class="gallery_video_link"><div class="ew-table-header-caption"><?php echo $gallery->video_link->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="video_link" class="<?php echo $gallery->video_link->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gallery->SortUrl($gallery->video_link) ?>',2);"><div id="elh_gallery_video_link" class="gallery_video_link">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gallery->video_link->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($gallery->video_link->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gallery->video_link->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gallery->operator->Visible) { // operator ?>
	<?php if ($gallery->sortUrl($gallery->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $gallery->operator->headerCellClass() ?>"><div id="elh_gallery_operator" class="gallery_operator"><div class="ew-table-header-caption"><?php echo $gallery->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $gallery->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gallery->SortUrl($gallery->operator) ?>',2);"><div id="elh_gallery_operator" class="gallery_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gallery->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($gallery->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gallery->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gallery->datetime->Visible) { // datetime ?>
	<?php if ($gallery->sortUrl($gallery->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $gallery->datetime->headerCellClass() ?>"><div id="elh_gallery_datetime" class="gallery_datetime"><div class="ew-table-header-caption"><?php echo $gallery->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $gallery->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gallery->SortUrl($gallery->datetime) ?>',2);"><div id="elh_gallery_datetime" class="gallery_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gallery->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($gallery->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gallery->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$gallery_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($gallery->ExportAll && $gallery->isExport()) {
	$gallery_list->StopRec = $gallery_list->TotalRecs;
} else {

	// Set the last record to display
	if ($gallery_list->TotalRecs > $gallery_list->StartRec + $gallery_list->DisplayRecs - 1)
		$gallery_list->StopRec = $gallery_list->StartRec + $gallery_list->DisplayRecs - 1;
	else
		$gallery_list->StopRec = $gallery_list->TotalRecs;
}
$gallery_list->RecCnt = $gallery_list->StartRec - 1;
if ($gallery_list->Recordset && !$gallery_list->Recordset->EOF) {
	$gallery_list->Recordset->moveFirst();
	$selectLimit = $gallery_list->UseSelectLimit;
	if (!$selectLimit && $gallery_list->StartRec > 1)
		$gallery_list->Recordset->move($gallery_list->StartRec - 1);
} elseif (!$gallery->AllowAddDeleteRow && $gallery_list->StopRec == 0) {
	$gallery_list->StopRec = $gallery->GridAddRowCount;
}

// Initialize aggregate
$gallery->RowType = ROWTYPE_AGGREGATEINIT;
$gallery->resetAttributes();
$gallery_list->renderRow();
while ($gallery_list->RecCnt < $gallery_list->StopRec) {
	$gallery_list->RecCnt++;
	if ($gallery_list->RecCnt >= $gallery_list->StartRec) {
		$gallery_list->RowCnt++;

		// Set up key count
		$gallery_list->KeyCount = $gallery_list->RowIndex;

		// Init row class and style
		$gallery->resetAttributes();
		$gallery->CssClass = "";
		if ($gallery->isGridAdd()) {
		} else {
			$gallery_list->loadRowValues($gallery_list->Recordset); // Load row values
		}
		$gallery->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$gallery->RowAttrs = array_merge($gallery->RowAttrs, array('data-rowindex'=>$gallery_list->RowCnt, 'id'=>'r' . $gallery_list->RowCnt . '_gallery', 'data-rowtype'=>$gallery->RowType));

		// Render row
		$gallery_list->renderRow();

		// Render list options
		$gallery_list->renderListOptions();
?>
	<tr<?php echo $gallery->rowAttributes() ?>>
<?php

// Render list options (body, left)
$gallery_list->ListOptions->render("body", "left", $gallery_list->RowCnt);
?>
	<?php if ($gallery->id->Visible) { // id ?>
		<td data-name="id"<?php echo $gallery->id->cellAttributes() ?>>
<span id="el<?php echo $gallery_list->RowCnt ?>_gallery_id" class="gallery_id">
<span<?php echo $gallery->id->viewAttributes() ?>>
<?php echo $gallery->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gallery->type->Visible) { // type ?>
		<td data-name="type"<?php echo $gallery->type->cellAttributes() ?>>
<span id="el<?php echo $gallery_list->RowCnt ?>_gallery_type" class="gallery_type">
<span<?php echo $gallery->type->viewAttributes() ?>>
<?php echo $gallery->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gallery->category->Visible) { // category ?>
		<td data-name="category"<?php echo $gallery->category->cellAttributes() ?>>
<span id="el<?php echo $gallery_list->RowCnt ?>_gallery_category" class="gallery_category">
<span<?php echo $gallery->category->viewAttributes() ?>>
<?php echo $gallery->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gallery->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $gallery->grp->cellAttributes() ?>>
<span id="el<?php echo $gallery_list->RowCnt ?>_gallery_grp" class="gallery_grp">
<span<?php echo $gallery->grp->viewAttributes() ?>>
<?php echo $gallery->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gallery->date->Visible) { // date ?>
		<td data-name="date"<?php echo $gallery->date->cellAttributes() ?>>
<span id="el<?php echo $gallery_list->RowCnt ?>_gallery_date" class="gallery_date">
<span<?php echo $gallery->date->viewAttributes() ?>>
<?php echo $gallery->date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gallery->description->Visible) { // description ?>
		<td data-name="description"<?php echo $gallery->description->cellAttributes() ?>>
<span id="el<?php echo $gallery_list->RowCnt ?>_gallery_description" class="gallery_description">
<span<?php echo $gallery->description->viewAttributes() ?>>
<?php echo $gallery->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gallery->image->Visible) { // image ?>
		<td data-name="image"<?php echo $gallery->image->cellAttributes() ?>>
<span id="el<?php echo $gallery_list->RowCnt ?>_gallery_image" class="gallery_image">
<span>
<?php echo GetFileViewTag($gallery->image, $gallery->image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gallery->video_link->Visible) { // video_link ?>
		<td data-name="video_link"<?php echo $gallery->video_link->cellAttributes() ?>>
<span id="el<?php echo $gallery_list->RowCnt ?>_gallery_video_link" class="gallery_video_link">
<span<?php echo $gallery->video_link->viewAttributes() ?>>
<?php echo $gallery->video_link->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gallery->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $gallery->operator->cellAttributes() ?>>
<span id="el<?php echo $gallery_list->RowCnt ?>_gallery_operator" class="gallery_operator">
<span<?php echo $gallery->operator->viewAttributes() ?>>
<?php echo $gallery->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gallery->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $gallery->datetime->cellAttributes() ?>>
<span id="el<?php echo $gallery_list->RowCnt ?>_gallery_datetime" class="gallery_datetime">
<span<?php echo $gallery->datetime->viewAttributes() ?>>
<?php echo $gallery->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$gallery_list->ListOptions->render("body", "right", $gallery_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$gallery->isGridAdd())
		$gallery_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$gallery->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($gallery_list->Recordset)
	$gallery_list->Recordset->Close();
?>
<?php if (!$gallery->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$gallery->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($gallery_list->Pager)) $gallery_list->Pager = new PrevNextPager($gallery_list->StartRec, $gallery_list->DisplayRecs, $gallery_list->TotalRecs, $gallery_list->AutoHidePager) ?>
<?php if ($gallery_list->Pager->RecordCount > 0 && $gallery_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($gallery_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $gallery_list->pageUrl() ?>start=<?php echo $gallery_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($gallery_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $gallery_list->pageUrl() ?>start=<?php echo $gallery_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $gallery_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($gallery_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $gallery_list->pageUrl() ?>start=<?php echo $gallery_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($gallery_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $gallery_list->pageUrl() ?>start=<?php echo $gallery_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $gallery_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($gallery_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $gallery_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $gallery_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $gallery_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($gallery_list->TotalRecs > 0 && (!$gallery_list->AutoHidePageSizeSelector || $gallery_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="gallery">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($gallery_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($gallery_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($gallery_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($gallery_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($gallery_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($gallery->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $gallery_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($gallery_list->TotalRecs == 0 && !$gallery->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $gallery_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$gallery_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$gallery->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$gallery_list->terminate();
?>