<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$gallery_view = new gallery_view();

// Run the page
$gallery_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$gallery_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$gallery->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fgalleryview = currentForm = new ew.Form("fgalleryview", "view");

// Form_CustomValidate event
fgalleryview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgalleryview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgalleryview.lists["x_type"] = <?php echo $gallery_view->type->Lookup->toClientList() ?>;
fgalleryview.lists["x_type"].options = <?php echo JsonEncode($gallery_view->type->options(FALSE, TRUE)) ?>;
fgalleryview.lists["x_category[]"] = <?php echo $gallery_view->category->Lookup->toClientList() ?>;
fgalleryview.lists["x_category[]"].options = <?php echo JsonEncode($gallery_view->category->lookupOptions()) ?>;
fgalleryview.lists["x_grp"] = <?php echo $gallery_view->grp->Lookup->toClientList() ?>;
fgalleryview.lists["x_grp"].options = <?php echo JsonEncode($gallery_view->grp->lookupOptions()) ?>;
fgalleryview.autoSuggests["x_grp"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$gallery->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $gallery_view->ExportOptions->render("body") ?>
<?php $gallery_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $gallery_view->showPageHeader(); ?>
<?php
$gallery_view->showMessage();
?>
<form name="fgalleryview" id="fgalleryview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($gallery_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $gallery_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="gallery">
<input type="hidden" name="modal" value="<?php echo (int)$gallery_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($gallery->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $gallery_view->TableLeftColumnClass ?>"><span id="elh_gallery_id"><?php echo $gallery->id->caption() ?></span></td>
		<td data-name="id"<?php echo $gallery->id->cellAttributes() ?>>
<span id="el_gallery_id">
<span<?php echo $gallery->id->viewAttributes() ?>>
<?php echo $gallery->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($gallery->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $gallery_view->TableLeftColumnClass ?>"><span id="elh_gallery_type"><?php echo $gallery->type->caption() ?></span></td>
		<td data-name="type"<?php echo $gallery->type->cellAttributes() ?>>
<span id="el_gallery_type">
<span<?php echo $gallery->type->viewAttributes() ?>>
<?php echo $gallery->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($gallery->category->Visible) { // category ?>
	<tr id="r_category">
		<td class="<?php echo $gallery_view->TableLeftColumnClass ?>"><span id="elh_gallery_category"><?php echo $gallery->category->caption() ?></span></td>
		<td data-name="category"<?php echo $gallery->category->cellAttributes() ?>>
<span id="el_gallery_category">
<span<?php echo $gallery->category->viewAttributes() ?>>
<?php echo $gallery->category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($gallery->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $gallery_view->TableLeftColumnClass ?>"><span id="elh_gallery_grp"><?php echo $gallery->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $gallery->grp->cellAttributes() ?>>
<span id="el_gallery_grp">
<span<?php echo $gallery->grp->viewAttributes() ?>>
<?php echo $gallery->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($gallery->date->Visible) { // date ?>
	<tr id="r_date">
		<td class="<?php echo $gallery_view->TableLeftColumnClass ?>"><span id="elh_gallery_date"><?php echo $gallery->date->caption() ?></span></td>
		<td data-name="date"<?php echo $gallery->date->cellAttributes() ?>>
<span id="el_gallery_date">
<span<?php echo $gallery->date->viewAttributes() ?>>
<?php echo $gallery->date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($gallery->description->Visible) { // description ?>
	<tr id="r_description">
		<td class="<?php echo $gallery_view->TableLeftColumnClass ?>"><span id="elh_gallery_description"><?php echo $gallery->description->caption() ?></span></td>
		<td data-name="description"<?php echo $gallery->description->cellAttributes() ?>>
<span id="el_gallery_description">
<span<?php echo $gallery->description->viewAttributes() ?>>
<?php echo $gallery->description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($gallery->detailed_description->Visible) { // detailed_description ?>
	<tr id="r_detailed_description">
		<td class="<?php echo $gallery_view->TableLeftColumnClass ?>"><span id="elh_gallery_detailed_description"><?php echo $gallery->detailed_description->caption() ?></span></td>
		<td data-name="detailed_description"<?php echo $gallery->detailed_description->cellAttributes() ?>>
<span id="el_gallery_detailed_description">
<span<?php echo $gallery->detailed_description->viewAttributes() ?>>
<?php echo $gallery->detailed_description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($gallery->image->Visible) { // image ?>
	<tr id="r_image">
		<td class="<?php echo $gallery_view->TableLeftColumnClass ?>"><span id="elh_gallery_image"><?php echo $gallery->image->caption() ?></span></td>
		<td data-name="image"<?php echo $gallery->image->cellAttributes() ?>>
<span id="el_gallery_image">
<span>
<?php echo GetFileViewTag($gallery->image, $gallery->image->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($gallery->video_link->Visible) { // video_link ?>
	<tr id="r_video_link">
		<td class="<?php echo $gallery_view->TableLeftColumnClass ?>"><span id="elh_gallery_video_link"><?php echo $gallery->video_link->caption() ?></span></td>
		<td data-name="video_link"<?php echo $gallery->video_link->cellAttributes() ?>>
<span id="el_gallery_video_link">
<span<?php echo $gallery->video_link->viewAttributes() ?>>
<?php echo $gallery->video_link->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($gallery->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $gallery_view->TableLeftColumnClass ?>"><span id="elh_gallery_operator"><?php echo $gallery->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $gallery->operator->cellAttributes() ?>>
<span id="el_gallery_operator">
<span<?php echo $gallery->operator->viewAttributes() ?>>
<?php echo $gallery->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($gallery->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $gallery_view->TableLeftColumnClass ?>"><span id="elh_gallery_datetime"><?php echo $gallery->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $gallery->datetime->cellAttributes() ?>>
<span id="el_gallery_datetime">
<span<?php echo $gallery->datetime->viewAttributes() ?>>
<?php echo $gallery->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$gallery_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$gallery->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$gallery_view->terminate();
?>