<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$gate_pass_received_list = new gate_pass_received_list();

// Run the page
$gate_pass_received_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$gate_pass_received_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$gate_pass_received->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fgate_pass_receivedlist = currentForm = new ew.Form("fgate_pass_receivedlist", "list");
fgate_pass_receivedlist.formKeyCountName = '<?php echo $gate_pass_received_list->FormKeyCountName ?>';

// Form_CustomValidate event
fgate_pass_receivedlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgate_pass_receivedlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgate_pass_receivedlist.lists["x_from"] = <?php echo $gate_pass_received_list->from->Lookup->toClientList() ?>;
fgate_pass_receivedlist.lists["x_from"].options = <?php echo JsonEncode($gate_pass_received_list->from->lookupOptions()) ?>;
fgate_pass_receivedlist.autoSuggests["x_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fgate_pass_receivedlist.lists["x_to"] = <?php echo $gate_pass_received_list->to->Lookup->toClientList() ?>;
fgate_pass_receivedlist.lists["x_to"].options = <?php echo JsonEncode($gate_pass_received_list->to->lookupOptions()) ?>;
fgate_pass_receivedlist.lists["x_attention"] = <?php echo $gate_pass_received_list->attention->Lookup->toClientList() ?>;
fgate_pass_receivedlist.lists["x_attention"].options = <?php echo JsonEncode($gate_pass_received_list->attention->lookupOptions()) ?>;
fgate_pass_receivedlist.lists["x_transfer_nature"] = <?php echo $gate_pass_received_list->transfer_nature->Lookup->toClientList() ?>;
fgate_pass_receivedlist.lists["x_transfer_nature"].options = <?php echo JsonEncode($gate_pass_received_list->transfer_nature->options(FALSE, TRUE)) ?>;
fgate_pass_receivedlist.lists["x_t_mode"] = <?php echo $gate_pass_received_list->t_mode->Lookup->toClientList() ?>;
fgate_pass_receivedlist.lists["x_t_mode"].options = <?php echo JsonEncode($gate_pass_received_list->t_mode->options(FALSE, TRUE)) ?>;
fgate_pass_receivedlist.lists["x_operator"] = <?php echo $gate_pass_received_list->operator->Lookup->toClientList() ?>;
fgate_pass_receivedlist.lists["x_operator"].options = <?php echo JsonEncode($gate_pass_received_list->operator->lookupOptions()) ?>;
fgate_pass_receivedlist.lists["x_receiving_condition"] = <?php echo $gate_pass_received_list->receiving_condition->Lookup->toClientList() ?>;
fgate_pass_receivedlist.lists["x_receiving_condition"].options = <?php echo JsonEncode($gate_pass_received_list->receiving_condition->options(FALSE, TRUE)) ?>;
fgate_pass_receivedlist.lists["x_r_operator"] = <?php echo $gate_pass_received_list->r_operator->Lookup->toClientList() ?>;
fgate_pass_receivedlist.lists["x_r_operator"].options = <?php echo JsonEncode($gate_pass_received_list->r_operator->lookupOptions()) ?>;
fgate_pass_receivedlist.lists["x_jc_no"] = <?php echo $gate_pass_received_list->jc_no->Lookup->toClientList() ?>;
fgate_pass_receivedlist.lists["x_jc_no"].options = <?php echo JsonEncode($gate_pass_received_list->jc_no->lookupOptions()) ?>;

// Form object for search
var fgate_pass_receivedlistsrch = currentSearchForm = new ew.Form("fgate_pass_receivedlistsrch");

// Validate function for search
fgate_pass_receivedlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_gp_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass_received->gp_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_from");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass_received->from->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fgate_pass_receivedlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgate_pass_receivedlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgate_pass_receivedlistsrch.lists["x_from"] = <?php echo $gate_pass_received_list->from->Lookup->toClientList() ?>;
fgate_pass_receivedlistsrch.lists["x_from"].options = <?php echo JsonEncode($gate_pass_received_list->from->lookupOptions()) ?>;
fgate_pass_receivedlistsrch.autoSuggests["x_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fgate_pass_receivedlistsrch.lists["x_to"] = <?php echo $gate_pass_received_list->to->Lookup->toClientList() ?>;
fgate_pass_receivedlistsrch.lists["x_to"].options = <?php echo JsonEncode($gate_pass_received_list->to->lookupOptions()) ?>;
fgate_pass_receivedlistsrch.lists["x_receiving_condition"] = <?php echo $gate_pass_received_list->receiving_condition->Lookup->toClientList() ?>;
fgate_pass_receivedlistsrch.lists["x_receiving_condition"].options = <?php echo JsonEncode($gate_pass_received_list->receiving_condition->options(FALSE, TRUE)) ?>;

// Filters
fgate_pass_receivedlistsrch.filterList = <?php echo $gate_pass_received_list->getFilterList() ?>;

// Init search panel as collapsed
fgate_pass_receivedlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$gate_pass_received->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($gate_pass_received_list->TotalRecs > 0 && $gate_pass_received_list->ExportOptions->visible()) { ?>
<?php $gate_pass_received_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($gate_pass_received_list->ImportOptions->visible()) { ?>
<?php $gate_pass_received_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($gate_pass_received_list->SearchOptions->visible()) { ?>
<?php $gate_pass_received_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($gate_pass_received_list->FilterOptions->visible()) { ?>
<?php $gate_pass_received_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$gate_pass_received_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$gate_pass_received->isExport() && !$gate_pass_received->CurrentAction) { ?>
<form name="fgate_pass_receivedlistsrch" id="fgate_pass_receivedlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($gate_pass_received_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fgate_pass_receivedlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="gate_pass_received">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$gate_pass_received_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$gate_pass_received->RowType = ROWTYPE_SEARCH;

// Render row
$gate_pass_received->resetAttributes();
$gate_pass_received_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($gate_pass_received->gp_no->Visible) { // gp_no ?>
	<div id="xsc_gp_no" class="ew-cell form-group">
		<label for="x_gp_no" class="ew-search-caption ew-label"><?php echo $gate_pass_received->gp_no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gp_no" id="z_gp_no" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="gate_pass_received" data-field="x_gp_no" name="x_gp_no" id="x_gp_no" size="30" placeholder="<?php echo HtmlEncode($gate_pass_received->gp_no->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->gp_no->EditValue ?>"<?php echo $gate_pass_received->gp_no->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($gate_pass_received->from->Visible) { // from ?>
	<div id="xsc_from" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $gate_pass_received->from->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_from" id="z_from" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$gate_pass_received->from->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$gate_pass_received->from->EditAttrs["onchange"] = "";
?>
<span id="as_x_from" class="text-nowrap" style="z-index: 8970">
	<input type="text" class="form-control" name="sv_x_from" id="sv_x_from" value="<?php echo RemoveHtml($gate_pass_received->from->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($gate_pass_received->from->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($gate_pass_received->from->getPlaceHolder()) ?>"<?php echo $gate_pass_received->from->editAttributes() ?>>
</span>
<input type="hidden" data-table="gate_pass_received" data-field="x_from" data-value-separator="<?php echo $gate_pass_received->from->displayValueSeparatorAttribute() ?>" name="x_from" id="x_from" value="<?php echo HtmlEncode($gate_pass_received->from->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fgate_pass_receivedlistsrch.createAutoSuggest({"id":"x_from","forceSelect":false});
</script>
<?php echo $gate_pass_received->from->Lookup->getParamTag("p_x_from") ?>
</span>
	</div>
<?php } ?>
<?php if ($gate_pass_received->to->Visible) { // to ?>
	<div id="xsc_to" class="ew-cell form-group">
		<label for="x_to" class="ew-search-caption ew-label"><?php echo $gate_pass_received->to->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_to" id="z_to" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass_received" data-field="x_to" data-value-separator="<?php echo $gate_pass_received->to->displayValueSeparatorAttribute() ?>" id="x_to" name="x_to"<?php echo $gate_pass_received->to->editAttributes() ?>>
		<?php echo $gate_pass_received->to->selectOptionListHtml("x_to") ?>
	</select>
</div>
<?php echo $gate_pass_received->to->Lookup->getParamTag("p_x_to") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($gate_pass_received->receiving_condition->Visible) { // receiving_condition ?>
	<div id="xsc_receiving_condition" class="ew-cell form-group">
		<label for="x_receiving_condition" class="ew-search-caption ew-label"><?php echo $gate_pass_received->receiving_condition->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_receiving_condition" id="z_receiving_condition" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass_received" data-field="x_receiving_condition" data-value-separator="<?php echo $gate_pass_received->receiving_condition->displayValueSeparatorAttribute() ?>" id="x_receiving_condition" name="x_receiving_condition"<?php echo $gate_pass_received->receiving_condition->editAttributes() ?>>
		<?php echo $gate_pass_received->receiving_condition->selectOptionListHtml("x_receiving_condition") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($gate_pass_received_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($gate_pass_received_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $gate_pass_received_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($gate_pass_received_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($gate_pass_received_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($gate_pass_received_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($gate_pass_received_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $gate_pass_received_list->showPageHeader(); ?>
<?php
$gate_pass_received_list->showMessage();
?>
<?php if ($gate_pass_received_list->TotalRecs > 0 || $gate_pass_received->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($gate_pass_received_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> gate_pass_received">
<?php if (!$gate_pass_received->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$gate_pass_received->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($gate_pass_received_list->Pager)) $gate_pass_received_list->Pager = new PrevNextPager($gate_pass_received_list->StartRec, $gate_pass_received_list->DisplayRecs, $gate_pass_received_list->TotalRecs, $gate_pass_received_list->AutoHidePager) ?>
<?php if ($gate_pass_received_list->Pager->RecordCount > 0 && $gate_pass_received_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($gate_pass_received_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $gate_pass_received_list->pageUrl() ?>start=<?php echo $gate_pass_received_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($gate_pass_received_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $gate_pass_received_list->pageUrl() ?>start=<?php echo $gate_pass_received_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $gate_pass_received_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($gate_pass_received_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $gate_pass_received_list->pageUrl() ?>start=<?php echo $gate_pass_received_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($gate_pass_received_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $gate_pass_received_list->pageUrl() ?>start=<?php echo $gate_pass_received_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $gate_pass_received_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($gate_pass_received_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $gate_pass_received_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $gate_pass_received_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $gate_pass_received_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($gate_pass_received_list->TotalRecs > 0 && (!$gate_pass_received_list->AutoHidePageSizeSelector || $gate_pass_received_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="gate_pass_received">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($gate_pass_received_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($gate_pass_received_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($gate_pass_received_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($gate_pass_received_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($gate_pass_received_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($gate_pass_received->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $gate_pass_received_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fgate_pass_receivedlist" id="fgate_pass_receivedlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($gate_pass_received_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $gate_pass_received_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="gate_pass_received">
<div id="gmp_gate_pass_received" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($gate_pass_received_list->TotalRecs > 0 || $gate_pass_received->isGridEdit()) { ?>
<table id="tbl_gate_pass_receivedlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$gate_pass_received_list->RowType = ROWTYPE_HEADER;

// Render list options
$gate_pass_received_list->renderListOptions();

// Render list options (header, left)
$gate_pass_received_list->ListOptions->render("header", "left");
?>
<?php if ($gate_pass_received->gp_no->Visible) { // gp_no ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->gp_no) == "") { ?>
		<th data-name="gp_no" class="<?php echo $gate_pass_received->gp_no->headerCellClass() ?>"><div id="elh_gate_pass_received_gp_no" class="gate_pass_received_gp_no"><div class="ew-table-header-caption"><?php echo $gate_pass_received->gp_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gp_no" class="<?php echo $gate_pass_received->gp_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->gp_no) ?>',2);"><div id="elh_gate_pass_received_gp_no" class="gate_pass_received_gp_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->gp_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->gp_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->gp_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->from->Visible) { // from ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->from) == "") { ?>
		<th data-name="from" class="<?php echo $gate_pass_received->from->headerCellClass() ?>"><div id="elh_gate_pass_received_from" class="gate_pass_received_from"><div class="ew-table-header-caption"><?php echo $gate_pass_received->from->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="from" class="<?php echo $gate_pass_received->from->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->from) ?>',2);"><div id="elh_gate_pass_received_from" class="gate_pass_received_from">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->from->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->from->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->from->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->to->Visible) { // to ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->to) == "") { ?>
		<th data-name="to" class="<?php echo $gate_pass_received->to->headerCellClass() ?>"><div id="elh_gate_pass_received_to" class="gate_pass_received_to"><div class="ew-table-header-caption"><?php echo $gate_pass_received->to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="to" class="<?php echo $gate_pass_received->to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->to) ?>',2);"><div id="elh_gate_pass_received_to" class="gate_pass_received_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->to->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->attention->Visible) { // attention ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->attention) == "") { ?>
		<th data-name="attention" class="<?php echo $gate_pass_received->attention->headerCellClass() ?>"><div id="elh_gate_pass_received_attention" class="gate_pass_received_attention"><div class="ew-table-header-caption"><?php echo $gate_pass_received->attention->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="attention" class="<?php echo $gate_pass_received->attention->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->attention) ?>',2);"><div id="elh_gate_pass_received_attention" class="gate_pass_received_attention">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->attention->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->attention->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->attention->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->transfer_nature->Visible) { // transfer_nature ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->transfer_nature) == "") { ?>
		<th data-name="transfer_nature" class="<?php echo $gate_pass_received->transfer_nature->headerCellClass() ?>"><div id="elh_gate_pass_received_transfer_nature" class="gate_pass_received_transfer_nature"><div class="ew-table-header-caption"><?php echo $gate_pass_received->transfer_nature->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="transfer_nature" class="<?php echo $gate_pass_received->transfer_nature->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->transfer_nature) ?>',2);"><div id="elh_gate_pass_received_transfer_nature" class="gate_pass_received_transfer_nature">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->transfer_nature->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->transfer_nature->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->transfer_nature->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->due_date->Visible) { // due_date ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->due_date) == "") { ?>
		<th data-name="due_date" class="<?php echo $gate_pass_received->due_date->headerCellClass() ?>"><div id="elh_gate_pass_received_due_date" class="gate_pass_received_due_date"><div class="ew-table-header-caption"><?php echo $gate_pass_received->due_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="due_date" class="<?php echo $gate_pass_received->due_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->due_date) ?>',2);"><div id="elh_gate_pass_received_due_date" class="gate_pass_received_due_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->due_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->due_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->due_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->item->Visible) { // item ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->item) == "") { ?>
		<th data-name="item" class="<?php echo $gate_pass_received->item->headerCellClass() ?>"><div id="elh_gate_pass_received_item" class="gate_pass_received_item"><div class="ew-table-header-caption"><?php echo $gate_pass_received->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $gate_pass_received->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->item) ?>',2);"><div id="elh_gate_pass_received_item" class="gate_pass_received_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->despatch_details->Visible) { // despatch details ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->despatch_details) == "") { ?>
		<th data-name="despatch_details" class="<?php echo $gate_pass_received->despatch_details->headerCellClass() ?>"><div id="elh_gate_pass_received_despatch_details" class="gate_pass_received_despatch_details"><div class="ew-table-header-caption"><?php echo $gate_pass_received->despatch_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_details" class="<?php echo $gate_pass_received->despatch_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->despatch_details) ?>',2);"><div id="elh_gate_pass_received_despatch_details" class="gate_pass_received_despatch_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->despatch_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->despatch_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->despatch_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->sender_comments->Visible) { // sender_comments ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->sender_comments) == "") { ?>
		<th data-name="sender_comments" class="<?php echo $gate_pass_received->sender_comments->headerCellClass() ?>"><div id="elh_gate_pass_received_sender_comments" class="gate_pass_received_sender_comments"><div class="ew-table-header-caption"><?php echo $gate_pass_received->sender_comments->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sender_comments" class="<?php echo $gate_pass_received->sender_comments->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->sender_comments) ?>',2);"><div id="elh_gate_pass_received_sender_comments" class="gate_pass_received_sender_comments">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->sender_comments->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->sender_comments->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->sender_comments->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->t_mode->Visible) { // t_mode ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->t_mode) == "") { ?>
		<th data-name="t_mode" class="<?php echo $gate_pass_received->t_mode->headerCellClass() ?>"><div id="elh_gate_pass_received_t_mode" class="gate_pass_received_t_mode"><div class="ew-table-header-caption"><?php echo $gate_pass_received->t_mode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_mode" class="<?php echo $gate_pass_received->t_mode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->t_mode) ?>',2);"><div id="elh_gate_pass_received_t_mode" class="gate_pass_received_t_mode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->t_mode->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->t_mode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->t_mode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->t_distance->Visible) { // t_distance ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->t_distance) == "") { ?>
		<th data-name="t_distance" class="<?php echo $gate_pass_received->t_distance->headerCellClass() ?>"><div id="elh_gate_pass_received_t_distance" class="gate_pass_received_t_distance"><div class="ew-table-header-caption"><?php echo $gate_pass_received->t_distance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_distance" class="<?php echo $gate_pass_received->t_distance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->t_distance) ?>',2);"><div id="elh_gate_pass_received_t_distance" class="gate_pass_received_t_distance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->t_distance->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->t_distance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->t_distance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->t_v_no->Visible) { // t_v_no ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->t_v_no) == "") { ?>
		<th data-name="t_v_no" class="<?php echo $gate_pass_received->t_v_no->headerCellClass() ?>"><div id="elh_gate_pass_received_t_v_no" class="gate_pass_received_t_v_no"><div class="ew-table-header-caption"><?php echo $gate_pass_received->t_v_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_v_no" class="<?php echo $gate_pass_received->t_v_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->t_v_no) ?>',2);"><div id="elh_gate_pass_received_t_v_no" class="gate_pass_received_t_v_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->t_v_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->t_v_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->t_v_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->purpose->Visible) { // purpose ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->purpose) == "") { ?>
		<th data-name="purpose" class="<?php echo $gate_pass_received->purpose->headerCellClass() ?>"><div id="elh_gate_pass_received_purpose" class="gate_pass_received_purpose"><div class="ew-table-header-caption"><?php echo $gate_pass_received->purpose->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="purpose" class="<?php echo $gate_pass_received->purpose->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->purpose) ?>',2);"><div id="elh_gate_pass_received_purpose" class="gate_pass_received_purpose">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->purpose->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->purpose->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->purpose->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->operator->Visible) { // operator ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $gate_pass_received->operator->headerCellClass() ?>"><div id="elh_gate_pass_received_operator" class="gate_pass_received_operator"><div class="ew-table-header-caption"><?php echo $gate_pass_received->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $gate_pass_received->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->operator) ?>',2);"><div id="elh_gate_pass_received_operator" class="gate_pass_received_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->datetime->Visible) { // datetime ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $gate_pass_received->datetime->headerCellClass() ?>"><div id="elh_gate_pass_received_datetime" class="gate_pass_received_datetime"><div class="ew-table-header-caption"><?php echo $gate_pass_received->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $gate_pass_received->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->datetime) ?>',2);"><div id="elh_gate_pass_received_datetime" class="gate_pass_received_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->receiving_condition->Visible) { // receiving_condition ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->receiving_condition) == "") { ?>
		<th data-name="receiving_condition" class="<?php echo $gate_pass_received->receiving_condition->headerCellClass() ?>"><div id="elh_gate_pass_received_receiving_condition" class="gate_pass_received_receiving_condition"><div class="ew-table-header-caption"><?php echo $gate_pass_received->receiving_condition->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="receiving_condition" class="<?php echo $gate_pass_received->receiving_condition->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->receiving_condition) ?>',2);"><div id="elh_gate_pass_received_receiving_condition" class="gate_pass_received_receiving_condition">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->receiving_condition->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->receiving_condition->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->receiving_condition->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->receiver_comments->Visible) { // receiver_comments ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->receiver_comments) == "") { ?>
		<th data-name="receiver_comments" class="<?php echo $gate_pass_received->receiver_comments->headerCellClass() ?>"><div id="elh_gate_pass_received_receiver_comments" class="gate_pass_received_receiver_comments"><div class="ew-table-header-caption"><?php echo $gate_pass_received->receiver_comments->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="receiver_comments" class="<?php echo $gate_pass_received->receiver_comments->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->receiver_comments) ?>',2);"><div id="elh_gate_pass_received_receiver_comments" class="gate_pass_received_receiver_comments">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->receiver_comments->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->receiver_comments->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->receiver_comments->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->r_operator->Visible) { // r_operator ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->r_operator) == "") { ?>
		<th data-name="r_operator" class="<?php echo $gate_pass_received->r_operator->headerCellClass() ?>"><div id="elh_gate_pass_received_r_operator" class="gate_pass_received_r_operator"><div class="ew-table-header-caption"><?php echo $gate_pass_received->r_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_operator" class="<?php echo $gate_pass_received->r_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->r_operator) ?>',2);"><div id="elh_gate_pass_received_r_operator" class="gate_pass_received_r_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->r_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->r_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->r_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->r_datetime->Visible) { // r_datetime ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->r_datetime) == "") { ?>
		<th data-name="r_datetime" class="<?php echo $gate_pass_received->r_datetime->headerCellClass() ?>"><div id="elh_gate_pass_received_r_datetime" class="gate_pass_received_r_datetime"><div class="ew-table-header-caption"><?php echo $gate_pass_received->r_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_datetime" class="<?php echo $gate_pass_received->r_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->r_datetime) ?>',2);"><div id="elh_gate_pass_received_r_datetime" class="gate_pass_received_r_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->r_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->r_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->r_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass_received->jc_no->Visible) { // jc_no ?>
	<?php if ($gate_pass_received->sortUrl($gate_pass_received->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $gate_pass_received->jc_no->headerCellClass() ?>"><div id="elh_gate_pass_received_jc_no" class="gate_pass_received_jc_no"><div class="ew-table-header-caption"><?php echo $gate_pass_received->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $gate_pass_received->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass_received->SortUrl($gate_pass_received->jc_no) ?>',2);"><div id="elh_gate_pass_received_jc_no" class="gate_pass_received_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass_received->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass_received->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass_received->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$gate_pass_received_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($gate_pass_received->ExportAll && $gate_pass_received->isExport()) {
	$gate_pass_received_list->StopRec = $gate_pass_received_list->TotalRecs;
} else {

	// Set the last record to display
	if ($gate_pass_received_list->TotalRecs > $gate_pass_received_list->StartRec + $gate_pass_received_list->DisplayRecs - 1)
		$gate_pass_received_list->StopRec = $gate_pass_received_list->StartRec + $gate_pass_received_list->DisplayRecs - 1;
	else
		$gate_pass_received_list->StopRec = $gate_pass_received_list->TotalRecs;
}
$gate_pass_received_list->RecCnt = $gate_pass_received_list->StartRec - 1;
if ($gate_pass_received_list->Recordset && !$gate_pass_received_list->Recordset->EOF) {
	$gate_pass_received_list->Recordset->moveFirst();
	$selectLimit = $gate_pass_received_list->UseSelectLimit;
	if (!$selectLimit && $gate_pass_received_list->StartRec > 1)
		$gate_pass_received_list->Recordset->move($gate_pass_received_list->StartRec - 1);
} elseif (!$gate_pass_received->AllowAddDeleteRow && $gate_pass_received_list->StopRec == 0) {
	$gate_pass_received_list->StopRec = $gate_pass_received->GridAddRowCount;
}

// Initialize aggregate
$gate_pass_received->RowType = ROWTYPE_AGGREGATEINIT;
$gate_pass_received->resetAttributes();
$gate_pass_received_list->renderRow();
while ($gate_pass_received_list->RecCnt < $gate_pass_received_list->StopRec) {
	$gate_pass_received_list->RecCnt++;
	if ($gate_pass_received_list->RecCnt >= $gate_pass_received_list->StartRec) {
		$gate_pass_received_list->RowCnt++;

		// Set up key count
		$gate_pass_received_list->KeyCount = $gate_pass_received_list->RowIndex;

		// Init row class and style
		$gate_pass_received->resetAttributes();
		$gate_pass_received->CssClass = "";
		if ($gate_pass_received->isGridAdd()) {
		} else {
			$gate_pass_received_list->loadRowValues($gate_pass_received_list->Recordset); // Load row values
		}
		$gate_pass_received->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$gate_pass_received->RowAttrs = array_merge($gate_pass_received->RowAttrs, array('data-rowindex'=>$gate_pass_received_list->RowCnt, 'id'=>'r' . $gate_pass_received_list->RowCnt . '_gate_pass_received', 'data-rowtype'=>$gate_pass_received->RowType));

		// Render row
		$gate_pass_received_list->renderRow();

		// Render list options
		$gate_pass_received_list->renderListOptions();
?>
	<tr<?php echo $gate_pass_received->rowAttributes() ?>>
<?php

// Render list options (body, left)
$gate_pass_received_list->ListOptions->render("body", "left", $gate_pass_received_list->RowCnt);
?>
	<?php if ($gate_pass_received->gp_no->Visible) { // gp_no ?>
		<td data-name="gp_no"<?php echo $gate_pass_received->gp_no->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_gp_no" class="gate_pass_received_gp_no">
<span<?php echo $gate_pass_received->gp_no->viewAttributes() ?>>
<?php echo $gate_pass_received->gp_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->from->Visible) { // from ?>
		<td data-name="from"<?php echo $gate_pass_received->from->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_from" class="gate_pass_received_from">
<span<?php echo $gate_pass_received->from->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass_received->from->getViewValue())) && $gate_pass_received->from->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass_received->from->linkAttributes() ?>><?php echo $gate_pass_received->from->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass_received->from->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->to->Visible) { // to ?>
		<td data-name="to"<?php echo $gate_pass_received->to->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_to" class="gate_pass_received_to">
<span<?php echo $gate_pass_received->to->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass_received->to->getViewValue())) && $gate_pass_received->to->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass_received->to->linkAttributes() ?>><?php echo $gate_pass_received->to->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass_received->to->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->attention->Visible) { // attention ?>
		<td data-name="attention"<?php echo $gate_pass_received->attention->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_attention" class="gate_pass_received_attention">
<span<?php echo $gate_pass_received->attention->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass_received->attention->getViewValue())) && $gate_pass_received->attention->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass_received->attention->linkAttributes() ?>><?php echo $gate_pass_received->attention->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass_received->attention->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->transfer_nature->Visible) { // transfer_nature ?>
		<td data-name="transfer_nature"<?php echo $gate_pass_received->transfer_nature->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_transfer_nature" class="gate_pass_received_transfer_nature">
<span<?php echo $gate_pass_received->transfer_nature->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass_received->transfer_nature->getViewValue())) && $gate_pass_received->transfer_nature->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass_received->transfer_nature->linkAttributes() ?>><?php echo $gate_pass_received->transfer_nature->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass_received->transfer_nature->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->due_date->Visible) { // due_date ?>
		<td data-name="due_date"<?php echo $gate_pass_received->due_date->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_due_date" class="gate_pass_received_due_date">
<span<?php echo $gate_pass_received->due_date->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass_received->due_date->getViewValue())) && $gate_pass_received->due_date->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass_received->due_date->linkAttributes() ?>><?php echo $gate_pass_received->due_date->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass_received->due_date->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->item->Visible) { // item ?>
		<td data-name="item"<?php echo $gate_pass_received->item->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_item" class="gate_pass_received_item">
<span<?php echo $gate_pass_received->item->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass_received->item->getViewValue())) && $gate_pass_received->item->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass_received->item->linkAttributes() ?>><?php echo $gate_pass_received->item->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass_received->item->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->despatch_details->Visible) { // despatch details ?>
		<td data-name="despatch_details"<?php echo $gate_pass_received->despatch_details->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_despatch_details" class="gate_pass_received_despatch_details">
<span<?php echo $gate_pass_received->despatch_details->viewAttributes() ?>>
<?php echo $gate_pass_received->despatch_details->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->sender_comments->Visible) { // sender_comments ?>
		<td data-name="sender_comments"<?php echo $gate_pass_received->sender_comments->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_sender_comments" class="gate_pass_received_sender_comments">
<span<?php echo $gate_pass_received->sender_comments->viewAttributes() ?>>
<?php echo $gate_pass_received->sender_comments->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->t_mode->Visible) { // t_mode ?>
		<td data-name="t_mode"<?php echo $gate_pass_received->t_mode->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_t_mode" class="gate_pass_received_t_mode">
<span<?php echo $gate_pass_received->t_mode->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass_received->t_mode->getViewValue())) && $gate_pass_received->t_mode->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass_received->t_mode->linkAttributes() ?>><?php echo $gate_pass_received->t_mode->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass_received->t_mode->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->t_distance->Visible) { // t_distance ?>
		<td data-name="t_distance"<?php echo $gate_pass_received->t_distance->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_t_distance" class="gate_pass_received_t_distance">
<span<?php echo $gate_pass_received->t_distance->viewAttributes() ?>>
<?php echo $gate_pass_received->t_distance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->t_v_no->Visible) { // t_v_no ?>
		<td data-name="t_v_no"<?php echo $gate_pass_received->t_v_no->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_t_v_no" class="gate_pass_received_t_v_no">
<span<?php echo $gate_pass_received->t_v_no->viewAttributes() ?>>
<?php echo $gate_pass_received->t_v_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->purpose->Visible) { // purpose ?>
		<td data-name="purpose"<?php echo $gate_pass_received->purpose->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_purpose" class="gate_pass_received_purpose">
<span<?php echo $gate_pass_received->purpose->viewAttributes() ?>>
<?php echo $gate_pass_received->purpose->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $gate_pass_received->operator->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_operator" class="gate_pass_received_operator">
<span<?php echo $gate_pass_received->operator->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass_received->operator->getViewValue())) && $gate_pass_received->operator->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass_received->operator->linkAttributes() ?>><?php echo $gate_pass_received->operator->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass_received->operator->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $gate_pass_received->datetime->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_datetime" class="gate_pass_received_datetime">
<span<?php echo $gate_pass_received->datetime->viewAttributes() ?>>
<?php echo $gate_pass_received->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->receiving_condition->Visible) { // receiving_condition ?>
		<td data-name="receiving_condition"<?php echo $gate_pass_received->receiving_condition->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_receiving_condition" class="gate_pass_received_receiving_condition">
<span<?php echo $gate_pass_received->receiving_condition->viewAttributes() ?>>
<?php echo $gate_pass_received->receiving_condition->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->receiver_comments->Visible) { // receiver_comments ?>
		<td data-name="receiver_comments"<?php echo $gate_pass_received->receiver_comments->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_receiver_comments" class="gate_pass_received_receiver_comments">
<span<?php echo $gate_pass_received->receiver_comments->viewAttributes() ?>>
<?php echo $gate_pass_received->receiver_comments->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->r_operator->Visible) { // r_operator ?>
		<td data-name="r_operator"<?php echo $gate_pass_received->r_operator->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_r_operator" class="gate_pass_received_r_operator">
<span<?php echo $gate_pass_received->r_operator->viewAttributes() ?>>
<?php echo $gate_pass_received->r_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->r_datetime->Visible) { // r_datetime ?>
		<td data-name="r_datetime"<?php echo $gate_pass_received->r_datetime->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_r_datetime" class="gate_pass_received_r_datetime">
<span<?php echo $gate_pass_received->r_datetime->viewAttributes() ?>>
<?php echo $gate_pass_received->r_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass_received->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $gate_pass_received->jc_no->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_received_list->RowCnt ?>_gate_pass_received_jc_no" class="gate_pass_received_jc_no">
<span<?php echo $gate_pass_received->jc_no->viewAttributes() ?>>
<?php echo $gate_pass_received->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$gate_pass_received_list->ListOptions->render("body", "right", $gate_pass_received_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$gate_pass_received->isGridAdd())
		$gate_pass_received_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$gate_pass_received->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($gate_pass_received_list->Recordset)
	$gate_pass_received_list->Recordset->Close();
?>
<?php if (!$gate_pass_received->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$gate_pass_received->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($gate_pass_received_list->Pager)) $gate_pass_received_list->Pager = new PrevNextPager($gate_pass_received_list->StartRec, $gate_pass_received_list->DisplayRecs, $gate_pass_received_list->TotalRecs, $gate_pass_received_list->AutoHidePager) ?>
<?php if ($gate_pass_received_list->Pager->RecordCount > 0 && $gate_pass_received_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($gate_pass_received_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $gate_pass_received_list->pageUrl() ?>start=<?php echo $gate_pass_received_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($gate_pass_received_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $gate_pass_received_list->pageUrl() ?>start=<?php echo $gate_pass_received_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $gate_pass_received_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($gate_pass_received_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $gate_pass_received_list->pageUrl() ?>start=<?php echo $gate_pass_received_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($gate_pass_received_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $gate_pass_received_list->pageUrl() ?>start=<?php echo $gate_pass_received_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $gate_pass_received_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($gate_pass_received_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $gate_pass_received_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $gate_pass_received_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $gate_pass_received_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($gate_pass_received_list->TotalRecs > 0 && (!$gate_pass_received_list->AutoHidePageSizeSelector || $gate_pass_received_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="gate_pass_received">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($gate_pass_received_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($gate_pass_received_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($gate_pass_received_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($gate_pass_received_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($gate_pass_received_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($gate_pass_received->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $gate_pass_received_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($gate_pass_received_list->TotalRecs == 0 && !$gate_pass_received->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $gate_pass_received_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$gate_pass_received_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$gate_pass_received->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$gate_pass_received->isExport()) { ?>
<script>
ew.scrollableTable("gmp_gate_pass_received", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$gate_pass_received_list->terminate();
?>