<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$gate_pass_received_search = new gate_pass_received_search();

// Run the page
$gate_pass_received_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$gate_pass_received_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($gate_pass_received_search->IsModal) { ?>
var fgate_pass_receivedsearch = currentAdvancedSearchForm = new ew.Form("fgate_pass_receivedsearch", "search");
<?php } else { ?>
var fgate_pass_receivedsearch = currentForm = new ew.Form("fgate_pass_receivedsearch", "search");
<?php } ?>

// Form_CustomValidate event
fgate_pass_receivedsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgate_pass_receivedsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgate_pass_receivedsearch.lists["x_from"] = <?php echo $gate_pass_received_search->from->Lookup->toClientList() ?>;
fgate_pass_receivedsearch.lists["x_from"].options = <?php echo JsonEncode($gate_pass_received_search->from->lookupOptions()) ?>;
fgate_pass_receivedsearch.autoSuggests["x_from"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fgate_pass_receivedsearch.lists["x_to"] = <?php echo $gate_pass_received_search->to->Lookup->toClientList() ?>;
fgate_pass_receivedsearch.lists["x_to"].options = <?php echo JsonEncode($gate_pass_received_search->to->lookupOptions()) ?>;
fgate_pass_receivedsearch.lists["x_attention"] = <?php echo $gate_pass_received_search->attention->Lookup->toClientList() ?>;
fgate_pass_receivedsearch.lists["x_attention"].options = <?php echo JsonEncode($gate_pass_received_search->attention->lookupOptions()) ?>;
fgate_pass_receivedsearch.lists["x_transfer_nature"] = <?php echo $gate_pass_received_search->transfer_nature->Lookup->toClientList() ?>;
fgate_pass_receivedsearch.lists["x_transfer_nature"].options = <?php echo JsonEncode($gate_pass_received_search->transfer_nature->options(FALSE, TRUE)) ?>;
fgate_pass_receivedsearch.lists["x_group"] = <?php echo $gate_pass_received_search->group->Lookup->toClientList() ?>;
fgate_pass_receivedsearch.lists["x_group"].options = <?php echo JsonEncode($gate_pass_received_search->group->options(FALSE, TRUE)) ?>;
fgate_pass_receivedsearch.lists["x_t_mode"] = <?php echo $gate_pass_received_search->t_mode->Lookup->toClientList() ?>;
fgate_pass_receivedsearch.lists["x_t_mode"].options = <?php echo JsonEncode($gate_pass_received_search->t_mode->options(FALSE, TRUE)) ?>;
fgate_pass_receivedsearch.lists["x_operator"] = <?php echo $gate_pass_received_search->operator->Lookup->toClientList() ?>;
fgate_pass_receivedsearch.lists["x_operator"].options = <?php echo JsonEncode($gate_pass_received_search->operator->lookupOptions()) ?>;
fgate_pass_receivedsearch.lists["x_receiving_condition"] = <?php echo $gate_pass_received_search->receiving_condition->Lookup->toClientList() ?>;
fgate_pass_receivedsearch.lists["x_receiving_condition"].options = <?php echo JsonEncode($gate_pass_received_search->receiving_condition->options(FALSE, TRUE)) ?>;
fgate_pass_receivedsearch.lists["x_r_operator"] = <?php echo $gate_pass_received_search->r_operator->Lookup->toClientList() ?>;
fgate_pass_receivedsearch.lists["x_r_operator"].options = <?php echo JsonEncode($gate_pass_received_search->r_operator->lookupOptions()) ?>;
fgate_pass_receivedsearch.lists["x_jc_no"] = <?php echo $gate_pass_received_search->jc_no->Lookup->toClientList() ?>;
fgate_pass_receivedsearch.lists["x_jc_no"].options = <?php echo JsonEncode($gate_pass_received_search->jc_no->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fgate_pass_receivedsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_gp_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass_received->gp_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_from");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass_received->from->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_due_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass_received->due_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_t_distance");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass_received->t_distance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass_received->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_e_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass_received->e_operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_e_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass_received->e_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_r_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass_received->r_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_updated");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass_received->updated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_r_e_user_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass_received->r_e_user_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_r_e_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass_received->r_e_datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $gate_pass_received_search->showPageHeader(); ?>
<?php
$gate_pass_received_search->showMessage();
?>
<form name="fgate_pass_receivedsearch" id="fgate_pass_receivedsearch" class="<?php echo $gate_pass_received_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($gate_pass_received_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $gate_pass_received_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="gate_pass_received">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$gate_pass_received_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($gate_pass_received->gp_no->Visible) { // gp_no ?>
	<div id="r_gp_no" class="form-group row">
		<label for="x_gp_no" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_gp_no"><?php echo $gate_pass_received->gp_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gp_no" id="z_gp_no" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->gp_no->cellAttributes() ?>>
			<span id="el_gate_pass_received_gp_no">
<input type="text" data-table="gate_pass_received" data-field="x_gp_no" name="x_gp_no" id="x_gp_no" size="30" placeholder="<?php echo HtmlEncode($gate_pass_received->gp_no->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->gp_no->EditValue ?>"<?php echo $gate_pass_received->gp_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->from->Visible) { // from ?>
	<div id="r_from" class="form-group row">
		<label class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_from"><?php echo $gate_pass_received->from->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_from" id="z_from" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->from->cellAttributes() ?>>
			<span id="el_gate_pass_received_from">
<?php
$wrkonchange = "" . trim(@$gate_pass_received->from->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$gate_pass_received->from->EditAttrs["onchange"] = "";
?>
<span id="as_x_from" class="text-nowrap" style="z-index: 8970">
	<input type="text" class="form-control" name="sv_x_from" id="sv_x_from" value="<?php echo RemoveHtml($gate_pass_received->from->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($gate_pass_received->from->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($gate_pass_received->from->getPlaceHolder()) ?>"<?php echo $gate_pass_received->from->editAttributes() ?>>
</span>
<input type="hidden" data-table="gate_pass_received" data-field="x_from" data-value-separator="<?php echo $gate_pass_received->from->displayValueSeparatorAttribute() ?>" name="x_from" id="x_from" value="<?php echo HtmlEncode($gate_pass_received->from->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fgate_pass_receivedsearch.createAutoSuggest({"id":"x_from","forceSelect":false});
</script>
<?php echo $gate_pass_received->from->Lookup->getParamTag("p_x_from") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->to->Visible) { // to ?>
	<div id="r_to" class="form-group row">
		<label for="x_to" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_to"><?php echo $gate_pass_received->to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_to" id="z_to" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->to->cellAttributes() ?>>
			<span id="el_gate_pass_received_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass_received" data-field="x_to" data-value-separator="<?php echo $gate_pass_received->to->displayValueSeparatorAttribute() ?>" id="x_to" name="x_to"<?php echo $gate_pass_received->to->editAttributes() ?>>
		<?php echo $gate_pass_received->to->selectOptionListHtml("x_to") ?>
	</select>
</div>
<?php echo $gate_pass_received->to->Lookup->getParamTag("p_x_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->attention->Visible) { // attention ?>
	<div id="r_attention" class="form-group row">
		<label for="x_attention" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_attention"><?php echo $gate_pass_received->attention->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_attention" id="z_attention" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->attention->cellAttributes() ?>>
			<span id="el_gate_pass_received_attention">
<?php if (!$Security->isAdmin() && $Security->isLoggedIn() && !$gate_pass_received->userIDAllow("search")) { // Non system admin ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass_received" data-field="x_attention" data-value-separator="<?php echo $gate_pass_received->attention->displayValueSeparatorAttribute() ?>" id="x_attention" name="x_attention"<?php echo $gate_pass_received->attention->editAttributes() ?>>
		<?php echo $gate_pass_received->attention->selectOptionListHtml("x_attention") ?>
	</select>
</div>
<?php echo $gate_pass_received->attention->Lookup->getParamTag("p_x_attention") ?>
<?php } else { ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass_received" data-field="x_attention" data-value-separator="<?php echo $gate_pass_received->attention->displayValueSeparatorAttribute() ?>" id="x_attention" name="x_attention"<?php echo $gate_pass_received->attention->editAttributes() ?>>
		<?php echo $gate_pass_received->attention->selectOptionListHtml("x_attention") ?>
	</select>
</div>
<?php echo $gate_pass_received->attention->Lookup->getParamTag("p_x_attention") ?>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->transfer_nature->Visible) { // transfer_nature ?>
	<div id="r_transfer_nature" class="form-group row">
		<label for="x_transfer_nature" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_transfer_nature"><?php echo $gate_pass_received->transfer_nature->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_transfer_nature" id="z_transfer_nature" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->transfer_nature->cellAttributes() ?>>
			<span id="el_gate_pass_received_transfer_nature">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass_received" data-field="x_transfer_nature" data-value-separator="<?php echo $gate_pass_received->transfer_nature->displayValueSeparatorAttribute() ?>" id="x_transfer_nature" name="x_transfer_nature"<?php echo $gate_pass_received->transfer_nature->editAttributes() ?>>
		<?php echo $gate_pass_received->transfer_nature->selectOptionListHtml("x_transfer_nature") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->due_date->Visible) { // due_date ?>
	<div id="r_due_date" class="form-group row">
		<label for="x_due_date" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_due_date"><?php echo $gate_pass_received->due_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_due_date" id="z_due_date" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->due_date->cellAttributes() ?>>
			<span id="el_gate_pass_received_due_date">
<input type="text" data-table="gate_pass_received" data-field="x_due_date" name="x_due_date" id="x_due_date" placeholder="<?php echo HtmlEncode($gate_pass_received->due_date->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->due_date->EditValue ?>"<?php echo $gate_pass_received->due_date->editAttributes() ?>>
<?php if (!$gate_pass_received->due_date->ReadOnly && !$gate_pass_received->due_date->Disabled && !isset($gate_pass_received->due_date->EditAttrs["readonly"]) && !isset($gate_pass_received->due_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fgate_pass_receivedsearch", "x_due_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->group->Visible) { // group ?>
	<div id="r_group" class="form-group row">
		<label for="x_group" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_group"><?php echo $gate_pass_received->group->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_group" id="z_group" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->group->cellAttributes() ?>>
			<span id="el_gate_pass_received_group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass_received" data-field="x_group" data-value-separator="<?php echo $gate_pass_received->group->displayValueSeparatorAttribute() ?>" id="x_group" name="x_group"<?php echo $gate_pass_received->group->editAttributes() ?>>
		<?php echo $gate_pass_received->group->selectOptionListHtml("x_group") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_product"><?php echo $gate_pass_received->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->product->cellAttributes() ?>>
			<span id="el_gate_pass_received_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass_received" data-field="x_product" data-value-separator="<?php echo $gate_pass_received->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $gate_pass_received->product->editAttributes() ?>>
		<?php echo $gate_pass_received->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->count_received->Visible) { // count_received ?>
	<div id="r_count_received" class="form-group row">
		<label for="x_count_received" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_count_received"><?php echo $gate_pass_received->count_received->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_count_received" id="z_count_received" value="LIKE"></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->count_received->cellAttributes() ?>>
			<span id="el_gate_pass_received_count_received">
<input type="text" data-table="gate_pass_received" data-field="x_count_received" name="x_count_received" id="x_count_received" size="30" maxlength="6" placeholder="<?php echo HtmlEncode($gate_pass_received->count_received->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->count_received->EditValue ?>"<?php echo $gate_pass_received->count_received->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label for="x_item" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_item"><?php echo $gate_pass_received->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->item->cellAttributes() ?>>
			<span id="el_gate_pass_received_item">
<input type="text" data-table="gate_pass_received" data-field="x_item" name="x_item" id="x_item" placeholder="<?php echo HtmlEncode($gate_pass_received->item->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->item->EditValue ?>"<?php echo $gate_pass_received->item->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->gt_id->Visible) { // gt_id ?>
	<div id="r_gt_id" class="form-group row">
		<label for="x_gt_id" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_gt_id"><?php echo $gate_pass_received->gt_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_gt_id" id="z_gt_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->gt_id->cellAttributes() ?>>
			<span id="el_gate_pass_received_gt_id">
<input type="text" data-table="gate_pass_received" data-field="x_gt_id" name="x_gt_id" id="x_gt_id" size="30" maxlength="144" placeholder="<?php echo HtmlEncode($gate_pass_received->gt_id->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->gt_id->EditValue ?>"<?php echo $gate_pass_received->gt_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->despatch_details->Visible) { // despatch details ?>
	<div id="r_despatch_details" class="form-group row">
		<label for="x_despatch_details" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_despatch_details"><?php echo $gate_pass_received->despatch_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_despatch_details" id="z_despatch_details" value="LIKE"></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->despatch_details->cellAttributes() ?>>
			<span id="el_gate_pass_received_despatch_details">
<input type="text" data-table="gate_pass_received" data-field="x_despatch_details" name="x_despatch_details" id="x_despatch_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($gate_pass_received->despatch_details->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->despatch_details->EditValue ?>"<?php echo $gate_pass_received->despatch_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->sender_comments->Visible) { // sender_comments ?>
	<div id="r_sender_comments" class="form-group row">
		<label for="x_sender_comments" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_sender_comments"><?php echo $gate_pass_received->sender_comments->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sender_comments" id="z_sender_comments" value="LIKE"></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->sender_comments->cellAttributes() ?>>
			<span id="el_gate_pass_received_sender_comments">
<input type="text" data-table="gate_pass_received" data-field="x_sender_comments" name="x_sender_comments" id="x_sender_comments" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($gate_pass_received->sender_comments->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->sender_comments->EditValue ?>"<?php echo $gate_pass_received->sender_comments->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->t_mode->Visible) { // t_mode ?>
	<div id="r_t_mode" class="form-group row">
		<label for="x_t_mode" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_t_mode"><?php echo $gate_pass_received->t_mode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_t_mode" id="z_t_mode" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->t_mode->cellAttributes() ?>>
			<span id="el_gate_pass_received_t_mode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass_received" data-field="x_t_mode" data-value-separator="<?php echo $gate_pass_received->t_mode->displayValueSeparatorAttribute() ?>" id="x_t_mode" name="x_t_mode"<?php echo $gate_pass_received->t_mode->editAttributes() ?>>
		<?php echo $gate_pass_received->t_mode->selectOptionListHtml("x_t_mode") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->t_distance->Visible) { // t_distance ?>
	<div id="r_t_distance" class="form-group row">
		<label for="x_t_distance" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_t_distance"><?php echo $gate_pass_received->t_distance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_t_distance" id="z_t_distance" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->t_distance->cellAttributes() ?>>
			<span id="el_gate_pass_received_t_distance">
<input type="text" data-table="gate_pass_received" data-field="x_t_distance" name="x_t_distance" id="x_t_distance" size="30" placeholder="<?php echo HtmlEncode($gate_pass_received->t_distance->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->t_distance->EditValue ?>"<?php echo $gate_pass_received->t_distance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->t_v_no->Visible) { // t_v_no ?>
	<div id="r_t_v_no" class="form-group row">
		<label for="x_t_v_no" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_t_v_no"><?php echo $gate_pass_received->t_v_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_v_no" id="z_t_v_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->t_v_no->cellAttributes() ?>>
			<span id="el_gate_pass_received_t_v_no">
<input type="text" data-table="gate_pass_received" data-field="x_t_v_no" name="x_t_v_no" id="x_t_v_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($gate_pass_received->t_v_no->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->t_v_no->EditValue ?>"<?php echo $gate_pass_received->t_v_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->purpose->Visible) { // purpose ?>
	<div id="r_purpose" class="form-group row">
		<label for="x_purpose" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_purpose"><?php echo $gate_pass_received->purpose->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_purpose" id="z_purpose" value="LIKE"></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->purpose->cellAttributes() ?>>
			<span id="el_gate_pass_received_purpose">
<input type="text" data-table="gate_pass_received" data-field="x_purpose" name="x_purpose" id="x_purpose" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($gate_pass_received->purpose->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->purpose->EditValue ?>"<?php echo $gate_pass_received->purpose->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_operator"><?php echo $gate_pass_received->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->operator->cellAttributes() ?>>
			<span id="el_gate_pass_received_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass_received" data-field="x_operator" data-value-separator="<?php echo $gate_pass_received->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $gate_pass_received->operator->editAttributes() ?>>
		<?php echo $gate_pass_received->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $gate_pass_received->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_datetime"><?php echo $gate_pass_received->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->datetime->cellAttributes() ?>>
			<span id="el_gate_pass_received_datetime">
<input type="text" data-table="gate_pass_received" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($gate_pass_received->datetime->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->datetime->EditValue ?>"<?php echo $gate_pass_received->datetime->editAttributes() ?>>
<?php if (!$gate_pass_received->datetime->ReadOnly && !$gate_pass_received->datetime->Disabled && !isset($gate_pass_received->datetime->EditAttrs["readonly"]) && !isset($gate_pass_received->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fgate_pass_receivedsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->e_operator->Visible) { // e_operator ?>
	<div id="r_e_operator" class="form-group row">
		<label for="x_e_operator" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_e_operator"><?php echo $gate_pass_received->e_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_e_operator" id="z_e_operator" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->e_operator->cellAttributes() ?>>
			<span id="el_gate_pass_received_e_operator">
<input type="text" data-table="gate_pass_received" data-field="x_e_operator" name="x_e_operator" id="x_e_operator" size="30" placeholder="<?php echo HtmlEncode($gate_pass_received->e_operator->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->e_operator->EditValue ?>"<?php echo $gate_pass_received->e_operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->e_datetime->Visible) { // e_datetime ?>
	<div id="r_e_datetime" class="form-group row">
		<label for="x_e_datetime" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_e_datetime"><?php echo $gate_pass_received->e_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_e_datetime" id="z_e_datetime" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->e_datetime->cellAttributes() ?>>
			<span id="el_gate_pass_received_e_datetime">
<input type="text" data-table="gate_pass_received" data-field="x_e_datetime" name="x_e_datetime" id="x_e_datetime" placeholder="<?php echo HtmlEncode($gate_pass_received->e_datetime->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->e_datetime->EditValue ?>"<?php echo $gate_pass_received->e_datetime->editAttributes() ?>>
<?php if (!$gate_pass_received->e_datetime->ReadOnly && !$gate_pass_received->e_datetime->Disabled && !isset($gate_pass_received->e_datetime->EditAttrs["readonly"]) && !isset($gate_pass_received->e_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fgate_pass_receivedsearch", "x_e_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->receiving_condition->Visible) { // receiving_condition ?>
	<div id="r_receiving_condition" class="form-group row">
		<label for="x_receiving_condition" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_receiving_condition"><?php echo $gate_pass_received->receiving_condition->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_receiving_condition" id="z_receiving_condition" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->receiving_condition->cellAttributes() ?>>
			<span id="el_gate_pass_received_receiving_condition">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass_received" data-field="x_receiving_condition" data-value-separator="<?php echo $gate_pass_received->receiving_condition->displayValueSeparatorAttribute() ?>" id="x_receiving_condition" name="x_receiving_condition"<?php echo $gate_pass_received->receiving_condition->editAttributes() ?>>
		<?php echo $gate_pass_received->receiving_condition->selectOptionListHtml("x_receiving_condition") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->receiver_comments->Visible) { // receiver_comments ?>
	<div id="r_receiver_comments" class="form-group row">
		<label for="x_receiver_comments" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_receiver_comments"><?php echo $gate_pass_received->receiver_comments->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_receiver_comments" id="z_receiver_comments" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->receiver_comments->cellAttributes() ?>>
			<span id="el_gate_pass_received_receiver_comments">
<input type="text" data-table="gate_pass_received" data-field="x_receiver_comments" name="x_receiver_comments" id="x_receiver_comments" placeholder="<?php echo HtmlEncode($gate_pass_received->receiver_comments->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->receiver_comments->EditValue ?>"<?php echo $gate_pass_received->receiver_comments->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->r_operator->Visible) { // r_operator ?>
	<div id="r_r_operator" class="form-group row">
		<label for="x_r_operator" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_r_operator"><?php echo $gate_pass_received->r_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_r_operator" id="z_r_operator" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->r_operator->cellAttributes() ?>>
			<span id="el_gate_pass_received_r_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass_received" data-field="x_r_operator" data-value-separator="<?php echo $gate_pass_received->r_operator->displayValueSeparatorAttribute() ?>" id="x_r_operator" name="x_r_operator"<?php echo $gate_pass_received->r_operator->editAttributes() ?>>
		<?php echo $gate_pass_received->r_operator->selectOptionListHtml("x_r_operator") ?>
	</select>
</div>
<?php echo $gate_pass_received->r_operator->Lookup->getParamTag("p_x_r_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->r_datetime->Visible) { // r_datetime ?>
	<div id="r_r_datetime" class="form-group row">
		<label for="x_r_datetime" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_r_datetime"><?php echo $gate_pass_received->r_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_r_datetime" id="z_r_datetime" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->r_datetime->cellAttributes() ?>>
			<span id="el_gate_pass_received_r_datetime">
<input type="text" data-table="gate_pass_received" data-field="x_r_datetime" name="x_r_datetime" id="x_r_datetime" placeholder="<?php echo HtmlEncode($gate_pass_received->r_datetime->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->r_datetime->EditValue ?>"<?php echo $gate_pass_received->r_datetime->editAttributes() ?>>
<?php if (!$gate_pass_received->r_datetime->ReadOnly && !$gate_pass_received->r_datetime->Disabled && !isset($gate_pass_received->r_datetime->EditAttrs["readonly"]) && !isset($gate_pass_received->r_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fgate_pass_receivedsearch", "x_r_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->updated->Visible) { // updated ?>
	<div id="r_updated" class="form-group row">
		<label for="x_updated" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_updated"><?php echo $gate_pass_received->updated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_updated" id="z_updated" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->updated->cellAttributes() ?>>
			<span id="el_gate_pass_received_updated">
<input type="text" data-table="gate_pass_received" data-field="x_updated" name="x_updated" id="x_updated" size="30" placeholder="<?php echo HtmlEncode($gate_pass_received->updated->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->updated->EditValue ?>"<?php echo $gate_pass_received->updated->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->r_e_user_id->Visible) { // r_e_user_id ?>
	<div id="r_r_e_user_id" class="form-group row">
		<label for="x_r_e_user_id" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_r_e_user_id"><?php echo $gate_pass_received->r_e_user_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_r_e_user_id" id="z_r_e_user_id" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->r_e_user_id->cellAttributes() ?>>
			<span id="el_gate_pass_received_r_e_user_id">
<input type="text" data-table="gate_pass_received" data-field="x_r_e_user_id" name="x_r_e_user_id" id="x_r_e_user_id" size="30" placeholder="<?php echo HtmlEncode($gate_pass_received->r_e_user_id->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->r_e_user_id->EditValue ?>"<?php echo $gate_pass_received->r_e_user_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->r_e_datetime->Visible) { // r_e_datetime ?>
	<div id="r_r_e_datetime" class="form-group row">
		<label for="x_r_e_datetime" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_r_e_datetime"><?php echo $gate_pass_received->r_e_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_r_e_datetime" id="z_r_e_datetime" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->r_e_datetime->cellAttributes() ?>>
			<span id="el_gate_pass_received_r_e_datetime">
<input type="text" data-table="gate_pass_received" data-field="x_r_e_datetime" name="x_r_e_datetime" id="x_r_e_datetime" placeholder="<?php echo HtmlEncode($gate_pass_received->r_e_datetime->getPlaceHolder()) ?>" value="<?php echo $gate_pass_received->r_e_datetime->EditValue ?>"<?php echo $gate_pass_received->r_e_datetime->editAttributes() ?>>
<?php if (!$gate_pass_received->r_e_datetime->ReadOnly && !$gate_pass_received->r_e_datetime->Disabled && !isset($gate_pass_received->r_e_datetime->EditAttrs["readonly"]) && !isset($gate_pass_received->r_e_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fgate_pass_receivedsearch", "x_r_e_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass_received->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label for="x_jc_no" class="<?php echo $gate_pass_received_search->LeftColumnClass ?>"><span id="elh_gate_pass_received_jc_no"><?php echo $gate_pass_received->jc_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no" id="z_jc_no" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_received_search->RightColumnClass ?>"><div<?php echo $gate_pass_received->jc_no->cellAttributes() ?>>
			<span id="el_gate_pass_received_jc_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass_received" data-field="x_jc_no" data-value-separator="<?php echo $gate_pass_received->jc_no->displayValueSeparatorAttribute() ?>" id="x_jc_no" name="x_jc_no"<?php echo $gate_pass_received->jc_no->editAttributes() ?>>
		<?php echo $gate_pass_received->jc_no->selectOptionListHtml("x_jc_no") ?>
	</select>
</div>
<?php echo $gate_pass_received->jc_no->Lookup->getParamTag("p_x_jc_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$gate_pass_received_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $gate_pass_received_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$gate_pass_received_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$gate_pass_received_search->terminate();
?>