<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$gate_pass_list = new gate_pass_list();

// Run the page
$gate_pass_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$gate_pass_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$gate_pass->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fgate_passlist = currentForm = new ew.Form("fgate_passlist", "list");
fgate_passlist.formKeyCountName = '<?php echo $gate_pass_list->FormKeyCountName ?>';

// Form_CustomValidate event
fgate_passlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgate_passlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgate_passlist.lists["x_company_id"] = <?php echo $gate_pass_list->company_id->Lookup->toClientList() ?>;
fgate_passlist.lists["x_company_id"].options = <?php echo JsonEncode($gate_pass_list->company_id->lookupOptions()) ?>;
fgate_passlist.lists["x_from"] = <?php echo $gate_pass_list->from->Lookup->toClientList() ?>;
fgate_passlist.lists["x_from"].options = <?php echo JsonEncode($gate_pass_list->from->lookupOptions()) ?>;
fgate_passlist.lists["x_to"] = <?php echo $gate_pass_list->to->Lookup->toClientList() ?>;
fgate_passlist.lists["x_to"].options = <?php echo JsonEncode($gate_pass_list->to->lookupOptions()) ?>;
fgate_passlist.lists["x_attention"] = <?php echo $gate_pass_list->attention->Lookup->toClientList() ?>;
fgate_passlist.lists["x_attention"].options = <?php echo JsonEncode($gate_pass_list->attention->lookupOptions()) ?>;
fgate_passlist.lists["x_transfer_nature"] = <?php echo $gate_pass_list->transfer_nature->Lookup->toClientList() ?>;
fgate_passlist.lists["x_transfer_nature"].options = <?php echo JsonEncode($gate_pass_list->transfer_nature->options(FALSE, TRUE)) ?>;
fgate_passlist.lists["x_t_mode"] = <?php echo $gate_pass_list->t_mode->Lookup->toClientList() ?>;
fgate_passlist.lists["x_t_mode"].options = <?php echo JsonEncode($gate_pass_list->t_mode->options(FALSE, TRUE)) ?>;
fgate_passlist.lists["x_operator"] = <?php echo $gate_pass_list->operator->Lookup->toClientList() ?>;
fgate_passlist.lists["x_operator"].options = <?php echo JsonEncode($gate_pass_list->operator->lookupOptions()) ?>;
fgate_passlist.lists["x_receiving_condition"] = <?php echo $gate_pass_list->receiving_condition->Lookup->toClientList() ?>;
fgate_passlist.lists["x_receiving_condition"].options = <?php echo JsonEncode($gate_pass_list->receiving_condition->options(FALSE, TRUE)) ?>;
fgate_passlist.lists["x_r_operator"] = <?php echo $gate_pass_list->r_operator->Lookup->toClientList() ?>;
fgate_passlist.lists["x_r_operator"].options = <?php echo JsonEncode($gate_pass_list->r_operator->lookupOptions()) ?>;

// Form object for search
var fgate_passlistsrch = currentSearchForm = new ew.Form("fgate_passlistsrch");

// Validate function for search
fgate_passlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_gp_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass->gp_no->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fgate_passlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgate_passlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgate_passlistsrch.lists["x_from"] = <?php echo $gate_pass_list->from->Lookup->toClientList() ?>;
fgate_passlistsrch.lists["x_from"].options = <?php echo JsonEncode($gate_pass_list->from->lookupOptions()) ?>;
fgate_passlistsrch.lists["x_to"] = <?php echo $gate_pass_list->to->Lookup->toClientList() ?>;
fgate_passlistsrch.lists["x_to"].options = <?php echo JsonEncode($gate_pass_list->to->lookupOptions()) ?>;

// Filters
fgate_passlistsrch.filterList = <?php echo $gate_pass_list->getFilterList() ?>;

// Init search panel as collapsed
fgate_passlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$gate_pass->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($gate_pass_list->TotalRecs > 0 && $gate_pass_list->ExportOptions->visible()) { ?>
<?php $gate_pass_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($gate_pass_list->ImportOptions->visible()) { ?>
<?php $gate_pass_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($gate_pass_list->SearchOptions->visible()) { ?>
<?php $gate_pass_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($gate_pass_list->FilterOptions->visible()) { ?>
<?php $gate_pass_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$gate_pass_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$gate_pass->isExport() && !$gate_pass->CurrentAction) { ?>
<form name="fgate_passlistsrch" id="fgate_passlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($gate_pass_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fgate_passlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="gate_pass">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$gate_pass_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$gate_pass->RowType = ROWTYPE_SEARCH;

// Render row
$gate_pass->resetAttributes();
$gate_pass_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($gate_pass->gp_no->Visible) { // gp_no ?>
	<div id="xsc_gp_no" class="ew-cell form-group">
		<label for="x_gp_no" class="ew-search-caption ew-label"><?php echo $gate_pass->gp_no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gp_no" id="z_gp_no" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="gate_pass" data-field="x_gp_no" name="x_gp_no" id="x_gp_no" size="30" placeholder="<?php echo HtmlEncode($gate_pass->gp_no->getPlaceHolder()) ?>" value="<?php echo $gate_pass->gp_no->EditValue ?>"<?php echo $gate_pass->gp_no->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($gate_pass->from->Visible) { // from ?>
	<div id="xsc_from" class="ew-cell form-group">
		<label for="x_from" class="ew-search-caption ew-label"><?php echo $gate_pass->from->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_from" id="z_from" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass" data-field="x_from" data-value-separator="<?php echo $gate_pass->from->displayValueSeparatorAttribute() ?>" id="x_from" name="x_from"<?php echo $gate_pass->from->editAttributes() ?>>
		<?php echo $gate_pass->from->selectOptionListHtml("x_from") ?>
	</select>
</div>
<?php echo $gate_pass->from->Lookup->getParamTag("p_x_from") ?>
</span>
	</div>
<?php } ?>
<?php if ($gate_pass->to->Visible) { // to ?>
	<div id="xsc_to" class="ew-cell form-group">
		<label for="x_to" class="ew-search-caption ew-label"><?php echo $gate_pass->to->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_to" id="z_to" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass" data-field="x_to" data-value-separator="<?php echo $gate_pass->to->displayValueSeparatorAttribute() ?>" id="x_to" name="x_to"<?php echo $gate_pass->to->editAttributes() ?>>
		<?php echo $gate_pass->to->selectOptionListHtml("x_to") ?>
	</select>
</div>
<?php echo $gate_pass->to->Lookup->getParamTag("p_x_to") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($gate_pass_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($gate_pass_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $gate_pass_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($gate_pass_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($gate_pass_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($gate_pass_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($gate_pass_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $gate_pass_list->showPageHeader(); ?>
<?php
$gate_pass_list->showMessage();
?>
<?php if ($gate_pass_list->TotalRecs > 0 || $gate_pass->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($gate_pass_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> gate_pass">
<?php if (!$gate_pass->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$gate_pass->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($gate_pass_list->Pager)) $gate_pass_list->Pager = new PrevNextPager($gate_pass_list->StartRec, $gate_pass_list->DisplayRecs, $gate_pass_list->TotalRecs, $gate_pass_list->AutoHidePager) ?>
<?php if ($gate_pass_list->Pager->RecordCount > 0 && $gate_pass_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($gate_pass_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $gate_pass_list->pageUrl() ?>start=<?php echo $gate_pass_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($gate_pass_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $gate_pass_list->pageUrl() ?>start=<?php echo $gate_pass_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $gate_pass_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($gate_pass_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $gate_pass_list->pageUrl() ?>start=<?php echo $gate_pass_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($gate_pass_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $gate_pass_list->pageUrl() ?>start=<?php echo $gate_pass_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $gate_pass_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($gate_pass_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $gate_pass_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $gate_pass_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $gate_pass_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($gate_pass_list->TotalRecs > 0 && (!$gate_pass_list->AutoHidePageSizeSelector || $gate_pass_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="gate_pass">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($gate_pass_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($gate_pass_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($gate_pass_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($gate_pass_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($gate_pass_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($gate_pass->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $gate_pass_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fgate_passlist" id="fgate_passlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($gate_pass_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $gate_pass_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="gate_pass">
<div id="gmp_gate_pass" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($gate_pass_list->TotalRecs > 0 || $gate_pass->isGridEdit()) { ?>
<table id="tbl_gate_passlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$gate_pass_list->RowType = ROWTYPE_HEADER;

// Render list options
$gate_pass_list->renderListOptions();

// Render list options (header, left)
$gate_pass_list->ListOptions->render("header", "left");
?>
<?php if ($gate_pass->gp_no->Visible) { // gp_no ?>
	<?php if ($gate_pass->sortUrl($gate_pass->gp_no) == "") { ?>
		<th data-name="gp_no" class="<?php echo $gate_pass->gp_no->headerCellClass() ?>"><div id="elh_gate_pass_gp_no" class="gate_pass_gp_no"><div class="ew-table-header-caption"><?php echo $gate_pass->gp_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gp_no" class="<?php echo $gate_pass->gp_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->gp_no) ?>',2);"><div id="elh_gate_pass_gp_no" class="gate_pass_gp_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->gp_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->gp_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->gp_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->company_id->Visible) { // company_id ?>
	<?php if ($gate_pass->sortUrl($gate_pass->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $gate_pass->company_id->headerCellClass() ?>"><div id="elh_gate_pass_company_id" class="gate_pass_company_id"><div class="ew-table-header-caption"><?php echo $gate_pass->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $gate_pass->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->company_id) ?>',2);"><div id="elh_gate_pass_company_id" class="gate_pass_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->from->Visible) { // from ?>
	<?php if ($gate_pass->sortUrl($gate_pass->from) == "") { ?>
		<th data-name="from" class="<?php echo $gate_pass->from->headerCellClass() ?>"><div id="elh_gate_pass_from" class="gate_pass_from"><div class="ew-table-header-caption"><?php echo $gate_pass->from->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="from" class="<?php echo $gate_pass->from->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->from) ?>',2);"><div id="elh_gate_pass_from" class="gate_pass_from">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->from->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->from->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->from->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->to->Visible) { // to ?>
	<?php if ($gate_pass->sortUrl($gate_pass->to) == "") { ?>
		<th data-name="to" class="<?php echo $gate_pass->to->headerCellClass() ?>"><div id="elh_gate_pass_to" class="gate_pass_to"><div class="ew-table-header-caption"><?php echo $gate_pass->to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="to" class="<?php echo $gate_pass->to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->to) ?>',2);"><div id="elh_gate_pass_to" class="gate_pass_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->to->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->attention->Visible) { // attention ?>
	<?php if ($gate_pass->sortUrl($gate_pass->attention) == "") { ?>
		<th data-name="attention" class="<?php echo $gate_pass->attention->headerCellClass() ?>"><div id="elh_gate_pass_attention" class="gate_pass_attention"><div class="ew-table-header-caption"><?php echo $gate_pass->attention->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="attention" class="<?php echo $gate_pass->attention->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->attention) ?>',2);"><div id="elh_gate_pass_attention" class="gate_pass_attention">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->attention->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->attention->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->attention->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->transfer_nature->Visible) { // transfer_nature ?>
	<?php if ($gate_pass->sortUrl($gate_pass->transfer_nature) == "") { ?>
		<th data-name="transfer_nature" class="<?php echo $gate_pass->transfer_nature->headerCellClass() ?>"><div id="elh_gate_pass_transfer_nature" class="gate_pass_transfer_nature"><div class="ew-table-header-caption"><?php echo $gate_pass->transfer_nature->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="transfer_nature" class="<?php echo $gate_pass->transfer_nature->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->transfer_nature) ?>',2);"><div id="elh_gate_pass_transfer_nature" class="gate_pass_transfer_nature">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->transfer_nature->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->transfer_nature->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->transfer_nature->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->due_date->Visible) { // due_date ?>
	<?php if ($gate_pass->sortUrl($gate_pass->due_date) == "") { ?>
		<th data-name="due_date" class="<?php echo $gate_pass->due_date->headerCellClass() ?>"><div id="elh_gate_pass_due_date" class="gate_pass_due_date"><div class="ew-table-header-caption"><?php echo $gate_pass->due_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="due_date" class="<?php echo $gate_pass->due_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->due_date) ?>',2);"><div id="elh_gate_pass_due_date" class="gate_pass_due_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->due_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->due_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->due_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->jc_no->Visible) { // jc_no ?>
	<?php if ($gate_pass->sortUrl($gate_pass->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $gate_pass->jc_no->headerCellClass() ?>"><div id="elh_gate_pass_jc_no" class="gate_pass_jc_no"><div class="ew-table-header-caption"><?php echo $gate_pass->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $gate_pass->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->jc_no) ?>',2);"><div id="elh_gate_pass_jc_no" class="gate_pass_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->item->Visible) { // item ?>
	<?php if ($gate_pass->sortUrl($gate_pass->item) == "") { ?>
		<th data-name="item" class="<?php echo $gate_pass->item->headerCellClass() ?>"><div id="elh_gate_pass_item" class="gate_pass_item"><div class="ew-table-header-caption"><?php echo $gate_pass->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $gate_pass->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->item) ?>',2);"><div id="elh_gate_pass_item" class="gate_pass_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->sender_comments->Visible) { // sender_comments ?>
	<?php if ($gate_pass->sortUrl($gate_pass->sender_comments) == "") { ?>
		<th data-name="sender_comments" class="<?php echo $gate_pass->sender_comments->headerCellClass() ?>"><div id="elh_gate_pass_sender_comments" class="gate_pass_sender_comments"><div class="ew-table-header-caption"><?php echo $gate_pass->sender_comments->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sender_comments" class="<?php echo $gate_pass->sender_comments->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->sender_comments) ?>',2);"><div id="elh_gate_pass_sender_comments" class="gate_pass_sender_comments">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->sender_comments->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->sender_comments->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->sender_comments->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->despatch_details->Visible) { // despatch details ?>
	<?php if ($gate_pass->sortUrl($gate_pass->despatch_details) == "") { ?>
		<th data-name="despatch_details" class="<?php echo $gate_pass->despatch_details->headerCellClass() ?>"><div id="elh_gate_pass_despatch_details" class="gate_pass_despatch_details"><div class="ew-table-header-caption"><?php echo $gate_pass->despatch_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_details" class="<?php echo $gate_pass->despatch_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->despatch_details) ?>',2);"><div id="elh_gate_pass_despatch_details" class="gate_pass_despatch_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->despatch_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->despatch_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->despatch_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->t_mode->Visible) { // t_mode ?>
	<?php if ($gate_pass->sortUrl($gate_pass->t_mode) == "") { ?>
		<th data-name="t_mode" class="<?php echo $gate_pass->t_mode->headerCellClass() ?>"><div id="elh_gate_pass_t_mode" class="gate_pass_t_mode"><div class="ew-table-header-caption"><?php echo $gate_pass->t_mode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_mode" class="<?php echo $gate_pass->t_mode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->t_mode) ?>',2);"><div id="elh_gate_pass_t_mode" class="gate_pass_t_mode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->t_mode->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->t_mode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->t_mode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->t_distance->Visible) { // t_distance ?>
	<?php if ($gate_pass->sortUrl($gate_pass->t_distance) == "") { ?>
		<th data-name="t_distance" class="<?php echo $gate_pass->t_distance->headerCellClass() ?>"><div id="elh_gate_pass_t_distance" class="gate_pass_t_distance"><div class="ew-table-header-caption"><?php echo $gate_pass->t_distance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_distance" class="<?php echo $gate_pass->t_distance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->t_distance) ?>',2);"><div id="elh_gate_pass_t_distance" class="gate_pass_t_distance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->t_distance->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->t_distance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->t_distance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->t_v_no->Visible) { // t_v_no ?>
	<?php if ($gate_pass->sortUrl($gate_pass->t_v_no) == "") { ?>
		<th data-name="t_v_no" class="<?php echo $gate_pass->t_v_no->headerCellClass() ?>"><div id="elh_gate_pass_t_v_no" class="gate_pass_t_v_no"><div class="ew-table-header-caption"><?php echo $gate_pass->t_v_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_v_no" class="<?php echo $gate_pass->t_v_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->t_v_no) ?>',2);"><div id="elh_gate_pass_t_v_no" class="gate_pass_t_v_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->t_v_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->t_v_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->t_v_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->purpose->Visible) { // purpose ?>
	<?php if ($gate_pass->sortUrl($gate_pass->purpose) == "") { ?>
		<th data-name="purpose" class="<?php echo $gate_pass->purpose->headerCellClass() ?>"><div id="elh_gate_pass_purpose" class="gate_pass_purpose"><div class="ew-table-header-caption"><?php echo $gate_pass->purpose->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="purpose" class="<?php echo $gate_pass->purpose->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->purpose) ?>',2);"><div id="elh_gate_pass_purpose" class="gate_pass_purpose">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->purpose->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->purpose->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->purpose->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->operator->Visible) { // operator ?>
	<?php if ($gate_pass->sortUrl($gate_pass->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $gate_pass->operator->headerCellClass() ?>"><div id="elh_gate_pass_operator" class="gate_pass_operator"><div class="ew-table-header-caption"><?php echo $gate_pass->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $gate_pass->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->operator) ?>',2);"><div id="elh_gate_pass_operator" class="gate_pass_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->datetime->Visible) { // datetime ?>
	<?php if ($gate_pass->sortUrl($gate_pass->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $gate_pass->datetime->headerCellClass() ?>"><div id="elh_gate_pass_datetime" class="gate_pass_datetime"><div class="ew-table-header-caption"><?php echo $gate_pass->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $gate_pass->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->datetime) ?>',2);"><div id="elh_gate_pass_datetime" class="gate_pass_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->e_operator->Visible) { // e_operator ?>
	<?php if ($gate_pass->sortUrl($gate_pass->e_operator) == "") { ?>
		<th data-name="e_operator" class="<?php echo $gate_pass->e_operator->headerCellClass() ?>"><div id="elh_gate_pass_e_operator" class="gate_pass_e_operator"><div class="ew-table-header-caption"><?php echo $gate_pass->e_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="e_operator" class="<?php echo $gate_pass->e_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->e_operator) ?>',2);"><div id="elh_gate_pass_e_operator" class="gate_pass_e_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->e_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->e_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->e_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->e_datetime->Visible) { // e_datetime ?>
	<?php if ($gate_pass->sortUrl($gate_pass->e_datetime) == "") { ?>
		<th data-name="e_datetime" class="<?php echo $gate_pass->e_datetime->headerCellClass() ?>"><div id="elh_gate_pass_e_datetime" class="gate_pass_e_datetime"><div class="ew-table-header-caption"><?php echo $gate_pass->e_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="e_datetime" class="<?php echo $gate_pass->e_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->e_datetime) ?>',2);"><div id="elh_gate_pass_e_datetime" class="gate_pass_e_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->e_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->e_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->e_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->receiving_condition->Visible) { // receiving_condition ?>
	<?php if ($gate_pass->sortUrl($gate_pass->receiving_condition) == "") { ?>
		<th data-name="receiving_condition" class="<?php echo $gate_pass->receiving_condition->headerCellClass() ?>"><div id="elh_gate_pass_receiving_condition" class="gate_pass_receiving_condition"><div class="ew-table-header-caption"><?php echo $gate_pass->receiving_condition->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="receiving_condition" class="<?php echo $gate_pass->receiving_condition->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->receiving_condition) ?>',2);"><div id="elh_gate_pass_receiving_condition" class="gate_pass_receiving_condition">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->receiving_condition->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->receiving_condition->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->receiving_condition->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->receiver_comments->Visible) { // receiver_comments ?>
	<?php if ($gate_pass->sortUrl($gate_pass->receiver_comments) == "") { ?>
		<th data-name="receiver_comments" class="<?php echo $gate_pass->receiver_comments->headerCellClass() ?>"><div id="elh_gate_pass_receiver_comments" class="gate_pass_receiver_comments"><div class="ew-table-header-caption"><?php echo $gate_pass->receiver_comments->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="receiver_comments" class="<?php echo $gate_pass->receiver_comments->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->receiver_comments) ?>',2);"><div id="elh_gate_pass_receiver_comments" class="gate_pass_receiver_comments">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->receiver_comments->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->receiver_comments->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->receiver_comments->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->r_operator->Visible) { // r_operator ?>
	<?php if ($gate_pass->sortUrl($gate_pass->r_operator) == "") { ?>
		<th data-name="r_operator" class="<?php echo $gate_pass->r_operator->headerCellClass() ?>"><div id="elh_gate_pass_r_operator" class="gate_pass_r_operator"><div class="ew-table-header-caption"><?php echo $gate_pass->r_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_operator" class="<?php echo $gate_pass->r_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->r_operator) ?>',2);"><div id="elh_gate_pass_r_operator" class="gate_pass_r_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->r_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->r_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->r_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->r_datetime->Visible) { // r_datetime ?>
	<?php if ($gate_pass->sortUrl($gate_pass->r_datetime) == "") { ?>
		<th data-name="r_datetime" class="<?php echo $gate_pass->r_datetime->headerCellClass() ?>"><div id="elh_gate_pass_r_datetime" class="gate_pass_r_datetime"><div class="ew-table-header-caption"><?php echo $gate_pass->r_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_datetime" class="<?php echo $gate_pass->r_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->r_datetime) ?>',2);"><div id="elh_gate_pass_r_datetime" class="gate_pass_r_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->r_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->r_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->r_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($gate_pass->from_po->Visible) { // from_po ?>
	<?php if ($gate_pass->sortUrl($gate_pass->from_po) == "") { ?>
		<th data-name="from_po" class="<?php echo $gate_pass->from_po->headerCellClass() ?>"><div id="elh_gate_pass_from_po" class="gate_pass_from_po"><div class="ew-table-header-caption"><?php echo $gate_pass->from_po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="from_po" class="<?php echo $gate_pass->from_po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $gate_pass->SortUrl($gate_pass->from_po) ?>',2);"><div id="elh_gate_pass_from_po" class="gate_pass_from_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $gate_pass->from_po->caption() ?></span><span class="ew-table-header-sort"><?php if ($gate_pass->from_po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($gate_pass->from_po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$gate_pass_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($gate_pass->ExportAll && $gate_pass->isExport()) {
	$gate_pass_list->StopRec = $gate_pass_list->TotalRecs;
} else {

	// Set the last record to display
	if ($gate_pass_list->TotalRecs > $gate_pass_list->StartRec + $gate_pass_list->DisplayRecs - 1)
		$gate_pass_list->StopRec = $gate_pass_list->StartRec + $gate_pass_list->DisplayRecs - 1;
	else
		$gate_pass_list->StopRec = $gate_pass_list->TotalRecs;
}
$gate_pass_list->RecCnt = $gate_pass_list->StartRec - 1;
if ($gate_pass_list->Recordset && !$gate_pass_list->Recordset->EOF) {
	$gate_pass_list->Recordset->moveFirst();
	$selectLimit = $gate_pass_list->UseSelectLimit;
	if (!$selectLimit && $gate_pass_list->StartRec > 1)
		$gate_pass_list->Recordset->move($gate_pass_list->StartRec - 1);
} elseif (!$gate_pass->AllowAddDeleteRow && $gate_pass_list->StopRec == 0) {
	$gate_pass_list->StopRec = $gate_pass->GridAddRowCount;
}

// Initialize aggregate
$gate_pass->RowType = ROWTYPE_AGGREGATEINIT;
$gate_pass->resetAttributes();
$gate_pass_list->renderRow();
while ($gate_pass_list->RecCnt < $gate_pass_list->StopRec) {
	$gate_pass_list->RecCnt++;
	if ($gate_pass_list->RecCnt >= $gate_pass_list->StartRec) {
		$gate_pass_list->RowCnt++;

		// Set up key count
		$gate_pass_list->KeyCount = $gate_pass_list->RowIndex;

		// Init row class and style
		$gate_pass->resetAttributes();
		$gate_pass->CssClass = "";
		if ($gate_pass->isGridAdd()) {
		} else {
			$gate_pass_list->loadRowValues($gate_pass_list->Recordset); // Load row values
		}
		$gate_pass->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$gate_pass->RowAttrs = array_merge($gate_pass->RowAttrs, array('data-rowindex'=>$gate_pass_list->RowCnt, 'id'=>'r' . $gate_pass_list->RowCnt . '_gate_pass', 'data-rowtype'=>$gate_pass->RowType));

		// Render row
		$gate_pass_list->renderRow();

		// Render list options
		$gate_pass_list->renderListOptions();
?>
	<tr<?php echo $gate_pass->rowAttributes() ?>>
<?php

// Render list options (body, left)
$gate_pass_list->ListOptions->render("body", "left", $gate_pass_list->RowCnt);
?>
	<?php if ($gate_pass->gp_no->Visible) { // gp_no ?>
		<td data-name="gp_no"<?php echo $gate_pass->gp_no->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_gp_no" class="gate_pass_gp_no">
<span<?php echo $gate_pass->gp_no->viewAttributes() ?>>
<?php echo $gate_pass->gp_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $gate_pass->company_id->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_company_id" class="gate_pass_company_id">
<span<?php echo $gate_pass->company_id->viewAttributes() ?>>
<?php echo $gate_pass->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->from->Visible) { // from ?>
		<td data-name="from"<?php echo $gate_pass->from->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_from" class="gate_pass_from">
<span<?php echo $gate_pass->from->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass->from->getViewValue())) && $gate_pass->from->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass->from->linkAttributes() ?>><?php echo $gate_pass->from->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass->from->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->to->Visible) { // to ?>
		<td data-name="to"<?php echo $gate_pass->to->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_to" class="gate_pass_to">
<span<?php echo $gate_pass->to->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass->to->getViewValue())) && $gate_pass->to->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass->to->linkAttributes() ?>><?php echo $gate_pass->to->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass->to->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->attention->Visible) { // attention ?>
		<td data-name="attention"<?php echo $gate_pass->attention->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_attention" class="gate_pass_attention">
<span<?php echo $gate_pass->attention->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass->attention->getViewValue())) && $gate_pass->attention->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass->attention->linkAttributes() ?>><?php echo $gate_pass->attention->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass->attention->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->transfer_nature->Visible) { // transfer_nature ?>
		<td data-name="transfer_nature"<?php echo $gate_pass->transfer_nature->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_transfer_nature" class="gate_pass_transfer_nature">
<span<?php echo $gate_pass->transfer_nature->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass->transfer_nature->getViewValue())) && $gate_pass->transfer_nature->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass->transfer_nature->linkAttributes() ?>><?php echo $gate_pass->transfer_nature->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass->transfer_nature->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->due_date->Visible) { // due_date ?>
		<td data-name="due_date"<?php echo $gate_pass->due_date->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_due_date" class="gate_pass_due_date">
<span<?php echo $gate_pass->due_date->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass->due_date->getViewValue())) && $gate_pass->due_date->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass->due_date->linkAttributes() ?>><?php echo $gate_pass->due_date->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass->due_date->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $gate_pass->jc_no->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_jc_no" class="gate_pass_jc_no">
<span<?php echo $gate_pass->jc_no->viewAttributes() ?>>
<?php echo $gate_pass->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->item->Visible) { // item ?>
		<td data-name="item"<?php echo $gate_pass->item->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_item" class="gate_pass_item">
<span<?php echo $gate_pass->item->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass->item->getViewValue())) && $gate_pass->item->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass->item->linkAttributes() ?>><?php echo $gate_pass->item->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass->item->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->sender_comments->Visible) { // sender_comments ?>
		<td data-name="sender_comments"<?php echo $gate_pass->sender_comments->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_sender_comments" class="gate_pass_sender_comments">
<span<?php echo $gate_pass->sender_comments->viewAttributes() ?>>
<?php echo $gate_pass->sender_comments->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->despatch_details->Visible) { // despatch details ?>
		<td data-name="despatch_details"<?php echo $gate_pass->despatch_details->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_despatch_details" class="gate_pass_despatch_details">
<span<?php echo $gate_pass->despatch_details->viewAttributes() ?>>
<?php echo $gate_pass->despatch_details->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->t_mode->Visible) { // t_mode ?>
		<td data-name="t_mode"<?php echo $gate_pass->t_mode->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_t_mode" class="gate_pass_t_mode">
<span<?php echo $gate_pass->t_mode->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass->t_mode->getViewValue())) && $gate_pass->t_mode->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass->t_mode->linkAttributes() ?>><?php echo $gate_pass->t_mode->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass->t_mode->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->t_distance->Visible) { // t_distance ?>
		<td data-name="t_distance"<?php echo $gate_pass->t_distance->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_t_distance" class="gate_pass_t_distance">
<span<?php echo $gate_pass->t_distance->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass->t_distance->getViewValue())) && $gate_pass->t_distance->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass->t_distance->linkAttributes() ?>><?php echo $gate_pass->t_distance->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass->t_distance->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->t_v_no->Visible) { // t_v_no ?>
		<td data-name="t_v_no"<?php echo $gate_pass->t_v_no->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_t_v_no" class="gate_pass_t_v_no">
<span<?php echo $gate_pass->t_v_no->viewAttributes() ?>>
<?php echo $gate_pass->t_v_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->purpose->Visible) { // purpose ?>
		<td data-name="purpose"<?php echo $gate_pass->purpose->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_purpose" class="gate_pass_purpose">
<span<?php echo $gate_pass->purpose->viewAttributes() ?>>
<?php echo $gate_pass->purpose->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $gate_pass->operator->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_operator" class="gate_pass_operator">
<span<?php echo $gate_pass->operator->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass->operator->getViewValue())) && $gate_pass->operator->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass->operator->linkAttributes() ?>><?php echo $gate_pass->operator->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass->operator->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $gate_pass->datetime->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_datetime" class="gate_pass_datetime">
<span<?php echo $gate_pass->datetime->viewAttributes() ?>>
<?php echo $gate_pass->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->e_operator->Visible) { // e_operator ?>
		<td data-name="e_operator"<?php echo $gate_pass->e_operator->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_e_operator" class="gate_pass_e_operator">
<span<?php echo $gate_pass->e_operator->viewAttributes() ?>>
<?php echo $gate_pass->e_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->e_datetime->Visible) { // e_datetime ?>
		<td data-name="e_datetime"<?php echo $gate_pass->e_datetime->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_e_datetime" class="gate_pass_e_datetime">
<span<?php echo $gate_pass->e_datetime->viewAttributes() ?>>
<?php echo $gate_pass->e_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->receiving_condition->Visible) { // receiving_condition ?>
		<td data-name="receiving_condition"<?php echo $gate_pass->receiving_condition->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_receiving_condition" class="gate_pass_receiving_condition">
<span<?php echo $gate_pass->receiving_condition->viewAttributes() ?>>
<?php if ((!EmptyString($gate_pass->receiving_condition->getViewValue())) && $gate_pass->receiving_condition->linkAttributes() <> "") { ?>
<a<?php echo $gate_pass->receiving_condition->linkAttributes() ?>><?php echo $gate_pass->receiving_condition->getViewValue() ?></a>
<?php } else { ?>
<?php echo $gate_pass->receiving_condition->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->receiver_comments->Visible) { // receiver_comments ?>
		<td data-name="receiver_comments"<?php echo $gate_pass->receiver_comments->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_receiver_comments" class="gate_pass_receiver_comments">
<span<?php echo $gate_pass->receiver_comments->viewAttributes() ?>>
<?php echo $gate_pass->receiver_comments->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->r_operator->Visible) { // r_operator ?>
		<td data-name="r_operator"<?php echo $gate_pass->r_operator->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_r_operator" class="gate_pass_r_operator">
<span<?php echo $gate_pass->r_operator->viewAttributes() ?>>
<?php echo $gate_pass->r_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->r_datetime->Visible) { // r_datetime ?>
		<td data-name="r_datetime"<?php echo $gate_pass->r_datetime->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_r_datetime" class="gate_pass_r_datetime">
<span<?php echo $gate_pass->r_datetime->viewAttributes() ?>>
<?php echo $gate_pass->r_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($gate_pass->from_po->Visible) { // from_po ?>
		<td data-name="from_po"<?php echo $gate_pass->from_po->cellAttributes() ?>>
<span id="el<?php echo $gate_pass_list->RowCnt ?>_gate_pass_from_po" class="gate_pass_from_po">
<span<?php echo $gate_pass->from_po->viewAttributes() ?>>
<?php echo $gate_pass->from_po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$gate_pass_list->ListOptions->render("body", "right", $gate_pass_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$gate_pass->isGridAdd())
		$gate_pass_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$gate_pass->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($gate_pass_list->Recordset)
	$gate_pass_list->Recordset->Close();
?>
<?php if (!$gate_pass->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$gate_pass->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($gate_pass_list->Pager)) $gate_pass_list->Pager = new PrevNextPager($gate_pass_list->StartRec, $gate_pass_list->DisplayRecs, $gate_pass_list->TotalRecs, $gate_pass_list->AutoHidePager) ?>
<?php if ($gate_pass_list->Pager->RecordCount > 0 && $gate_pass_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($gate_pass_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $gate_pass_list->pageUrl() ?>start=<?php echo $gate_pass_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($gate_pass_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $gate_pass_list->pageUrl() ?>start=<?php echo $gate_pass_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $gate_pass_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($gate_pass_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $gate_pass_list->pageUrl() ?>start=<?php echo $gate_pass_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($gate_pass_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $gate_pass_list->pageUrl() ?>start=<?php echo $gate_pass_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $gate_pass_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($gate_pass_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $gate_pass_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $gate_pass_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $gate_pass_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($gate_pass_list->TotalRecs > 0 && (!$gate_pass_list->AutoHidePageSizeSelector || $gate_pass_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="gate_pass">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($gate_pass_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($gate_pass_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($gate_pass_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($gate_pass_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($gate_pass_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($gate_pass->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $gate_pass_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($gate_pass_list->TotalRecs == 0 && !$gate_pass->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $gate_pass_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$gate_pass_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$gate_pass->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$gate_pass->isExport()) { ?>
<script>
ew.scrollableTable("gmp_gate_pass", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$gate_pass_list->terminate();
?>