<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$gate_pass_search = new gate_pass_search();

// Run the page
$gate_pass_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$gate_pass_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($gate_pass_search->IsModal) { ?>
var fgate_passsearch = currentAdvancedSearchForm = new ew.Form("fgate_passsearch", "search");
<?php } else { ?>
var fgate_passsearch = currentForm = new ew.Form("fgate_passsearch", "search");
<?php } ?>

// Form_CustomValidate event
fgate_passsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgate_passsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgate_passsearch.lists["x_company_id"] = <?php echo $gate_pass_search->company_id->Lookup->toClientList() ?>;
fgate_passsearch.lists["x_company_id"].options = <?php echo JsonEncode($gate_pass_search->company_id->lookupOptions()) ?>;
fgate_passsearch.lists["x_from"] = <?php echo $gate_pass_search->from->Lookup->toClientList() ?>;
fgate_passsearch.lists["x_from"].options = <?php echo JsonEncode($gate_pass_search->from->lookupOptions()) ?>;
fgate_passsearch.lists["x_to"] = <?php echo $gate_pass_search->to->Lookup->toClientList() ?>;
fgate_passsearch.lists["x_to"].options = <?php echo JsonEncode($gate_pass_search->to->lookupOptions()) ?>;
fgate_passsearch.lists["x_attention"] = <?php echo $gate_pass_search->attention->Lookup->toClientList() ?>;
fgate_passsearch.lists["x_attention"].options = <?php echo JsonEncode($gate_pass_search->attention->lookupOptions()) ?>;
fgate_passsearch.lists["x_transfer_nature"] = <?php echo $gate_pass_search->transfer_nature->Lookup->toClientList() ?>;
fgate_passsearch.lists["x_transfer_nature"].options = <?php echo JsonEncode($gate_pass_search->transfer_nature->options(FALSE, TRUE)) ?>;
fgate_passsearch.lists["x_t_mode"] = <?php echo $gate_pass_search->t_mode->Lookup->toClientList() ?>;
fgate_passsearch.lists["x_t_mode"].options = <?php echo JsonEncode($gate_pass_search->t_mode->options(FALSE, TRUE)) ?>;
fgate_passsearch.lists["x_operator"] = <?php echo $gate_pass_search->operator->Lookup->toClientList() ?>;
fgate_passsearch.lists["x_operator"].options = <?php echo JsonEncode($gate_pass_search->operator->lookupOptions()) ?>;
fgate_passsearch.lists["x_receiving_condition"] = <?php echo $gate_pass_search->receiving_condition->Lookup->toClientList() ?>;
fgate_passsearch.lists["x_receiving_condition"].options = <?php echo JsonEncode($gate_pass_search->receiving_condition->options(FALSE, TRUE)) ?>;
fgate_passsearch.lists["x_r_operator"] = <?php echo $gate_pass_search->r_operator->Lookup->toClientList() ?>;
fgate_passsearch.lists["x_r_operator"].options = <?php echo JsonEncode($gate_pass_search->r_operator->lookupOptions()) ?>;
fgate_passsearch.lists["x_r_e_user_id"] = <?php echo $gate_pass_search->r_e_user_id->Lookup->toClientList() ?>;
fgate_passsearch.lists["x_r_e_user_id"].options = <?php echo JsonEncode($gate_pass_search->r_e_user_id->lookupOptions()) ?>;
fgate_passsearch.lists["x_group"] = <?php echo $gate_pass_search->group->Lookup->toClientList() ?>;
fgate_passsearch.lists["x_group"].options = <?php echo JsonEncode($gate_pass_search->group->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fgate_passsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_gp_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass->gp_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_due_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass->due_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_jc_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass->jc_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_t_distance");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass->t_distance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_e_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass->e_operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_e_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass->e_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_receiver_comments");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass->receiver_comments->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_r_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass->r_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_updated");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass->updated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_r_e_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass->r_e_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_product");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass->product->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_from_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($gate_pass->from_po->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $gate_pass_search->showPageHeader(); ?>
<?php
$gate_pass_search->showMessage();
?>
<form name="fgate_passsearch" id="fgate_passsearch" class="<?php echo $gate_pass_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($gate_pass_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $gate_pass_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="gate_pass">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$gate_pass_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($gate_pass->gp_no->Visible) { // gp_no ?>
	<div id="r_gp_no" class="form-group row">
		<label for="x_gp_no" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_gp_no"><?php echo $gate_pass->gp_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gp_no" id="z_gp_no" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->gp_no->cellAttributes() ?>>
			<span id="el_gate_pass_gp_no">
<input type="text" data-table="gate_pass" data-field="x_gp_no" name="x_gp_no" id="x_gp_no" size="30" placeholder="<?php echo HtmlEncode($gate_pass->gp_no->getPlaceHolder()) ?>" value="<?php echo $gate_pass->gp_no->EditValue ?>"<?php echo $gate_pass->gp_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label for="x_company_id" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_company_id"><?php echo $gate_pass->company_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company_id" id="z_company_id" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->company_id->cellAttributes() ?>>
			<span id="el_gate_pass_company_id">
<?php $gate_pass->company_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$gate_pass->company_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass" data-field="x_company_id" data-value-separator="<?php echo $gate_pass->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $gate_pass->company_id->editAttributes() ?>>
		<?php echo $gate_pass->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $gate_pass->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->from->Visible) { // from ?>
	<div id="r_from" class="form-group row">
		<label for="x_from" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_from"><?php echo $gate_pass->from->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_from" id="z_from" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->from->cellAttributes() ?>>
			<span id="el_gate_pass_from">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass" data-field="x_from" data-value-separator="<?php echo $gate_pass->from->displayValueSeparatorAttribute() ?>" id="x_from" name="x_from"<?php echo $gate_pass->from->editAttributes() ?>>
		<?php echo $gate_pass->from->selectOptionListHtml("x_from") ?>
	</select>
</div>
<?php echo $gate_pass->from->Lookup->getParamTag("p_x_from") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->to->Visible) { // to ?>
	<div id="r_to" class="form-group row">
		<label for="x_to" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_to"><?php echo $gate_pass->to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_to" id="z_to" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->to->cellAttributes() ?>>
			<span id="el_gate_pass_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass" data-field="x_to" data-value-separator="<?php echo $gate_pass->to->displayValueSeparatorAttribute() ?>" id="x_to" name="x_to"<?php echo $gate_pass->to->editAttributes() ?>>
		<?php echo $gate_pass->to->selectOptionListHtml("x_to") ?>
	</select>
</div>
<?php echo $gate_pass->to->Lookup->getParamTag("p_x_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->to_other->Visible) { // to_other ?>
	<div id="r_to_other" class="form-group row">
		<label for="x_to_other" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_to_other"><?php echo $gate_pass->to_other->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_to_other" id="z_to_other" value="LIKE"></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->to_other->cellAttributes() ?>>
			<span id="el_gate_pass_to_other">
<input type="text" data-table="gate_pass" data-field="x_to_other" name="x_to_other" id="x_to_other" size="35" placeholder="<?php echo HtmlEncode($gate_pass->to_other->getPlaceHolder()) ?>" value="<?php echo $gate_pass->to_other->EditValue ?>"<?php echo $gate_pass->to_other->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->attention->Visible) { // attention ?>
	<div id="r_attention" class="form-group row">
		<label for="x_attention" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_attention"><?php echo $gate_pass->attention->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_attention" id="z_attention" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->attention->cellAttributes() ?>>
			<span id="el_gate_pass_attention">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass" data-field="x_attention" data-value-separator="<?php echo $gate_pass->attention->displayValueSeparatorAttribute() ?>" id="x_attention" name="x_attention"<?php echo $gate_pass->attention->editAttributes() ?>>
		<?php echo $gate_pass->attention->selectOptionListHtml("x_attention") ?>
	</select>
</div>
<?php echo $gate_pass->attention->Lookup->getParamTag("p_x_attention") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->transfer_nature->Visible) { // transfer_nature ?>
	<div id="r_transfer_nature" class="form-group row">
		<label for="x_transfer_nature" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_transfer_nature"><?php echo $gate_pass->transfer_nature->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_transfer_nature" id="z_transfer_nature" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->transfer_nature->cellAttributes() ?>>
			<span id="el_gate_pass_transfer_nature">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass" data-field="x_transfer_nature" data-value-separator="<?php echo $gate_pass->transfer_nature->displayValueSeparatorAttribute() ?>" id="x_transfer_nature" name="x_transfer_nature"<?php echo $gate_pass->transfer_nature->editAttributes() ?>>
		<?php echo $gate_pass->transfer_nature->selectOptionListHtml("x_transfer_nature") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->due_date->Visible) { // due_date ?>
	<div id="r_due_date" class="form-group row">
		<label for="x_due_date" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_due_date"><?php echo $gate_pass->due_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_due_date" id="z_due_date" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->due_date->cellAttributes() ?>>
			<span id="el_gate_pass_due_date">
<input type="text" data-table="gate_pass" data-field="x_due_date" name="x_due_date" id="x_due_date" placeholder="<?php echo HtmlEncode($gate_pass->due_date->getPlaceHolder()) ?>" value="<?php echo $gate_pass->due_date->EditValue ?>"<?php echo $gate_pass->due_date->editAttributes() ?>>
<?php if (!$gate_pass->due_date->ReadOnly && !$gate_pass->due_date->Disabled && !isset($gate_pass->due_date->EditAttrs["readonly"]) && !isset($gate_pass->due_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fgate_passsearch", "x_due_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label for="x_jc_no" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_jc_no"><?php echo $gate_pass->jc_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no" id="z_jc_no" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->jc_no->cellAttributes() ?>>
			<span id="el_gate_pass_jc_no">
<input type="text" data-table="gate_pass" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" size="30" placeholder="<?php echo HtmlEncode($gate_pass->jc_no->getPlaceHolder()) ?>" value="<?php echo $gate_pass->jc_no->EditValue ?>"<?php echo $gate_pass->jc_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label for="x_item" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_item"><?php echo $gate_pass->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->item->cellAttributes() ?>>
			<span id="el_gate_pass_item">
<input type="text" data-table="gate_pass" data-field="x_item" name="x_item" id="x_item" placeholder="<?php echo HtmlEncode($gate_pass->item->getPlaceHolder()) ?>" value="<?php echo $gate_pass->item->EditValue ?>"<?php echo $gate_pass->item->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->sender_comments->Visible) { // sender_comments ?>
	<div id="r_sender_comments" class="form-group row">
		<label for="x_sender_comments" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_sender_comments"><?php echo $gate_pass->sender_comments->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sender_comments" id="z_sender_comments" value="LIKE"></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->sender_comments->cellAttributes() ?>>
			<span id="el_gate_pass_sender_comments">
<input type="text" data-table="gate_pass" data-field="x_sender_comments" name="x_sender_comments" id="x_sender_comments" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($gate_pass->sender_comments->getPlaceHolder()) ?>" value="<?php echo $gate_pass->sender_comments->EditValue ?>"<?php echo $gate_pass->sender_comments->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->despatch_details->Visible) { // despatch details ?>
	<div id="r_despatch_details" class="form-group row">
		<label for="x_despatch_details" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_despatch_details"><?php echo $gate_pass->despatch_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_despatch_details" id="z_despatch_details" value="LIKE"></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->despatch_details->cellAttributes() ?>>
			<span id="el_gate_pass_despatch_details">
<input type="text" data-table="gate_pass" data-field="x_despatch_details" name="x_despatch_details" id="x_despatch_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($gate_pass->despatch_details->getPlaceHolder()) ?>" value="<?php echo $gate_pass->despatch_details->EditValue ?>"<?php echo $gate_pass->despatch_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->t_mode->Visible) { // t_mode ?>
	<div id="r_t_mode" class="form-group row">
		<label for="x_t_mode" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_t_mode"><?php echo $gate_pass->t_mode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_t_mode" id="z_t_mode" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->t_mode->cellAttributes() ?>>
			<span id="el_gate_pass_t_mode">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass" data-field="x_t_mode" data-value-separator="<?php echo $gate_pass->t_mode->displayValueSeparatorAttribute() ?>" id="x_t_mode" name="x_t_mode"<?php echo $gate_pass->t_mode->editAttributes() ?>>
		<?php echo $gate_pass->t_mode->selectOptionListHtml("x_t_mode") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->t_distance->Visible) { // t_distance ?>
	<div id="r_t_distance" class="form-group row">
		<label for="x_t_distance" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_t_distance"><?php echo $gate_pass->t_distance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_t_distance" id="z_t_distance" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->t_distance->cellAttributes() ?>>
			<span id="el_gate_pass_t_distance">
<input type="text" data-table="gate_pass" data-field="x_t_distance" name="x_t_distance" id="x_t_distance" size="30" placeholder="<?php echo HtmlEncode($gate_pass->t_distance->getPlaceHolder()) ?>" value="<?php echo $gate_pass->t_distance->EditValue ?>"<?php echo $gate_pass->t_distance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->t_v_no->Visible) { // t_v_no ?>
	<div id="r_t_v_no" class="form-group row">
		<label for="x_t_v_no" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_t_v_no"><?php echo $gate_pass->t_v_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_t_v_no" id="z_t_v_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->t_v_no->cellAttributes() ?>>
			<span id="el_gate_pass_t_v_no">
<input type="text" data-table="gate_pass" data-field="x_t_v_no" name="x_t_v_no" id="x_t_v_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($gate_pass->t_v_no->getPlaceHolder()) ?>" value="<?php echo $gate_pass->t_v_no->EditValue ?>"<?php echo $gate_pass->t_v_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->purpose->Visible) { // purpose ?>
	<div id="r_purpose" class="form-group row">
		<label for="x_purpose" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_purpose"><?php echo $gate_pass->purpose->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_purpose" id="z_purpose" value="LIKE"></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->purpose->cellAttributes() ?>>
			<span id="el_gate_pass_purpose">
<input type="text" data-table="gate_pass" data-field="x_purpose" name="x_purpose" id="x_purpose" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($gate_pass->purpose->getPlaceHolder()) ?>" value="<?php echo $gate_pass->purpose->EditValue ?>"<?php echo $gate_pass->purpose->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_operator"><?php echo $gate_pass->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->operator->cellAttributes() ?>>
			<span id="el_gate_pass_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass" data-field="x_operator" data-value-separator="<?php echo $gate_pass->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $gate_pass->operator->editAttributes() ?>>
		<?php echo $gate_pass->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $gate_pass->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_datetime"><?php echo $gate_pass->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->datetime->cellAttributes() ?>>
			<span id="el_gate_pass_datetime">
<input type="text" data-table="gate_pass" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($gate_pass->datetime->getPlaceHolder()) ?>" value="<?php echo $gate_pass->datetime->EditValue ?>"<?php echo $gate_pass->datetime->editAttributes() ?>>
<?php if (!$gate_pass->datetime->ReadOnly && !$gate_pass->datetime->Disabled && !isset($gate_pass->datetime->EditAttrs["readonly"]) && !isset($gate_pass->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fgate_passsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->e_operator->Visible) { // e_operator ?>
	<div id="r_e_operator" class="form-group row">
		<label for="x_e_operator" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_e_operator"><?php echo $gate_pass->e_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_e_operator" id="z_e_operator" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->e_operator->cellAttributes() ?>>
			<span id="el_gate_pass_e_operator">
<input type="text" data-table="gate_pass" data-field="x_e_operator" name="x_e_operator" id="x_e_operator" size="30" placeholder="<?php echo HtmlEncode($gate_pass->e_operator->getPlaceHolder()) ?>" value="<?php echo $gate_pass->e_operator->EditValue ?>"<?php echo $gate_pass->e_operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->e_datetime->Visible) { // e_datetime ?>
	<div id="r_e_datetime" class="form-group row">
		<label for="x_e_datetime" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_e_datetime"><?php echo $gate_pass->e_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_e_datetime" id="z_e_datetime" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->e_datetime->cellAttributes() ?>>
			<span id="el_gate_pass_e_datetime">
<input type="text" data-table="gate_pass" data-field="x_e_datetime" name="x_e_datetime" id="x_e_datetime" placeholder="<?php echo HtmlEncode($gate_pass->e_datetime->getPlaceHolder()) ?>" value="<?php echo $gate_pass->e_datetime->EditValue ?>"<?php echo $gate_pass->e_datetime->editAttributes() ?>>
<?php if (!$gate_pass->e_datetime->ReadOnly && !$gate_pass->e_datetime->Disabled && !isset($gate_pass->e_datetime->EditAttrs["readonly"]) && !isset($gate_pass->e_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fgate_passsearch", "x_e_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->receiving_condition->Visible) { // receiving_condition ?>
	<div id="r_receiving_condition" class="form-group row">
		<label for="x_receiving_condition" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_receiving_condition"><?php echo $gate_pass->receiving_condition->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_receiving_condition" id="z_receiving_condition" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->receiving_condition->cellAttributes() ?>>
			<span id="el_gate_pass_receiving_condition">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass" data-field="x_receiving_condition" data-value-separator="<?php echo $gate_pass->receiving_condition->displayValueSeparatorAttribute() ?>" id="x_receiving_condition" name="x_receiving_condition"<?php echo $gate_pass->receiving_condition->editAttributes() ?>>
		<?php echo $gate_pass->receiving_condition->selectOptionListHtml("x_receiving_condition") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->receiver_comments->Visible) { // receiver_comments ?>
	<div id="r_receiver_comments" class="form-group row">
		<label for="x_receiver_comments" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_receiver_comments"><?php echo $gate_pass->receiver_comments->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_receiver_comments" id="z_receiver_comments" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->receiver_comments->cellAttributes() ?>>
			<span id="el_gate_pass_receiver_comments">
<input type="text" data-table="gate_pass" data-field="x_receiver_comments" name="x_receiver_comments" id="x_receiver_comments" size="30" placeholder="<?php echo HtmlEncode($gate_pass->receiver_comments->getPlaceHolder()) ?>" value="<?php echo $gate_pass->receiver_comments->EditValue ?>"<?php echo $gate_pass->receiver_comments->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->r_operator->Visible) { // r_operator ?>
	<div id="r_r_operator" class="form-group row">
		<label for="x_r_operator" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_r_operator"><?php echo $gate_pass->r_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_r_operator" id="z_r_operator" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->r_operator->cellAttributes() ?>>
			<span id="el_gate_pass_r_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass" data-field="x_r_operator" data-value-separator="<?php echo $gate_pass->r_operator->displayValueSeparatorAttribute() ?>" id="x_r_operator" name="x_r_operator"<?php echo $gate_pass->r_operator->editAttributes() ?>>
		<?php echo $gate_pass->r_operator->selectOptionListHtml("x_r_operator") ?>
	</select>
</div>
<?php echo $gate_pass->r_operator->Lookup->getParamTag("p_x_r_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->r_datetime->Visible) { // r_datetime ?>
	<div id="r_r_datetime" class="form-group row">
		<label for="x_r_datetime" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_r_datetime"><?php echo $gate_pass->r_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_r_datetime" id="z_r_datetime" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->r_datetime->cellAttributes() ?>>
			<span id="el_gate_pass_r_datetime">
<input type="text" data-table="gate_pass" data-field="x_r_datetime" name="x_r_datetime" id="x_r_datetime" placeholder="<?php echo HtmlEncode($gate_pass->r_datetime->getPlaceHolder()) ?>" value="<?php echo $gate_pass->r_datetime->EditValue ?>"<?php echo $gate_pass->r_datetime->editAttributes() ?>>
<?php if (!$gate_pass->r_datetime->ReadOnly && !$gate_pass->r_datetime->Disabled && !isset($gate_pass->r_datetime->EditAttrs["readonly"]) && !isset($gate_pass->r_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fgate_passsearch", "x_r_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->updated->Visible) { // updated ?>
	<div id="r_updated" class="form-group row">
		<label for="x_updated" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_updated"><?php echo $gate_pass->updated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_updated" id="z_updated" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->updated->cellAttributes() ?>>
			<span id="el_gate_pass_updated">
<input type="text" data-table="gate_pass" data-field="x_updated" name="x_updated" id="x_updated" size="30" placeholder="<?php echo HtmlEncode($gate_pass->updated->getPlaceHolder()) ?>" value="<?php echo $gate_pass->updated->EditValue ?>"<?php echo $gate_pass->updated->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->r_e_user_id->Visible) { // r_e_user_id ?>
	<div id="r_r_e_user_id" class="form-group row">
		<label for="x_r_e_user_id" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_r_e_user_id"><?php echo $gate_pass->r_e_user_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_r_e_user_id" id="z_r_e_user_id" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->r_e_user_id->cellAttributes() ?>>
			<span id="el_gate_pass_r_e_user_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass" data-field="x_r_e_user_id" data-value-separator="<?php echo $gate_pass->r_e_user_id->displayValueSeparatorAttribute() ?>" id="x_r_e_user_id" name="x_r_e_user_id"<?php echo $gate_pass->r_e_user_id->editAttributes() ?>>
		<?php echo $gate_pass->r_e_user_id->selectOptionListHtml("x_r_e_user_id") ?>
	</select>
</div>
<?php echo $gate_pass->r_e_user_id->Lookup->getParamTag("p_x_r_e_user_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->r_e_datetime->Visible) { // r_e_datetime ?>
	<div id="r_r_e_datetime" class="form-group row">
		<label for="x_r_e_datetime" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_r_e_datetime"><?php echo $gate_pass->r_e_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_r_e_datetime" id="z_r_e_datetime" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->r_e_datetime->cellAttributes() ?>>
			<span id="el_gate_pass_r_e_datetime">
<input type="text" data-table="gate_pass" data-field="x_r_e_datetime" name="x_r_e_datetime" id="x_r_e_datetime" placeholder="<?php echo HtmlEncode($gate_pass->r_e_datetime->getPlaceHolder()) ?>" value="<?php echo $gate_pass->r_e_datetime->EditValue ?>"<?php echo $gate_pass->r_e_datetime->editAttributes() ?>>
<?php if (!$gate_pass->r_e_datetime->ReadOnly && !$gate_pass->r_e_datetime->Disabled && !isset($gate_pass->r_e_datetime->EditAttrs["readonly"]) && !isset($gate_pass->r_e_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fgate_passsearch", "x_r_e_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->group->Visible) { // group ?>
	<div id="r_group" class="form-group row">
		<label for="x_group" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_group"><?php echo $gate_pass->group->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_group" id="z_group" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->group->cellAttributes() ?>>
			<span id="el_gate_pass_group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="gate_pass" data-field="x_group" data-value-separator="<?php echo $gate_pass->group->displayValueSeparatorAttribute() ?>" id="x_group" name="x_group"<?php echo $gate_pass->group->editAttributes() ?>>
		<?php echo $gate_pass->group->selectOptionListHtml("x_group") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_product"><?php echo $gate_pass->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->product->cellAttributes() ?>>
			<span id="el_gate_pass_product">
<input type="text" data-table="gate_pass" data-field="x_product" name="x_product" id="x_product" size="30" placeholder="<?php echo HtmlEncode($gate_pass->product->getPlaceHolder()) ?>" value="<?php echo $gate_pass->product->EditValue ?>"<?php echo $gate_pass->product->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->count_received->Visible) { // count_received ?>
	<div id="r_count_received" class="form-group row">
		<label for="x_count_received" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_count_received"><?php echo $gate_pass->count_received->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_count_received" id="z_count_received" value="LIKE"></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->count_received->cellAttributes() ?>>
			<span id="el_gate_pass_count_received">
<input type="text" data-table="gate_pass" data-field="x_count_received" name="x_count_received" id="x_count_received" size="30" maxlength="6" placeholder="<?php echo HtmlEncode($gate_pass->count_received->getPlaceHolder()) ?>" value="<?php echo $gate_pass->count_received->EditValue ?>"<?php echo $gate_pass->count_received->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->gt_id->Visible) { // gt_id ?>
	<div id="r_gt_id" class="form-group row">
		<label for="x_gt_id" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_gt_id"><?php echo $gate_pass->gt_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_gt_id" id="z_gt_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->gt_id->cellAttributes() ?>>
			<span id="el_gate_pass_gt_id">
<input type="text" data-table="gate_pass" data-field="x_gt_id" name="x_gt_id" id="x_gt_id" size="30" maxlength="144" placeholder="<?php echo HtmlEncode($gate_pass->gt_id->getPlaceHolder()) ?>" value="<?php echo $gate_pass->gt_id->EditValue ?>"<?php echo $gate_pass->gt_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($gate_pass->from_po->Visible) { // from_po ?>
	<div id="r_from_po" class="form-group row">
		<label for="x_from_po" class="<?php echo $gate_pass_search->LeftColumnClass ?>"><span id="elh_gate_pass_from_po"><?php echo $gate_pass->from_po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_from_po" id="z_from_po" value="="></span>
		</label>
		<div class="<?php echo $gate_pass_search->RightColumnClass ?>"><div<?php echo $gate_pass->from_po->cellAttributes() ?>>
			<span id="el_gate_pass_from_po">
<input type="text" data-table="gate_pass" data-field="x_from_po" name="x_from_po" id="x_from_po" size="30" placeholder="<?php echo HtmlEncode($gate_pass->from_po->getPlaceHolder()) ?>" value="<?php echo $gate_pass->from_po->EditValue ?>"<?php echo $gate_pass->from_po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$gate_pass_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $gate_pass_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$gate_pass_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$gate_pass_search->terminate();
?>