<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$godown_table_add = new godown_table_add();

// Run the page
$godown_table_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$godown_table_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fgodown_tableadd = currentForm = new ew.Form("fgodown_tableadd", "add");

// Validate form
fgodown_tableadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($godown_table_add->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->company_id->caption(), $godown_table->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->grp->caption(), $godown_table->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_add->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->type->caption(), $godown_table->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_add->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->name->caption(), $godown_table->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_add->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->location->caption(), $godown_table->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_add->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->code->caption(), $godown_table->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($godown_table->code->errorMessage()) ?>");
		<?php if ($godown_table_add->incharge->Required) { ?>
			elm = this.getElements("x" + infix + "_incharge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->incharge->caption(), $godown_table->incharge->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_add->capacity->Required) { ?>
			elm = this.getElements("x" + infix + "_capacity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->capacity->caption(), $godown_table->capacity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_capacity");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($godown_table->capacity->errorMessage()) ?>");
		<?php if ($godown_table_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->status->caption(), $godown_table->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->operator->caption(), $godown_table->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->datetime->caption(), $godown_table->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fgodown_tableadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgodown_tableadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgodown_tableadd.lists["x_company_id"] = <?php echo $godown_table_add->company_id->Lookup->toClientList() ?>;
fgodown_tableadd.lists["x_company_id"].options = <?php echo JsonEncode($godown_table_add->company_id->lookupOptions()) ?>;
fgodown_tableadd.lists["x_grp[]"] = <?php echo $godown_table_add->grp->Lookup->toClientList() ?>;
fgodown_tableadd.lists["x_grp[]"].options = <?php echo JsonEncode($godown_table_add->grp->lookupOptions()) ?>;
fgodown_tableadd.lists["x_type"] = <?php echo $godown_table_add->type->Lookup->toClientList() ?>;
fgodown_tableadd.lists["x_type"].options = <?php echo JsonEncode($godown_table_add->type->options(FALSE, TRUE)) ?>;
fgodown_tableadd.lists["x_incharge"] = <?php echo $godown_table_add->incharge->Lookup->toClientList() ?>;
fgodown_tableadd.lists["x_incharge"].options = <?php echo JsonEncode($godown_table_add->incharge->lookupOptions()) ?>;
fgodown_tableadd.lists["x_status"] = <?php echo $godown_table_add->status->Lookup->toClientList() ?>;
fgodown_tableadd.lists["x_status"].options = <?php echo JsonEncode($godown_table_add->status->options(FALSE, TRUE)) ?>;
fgodown_tableadd.lists["x_operator"] = <?php echo $godown_table_add->operator->Lookup->toClientList() ?>;
fgodown_tableadd.lists["x_operator"].options = <?php echo JsonEncode($godown_table_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $godown_table_add->showPageHeader(); ?>
<?php
$godown_table_add->showMessage();
?>
<form name="fgodown_tableadd" id="fgodown_tableadd" class="<?php echo $godown_table_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($godown_table_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $godown_table_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="godown_table">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$godown_table_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($godown_table->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_godown_table_company_id" for="x_company_id" class="<?php echo $godown_table_add->LeftColumnClass ?>"><?php echo $godown_table->company_id->caption() ?><?php echo ($godown_table->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $godown_table_add->RightColumnClass ?>"><div<?php echo $godown_table->company_id->cellAttributes() ?>>
<span id="el_godown_table_company_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="godown_table" data-field="x_company_id" data-value-separator="<?php echo $godown_table->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $godown_table->company_id->editAttributes() ?>>
		<?php echo $godown_table->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $godown_table->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
<?php echo $godown_table->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($godown_table->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_godown_table_grp" class="<?php echo $godown_table_add->LeftColumnClass ?>"><?php echo $godown_table->grp->caption() ?><?php echo ($godown_table->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $godown_table_add->RightColumnClass ?>"><div<?php echo $godown_table->grp->cellAttributes() ?>>
<span id="el_godown_table_grp">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="godown_table" data-field="x_grp" data-value-separator="<?php echo $godown_table->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $godown_table->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $godown_table->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $godown_table->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $godown_table->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($godown_table->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_godown_table_type" for="x_type" class="<?php echo $godown_table_add->LeftColumnClass ?>"><?php echo $godown_table->type->caption() ?><?php echo ($godown_table->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $godown_table_add->RightColumnClass ?>"><div<?php echo $godown_table->type->cellAttributes() ?>>
<span id="el_godown_table_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="godown_table" data-field="x_type" data-value-separator="<?php echo $godown_table->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $godown_table->type->editAttributes() ?>>
		<?php echo $godown_table->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
<?php echo $godown_table->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($godown_table->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_godown_table_name" for="x_name" class="<?php echo $godown_table_add->LeftColumnClass ?>"><?php echo $godown_table->name->caption() ?><?php echo ($godown_table->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $godown_table_add->RightColumnClass ?>"><div<?php echo $godown_table->name->cellAttributes() ?>>
<span id="el_godown_table_name">
<input type="text" data-table="godown_table" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($godown_table->name->getPlaceHolder()) ?>" value="<?php echo $godown_table->name->EditValue ?>"<?php echo $godown_table->name->editAttributes() ?>>
</span>
<?php echo $godown_table->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($godown_table->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_godown_table_location" for="x_location" class="<?php echo $godown_table_add->LeftColumnClass ?>"><?php echo $godown_table->location->caption() ?><?php echo ($godown_table->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $godown_table_add->RightColumnClass ?>"><div<?php echo $godown_table->location->cellAttributes() ?>>
<span id="el_godown_table_location">
<textarea data-table="godown_table" data-field="x_location" name="x_location" id="x_location" cols="30" rows="4" placeholder="<?php echo HtmlEncode($godown_table->location->getPlaceHolder()) ?>"<?php echo $godown_table->location->editAttributes() ?>><?php echo $godown_table->location->EditValue ?></textarea>
</span>
<?php echo $godown_table->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($godown_table->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_godown_table_code" for="x_code" class="<?php echo $godown_table_add->LeftColumnClass ?>"><?php echo $godown_table->code->caption() ?><?php echo ($godown_table->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $godown_table_add->RightColumnClass ?>"><div<?php echo $godown_table->code->cellAttributes() ?>>
<span id="el_godown_table_code">
<input type="text" data-table="godown_table" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($godown_table->code->getPlaceHolder()) ?>" value="<?php echo $godown_table->code->EditValue ?>"<?php echo $godown_table->code->editAttributes() ?>>
</span>
<?php echo $godown_table->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($godown_table->incharge->Visible) { // incharge ?>
	<div id="r_incharge" class="form-group row">
		<label id="elh_godown_table_incharge" for="x_incharge" class="<?php echo $godown_table_add->LeftColumnClass ?>"><?php echo $godown_table->incharge->caption() ?><?php echo ($godown_table->incharge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $godown_table_add->RightColumnClass ?>"><div<?php echo $godown_table->incharge->cellAttributes() ?>>
<span id="el_godown_table_incharge">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="godown_table" data-field="x_incharge" data-value-separator="<?php echo $godown_table->incharge->displayValueSeparatorAttribute() ?>" id="x_incharge" name="x_incharge"<?php echo $godown_table->incharge->editAttributes() ?>>
		<?php echo $godown_table->incharge->selectOptionListHtml("x_incharge") ?>
	</select>
</div>
<?php echo $godown_table->incharge->Lookup->getParamTag("p_x_incharge") ?>
</span>
<?php echo $godown_table->incharge->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($godown_table->capacity->Visible) { // capacity ?>
	<div id="r_capacity" class="form-group row">
		<label id="elh_godown_table_capacity" for="x_capacity" class="<?php echo $godown_table_add->LeftColumnClass ?>"><?php echo $godown_table->capacity->caption() ?><?php echo ($godown_table->capacity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $godown_table_add->RightColumnClass ?>"><div<?php echo $godown_table->capacity->cellAttributes() ?>>
<span id="el_godown_table_capacity">
<input type="text" data-table="godown_table" data-field="x_capacity" name="x_capacity" id="x_capacity" size="30" placeholder="<?php echo HtmlEncode($godown_table->capacity->getPlaceHolder()) ?>" value="<?php echo $godown_table->capacity->EditValue ?>"<?php echo $godown_table->capacity->editAttributes() ?>>
</span>
<?php echo $godown_table->capacity->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($godown_table->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_godown_table_status" for="x_status" class="<?php echo $godown_table_add->LeftColumnClass ?>"><?php echo $godown_table->status->caption() ?><?php echo ($godown_table->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $godown_table_add->RightColumnClass ?>"><div<?php echo $godown_table->status->cellAttributes() ?>>
<span id="el_godown_table_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="godown_table" data-field="x_status" data-value-separator="<?php echo $godown_table->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $godown_table->status->editAttributes() ?>>
		<?php echo $godown_table->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $godown_table->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$godown_table_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $godown_table_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $godown_table_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$godown_table_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$godown_table_add->terminate();
?>