<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$godown_table_addopt = new godown_table_addopt();

// Run the page
$godown_table_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$godown_table_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fgodown_tableaddopt = currentForm = new ew.Form("fgodown_tableaddopt", "addopt");

// Validate form
fgodown_tableaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($godown_table_addopt->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->company_id->caption(), $godown_table->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->grp->caption(), $godown_table->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_addopt->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->type->caption(), $godown_table->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_addopt->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->name->caption(), $godown_table->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_addopt->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->location->caption(), $godown_table->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_addopt->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->code->caption(), $godown_table->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($godown_table->code->errorMessage()) ?>");
		<?php if ($godown_table_addopt->incharge->Required) { ?>
			elm = this.getElements("x" + infix + "_incharge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->incharge->caption(), $godown_table->incharge->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_addopt->capacity->Required) { ?>
			elm = this.getElements("x" + infix + "_capacity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->capacity->caption(), $godown_table->capacity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_capacity");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($godown_table->capacity->errorMessage()) ?>");
		<?php if ($godown_table_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->status->caption(), $godown_table->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->operator->caption(), $godown_table->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->datetime->caption(), $godown_table->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_table_addopt->r_text->Required) { ?>
			elm = this.getElements("x" + infix + "_r_text");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown_table->r_text->caption(), $godown_table->r_text->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fgodown_tableaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgodown_tableaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgodown_tableaddopt.lists["x_company_id"] = <?php echo $godown_table_addopt->company_id->Lookup->toClientList() ?>;
fgodown_tableaddopt.lists["x_company_id"].options = <?php echo JsonEncode($godown_table_addopt->company_id->lookupOptions()) ?>;
fgodown_tableaddopt.lists["x_grp[]"] = <?php echo $godown_table_addopt->grp->Lookup->toClientList() ?>;
fgodown_tableaddopt.lists["x_grp[]"].options = <?php echo JsonEncode($godown_table_addopt->grp->lookupOptions()) ?>;
fgodown_tableaddopt.lists["x_type"] = <?php echo $godown_table_addopt->type->Lookup->toClientList() ?>;
fgodown_tableaddopt.lists["x_type"].options = <?php echo JsonEncode($godown_table_addopt->type->options(FALSE, TRUE)) ?>;
fgodown_tableaddopt.lists["x_incharge"] = <?php echo $godown_table_addopt->incharge->Lookup->toClientList() ?>;
fgodown_tableaddopt.lists["x_incharge"].options = <?php echo JsonEncode($godown_table_addopt->incharge->lookupOptions()) ?>;
fgodown_tableaddopt.lists["x_status"] = <?php echo $godown_table_addopt->status->Lookup->toClientList() ?>;
fgodown_tableaddopt.lists["x_status"].options = <?php echo JsonEncode($godown_table_addopt->status->options(FALSE, TRUE)) ?>;
fgodown_tableaddopt.lists["x_operator"] = <?php echo $godown_table_addopt->operator->Lookup->toClientList() ?>;
fgodown_tableaddopt.lists["x_operator"].options = <?php echo JsonEncode($godown_table_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $godown_table_addopt->showPageHeader(); ?>
<?php
$godown_table_addopt->showMessage();
?>
<form name="fgodown_tableaddopt" id="fgodown_tableaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($godown_table_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $godown_table_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $godown_table_addopt->TableVar ?>">
<?php if ($godown_table->company_id->Visible) { // company_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_company_id"><?php echo $godown_table->company_id->caption() ?><?php echo ($godown_table->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="godown_table" data-field="x_company_id" data-value-separator="<?php echo $godown_table->company_id->displayValueSeparatorAttribute() ?>" id="x_company_id" name="x_company_id"<?php echo $godown_table->company_id->editAttributes() ?>>
		<?php echo $godown_table->company_id->selectOptionListHtml("x_company_id") ?>
	</select>
</div>
<?php echo $godown_table->company_id->Lookup->getParamTag("p_x_company_id") ?>
<?php echo $godown_table->company_id->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($godown_table->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label"><?php echo $godown_table->grp->caption() ?><?php echo ($godown_table->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="godown_table" data-field="x_grp" data-value-separator="<?php echo $godown_table->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $godown_table->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $godown_table->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $godown_table->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $godown_table->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($godown_table->type->Visible) { // type ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_type"><?php echo $godown_table->type->caption() ?><?php echo ($godown_table->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="godown_table" data-field="x_type" data-value-separator="<?php echo $godown_table->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $godown_table->type->editAttributes() ?>>
		<?php echo $godown_table->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $godown_table->type->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($godown_table->name->Visible) { // name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_name"><?php echo $godown_table->name->caption() ?><?php echo ($godown_table->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="godown_table" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($godown_table->name->getPlaceHolder()) ?>" value="<?php echo $godown_table->name->EditValue ?>"<?php echo $godown_table->name->editAttributes() ?>>
<?php echo $godown_table->name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($godown_table->location->Visible) { // location ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_location"><?php echo $godown_table->location->caption() ?><?php echo ($godown_table->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="godown_table" data-field="x_location" name="x_location" id="x_location" cols="30" rows="4" placeholder="<?php echo HtmlEncode($godown_table->location->getPlaceHolder()) ?>"<?php echo $godown_table->location->editAttributes() ?>><?php echo $godown_table->location->EditValue ?></textarea>
<?php echo $godown_table->location->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($godown_table->code->Visible) { // code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_code"><?php echo $godown_table->code->caption() ?><?php echo ($godown_table->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="godown_table" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($godown_table->code->getPlaceHolder()) ?>" value="<?php echo $godown_table->code->EditValue ?>"<?php echo $godown_table->code->editAttributes() ?>>
<?php echo $godown_table->code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($godown_table->incharge->Visible) { // incharge ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_incharge"><?php echo $godown_table->incharge->caption() ?><?php echo ($godown_table->incharge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="godown_table" data-field="x_incharge" data-value-separator="<?php echo $godown_table->incharge->displayValueSeparatorAttribute() ?>" id="x_incharge" name="x_incharge"<?php echo $godown_table->incharge->editAttributes() ?>>
		<?php echo $godown_table->incharge->selectOptionListHtml("x_incharge") ?>
	</select>
</div>
<?php echo $godown_table->incharge->Lookup->getParamTag("p_x_incharge") ?>
<?php echo $godown_table->incharge->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($godown_table->capacity->Visible) { // capacity ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_capacity"><?php echo $godown_table->capacity->caption() ?><?php echo ($godown_table->capacity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="godown_table" data-field="x_capacity" name="x_capacity" id="x_capacity" size="30" placeholder="<?php echo HtmlEncode($godown_table->capacity->getPlaceHolder()) ?>" value="<?php echo $godown_table->capacity->EditValue ?>"<?php echo $godown_table->capacity->editAttributes() ?>>
<?php echo $godown_table->capacity->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($godown_table->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $godown_table->status->caption() ?><?php echo ($godown_table->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="godown_table" data-field="x_status" data-value-separator="<?php echo $godown_table->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $godown_table->status->editAttributes() ?>>
		<?php echo $godown_table->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $godown_table->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($godown_table->operator->Visible) { // operator ?>
	<input type="hidden" data-table="godown_table" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($godown_table->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($godown_table->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="godown_table" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($godown_table->datetime->CurrentValue) ?>">
	<?php if (!$godown_table->datetime->ReadOnly && !$godown_table->datetime->Disabled && !isset($godown_table->datetime->EditAttrs["readonly"]) && !isset($godown_table->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fgodown_tableaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
<?php if ($godown_table->r_text->Visible) { // r_text ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_r_text"><?php echo $godown_table->r_text->caption() ?><?php echo ($godown_table->r_text->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="godown_table" data-field="x_r_text" name="x_r_text" id="x_r_text" cols="35" rows="4" placeholder="<?php echo HtmlEncode($godown_table->r_text->getPlaceHolder()) ?>"<?php echo $godown_table->r_text->editAttributes() ?>><?php echo $godown_table->r_text->EditValue ?></textarea>
<?php echo $godown_table->r_text->CustomMsg ?></div>
	</div>
<?php } ?>
</form>
<?php
$godown_table_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$godown_table_addopt->terminate();
?>