<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$godown_table_list = new godown_table_list();

// Run the page
$godown_table_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$godown_table_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$godown_table->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fgodown_tablelist = currentForm = new ew.Form("fgodown_tablelist", "list");
fgodown_tablelist.formKeyCountName = '<?php echo $godown_table_list->FormKeyCountName ?>';

// Form_CustomValidate event
fgodown_tablelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgodown_tablelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgodown_tablelist.lists["x_company_id"] = <?php echo $godown_table_list->company_id->Lookup->toClientList() ?>;
fgodown_tablelist.lists["x_company_id"].options = <?php echo JsonEncode($godown_table_list->company_id->lookupOptions()) ?>;
fgodown_tablelist.lists["x_grp[]"] = <?php echo $godown_table_list->grp->Lookup->toClientList() ?>;
fgodown_tablelist.lists["x_grp[]"].options = <?php echo JsonEncode($godown_table_list->grp->lookupOptions()) ?>;
fgodown_tablelist.lists["x_type"] = <?php echo $godown_table_list->type->Lookup->toClientList() ?>;
fgodown_tablelist.lists["x_type"].options = <?php echo JsonEncode($godown_table_list->type->options(FALSE, TRUE)) ?>;
fgodown_tablelist.lists["x_incharge"] = <?php echo $godown_table_list->incharge->Lookup->toClientList() ?>;
fgodown_tablelist.lists["x_incharge"].options = <?php echo JsonEncode($godown_table_list->incharge->lookupOptions()) ?>;
fgodown_tablelist.lists["x_status"] = <?php echo $godown_table_list->status->Lookup->toClientList() ?>;
fgodown_tablelist.lists["x_status"].options = <?php echo JsonEncode($godown_table_list->status->options(FALSE, TRUE)) ?>;
fgodown_tablelist.lists["x_operator"] = <?php echo $godown_table_list->operator->Lookup->toClientList() ?>;
fgodown_tablelist.lists["x_operator"].options = <?php echo JsonEncode($godown_table_list->operator->lookupOptions()) ?>;

// Form object for search
var fgodown_tablelistsrch = currentSearchForm = new ew.Form("fgodown_tablelistsrch");

// Filters
fgodown_tablelistsrch.filterList = <?php echo $godown_table_list->getFilterList() ?>;

// Init search panel as collapsed
fgodown_tablelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$godown_table->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($godown_table_list->TotalRecs > 0 && $godown_table_list->ExportOptions->visible()) { ?>
<?php $godown_table_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($godown_table_list->ImportOptions->visible()) { ?>
<?php $godown_table_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($godown_table_list->SearchOptions->visible()) { ?>
<?php $godown_table_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($godown_table_list->FilterOptions->visible()) { ?>
<?php $godown_table_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$godown_table_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$godown_table->isExport() && !$godown_table->CurrentAction) { ?>
<form name="fgodown_tablelistsrch" id="fgodown_tablelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($godown_table_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fgodown_tablelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="godown_table">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($godown_table_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($godown_table_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $godown_table_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($godown_table_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($godown_table_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($godown_table_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($godown_table_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $godown_table_list->showPageHeader(); ?>
<?php
$godown_table_list->showMessage();
?>
<?php if ($godown_table_list->TotalRecs > 0 || $godown_table->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($godown_table_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> godown_table">
<?php if (!$godown_table->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$godown_table->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($godown_table_list->Pager)) $godown_table_list->Pager = new PrevNextPager($godown_table_list->StartRec, $godown_table_list->DisplayRecs, $godown_table_list->TotalRecs, $godown_table_list->AutoHidePager) ?>
<?php if ($godown_table_list->Pager->RecordCount > 0 && $godown_table_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($godown_table_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $godown_table_list->pageUrl() ?>start=<?php echo $godown_table_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($godown_table_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $godown_table_list->pageUrl() ?>start=<?php echo $godown_table_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $godown_table_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($godown_table_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $godown_table_list->pageUrl() ?>start=<?php echo $godown_table_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($godown_table_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $godown_table_list->pageUrl() ?>start=<?php echo $godown_table_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $godown_table_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($godown_table_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $godown_table_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $godown_table_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $godown_table_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($godown_table_list->TotalRecs > 0 && (!$godown_table_list->AutoHidePageSizeSelector || $godown_table_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="godown_table">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($godown_table_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($godown_table_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($godown_table_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($godown_table_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($godown_table_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($godown_table->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $godown_table_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fgodown_tablelist" id="fgodown_tablelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($godown_table_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $godown_table_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="godown_table">
<div id="gmp_godown_table" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($godown_table_list->TotalRecs > 0 || $godown_table->isGridEdit()) { ?>
<table id="tbl_godown_tablelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$godown_table_list->RowType = ROWTYPE_HEADER;

// Render list options
$godown_table_list->renderListOptions();

// Render list options (header, left)
$godown_table_list->ListOptions->render("header", "left");
?>
<?php if ($godown_table->id->Visible) { // id ?>
	<?php if ($godown_table->sortUrl($godown_table->id) == "") { ?>
		<th data-name="id" class="<?php echo $godown_table->id->headerCellClass() ?>"><div id="elh_godown_table_id" class="godown_table_id"><div class="ew-table-header-caption"><?php echo $godown_table->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $godown_table->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_table->SortUrl($godown_table->id) ?>',2);"><div id="elh_godown_table_id" class="godown_table_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_table->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_table->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_table->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_table->company_id->Visible) { // company_id ?>
	<?php if ($godown_table->sortUrl($godown_table->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $godown_table->company_id->headerCellClass() ?>"><div id="elh_godown_table_company_id" class="godown_table_company_id"><div class="ew-table-header-caption"><?php echo $godown_table->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $godown_table->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_table->SortUrl($godown_table->company_id) ?>',2);"><div id="elh_godown_table_company_id" class="godown_table_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_table->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_table->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_table->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_table->grp->Visible) { // grp ?>
	<?php if ($godown_table->sortUrl($godown_table->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $godown_table->grp->headerCellClass() ?>"><div id="elh_godown_table_grp" class="godown_table_grp"><div class="ew-table-header-caption"><?php echo $godown_table->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $godown_table->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_table->SortUrl($godown_table->grp) ?>',2);"><div id="elh_godown_table_grp" class="godown_table_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_table->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_table->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_table->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_table->type->Visible) { // type ?>
	<?php if ($godown_table->sortUrl($godown_table->type) == "") { ?>
		<th data-name="type" class="<?php echo $godown_table->type->headerCellClass() ?>"><div id="elh_godown_table_type" class="godown_table_type"><div class="ew-table-header-caption"><?php echo $godown_table->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $godown_table->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_table->SortUrl($godown_table->type) ?>',2);"><div id="elh_godown_table_type" class="godown_table_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_table->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_table->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_table->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_table->name->Visible) { // name ?>
	<?php if ($godown_table->sortUrl($godown_table->name) == "") { ?>
		<th data-name="name" class="<?php echo $godown_table->name->headerCellClass() ?>"><div id="elh_godown_table_name" class="godown_table_name"><div class="ew-table-header-caption"><?php echo $godown_table->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $godown_table->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_table->SortUrl($godown_table->name) ?>',2);"><div id="elh_godown_table_name" class="godown_table_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_table->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($godown_table->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_table->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_table->location->Visible) { // location ?>
	<?php if ($godown_table->sortUrl($godown_table->location) == "") { ?>
		<th data-name="location" class="<?php echo $godown_table->location->headerCellClass() ?>"><div id="elh_godown_table_location" class="godown_table_location"><div class="ew-table-header-caption"><?php echo $godown_table->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $godown_table->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_table->SortUrl($godown_table->location) ?>',2);"><div id="elh_godown_table_location" class="godown_table_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_table->location->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($godown_table->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_table->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_table->code->Visible) { // code ?>
	<?php if ($godown_table->sortUrl($godown_table->code) == "") { ?>
		<th data-name="code" class="<?php echo $godown_table->code->headerCellClass() ?>"><div id="elh_godown_table_code" class="godown_table_code"><div class="ew-table-header-caption"><?php echo $godown_table->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $godown_table->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_table->SortUrl($godown_table->code) ?>',2);"><div id="elh_godown_table_code" class="godown_table_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_table->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($godown_table->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_table->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_table->incharge->Visible) { // incharge ?>
	<?php if ($godown_table->sortUrl($godown_table->incharge) == "") { ?>
		<th data-name="incharge" class="<?php echo $godown_table->incharge->headerCellClass() ?>"><div id="elh_godown_table_incharge" class="godown_table_incharge"><div class="ew-table-header-caption"><?php echo $godown_table->incharge->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="incharge" class="<?php echo $godown_table->incharge->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_table->SortUrl($godown_table->incharge) ?>',2);"><div id="elh_godown_table_incharge" class="godown_table_incharge">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_table->incharge->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_table->incharge->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_table->incharge->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_table->capacity->Visible) { // capacity ?>
	<?php if ($godown_table->sortUrl($godown_table->capacity) == "") { ?>
		<th data-name="capacity" class="<?php echo $godown_table->capacity->headerCellClass() ?>"><div id="elh_godown_table_capacity" class="godown_table_capacity"><div class="ew-table-header-caption"><?php echo $godown_table->capacity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="capacity" class="<?php echo $godown_table->capacity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_table->SortUrl($godown_table->capacity) ?>',2);"><div id="elh_godown_table_capacity" class="godown_table_capacity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_table->capacity->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_table->capacity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_table->capacity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_table->status->Visible) { // status ?>
	<?php if ($godown_table->sortUrl($godown_table->status) == "") { ?>
		<th data-name="status" class="<?php echo $godown_table->status->headerCellClass() ?>"><div id="elh_godown_table_status" class="godown_table_status"><div class="ew-table-header-caption"><?php echo $godown_table->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $godown_table->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_table->SortUrl($godown_table->status) ?>',2);"><div id="elh_godown_table_status" class="godown_table_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_table->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_table->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_table->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_table->operator->Visible) { // operator ?>
	<?php if ($godown_table->sortUrl($godown_table->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $godown_table->operator->headerCellClass() ?>"><div id="elh_godown_table_operator" class="godown_table_operator"><div class="ew-table-header-caption"><?php echo $godown_table->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $godown_table->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_table->SortUrl($godown_table->operator) ?>',2);"><div id="elh_godown_table_operator" class="godown_table_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_table->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_table->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_table->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_table->datetime->Visible) { // datetime ?>
	<?php if ($godown_table->sortUrl($godown_table->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $godown_table->datetime->headerCellClass() ?>"><div id="elh_godown_table_datetime" class="godown_table_datetime"><div class="ew-table-header-caption"><?php echo $godown_table->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $godown_table->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_table->SortUrl($godown_table->datetime) ?>',2);"><div id="elh_godown_table_datetime" class="godown_table_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_table->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_table->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_table->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$godown_table_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($godown_table->ExportAll && $godown_table->isExport()) {
	$godown_table_list->StopRec = $godown_table_list->TotalRecs;
} else {

	// Set the last record to display
	if ($godown_table_list->TotalRecs > $godown_table_list->StartRec + $godown_table_list->DisplayRecs - 1)
		$godown_table_list->StopRec = $godown_table_list->StartRec + $godown_table_list->DisplayRecs - 1;
	else
		$godown_table_list->StopRec = $godown_table_list->TotalRecs;
}
$godown_table_list->RecCnt = $godown_table_list->StartRec - 1;
if ($godown_table_list->Recordset && !$godown_table_list->Recordset->EOF) {
	$godown_table_list->Recordset->moveFirst();
	$selectLimit = $godown_table_list->UseSelectLimit;
	if (!$selectLimit && $godown_table_list->StartRec > 1)
		$godown_table_list->Recordset->move($godown_table_list->StartRec - 1);
} elseif (!$godown_table->AllowAddDeleteRow && $godown_table_list->StopRec == 0) {
	$godown_table_list->StopRec = $godown_table->GridAddRowCount;
}

// Initialize aggregate
$godown_table->RowType = ROWTYPE_AGGREGATEINIT;
$godown_table->resetAttributes();
$godown_table_list->renderRow();
while ($godown_table_list->RecCnt < $godown_table_list->StopRec) {
	$godown_table_list->RecCnt++;
	if ($godown_table_list->RecCnt >= $godown_table_list->StartRec) {
		$godown_table_list->RowCnt++;

		// Set up key count
		$godown_table_list->KeyCount = $godown_table_list->RowIndex;

		// Init row class and style
		$godown_table->resetAttributes();
		$godown_table->CssClass = "";
		if ($godown_table->isGridAdd()) {
		} else {
			$godown_table_list->loadRowValues($godown_table_list->Recordset); // Load row values
		}
		$godown_table->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$godown_table->RowAttrs = array_merge($godown_table->RowAttrs, array('data-rowindex'=>$godown_table_list->RowCnt, 'id'=>'r' . $godown_table_list->RowCnt . '_godown_table', 'data-rowtype'=>$godown_table->RowType));

		// Render row
		$godown_table_list->renderRow();

		// Render list options
		$godown_table_list->renderListOptions();
?>
	<tr<?php echo $godown_table->rowAttributes() ?>>
<?php

// Render list options (body, left)
$godown_table_list->ListOptions->render("body", "left", $godown_table_list->RowCnt);
?>
	<?php if ($godown_table->id->Visible) { // id ?>
		<td data-name="id"<?php echo $godown_table->id->cellAttributes() ?>>
<span id="el<?php echo $godown_table_list->RowCnt ?>_godown_table_id" class="godown_table_id">
<span<?php echo $godown_table->id->viewAttributes() ?>>
<?php echo $godown_table->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_table->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $godown_table->company_id->cellAttributes() ?>>
<span id="el<?php echo $godown_table_list->RowCnt ?>_godown_table_company_id" class="godown_table_company_id">
<span<?php echo $godown_table->company_id->viewAttributes() ?>>
<?php echo $godown_table->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_table->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $godown_table->grp->cellAttributes() ?>>
<span id="el<?php echo $godown_table_list->RowCnt ?>_godown_table_grp" class="godown_table_grp">
<span<?php echo $godown_table->grp->viewAttributes() ?>>
<?php echo $godown_table->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_table->type->Visible) { // type ?>
		<td data-name="type"<?php echo $godown_table->type->cellAttributes() ?>>
<span id="el<?php echo $godown_table_list->RowCnt ?>_godown_table_type" class="godown_table_type">
<span<?php echo $godown_table->type->viewAttributes() ?>>
<?php echo $godown_table->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_table->name->Visible) { // name ?>
		<td data-name="name"<?php echo $godown_table->name->cellAttributes() ?>>
<span id="el<?php echo $godown_table_list->RowCnt ?>_godown_table_name" class="godown_table_name">
<span<?php echo $godown_table->name->viewAttributes() ?>>
<?php echo $godown_table->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_table->location->Visible) { // location ?>
		<td data-name="location"<?php echo $godown_table->location->cellAttributes() ?>>
<span id="el<?php echo $godown_table_list->RowCnt ?>_godown_table_location" class="godown_table_location">
<span<?php echo $godown_table->location->viewAttributes() ?>>
<?php echo $godown_table->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_table->code->Visible) { // code ?>
		<td data-name="code"<?php echo $godown_table->code->cellAttributes() ?>>
<span id="el<?php echo $godown_table_list->RowCnt ?>_godown_table_code" class="godown_table_code">
<span<?php echo $godown_table->code->viewAttributes() ?>>
<?php echo $godown_table->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_table->incharge->Visible) { // incharge ?>
		<td data-name="incharge"<?php echo $godown_table->incharge->cellAttributes() ?>>
<span id="el<?php echo $godown_table_list->RowCnt ?>_godown_table_incharge" class="godown_table_incharge">
<span<?php echo $godown_table->incharge->viewAttributes() ?>>
<?php echo $godown_table->incharge->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_table->capacity->Visible) { // capacity ?>
		<td data-name="capacity"<?php echo $godown_table->capacity->cellAttributes() ?>>
<span id="el<?php echo $godown_table_list->RowCnt ?>_godown_table_capacity" class="godown_table_capacity">
<span<?php echo $godown_table->capacity->viewAttributes() ?>>
<?php echo $godown_table->capacity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_table->status->Visible) { // status ?>
		<td data-name="status"<?php echo $godown_table->status->cellAttributes() ?>>
<span id="el<?php echo $godown_table_list->RowCnt ?>_godown_table_status" class="godown_table_status">
<span<?php echo $godown_table->status->viewAttributes() ?>>
<?php echo $godown_table->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_table->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $godown_table->operator->cellAttributes() ?>>
<span id="el<?php echo $godown_table_list->RowCnt ?>_godown_table_operator" class="godown_table_operator">
<span<?php echo $godown_table->operator->viewAttributes() ?>>
<?php echo $godown_table->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_table->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $godown_table->datetime->cellAttributes() ?>>
<span id="el<?php echo $godown_table_list->RowCnt ?>_godown_table_datetime" class="godown_table_datetime">
<span<?php echo $godown_table->datetime->viewAttributes() ?>>
<?php echo $godown_table->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$godown_table_list->ListOptions->render("body", "right", $godown_table_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$godown_table->isGridAdd())
		$godown_table_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$godown_table->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($godown_table_list->Recordset)
	$godown_table_list->Recordset->Close();
?>
<?php if (!$godown_table->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$godown_table->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($godown_table_list->Pager)) $godown_table_list->Pager = new PrevNextPager($godown_table_list->StartRec, $godown_table_list->DisplayRecs, $godown_table_list->TotalRecs, $godown_table_list->AutoHidePager) ?>
<?php if ($godown_table_list->Pager->RecordCount > 0 && $godown_table_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($godown_table_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $godown_table_list->pageUrl() ?>start=<?php echo $godown_table_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($godown_table_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $godown_table_list->pageUrl() ?>start=<?php echo $godown_table_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $godown_table_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($godown_table_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $godown_table_list->pageUrl() ?>start=<?php echo $godown_table_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($godown_table_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $godown_table_list->pageUrl() ?>start=<?php echo $godown_table_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $godown_table_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($godown_table_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $godown_table_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $godown_table_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $godown_table_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($godown_table_list->TotalRecs > 0 && (!$godown_table_list->AutoHidePageSizeSelector || $godown_table_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="godown_table">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($godown_table_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($godown_table_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($godown_table_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($godown_table_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($godown_table_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($godown_table->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $godown_table_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($godown_table_list->TotalRecs == 0 && !$godown_table->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $godown_table_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$godown_table_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$godown_table->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$godown_table->isExport()) { ?>
<script>
ew.scrollableTable("gmp_godown_table", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$godown_table_list->terminate();
?>