<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$godown_table_view = new godown_table_view();

// Run the page
$godown_table_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$godown_table_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$godown_table->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fgodown_tableview = currentForm = new ew.Form("fgodown_tableview", "view");

// Form_CustomValidate event
fgodown_tableview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgodown_tableview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgodown_tableview.lists["x_company_id"] = <?php echo $godown_table_view->company_id->Lookup->toClientList() ?>;
fgodown_tableview.lists["x_company_id"].options = <?php echo JsonEncode($godown_table_view->company_id->lookupOptions()) ?>;
fgodown_tableview.lists["x_grp[]"] = <?php echo $godown_table_view->grp->Lookup->toClientList() ?>;
fgodown_tableview.lists["x_grp[]"].options = <?php echo JsonEncode($godown_table_view->grp->lookupOptions()) ?>;
fgodown_tableview.lists["x_type"] = <?php echo $godown_table_view->type->Lookup->toClientList() ?>;
fgodown_tableview.lists["x_type"].options = <?php echo JsonEncode($godown_table_view->type->options(FALSE, TRUE)) ?>;
fgodown_tableview.lists["x_incharge"] = <?php echo $godown_table_view->incharge->Lookup->toClientList() ?>;
fgodown_tableview.lists["x_incharge"].options = <?php echo JsonEncode($godown_table_view->incharge->lookupOptions()) ?>;
fgodown_tableview.lists["x_status"] = <?php echo $godown_table_view->status->Lookup->toClientList() ?>;
fgodown_tableview.lists["x_status"].options = <?php echo JsonEncode($godown_table_view->status->options(FALSE, TRUE)) ?>;
fgodown_tableview.lists["x_operator"] = <?php echo $godown_table_view->operator->Lookup->toClientList() ?>;
fgodown_tableview.lists["x_operator"].options = <?php echo JsonEncode($godown_table_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$godown_table->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $godown_table_view->ExportOptions->render("body") ?>
<?php $godown_table_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $godown_table_view->showPageHeader(); ?>
<?php
$godown_table_view->showMessage();
?>
<form name="fgodown_tableview" id="fgodown_tableview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($godown_table_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $godown_table_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="godown_table">
<input type="hidden" name="modal" value="<?php echo (int)$godown_table_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($godown_table->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $godown_table_view->TableLeftColumnClass ?>"><span id="elh_godown_table_id"><?php echo $godown_table->id->caption() ?></span></td>
		<td data-name="id"<?php echo $godown_table->id->cellAttributes() ?>>
<span id="el_godown_table_id">
<span<?php echo $godown_table->id->viewAttributes() ?>>
<?php echo $godown_table->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown_table->company_id->Visible) { // company_id ?>
	<tr id="r_company_id">
		<td class="<?php echo $godown_table_view->TableLeftColumnClass ?>"><span id="elh_godown_table_company_id"><?php echo $godown_table->company_id->caption() ?></span></td>
		<td data-name="company_id"<?php echo $godown_table->company_id->cellAttributes() ?>>
<span id="el_godown_table_company_id">
<span<?php echo $godown_table->company_id->viewAttributes() ?>>
<?php echo $godown_table->company_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown_table->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $godown_table_view->TableLeftColumnClass ?>"><span id="elh_godown_table_grp"><?php echo $godown_table->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $godown_table->grp->cellAttributes() ?>>
<span id="el_godown_table_grp">
<span<?php echo $godown_table->grp->viewAttributes() ?>>
<?php echo $godown_table->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown_table->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $godown_table_view->TableLeftColumnClass ?>"><span id="elh_godown_table_type"><?php echo $godown_table->type->caption() ?></span></td>
		<td data-name="type"<?php echo $godown_table->type->cellAttributes() ?>>
<span id="el_godown_table_type">
<span<?php echo $godown_table->type->viewAttributes() ?>>
<?php echo $godown_table->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown_table->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $godown_table_view->TableLeftColumnClass ?>"><span id="elh_godown_table_name"><?php echo $godown_table->name->caption() ?></span></td>
		<td data-name="name"<?php echo $godown_table->name->cellAttributes() ?>>
<span id="el_godown_table_name">
<span<?php echo $godown_table->name->viewAttributes() ?>>
<?php echo $godown_table->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown_table->location->Visible) { // location ?>
	<tr id="r_location">
		<td class="<?php echo $godown_table_view->TableLeftColumnClass ?>"><span id="elh_godown_table_location"><?php echo $godown_table->location->caption() ?></span></td>
		<td data-name="location"<?php echo $godown_table->location->cellAttributes() ?>>
<span id="el_godown_table_location">
<span<?php echo $godown_table->location->viewAttributes() ?>>
<?php echo $godown_table->location->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown_table->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $godown_table_view->TableLeftColumnClass ?>"><span id="elh_godown_table_code"><?php echo $godown_table->code->caption() ?></span></td>
		<td data-name="code"<?php echo $godown_table->code->cellAttributes() ?>>
<span id="el_godown_table_code">
<span<?php echo $godown_table->code->viewAttributes() ?>>
<?php echo $godown_table->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown_table->incharge->Visible) { // incharge ?>
	<tr id="r_incharge">
		<td class="<?php echo $godown_table_view->TableLeftColumnClass ?>"><span id="elh_godown_table_incharge"><?php echo $godown_table->incharge->caption() ?></span></td>
		<td data-name="incharge"<?php echo $godown_table->incharge->cellAttributes() ?>>
<span id="el_godown_table_incharge">
<span<?php echo $godown_table->incharge->viewAttributes() ?>>
<?php echo $godown_table->incharge->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown_table->capacity->Visible) { // capacity ?>
	<tr id="r_capacity">
		<td class="<?php echo $godown_table_view->TableLeftColumnClass ?>"><span id="elh_godown_table_capacity"><?php echo $godown_table->capacity->caption() ?></span></td>
		<td data-name="capacity"<?php echo $godown_table->capacity->cellAttributes() ?>>
<span id="el_godown_table_capacity">
<span<?php echo $godown_table->capacity->viewAttributes() ?>>
<?php echo $godown_table->capacity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown_table->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $godown_table_view->TableLeftColumnClass ?>"><span id="elh_godown_table_status"><?php echo $godown_table->status->caption() ?></span></td>
		<td data-name="status"<?php echo $godown_table->status->cellAttributes() ?>>
<span id="el_godown_table_status">
<span<?php echo $godown_table->status->viewAttributes() ?>>
<?php echo $godown_table->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown_table->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $godown_table_view->TableLeftColumnClass ?>"><span id="elh_godown_table_operator"><?php echo $godown_table->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $godown_table->operator->cellAttributes() ?>>
<span id="el_godown_table_operator">
<span<?php echo $godown_table->operator->viewAttributes() ?>>
<?php echo $godown_table->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown_table->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $godown_table_view->TableLeftColumnClass ?>"><span id="elh_godown_table_datetime"><?php echo $godown_table->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $godown_table->datetime->cellAttributes() ?>>
<span id="el_godown_table_datetime">
<span<?php echo $godown_table->datetime->viewAttributes() ?>>
<?php echo $godown_table->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$godown_table_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$godown_table->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$godown_table_view->terminate();
?>