<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$godown_transfer_dw_list = new godown_transfer_dw_list();

// Run the page
$godown_transfer_dw_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$godown_transfer_dw_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$godown_transfer_dw->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fgodown_transfer_dwlist = currentForm = new ew.Form("fgodown_transfer_dwlist", "list");
fgodown_transfer_dwlist.formKeyCountName = '<?php echo $godown_transfer_dw_list->FormKeyCountName ?>';

// Form_CustomValidate event
fgodown_transfer_dwlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgodown_transfer_dwlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgodown_transfer_dwlist.lists["x_product"] = <?php echo $godown_transfer_dw_list->product->Lookup->toClientList() ?>;
fgodown_transfer_dwlist.lists["x_product"].options = <?php echo JsonEncode($godown_transfer_dw_list->product->lookupOptions()) ?>;
fgodown_transfer_dwlist.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fgodown_transfer_dwlist.lists["x_rid"] = <?php echo $godown_transfer_dw_list->rid->Lookup->toClientList() ?>;
fgodown_transfer_dwlist.lists["x_rid"].options = <?php echo JsonEncode($godown_transfer_dw_list->rid->lookupOptions()) ?>;
fgodown_transfer_dwlist.lists["x_packing_type"] = <?php echo $godown_transfer_dw_list->packing_type->Lookup->toClientList() ?>;
fgodown_transfer_dwlist.lists["x_packing_type"].options = <?php echo JsonEncode($godown_transfer_dw_list->packing_type->lookupOptions()) ?>;
fgodown_transfer_dwlist.lists["x_godown"] = <?php echo $godown_transfer_dw_list->godown->Lookup->toClientList() ?>;
fgodown_transfer_dwlist.lists["x_godown"].options = <?php echo JsonEncode($godown_transfer_dw_list->godown->lookupOptions()) ?>;

// Form object for search
var fgodown_transfer_dwlistsrch = currentSearchForm = new ew.Form("fgodown_transfer_dwlistsrch");

// Validate function for search
fgodown_transfer_dwlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_product");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($godown_transfer_dw->product->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fgodown_transfer_dwlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgodown_transfer_dwlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgodown_transfer_dwlistsrch.lists["x_product"] = <?php echo $godown_transfer_dw_list->product->Lookup->toClientList() ?>;
fgodown_transfer_dwlistsrch.lists["x_product"].options = <?php echo JsonEncode($godown_transfer_dw_list->product->lookupOptions()) ?>;
fgodown_transfer_dwlistsrch.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fgodown_transfer_dwlistsrch.lists["x_rid"] = <?php echo $godown_transfer_dw_list->rid->Lookup->toClientList() ?>;
fgodown_transfer_dwlistsrch.lists["x_rid"].options = <?php echo JsonEncode($godown_transfer_dw_list->rid->lookupOptions()) ?>;

// Filters
fgodown_transfer_dwlistsrch.filterList = <?php echo $godown_transfer_dw_list->getFilterList() ?>;

// Init search panel as collapsed
fgodown_transfer_dwlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$godown_transfer_dw->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($godown_transfer_dw_list->TotalRecs > 0 && $godown_transfer_dw_list->ExportOptions->visible()) { ?>
<?php $godown_transfer_dw_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($godown_transfer_dw_list->ImportOptions->visible()) { ?>
<?php $godown_transfer_dw_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($godown_transfer_dw_list->SearchOptions->visible()) { ?>
<?php $godown_transfer_dw_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($godown_transfer_dw_list->FilterOptions->visible()) { ?>
<?php $godown_transfer_dw_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$godown_transfer_dw_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$godown_transfer_dw->isExport() && !$godown_transfer_dw->CurrentAction) { ?>
<form name="fgodown_transfer_dwlistsrch" id="fgodown_transfer_dwlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($godown_transfer_dw_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fgodown_transfer_dwlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="godown_transfer_dw">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$godown_transfer_dw_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$godown_transfer_dw->RowType = ROWTYPE_SEARCH;

// Render row
$godown_transfer_dw->resetAttributes();
$godown_transfer_dw_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($godown_transfer_dw->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $godown_transfer_dw->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$godown_transfer_dw->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$godown_transfer_dw->product->EditAttrs["onchange"] = "";
?>
<span id="as_x_product" class="text-nowrap" style="z-index: 8970">
	<input type="text" class="form-control" name="sv_x_product" id="sv_x_product" value="<?php echo RemoveHtml($godown_transfer_dw->product->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($godown_transfer_dw->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($godown_transfer_dw->product->getPlaceHolder()) ?>"<?php echo $godown_transfer_dw->product->editAttributes() ?>>
</span>
<input type="hidden" data-table="godown_transfer_dw" data-field="x_product" data-value-separator="<?php echo $godown_transfer_dw->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?php echo HtmlEncode($godown_transfer_dw->product->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fgodown_transfer_dwlistsrch.createAutoSuggest({"id":"x_product","forceSelect":false});
</script>
<?php echo $godown_transfer_dw->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($godown_transfer_dw->rid->Visible) { // rid ?>
	<div id="xsc_rid" class="ew-cell form-group">
		<label for="x_rid" class="ew-search-caption ew-label"><?php echo $godown_transfer_dw->rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="godown_transfer_dw" data-field="x_rid" data-value-separator="<?php echo $godown_transfer_dw->rid->displayValueSeparatorAttribute() ?>" id="x_rid" name="x_rid"<?php echo $godown_transfer_dw->rid->editAttributes() ?>>
		<?php echo $godown_transfer_dw->rid->selectOptionListHtml("x_rid") ?>
	</select>
</div>
<?php echo $godown_transfer_dw->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $godown_transfer_dw_list->showPageHeader(); ?>
<?php
$godown_transfer_dw_list->showMessage();
?>
<?php if ($godown_transfer_dw_list->TotalRecs > 0 || $godown_transfer_dw->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($godown_transfer_dw_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> godown_transfer_dw">
<?php if (!$godown_transfer_dw->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$godown_transfer_dw->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($godown_transfer_dw_list->Pager)) $godown_transfer_dw_list->Pager = new PrevNextPager($godown_transfer_dw_list->StartRec, $godown_transfer_dw_list->DisplayRecs, $godown_transfer_dw_list->TotalRecs, $godown_transfer_dw_list->AutoHidePager) ?>
<?php if ($godown_transfer_dw_list->Pager->RecordCount > 0 && $godown_transfer_dw_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($godown_transfer_dw_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $godown_transfer_dw_list->pageUrl() ?>start=<?php echo $godown_transfer_dw_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($godown_transfer_dw_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $godown_transfer_dw_list->pageUrl() ?>start=<?php echo $godown_transfer_dw_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $godown_transfer_dw_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($godown_transfer_dw_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $godown_transfer_dw_list->pageUrl() ?>start=<?php echo $godown_transfer_dw_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($godown_transfer_dw_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $godown_transfer_dw_list->pageUrl() ?>start=<?php echo $godown_transfer_dw_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $godown_transfer_dw_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($godown_transfer_dw_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $godown_transfer_dw_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $godown_transfer_dw_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $godown_transfer_dw_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($godown_transfer_dw_list->TotalRecs > 0 && (!$godown_transfer_dw_list->AutoHidePageSizeSelector || $godown_transfer_dw_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="godown_transfer_dw">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($godown_transfer_dw_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($godown_transfer_dw_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($godown_transfer_dw_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($godown_transfer_dw_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($godown_transfer_dw_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($godown_transfer_dw->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $godown_transfer_dw_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fgodown_transfer_dwlist" id="fgodown_transfer_dwlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($godown_transfer_dw_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $godown_transfer_dw_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="godown_transfer_dw">
<div id="gmp_godown_transfer_dw" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($godown_transfer_dw_list->TotalRecs > 0 || $godown_transfer_dw->isGridEdit()) { ?>
<table id="tbl_godown_transfer_dwlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$godown_transfer_dw_list->RowType = ROWTYPE_HEADER;

// Render list options
$godown_transfer_dw_list->renderListOptions();

// Render list options (header, left)
$godown_transfer_dw_list->ListOptions->render("header", "left");
?>
<?php if ($godown_transfer_dw->id->Visible) { // id ?>
	<?php if ($godown_transfer_dw->sortUrl($godown_transfer_dw->id) == "") { ?>
		<th data-name="id" class="<?php echo $godown_transfer_dw->id->headerCellClass() ?>"><div id="elh_godown_transfer_dw_id" class="godown_transfer_dw_id"><div class="ew-table-header-caption"><?php echo $godown_transfer_dw->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $godown_transfer_dw->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_dw->SortUrl($godown_transfer_dw->id) ?>',2);"><div id="elh_godown_transfer_dw_id" class="godown_transfer_dw_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_dw->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_dw->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_dw->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_dw->dated->Visible) { // dated ?>
	<?php if ($godown_transfer_dw->sortUrl($godown_transfer_dw->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $godown_transfer_dw->dated->headerCellClass() ?>"><div id="elh_godown_transfer_dw_dated" class="godown_transfer_dw_dated"><div class="ew-table-header-caption"><?php echo $godown_transfer_dw->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $godown_transfer_dw->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_dw->SortUrl($godown_transfer_dw->dated) ?>',2);"><div id="elh_godown_transfer_dw_dated" class="godown_transfer_dw_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_dw->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_dw->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_dw->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_dw->product->Visible) { // product ?>
	<?php if ($godown_transfer_dw->sortUrl($godown_transfer_dw->product) == "") { ?>
		<th data-name="product" class="<?php echo $godown_transfer_dw->product->headerCellClass() ?>"><div id="elh_godown_transfer_dw_product" class="godown_transfer_dw_product"><div class="ew-table-header-caption"><?php echo $godown_transfer_dw->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $godown_transfer_dw->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_dw->SortUrl($godown_transfer_dw->product) ?>',2);"><div id="elh_godown_transfer_dw_product" class="godown_transfer_dw_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_dw->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_dw->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_dw->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_dw->rid->Visible) { // rid ?>
	<?php if ($godown_transfer_dw->sortUrl($godown_transfer_dw->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $godown_transfer_dw->rid->headerCellClass() ?>"><div id="elh_godown_transfer_dw_rid" class="godown_transfer_dw_rid"><div class="ew-table-header-caption"><?php echo $godown_transfer_dw->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $godown_transfer_dw->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_dw->SortUrl($godown_transfer_dw->rid) ?>',2);"><div id="elh_godown_transfer_dw_rid" class="godown_transfer_dw_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_dw->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_dw->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_dw->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_dw->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($godown_transfer_dw->sortUrl($godown_transfer_dw->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $godown_transfer_dw->tmp_lot->headerCellClass() ?>"><div id="elh_godown_transfer_dw_tmp_lot" class="godown_transfer_dw_tmp_lot"><div class="ew-table-header-caption"><?php echo $godown_transfer_dw->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $godown_transfer_dw->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_dw->SortUrl($godown_transfer_dw->tmp_lot) ?>',2);"><div id="elh_godown_transfer_dw_tmp_lot" class="godown_transfer_dw_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_dw->tmp_lot->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_dw->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_dw->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_dw->packing_type->Visible) { // packing_type ?>
	<?php if ($godown_transfer_dw->sortUrl($godown_transfer_dw->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $godown_transfer_dw->packing_type->headerCellClass() ?>"><div id="elh_godown_transfer_dw_packing_type" class="godown_transfer_dw_packing_type"><div class="ew-table-header-caption"><?php echo $godown_transfer_dw->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $godown_transfer_dw->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_dw->SortUrl($godown_transfer_dw->packing_type) ?>',2);"><div id="elh_godown_transfer_dw_packing_type" class="godown_transfer_dw_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_dw->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_dw->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_dw->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_dw->IN->Visible) { // IN ?>
	<?php if ($godown_transfer_dw->sortUrl($godown_transfer_dw->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $godown_transfer_dw->IN->headerCellClass() ?>"><div id="elh_godown_transfer_dw_IN" class="godown_transfer_dw_IN"><div class="ew-table-header-caption"><?php echo $godown_transfer_dw->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $godown_transfer_dw->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_dw->SortUrl($godown_transfer_dw->IN) ?>',2);"><div id="elh_godown_transfer_dw_IN" class="godown_transfer_dw_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_dw->IN->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_dw->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_dw->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_dw->packets->Visible) { // packets ?>
	<?php if ($godown_transfer_dw->sortUrl($godown_transfer_dw->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $godown_transfer_dw->packets->headerCellClass() ?>"><div id="elh_godown_transfer_dw_packets" class="godown_transfer_dw_packets"><div class="ew-table-header-caption"><?php echo $godown_transfer_dw->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $godown_transfer_dw->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_dw->SortUrl($godown_transfer_dw->packets) ?>',2);"><div id="elh_godown_transfer_dw_packets" class="godown_transfer_dw_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_dw->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_dw->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_dw->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_dw->godown->Visible) { // godown ?>
	<?php if ($godown_transfer_dw->sortUrl($godown_transfer_dw->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $godown_transfer_dw->godown->headerCellClass() ?>"><div id="elh_godown_transfer_dw_godown" class="godown_transfer_dw_godown"><div class="ew-table-header-caption"><?php echo $godown_transfer_dw->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $godown_transfer_dw->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_dw->SortUrl($godown_transfer_dw->godown) ?>',2);"><div id="elh_godown_transfer_dw_godown" class="godown_transfer_dw_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_dw->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_dw->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_dw->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$godown_transfer_dw_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($godown_transfer_dw->ExportAll && $godown_transfer_dw->isExport()) {
	$godown_transfer_dw_list->StopRec = $godown_transfer_dw_list->TotalRecs;
} else {

	// Set the last record to display
	if ($godown_transfer_dw_list->TotalRecs > $godown_transfer_dw_list->StartRec + $godown_transfer_dw_list->DisplayRecs - 1)
		$godown_transfer_dw_list->StopRec = $godown_transfer_dw_list->StartRec + $godown_transfer_dw_list->DisplayRecs - 1;
	else
		$godown_transfer_dw_list->StopRec = $godown_transfer_dw_list->TotalRecs;
}
$godown_transfer_dw_list->RecCnt = $godown_transfer_dw_list->StartRec - 1;
if ($godown_transfer_dw_list->Recordset && !$godown_transfer_dw_list->Recordset->EOF) {
	$godown_transfer_dw_list->Recordset->moveFirst();
	$selectLimit = $godown_transfer_dw_list->UseSelectLimit;
	if (!$selectLimit && $godown_transfer_dw_list->StartRec > 1)
		$godown_transfer_dw_list->Recordset->move($godown_transfer_dw_list->StartRec - 1);
} elseif (!$godown_transfer_dw->AllowAddDeleteRow && $godown_transfer_dw_list->StopRec == 0) {
	$godown_transfer_dw_list->StopRec = $godown_transfer_dw->GridAddRowCount;
}

// Initialize aggregate
$godown_transfer_dw->RowType = ROWTYPE_AGGREGATEINIT;
$godown_transfer_dw->resetAttributes();
$godown_transfer_dw_list->renderRow();
while ($godown_transfer_dw_list->RecCnt < $godown_transfer_dw_list->StopRec) {
	$godown_transfer_dw_list->RecCnt++;
	if ($godown_transfer_dw_list->RecCnt >= $godown_transfer_dw_list->StartRec) {
		$godown_transfer_dw_list->RowCnt++;

		// Set up key count
		$godown_transfer_dw_list->KeyCount = $godown_transfer_dw_list->RowIndex;

		// Init row class and style
		$godown_transfer_dw->resetAttributes();
		$godown_transfer_dw->CssClass = "";
		if ($godown_transfer_dw->isGridAdd()) {
		} else {
			$godown_transfer_dw_list->loadRowValues($godown_transfer_dw_list->Recordset); // Load row values
		}
		$godown_transfer_dw->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$godown_transfer_dw->RowAttrs = array_merge($godown_transfer_dw->RowAttrs, array('data-rowindex'=>$godown_transfer_dw_list->RowCnt, 'id'=>'r' . $godown_transfer_dw_list->RowCnt . '_godown_transfer_dw', 'data-rowtype'=>$godown_transfer_dw->RowType));

		// Render row
		$godown_transfer_dw_list->renderRow();

		// Render list options
		$godown_transfer_dw_list->renderListOptions();
?>
	<tr<?php echo $godown_transfer_dw->rowAttributes() ?>>
<?php

// Render list options (body, left)
$godown_transfer_dw_list->ListOptions->render("body", "left", $godown_transfer_dw_list->RowCnt);
?>
	<?php if ($godown_transfer_dw->id->Visible) { // id ?>
		<td data-name="id"<?php echo $godown_transfer_dw->id->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_dw_list->RowCnt ?>_godown_transfer_dw_id" class="godown_transfer_dw_id">
<span<?php echo $godown_transfer_dw->id->viewAttributes() ?>>
<?php echo $godown_transfer_dw->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_dw->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $godown_transfer_dw->dated->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_dw_list->RowCnt ?>_godown_transfer_dw_dated" class="godown_transfer_dw_dated">
<span<?php echo $godown_transfer_dw->dated->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_dw->dated->getViewValue())) && $godown_transfer_dw->dated->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_dw->dated->linkAttributes() ?>><?php echo $godown_transfer_dw->dated->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_dw->dated->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_dw->product->Visible) { // product ?>
		<td data-name="product"<?php echo $godown_transfer_dw->product->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_dw_list->RowCnt ?>_godown_transfer_dw_product" class="godown_transfer_dw_product">
<span<?php echo $godown_transfer_dw->product->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_dw->product->getViewValue())) && $godown_transfer_dw->product->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_dw->product->linkAttributes() ?>><?php echo $godown_transfer_dw->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_dw->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_dw->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $godown_transfer_dw->rid->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_dw_list->RowCnt ?>_godown_transfer_dw_rid" class="godown_transfer_dw_rid">
<span<?php echo $godown_transfer_dw->rid->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_dw->rid->getViewValue())) && $godown_transfer_dw->rid->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_dw->rid->linkAttributes() ?>><?php echo $godown_transfer_dw->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_dw->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_dw->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $godown_transfer_dw->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_dw_list->RowCnt ?>_godown_transfer_dw_tmp_lot" class="godown_transfer_dw_tmp_lot">
<span<?php echo $godown_transfer_dw->tmp_lot->viewAttributes() ?>>
<?php echo $godown_transfer_dw->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_dw->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $godown_transfer_dw->packing_type->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_dw_list->RowCnt ?>_godown_transfer_dw_packing_type" class="godown_transfer_dw_packing_type">
<span<?php echo $godown_transfer_dw->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_dw->packing_type->getViewValue())) && $godown_transfer_dw->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_dw->packing_type->linkAttributes() ?>><?php echo $godown_transfer_dw->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_dw->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_dw->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $godown_transfer_dw->IN->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_dw_list->RowCnt ?>_godown_transfer_dw_IN" class="godown_transfer_dw_IN">
<span<?php echo $godown_transfer_dw->IN->viewAttributes() ?>>
<?php echo $godown_transfer_dw->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_dw->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $godown_transfer_dw->packets->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_dw_list->RowCnt ?>_godown_transfer_dw_packets" class="godown_transfer_dw_packets">
<span<?php echo $godown_transfer_dw->packets->viewAttributes() ?>>
<?php echo $godown_transfer_dw->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_dw->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $godown_transfer_dw->godown->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_dw_list->RowCnt ?>_godown_transfer_dw_godown" class="godown_transfer_dw_godown">
<span<?php echo $godown_transfer_dw->godown->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_dw->godown->getViewValue())) && $godown_transfer_dw->godown->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_dw->godown->linkAttributes() ?>><?php echo $godown_transfer_dw->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_dw->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$godown_transfer_dw_list->ListOptions->render("body", "right", $godown_transfer_dw_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$godown_transfer_dw->isGridAdd())
		$godown_transfer_dw_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$godown_transfer_dw->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($godown_transfer_dw_list->Recordset)
	$godown_transfer_dw_list->Recordset->Close();
?>
<?php if (!$godown_transfer_dw->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$godown_transfer_dw->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($godown_transfer_dw_list->Pager)) $godown_transfer_dw_list->Pager = new PrevNextPager($godown_transfer_dw_list->StartRec, $godown_transfer_dw_list->DisplayRecs, $godown_transfer_dw_list->TotalRecs, $godown_transfer_dw_list->AutoHidePager) ?>
<?php if ($godown_transfer_dw_list->Pager->RecordCount > 0 && $godown_transfer_dw_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($godown_transfer_dw_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $godown_transfer_dw_list->pageUrl() ?>start=<?php echo $godown_transfer_dw_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($godown_transfer_dw_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $godown_transfer_dw_list->pageUrl() ?>start=<?php echo $godown_transfer_dw_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $godown_transfer_dw_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($godown_transfer_dw_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $godown_transfer_dw_list->pageUrl() ?>start=<?php echo $godown_transfer_dw_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($godown_transfer_dw_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $godown_transfer_dw_list->pageUrl() ?>start=<?php echo $godown_transfer_dw_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $godown_transfer_dw_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($godown_transfer_dw_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $godown_transfer_dw_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $godown_transfer_dw_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $godown_transfer_dw_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($godown_transfer_dw_list->TotalRecs > 0 && (!$godown_transfer_dw_list->AutoHidePageSizeSelector || $godown_transfer_dw_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="godown_transfer_dw">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($godown_transfer_dw_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($godown_transfer_dw_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($godown_transfer_dw_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($godown_transfer_dw_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($godown_transfer_dw_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($godown_transfer_dw->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $godown_transfer_dw_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($godown_transfer_dw_list->TotalRecs == 0 && !$godown_transfer_dw->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $godown_transfer_dw_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$godown_transfer_dw_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$godown_transfer_dw->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$godown_transfer_dw->isExport()) { ?>
<script>
ew.scrollableTable("gmp_godown_transfer_dw", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$godown_transfer_dw_list->terminate();
?>