<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$godown_transfer_fp_list = new godown_transfer_fp_list();

// Run the page
$godown_transfer_fp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$godown_transfer_fp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$godown_transfer_fp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fgodown_transfer_fplist = currentForm = new ew.Form("fgodown_transfer_fplist", "list");
fgodown_transfer_fplist.formKeyCountName = '<?php echo $godown_transfer_fp_list->FormKeyCountName ?>';

// Form_CustomValidate event
fgodown_transfer_fplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgodown_transfer_fplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgodown_transfer_fplist.lists["x_grp"] = <?php echo $godown_transfer_fp_list->grp->Lookup->toClientList() ?>;
fgodown_transfer_fplist.lists["x_grp"].options = <?php echo JsonEncode($godown_transfer_fp_list->grp->options(FALSE, TRUE)) ?>;
fgodown_transfer_fplist.lists["x_product"] = <?php echo $godown_transfer_fp_list->product->Lookup->toClientList() ?>;
fgodown_transfer_fplist.lists["x_product"].options = <?php echo JsonEncode($godown_transfer_fp_list->product->lookupOptions()) ?>;
fgodown_transfer_fplist.lists["x_ref"] = <?php echo $godown_transfer_fp_list->ref->Lookup->toClientList() ?>;
fgodown_transfer_fplist.lists["x_ref"].options = <?php echo JsonEncode($godown_transfer_fp_list->ref->lookupOptions()) ?>;
fgodown_transfer_fplist.lists["x_count_received"] = <?php echo $godown_transfer_fp_list->count_received->Lookup->toClientList() ?>;
fgodown_transfer_fplist.lists["x_count_received"].options = <?php echo JsonEncode($godown_transfer_fp_list->count_received->lookupOptions()) ?>;
fgodown_transfer_fplist.lists["x_rid"] = <?php echo $godown_transfer_fp_list->rid->Lookup->toClientList() ?>;
fgodown_transfer_fplist.lists["x_rid"].options = <?php echo JsonEncode($godown_transfer_fp_list->rid->lookupOptions()) ?>;
fgodown_transfer_fplist.lists["x_packing_type"] = <?php echo $godown_transfer_fp_list->packing_type->Lookup->toClientList() ?>;
fgodown_transfer_fplist.lists["x_packing_type"].options = <?php echo JsonEncode($godown_transfer_fp_list->packing_type->lookupOptions()) ?>;
fgodown_transfer_fplist.lists["x_godown"] = <?php echo $godown_transfer_fp_list->godown->Lookup->toClientList() ?>;
fgodown_transfer_fplist.lists["x_godown"].options = <?php echo JsonEncode($godown_transfer_fp_list->godown->lookupOptions()) ?>;
fgodown_transfer_fplist.lists["x_next_godown"] = <?php echo $godown_transfer_fp_list->next_godown->Lookup->toClientList() ?>;
fgodown_transfer_fplist.lists["x_next_godown"].options = <?php echo JsonEncode($godown_transfer_fp_list->next_godown->lookupOptions()) ?>;
fgodown_transfer_fplist.lists["x_operator"] = <?php echo $godown_transfer_fp_list->operator->Lookup->toClientList() ?>;
fgodown_transfer_fplist.lists["x_operator"].options = <?php echo JsonEncode($godown_transfer_fp_list->operator->lookupOptions()) ?>;

// Form object for search
var fgodown_transfer_fplistsrch = currentSearchForm = new ew.Form("fgodown_transfer_fplistsrch");

// Filters
fgodown_transfer_fplistsrch.filterList = <?php echo $godown_transfer_fp_list->getFilterList() ?>;

// Init search panel as collapsed
fgodown_transfer_fplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$godown_transfer_fp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($godown_transfer_fp_list->TotalRecs > 0 && $godown_transfer_fp_list->ExportOptions->visible()) { ?>
<?php $godown_transfer_fp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($godown_transfer_fp_list->ImportOptions->visible()) { ?>
<?php $godown_transfer_fp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($godown_transfer_fp_list->SearchOptions->visible()) { ?>
<?php $godown_transfer_fp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($godown_transfer_fp_list->FilterOptions->visible()) { ?>
<?php $godown_transfer_fp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$godown_transfer_fp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$godown_transfer_fp->isExport() && !$godown_transfer_fp->CurrentAction) { ?>
<form name="fgodown_transfer_fplistsrch" id="fgodown_transfer_fplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($godown_transfer_fp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fgodown_transfer_fplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="godown_transfer_fp">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($godown_transfer_fp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($godown_transfer_fp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $godown_transfer_fp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($godown_transfer_fp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($godown_transfer_fp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($godown_transfer_fp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($godown_transfer_fp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $godown_transfer_fp_list->showPageHeader(); ?>
<?php
$godown_transfer_fp_list->showMessage();
?>
<?php if ($godown_transfer_fp_list->TotalRecs > 0 || $godown_transfer_fp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($godown_transfer_fp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> godown_transfer_fp">
<?php if (!$godown_transfer_fp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$godown_transfer_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($godown_transfer_fp_list->Pager)) $godown_transfer_fp_list->Pager = new PrevNextPager($godown_transfer_fp_list->StartRec, $godown_transfer_fp_list->DisplayRecs, $godown_transfer_fp_list->TotalRecs, $godown_transfer_fp_list->AutoHidePager) ?>
<?php if ($godown_transfer_fp_list->Pager->RecordCount > 0 && $godown_transfer_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($godown_transfer_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $godown_transfer_fp_list->pageUrl() ?>start=<?php echo $godown_transfer_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($godown_transfer_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $godown_transfer_fp_list->pageUrl() ?>start=<?php echo $godown_transfer_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $godown_transfer_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($godown_transfer_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $godown_transfer_fp_list->pageUrl() ?>start=<?php echo $godown_transfer_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($godown_transfer_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $godown_transfer_fp_list->pageUrl() ?>start=<?php echo $godown_transfer_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $godown_transfer_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($godown_transfer_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $godown_transfer_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $godown_transfer_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $godown_transfer_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($godown_transfer_fp_list->TotalRecs > 0 && (!$godown_transfer_fp_list->AutoHidePageSizeSelector || $godown_transfer_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="godown_transfer_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($godown_transfer_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($godown_transfer_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($godown_transfer_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($godown_transfer_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($godown_transfer_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($godown_transfer_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $godown_transfer_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fgodown_transfer_fplist" id="fgodown_transfer_fplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($godown_transfer_fp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $godown_transfer_fp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="godown_transfer_fp">
<div id="gmp_godown_transfer_fp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($godown_transfer_fp_list->TotalRecs > 0 || $godown_transfer_fp->isGridEdit()) { ?>
<table id="tbl_godown_transfer_fplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$godown_transfer_fp_list->RowType = ROWTYPE_HEADER;

// Render list options
$godown_transfer_fp_list->renderListOptions();

// Render list options (header, left)
$godown_transfer_fp_list->ListOptions->render("header", "left");
?>
<?php if ($godown_transfer_fp->id->Visible) { // id ?>
	<?php if ($godown_transfer_fp->sortUrl($godown_transfer_fp->id) == "") { ?>
		<th data-name="id" class="<?php echo $godown_transfer_fp->id->headerCellClass() ?>"><div id="elh_godown_transfer_fp_id" class="godown_transfer_fp_id"><div class="ew-table-header-caption"><?php echo $godown_transfer_fp->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $godown_transfer_fp->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_fp->SortUrl($godown_transfer_fp->id) ?>',2);"><div id="elh_godown_transfer_fp_id" class="godown_transfer_fp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_fp->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_fp->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_fp->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_fp->gp_no->Visible) { // gp_no ?>
	<?php if ($godown_transfer_fp->sortUrl($godown_transfer_fp->gp_no) == "") { ?>
		<th data-name="gp_no" class="<?php echo $godown_transfer_fp->gp_no->headerCellClass() ?>"><div id="elh_godown_transfer_fp_gp_no" class="godown_transfer_fp_gp_no"><div class="ew-table-header-caption"><?php echo $godown_transfer_fp->gp_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gp_no" class="<?php echo $godown_transfer_fp->gp_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_fp->SortUrl($godown_transfer_fp->gp_no) ?>',2);"><div id="elh_godown_transfer_fp_gp_no" class="godown_transfer_fp_gp_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_fp->gp_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_fp->gp_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_fp->gp_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_fp->grp->Visible) { // grp ?>
	<?php if ($godown_transfer_fp->sortUrl($godown_transfer_fp->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $godown_transfer_fp->grp->headerCellClass() ?>"><div id="elh_godown_transfer_fp_grp" class="godown_transfer_fp_grp"><div class="ew-table-header-caption"><?php echo $godown_transfer_fp->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $godown_transfer_fp->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_fp->SortUrl($godown_transfer_fp->grp) ?>',2);"><div id="elh_godown_transfer_fp_grp" class="godown_transfer_fp_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_fp->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_fp->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_fp->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_fp->product->Visible) { // product ?>
	<?php if ($godown_transfer_fp->sortUrl($godown_transfer_fp->product) == "") { ?>
		<th data-name="product" class="<?php echo $godown_transfer_fp->product->headerCellClass() ?>"><div id="elh_godown_transfer_fp_product" class="godown_transfer_fp_product"><div class="ew-table-header-caption"><?php echo $godown_transfer_fp->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $godown_transfer_fp->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_fp->SortUrl($godown_transfer_fp->product) ?>',2);"><div id="elh_godown_transfer_fp_product" class="godown_transfer_fp_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_fp->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_fp->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_fp->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_fp->ref->Visible) { // ref ?>
	<?php if ($godown_transfer_fp->sortUrl($godown_transfer_fp->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $godown_transfer_fp->ref->headerCellClass() ?>"><div id="elh_godown_transfer_fp_ref" class="godown_transfer_fp_ref"><div class="ew-table-header-caption"><?php echo $godown_transfer_fp->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $godown_transfer_fp->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_fp->SortUrl($godown_transfer_fp->ref) ?>',2);"><div id="elh_godown_transfer_fp_ref" class="godown_transfer_fp_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_fp->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_fp->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_fp->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_fp->count_received->Visible) { // count_received ?>
	<?php if ($godown_transfer_fp->sortUrl($godown_transfer_fp->count_received) == "") { ?>
		<th data-name="count_received" class="<?php echo $godown_transfer_fp->count_received->headerCellClass() ?>"><div id="elh_godown_transfer_fp_count_received" class="godown_transfer_fp_count_received"><div class="ew-table-header-caption"><?php echo $godown_transfer_fp->count_received->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="count_received" class="<?php echo $godown_transfer_fp->count_received->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_fp->SortUrl($godown_transfer_fp->count_received) ?>',2);"><div id="elh_godown_transfer_fp_count_received" class="godown_transfer_fp_count_received">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_fp->count_received->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_fp->count_received->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_fp->count_received->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_fp->rid->Visible) { // rid ?>
	<?php if ($godown_transfer_fp->sortUrl($godown_transfer_fp->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $godown_transfer_fp->rid->headerCellClass() ?>"><div id="elh_godown_transfer_fp_rid" class="godown_transfer_fp_rid"><div class="ew-table-header-caption"><?php echo $godown_transfer_fp->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $godown_transfer_fp->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_fp->SortUrl($godown_transfer_fp->rid) ?>',2);"><div id="elh_godown_transfer_fp_rid" class="godown_transfer_fp_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_fp->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_fp->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_fp->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_fp->packets->Visible) { // packets ?>
	<?php if ($godown_transfer_fp->sortUrl($godown_transfer_fp->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $godown_transfer_fp->packets->headerCellClass() ?>"><div id="elh_godown_transfer_fp_packets" class="godown_transfer_fp_packets"><div class="ew-table-header-caption"><?php echo $godown_transfer_fp->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $godown_transfer_fp->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_fp->SortUrl($godown_transfer_fp->packets) ?>',2);"><div id="elh_godown_transfer_fp_packets" class="godown_transfer_fp_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_fp->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_fp->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_fp->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_fp->quantity->Visible) { // quantity ?>
	<?php if ($godown_transfer_fp->sortUrl($godown_transfer_fp->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $godown_transfer_fp->quantity->headerCellClass() ?>"><div id="elh_godown_transfer_fp_quantity" class="godown_transfer_fp_quantity"><div class="ew-table-header-caption"><?php echo $godown_transfer_fp->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $godown_transfer_fp->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_fp->SortUrl($godown_transfer_fp->quantity) ?>',2);"><div id="elh_godown_transfer_fp_quantity" class="godown_transfer_fp_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_fp->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_fp->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_fp->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_fp->packing_type->Visible) { // packing_type ?>
	<?php if ($godown_transfer_fp->sortUrl($godown_transfer_fp->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $godown_transfer_fp->packing_type->headerCellClass() ?>"><div id="elh_godown_transfer_fp_packing_type" class="godown_transfer_fp_packing_type"><div class="ew-table-header-caption"><?php echo $godown_transfer_fp->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $godown_transfer_fp->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_fp->SortUrl($godown_transfer_fp->packing_type) ?>',2);"><div id="elh_godown_transfer_fp_packing_type" class="godown_transfer_fp_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_fp->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_fp->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_fp->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_fp->godown->Visible) { // godown ?>
	<?php if ($godown_transfer_fp->sortUrl($godown_transfer_fp->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $godown_transfer_fp->godown->headerCellClass() ?>"><div id="elh_godown_transfer_fp_godown" class="godown_transfer_fp_godown"><div class="ew-table-header-caption"><?php echo $godown_transfer_fp->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $godown_transfer_fp->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_fp->SortUrl($godown_transfer_fp->godown) ?>',2);"><div id="elh_godown_transfer_fp_godown" class="godown_transfer_fp_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_fp->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_fp->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_fp->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_fp->next_godown->Visible) { // next_godown ?>
	<?php if ($godown_transfer_fp->sortUrl($godown_transfer_fp->next_godown) == "") { ?>
		<th data-name="next_godown" class="<?php echo $godown_transfer_fp->next_godown->headerCellClass() ?>"><div id="elh_godown_transfer_fp_next_godown" class="godown_transfer_fp_next_godown"><div class="ew-table-header-caption"><?php echo $godown_transfer_fp->next_godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="next_godown" class="<?php echo $godown_transfer_fp->next_godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_fp->SortUrl($godown_transfer_fp->next_godown) ?>',2);"><div id="elh_godown_transfer_fp_next_godown" class="godown_transfer_fp_next_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_fp->next_godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_fp->next_godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_fp->next_godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_fp->remarks->Visible) { // remarks ?>
	<?php if ($godown_transfer_fp->sortUrl($godown_transfer_fp->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $godown_transfer_fp->remarks->headerCellClass() ?>"><div id="elh_godown_transfer_fp_remarks" class="godown_transfer_fp_remarks"><div class="ew-table-header-caption"><?php echo $godown_transfer_fp->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $godown_transfer_fp->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_fp->SortUrl($godown_transfer_fp->remarks) ?>',2);"><div id="elh_godown_transfer_fp_remarks" class="godown_transfer_fp_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_fp->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_fp->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_fp->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_fp->datetime->Visible) { // datetime ?>
	<?php if ($godown_transfer_fp->sortUrl($godown_transfer_fp->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $godown_transfer_fp->datetime->headerCellClass() ?>"><div id="elh_godown_transfer_fp_datetime" class="godown_transfer_fp_datetime"><div class="ew-table-header-caption"><?php echo $godown_transfer_fp->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $godown_transfer_fp->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_fp->SortUrl($godown_transfer_fp->datetime) ?>',2);"><div id="elh_godown_transfer_fp_datetime" class="godown_transfer_fp_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_fp->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_fp->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_fp->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_fp->operator->Visible) { // operator ?>
	<?php if ($godown_transfer_fp->sortUrl($godown_transfer_fp->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $godown_transfer_fp->operator->headerCellClass() ?>"><div id="elh_godown_transfer_fp_operator" class="godown_transfer_fp_operator"><div class="ew-table-header-caption"><?php echo $godown_transfer_fp->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $godown_transfer_fp->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_fp->SortUrl($godown_transfer_fp->operator) ?>',2);"><div id="elh_godown_transfer_fp_operator" class="godown_transfer_fp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_fp->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_fp->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_fp->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$godown_transfer_fp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($godown_transfer_fp->ExportAll && $godown_transfer_fp->isExport()) {
	$godown_transfer_fp_list->StopRec = $godown_transfer_fp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($godown_transfer_fp_list->TotalRecs > $godown_transfer_fp_list->StartRec + $godown_transfer_fp_list->DisplayRecs - 1)
		$godown_transfer_fp_list->StopRec = $godown_transfer_fp_list->StartRec + $godown_transfer_fp_list->DisplayRecs - 1;
	else
		$godown_transfer_fp_list->StopRec = $godown_transfer_fp_list->TotalRecs;
}
$godown_transfer_fp_list->RecCnt = $godown_transfer_fp_list->StartRec - 1;
if ($godown_transfer_fp_list->Recordset && !$godown_transfer_fp_list->Recordset->EOF) {
	$godown_transfer_fp_list->Recordset->moveFirst();
	$selectLimit = $godown_transfer_fp_list->UseSelectLimit;
	if (!$selectLimit && $godown_transfer_fp_list->StartRec > 1)
		$godown_transfer_fp_list->Recordset->move($godown_transfer_fp_list->StartRec - 1);
} elseif (!$godown_transfer_fp->AllowAddDeleteRow && $godown_transfer_fp_list->StopRec == 0) {
	$godown_transfer_fp_list->StopRec = $godown_transfer_fp->GridAddRowCount;
}

// Initialize aggregate
$godown_transfer_fp->RowType = ROWTYPE_AGGREGATEINIT;
$godown_transfer_fp->resetAttributes();
$godown_transfer_fp_list->renderRow();
while ($godown_transfer_fp_list->RecCnt < $godown_transfer_fp_list->StopRec) {
	$godown_transfer_fp_list->RecCnt++;
	if ($godown_transfer_fp_list->RecCnt >= $godown_transfer_fp_list->StartRec) {
		$godown_transfer_fp_list->RowCnt++;

		// Set up key count
		$godown_transfer_fp_list->KeyCount = $godown_transfer_fp_list->RowIndex;

		// Init row class and style
		$godown_transfer_fp->resetAttributes();
		$godown_transfer_fp->CssClass = "";
		if ($godown_transfer_fp->isGridAdd()) {
		} else {
			$godown_transfer_fp_list->loadRowValues($godown_transfer_fp_list->Recordset); // Load row values
		}
		$godown_transfer_fp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$godown_transfer_fp->RowAttrs = array_merge($godown_transfer_fp->RowAttrs, array('data-rowindex'=>$godown_transfer_fp_list->RowCnt, 'id'=>'r' . $godown_transfer_fp_list->RowCnt . '_godown_transfer_fp', 'data-rowtype'=>$godown_transfer_fp->RowType));

		// Render row
		$godown_transfer_fp_list->renderRow();

		// Render list options
		$godown_transfer_fp_list->renderListOptions();
?>
	<tr<?php echo $godown_transfer_fp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$godown_transfer_fp_list->ListOptions->render("body", "left", $godown_transfer_fp_list->RowCnt);
?>
	<?php if ($godown_transfer_fp->id->Visible) { // id ?>
		<td data-name="id"<?php echo $godown_transfer_fp->id->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_fp_list->RowCnt ?>_godown_transfer_fp_id" class="godown_transfer_fp_id">
<span<?php echo $godown_transfer_fp->id->viewAttributes() ?>>
<?php echo $godown_transfer_fp->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_fp->gp_no->Visible) { // gp_no ?>
		<td data-name="gp_no"<?php echo $godown_transfer_fp->gp_no->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_fp_list->RowCnt ?>_godown_transfer_fp_gp_no" class="godown_transfer_fp_gp_no">
<span<?php echo $godown_transfer_fp->gp_no->viewAttributes() ?>>
<?php echo $godown_transfer_fp->gp_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_fp->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $godown_transfer_fp->grp->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_fp_list->RowCnt ?>_godown_transfer_fp_grp" class="godown_transfer_fp_grp">
<span<?php echo $godown_transfer_fp->grp->viewAttributes() ?>>
<?php echo $godown_transfer_fp->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_fp->product->Visible) { // product ?>
		<td data-name="product"<?php echo $godown_transfer_fp->product->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_fp_list->RowCnt ?>_godown_transfer_fp_product" class="godown_transfer_fp_product">
<span<?php echo $godown_transfer_fp->product->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_fp->product->getViewValue())) && $godown_transfer_fp->product->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_fp->product->linkAttributes() ?>><?php echo $godown_transfer_fp->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_fp->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_fp->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $godown_transfer_fp->ref->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_fp_list->RowCnt ?>_godown_transfer_fp_ref" class="godown_transfer_fp_ref">
<span<?php echo $godown_transfer_fp->ref->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_fp->ref->getViewValue())) && $godown_transfer_fp->ref->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_fp->ref->linkAttributes() ?>><?php echo $godown_transfer_fp->ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_fp->ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_fp->count_received->Visible) { // count_received ?>
		<td data-name="count_received"<?php echo $godown_transfer_fp->count_received->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_fp_list->RowCnt ?>_godown_transfer_fp_count_received" class="godown_transfer_fp_count_received">
<span<?php echo $godown_transfer_fp->count_received->viewAttributes() ?>>
<?php echo $godown_transfer_fp->count_received->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_fp->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $godown_transfer_fp->rid->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_fp_list->RowCnt ?>_godown_transfer_fp_rid" class="godown_transfer_fp_rid">
<span<?php echo $godown_transfer_fp->rid->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_fp->rid->getViewValue())) && $godown_transfer_fp->rid->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_fp->rid->linkAttributes() ?>><?php echo $godown_transfer_fp->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_fp->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_fp->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $godown_transfer_fp->packets->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_fp_list->RowCnt ?>_godown_transfer_fp_packets" class="godown_transfer_fp_packets">
<span<?php echo $godown_transfer_fp->packets->viewAttributes() ?>>
<?php echo $godown_transfer_fp->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_fp->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $godown_transfer_fp->quantity->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_fp_list->RowCnt ?>_godown_transfer_fp_quantity" class="godown_transfer_fp_quantity">
<span<?php echo $godown_transfer_fp->quantity->viewAttributes() ?>>
<?php echo $godown_transfer_fp->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_fp->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $godown_transfer_fp->packing_type->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_fp_list->RowCnt ?>_godown_transfer_fp_packing_type" class="godown_transfer_fp_packing_type">
<span<?php echo $godown_transfer_fp->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_fp->packing_type->getViewValue())) && $godown_transfer_fp->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_fp->packing_type->linkAttributes() ?>><?php echo $godown_transfer_fp->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_fp->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_fp->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $godown_transfer_fp->godown->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_fp_list->RowCnt ?>_godown_transfer_fp_godown" class="godown_transfer_fp_godown">
<span<?php echo $godown_transfer_fp->godown->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_fp->godown->getViewValue())) && $godown_transfer_fp->godown->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_fp->godown->linkAttributes() ?>><?php echo $godown_transfer_fp->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_fp->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_fp->next_godown->Visible) { // next_godown ?>
		<td data-name="next_godown"<?php echo $godown_transfer_fp->next_godown->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_fp_list->RowCnt ?>_godown_transfer_fp_next_godown" class="godown_transfer_fp_next_godown">
<span<?php echo $godown_transfer_fp->next_godown->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_fp->next_godown->getViewValue())) && $godown_transfer_fp->next_godown->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_fp->next_godown->linkAttributes() ?>><?php echo $godown_transfer_fp->next_godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_fp->next_godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_fp->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $godown_transfer_fp->remarks->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_fp_list->RowCnt ?>_godown_transfer_fp_remarks" class="godown_transfer_fp_remarks">
<span<?php echo $godown_transfer_fp->remarks->viewAttributes() ?>>
<?php echo $godown_transfer_fp->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_fp->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $godown_transfer_fp->datetime->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_fp_list->RowCnt ?>_godown_transfer_fp_datetime" class="godown_transfer_fp_datetime">
<span<?php echo $godown_transfer_fp->datetime->viewAttributes() ?>>
<?php echo $godown_transfer_fp->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_fp->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $godown_transfer_fp->operator->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_fp_list->RowCnt ?>_godown_transfer_fp_operator" class="godown_transfer_fp_operator">
<span<?php echo $godown_transfer_fp->operator->viewAttributes() ?>>
<?php echo $godown_transfer_fp->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$godown_transfer_fp_list->ListOptions->render("body", "right", $godown_transfer_fp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$godown_transfer_fp->isGridAdd())
		$godown_transfer_fp_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$godown_transfer_fp->RowType = ROWTYPE_AGGREGATE;
$godown_transfer_fp->resetAttributes();
$godown_transfer_fp_list->renderRow();
?>
<?php if ($godown_transfer_fp_list->TotalRecs > 0 && !$godown_transfer_fp->isGridAdd() && !$godown_transfer_fp->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$godown_transfer_fp_list->renderListOptions();

// Render list options (footer, left)
$godown_transfer_fp_list->ListOptions->render("footer", "left");
?>
	<?php if ($godown_transfer_fp->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $godown_transfer_fp->id->footerCellClass() ?>"><span id="elf_godown_transfer_fp_id" class="godown_transfer_fp_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_fp->gp_no->Visible) { // gp_no ?>
		<td data-name="gp_no" class="<?php echo $godown_transfer_fp->gp_no->footerCellClass() ?>"><span id="elf_godown_transfer_fp_gp_no" class="godown_transfer_fp_gp_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_fp->grp->Visible) { // grp ?>
		<td data-name="grp" class="<?php echo $godown_transfer_fp->grp->footerCellClass() ?>"><span id="elf_godown_transfer_fp_grp" class="godown_transfer_fp_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_fp->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $godown_transfer_fp->product->footerCellClass() ?>"><span id="elf_godown_transfer_fp_product" class="godown_transfer_fp_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_fp->ref->Visible) { // ref ?>
		<td data-name="ref" class="<?php echo $godown_transfer_fp->ref->footerCellClass() ?>"><span id="elf_godown_transfer_fp_ref" class="godown_transfer_fp_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_fp->count_received->Visible) { // count_received ?>
		<td data-name="count_received" class="<?php echo $godown_transfer_fp->count_received->footerCellClass() ?>"><span id="elf_godown_transfer_fp_count_received" class="godown_transfer_fp_count_received">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_fp->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $godown_transfer_fp->rid->footerCellClass() ?>"><span id="elf_godown_transfer_fp_rid" class="godown_transfer_fp_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_fp->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $godown_transfer_fp->packets->footerCellClass() ?>"><span id="elf_godown_transfer_fp_packets" class="godown_transfer_fp_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_fp->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $godown_transfer_fp->quantity->footerCellClass() ?>"><span id="elf_godown_transfer_fp_quantity" class="godown_transfer_fp_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $godown_transfer_fp->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_fp->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $godown_transfer_fp->packing_type->footerCellClass() ?>"><span id="elf_godown_transfer_fp_packing_type" class="godown_transfer_fp_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_fp->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $godown_transfer_fp->godown->footerCellClass() ?>"><span id="elf_godown_transfer_fp_godown" class="godown_transfer_fp_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_fp->next_godown->Visible) { // next_godown ?>
		<td data-name="next_godown" class="<?php echo $godown_transfer_fp->next_godown->footerCellClass() ?>"><span id="elf_godown_transfer_fp_next_godown" class="godown_transfer_fp_next_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_fp->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $godown_transfer_fp->remarks->footerCellClass() ?>"><span id="elf_godown_transfer_fp_remarks" class="godown_transfer_fp_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_fp->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $godown_transfer_fp->datetime->footerCellClass() ?>"><span id="elf_godown_transfer_fp_datetime" class="godown_transfer_fp_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_fp->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $godown_transfer_fp->operator->footerCellClass() ?>"><span id="elf_godown_transfer_fp_operator" class="godown_transfer_fp_operator">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$godown_transfer_fp_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$godown_transfer_fp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($godown_transfer_fp_list->Recordset)
	$godown_transfer_fp_list->Recordset->Close();
?>
<?php if (!$godown_transfer_fp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$godown_transfer_fp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($godown_transfer_fp_list->Pager)) $godown_transfer_fp_list->Pager = new PrevNextPager($godown_transfer_fp_list->StartRec, $godown_transfer_fp_list->DisplayRecs, $godown_transfer_fp_list->TotalRecs, $godown_transfer_fp_list->AutoHidePager) ?>
<?php if ($godown_transfer_fp_list->Pager->RecordCount > 0 && $godown_transfer_fp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($godown_transfer_fp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $godown_transfer_fp_list->pageUrl() ?>start=<?php echo $godown_transfer_fp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($godown_transfer_fp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $godown_transfer_fp_list->pageUrl() ?>start=<?php echo $godown_transfer_fp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $godown_transfer_fp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($godown_transfer_fp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $godown_transfer_fp_list->pageUrl() ?>start=<?php echo $godown_transfer_fp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($godown_transfer_fp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $godown_transfer_fp_list->pageUrl() ?>start=<?php echo $godown_transfer_fp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $godown_transfer_fp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($godown_transfer_fp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $godown_transfer_fp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $godown_transfer_fp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $godown_transfer_fp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($godown_transfer_fp_list->TotalRecs > 0 && (!$godown_transfer_fp_list->AutoHidePageSizeSelector || $godown_transfer_fp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="godown_transfer_fp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($godown_transfer_fp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($godown_transfer_fp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($godown_transfer_fp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($godown_transfer_fp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($godown_transfer_fp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($godown_transfer_fp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $godown_transfer_fp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($godown_transfer_fp_list->TotalRecs == 0 && !$godown_transfer_fp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $godown_transfer_fp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$godown_transfer_fp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$godown_transfer_fp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$godown_transfer_fp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_godown_transfer_fp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$godown_transfer_fp_list->terminate();
?>