<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$godown_transfer_hs_list = new godown_transfer_hs_list();

// Run the page
$godown_transfer_hs_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$godown_transfer_hs_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$godown_transfer_hs->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fgodown_transfer_hslist = currentForm = new ew.Form("fgodown_transfer_hslist", "list");
fgodown_transfer_hslist.formKeyCountName = '<?php echo $godown_transfer_hs_list->FormKeyCountName ?>';

// Form_CustomValidate event
fgodown_transfer_hslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgodown_transfer_hslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgodown_transfer_hslist.lists["x_product"] = <?php echo $godown_transfer_hs_list->product->Lookup->toClientList() ?>;
fgodown_transfer_hslist.lists["x_product"].options = <?php echo JsonEncode($godown_transfer_hs_list->product->lookupOptions()) ?>;
fgodown_transfer_hslist.lists["x_ref"] = <?php echo $godown_transfer_hs_list->ref->Lookup->toClientList() ?>;
fgodown_transfer_hslist.lists["x_ref"].options = <?php echo JsonEncode($godown_transfer_hs_list->ref->lookupOptions()) ?>;
fgodown_transfer_hslist.lists["x_packets"] = <?php echo $godown_transfer_hs_list->packets->Lookup->toClientList() ?>;
fgodown_transfer_hslist.lists["x_packets"].options = <?php echo JsonEncode($godown_transfer_hs_list->packets->lookupOptions()) ?>;
fgodown_transfer_hslist.lists["x_packing_type"] = <?php echo $godown_transfer_hs_list->packing_type->Lookup->toClientList() ?>;
fgodown_transfer_hslist.lists["x_packing_type"].options = <?php echo JsonEncode($godown_transfer_hs_list->packing_type->lookupOptions()) ?>;
fgodown_transfer_hslist.lists["x_godown"] = <?php echo $godown_transfer_hs_list->godown->Lookup->toClientList() ?>;
fgodown_transfer_hslist.lists["x_godown"].options = <?php echo JsonEncode($godown_transfer_hs_list->godown->lookupOptions()) ?>;
fgodown_transfer_hslist.lists["x_issue_to"] = <?php echo $godown_transfer_hs_list->issue_to->Lookup->toClientList() ?>;
fgodown_transfer_hslist.lists["x_issue_to"].options = <?php echo JsonEncode($godown_transfer_hs_list->issue_to->lookupOptions()) ?>;
fgodown_transfer_hslist.lists["x_operator"] = <?php echo $godown_transfer_hs_list->operator->Lookup->toClientList() ?>;
fgodown_transfer_hslist.lists["x_operator"].options = <?php echo JsonEncode($godown_transfer_hs_list->operator->lookupOptions()) ?>;

// Form object for search
var fgodown_transfer_hslistsrch = currentSearchForm = new ew.Form("fgodown_transfer_hslistsrch");

// Filters
fgodown_transfer_hslistsrch.filterList = <?php echo $godown_transfer_hs_list->getFilterList() ?>;

// Init search panel as collapsed
fgodown_transfer_hslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$godown_transfer_hs->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($godown_transfer_hs_list->TotalRecs > 0 && $godown_transfer_hs_list->ExportOptions->visible()) { ?>
<?php $godown_transfer_hs_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($godown_transfer_hs_list->ImportOptions->visible()) { ?>
<?php $godown_transfer_hs_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($godown_transfer_hs_list->SearchOptions->visible()) { ?>
<?php $godown_transfer_hs_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($godown_transfer_hs_list->FilterOptions->visible()) { ?>
<?php $godown_transfer_hs_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$godown_transfer_hs_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$godown_transfer_hs->isExport() && !$godown_transfer_hs->CurrentAction) { ?>
<form name="fgodown_transfer_hslistsrch" id="fgodown_transfer_hslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($godown_transfer_hs_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fgodown_transfer_hslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="godown_transfer_hs">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($godown_transfer_hs_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($godown_transfer_hs_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $godown_transfer_hs_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($godown_transfer_hs_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($godown_transfer_hs_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($godown_transfer_hs_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($godown_transfer_hs_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $godown_transfer_hs_list->showPageHeader(); ?>
<?php
$godown_transfer_hs_list->showMessage();
?>
<?php if ($godown_transfer_hs_list->TotalRecs > 0 || $godown_transfer_hs->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($godown_transfer_hs_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> godown_transfer_hs">
<?php if (!$godown_transfer_hs->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$godown_transfer_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($godown_transfer_hs_list->Pager)) $godown_transfer_hs_list->Pager = new PrevNextPager($godown_transfer_hs_list->StartRec, $godown_transfer_hs_list->DisplayRecs, $godown_transfer_hs_list->TotalRecs, $godown_transfer_hs_list->AutoHidePager) ?>
<?php if ($godown_transfer_hs_list->Pager->RecordCount > 0 && $godown_transfer_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($godown_transfer_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $godown_transfer_hs_list->pageUrl() ?>start=<?php echo $godown_transfer_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($godown_transfer_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $godown_transfer_hs_list->pageUrl() ?>start=<?php echo $godown_transfer_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $godown_transfer_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($godown_transfer_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $godown_transfer_hs_list->pageUrl() ?>start=<?php echo $godown_transfer_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($godown_transfer_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $godown_transfer_hs_list->pageUrl() ?>start=<?php echo $godown_transfer_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $godown_transfer_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($godown_transfer_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $godown_transfer_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $godown_transfer_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $godown_transfer_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($godown_transfer_hs_list->TotalRecs > 0 && (!$godown_transfer_hs_list->AutoHidePageSizeSelector || $godown_transfer_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="godown_transfer_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($godown_transfer_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($godown_transfer_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($godown_transfer_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($godown_transfer_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($godown_transfer_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($godown_transfer_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $godown_transfer_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fgodown_transfer_hslist" id="fgodown_transfer_hslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($godown_transfer_hs_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $godown_transfer_hs_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="godown_transfer_hs">
<div id="gmp_godown_transfer_hs" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($godown_transfer_hs_list->TotalRecs > 0 || $godown_transfer_hs->isGridEdit()) { ?>
<table id="tbl_godown_transfer_hslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$godown_transfer_hs_list->RowType = ROWTYPE_HEADER;

// Render list options
$godown_transfer_hs_list->renderListOptions();

// Render list options (header, left)
$godown_transfer_hs_list->ListOptions->render("header", "left");
?>
<?php if ($godown_transfer_hs->id->Visible) { // id ?>
	<?php if ($godown_transfer_hs->sortUrl($godown_transfer_hs->id) == "") { ?>
		<th data-name="id" class="<?php echo $godown_transfer_hs->id->headerCellClass() ?>"><div id="elh_godown_transfer_hs_id" class="godown_transfer_hs_id"><div class="ew-table-header-caption"><?php echo $godown_transfer_hs->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $godown_transfer_hs->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_hs->SortUrl($godown_transfer_hs->id) ?>',2);"><div id="elh_godown_transfer_hs_id" class="godown_transfer_hs_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_hs->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_hs->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_hs->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_hs->product->Visible) { // product ?>
	<?php if ($godown_transfer_hs->sortUrl($godown_transfer_hs->product) == "") { ?>
		<th data-name="product" class="<?php echo $godown_transfer_hs->product->headerCellClass() ?>"><div id="elh_godown_transfer_hs_product" class="godown_transfer_hs_product"><div class="ew-table-header-caption"><?php echo $godown_transfer_hs->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $godown_transfer_hs->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_hs->SortUrl($godown_transfer_hs->product) ?>',2);"><div id="elh_godown_transfer_hs_product" class="godown_transfer_hs_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_hs->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_hs->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_hs->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_hs->ref->Visible) { // ref ?>
	<?php if ($godown_transfer_hs->sortUrl($godown_transfer_hs->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $godown_transfer_hs->ref->headerCellClass() ?>"><div id="elh_godown_transfer_hs_ref" class="godown_transfer_hs_ref"><div class="ew-table-header-caption"><?php echo $godown_transfer_hs->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $godown_transfer_hs->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_hs->SortUrl($godown_transfer_hs->ref) ?>',2);"><div id="elh_godown_transfer_hs_ref" class="godown_transfer_hs_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_hs->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_hs->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_hs->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_hs->packets->Visible) { // packets ?>
	<?php if ($godown_transfer_hs->sortUrl($godown_transfer_hs->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $godown_transfer_hs->packets->headerCellClass() ?>"><div id="elh_godown_transfer_hs_packets" class="godown_transfer_hs_packets"><div class="ew-table-header-caption"><?php echo $godown_transfer_hs->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $godown_transfer_hs->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_hs->SortUrl($godown_transfer_hs->packets) ?>',2);"><div id="elh_godown_transfer_hs_packets" class="godown_transfer_hs_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_hs->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_hs->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_hs->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_hs->quantity->Visible) { // quantity ?>
	<?php if ($godown_transfer_hs->sortUrl($godown_transfer_hs->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $godown_transfer_hs->quantity->headerCellClass() ?>"><div id="elh_godown_transfer_hs_quantity" class="godown_transfer_hs_quantity"><div class="ew-table-header-caption"><?php echo $godown_transfer_hs->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $godown_transfer_hs->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_hs->SortUrl($godown_transfer_hs->quantity) ?>',2);"><div id="elh_godown_transfer_hs_quantity" class="godown_transfer_hs_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_hs->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_hs->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_hs->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_hs->packing_type->Visible) { // packing_type ?>
	<?php if ($godown_transfer_hs->sortUrl($godown_transfer_hs->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $godown_transfer_hs->packing_type->headerCellClass() ?>"><div id="elh_godown_transfer_hs_packing_type" class="godown_transfer_hs_packing_type"><div class="ew-table-header-caption"><?php echo $godown_transfer_hs->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $godown_transfer_hs->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_hs->SortUrl($godown_transfer_hs->packing_type) ?>',2);"><div id="elh_godown_transfer_hs_packing_type" class="godown_transfer_hs_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_hs->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_hs->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_hs->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_hs->godown->Visible) { // godown ?>
	<?php if ($godown_transfer_hs->sortUrl($godown_transfer_hs->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $godown_transfer_hs->godown->headerCellClass() ?>"><div id="elh_godown_transfer_hs_godown" class="godown_transfer_hs_godown"><div class="ew-table-header-caption"><?php echo $godown_transfer_hs->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $godown_transfer_hs->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_hs->SortUrl($godown_transfer_hs->godown) ?>',2);"><div id="elh_godown_transfer_hs_godown" class="godown_transfer_hs_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_hs->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_hs->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_hs->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_hs->issue_to->Visible) { // issue_to ?>
	<?php if ($godown_transfer_hs->sortUrl($godown_transfer_hs->issue_to) == "") { ?>
		<th data-name="issue_to" class="<?php echo $godown_transfer_hs->issue_to->headerCellClass() ?>"><div id="elh_godown_transfer_hs_issue_to" class="godown_transfer_hs_issue_to"><div class="ew-table-header-caption"><?php echo $godown_transfer_hs->issue_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="issue_to" class="<?php echo $godown_transfer_hs->issue_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_hs->SortUrl($godown_transfer_hs->issue_to) ?>',2);"><div id="elh_godown_transfer_hs_issue_to" class="godown_transfer_hs_issue_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_hs->issue_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_hs->issue_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_hs->issue_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_hs->dated->Visible) { // dated ?>
	<?php if ($godown_transfer_hs->sortUrl($godown_transfer_hs->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $godown_transfer_hs->dated->headerCellClass() ?>"><div id="elh_godown_transfer_hs_dated" class="godown_transfer_hs_dated"><div class="ew-table-header-caption"><?php echo $godown_transfer_hs->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $godown_transfer_hs->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_hs->SortUrl($godown_transfer_hs->dated) ?>',2);"><div id="elh_godown_transfer_hs_dated" class="godown_transfer_hs_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_hs->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_hs->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_hs->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_hs->operator->Visible) { // operator ?>
	<?php if ($godown_transfer_hs->sortUrl($godown_transfer_hs->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $godown_transfer_hs->operator->headerCellClass() ?>"><div id="elh_godown_transfer_hs_operator" class="godown_transfer_hs_operator"><div class="ew-table-header-caption"><?php echo $godown_transfer_hs->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $godown_transfer_hs->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_hs->SortUrl($godown_transfer_hs->operator) ?>',2);"><div id="elh_godown_transfer_hs_operator" class="godown_transfer_hs_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_hs->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_hs->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_hs->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_hs->datetime->Visible) { // datetime ?>
	<?php if ($godown_transfer_hs->sortUrl($godown_transfer_hs->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $godown_transfer_hs->datetime->headerCellClass() ?>"><div id="elh_godown_transfer_hs_datetime" class="godown_transfer_hs_datetime"><div class="ew-table-header-caption"><?php echo $godown_transfer_hs->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $godown_transfer_hs->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_hs->SortUrl($godown_transfer_hs->datetime) ?>',2);"><div id="elh_godown_transfer_hs_datetime" class="godown_transfer_hs_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_hs->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_hs->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_hs->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_hs->remarks->Visible) { // remarks ?>
	<?php if ($godown_transfer_hs->sortUrl($godown_transfer_hs->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $godown_transfer_hs->remarks->headerCellClass() ?>"><div id="elh_godown_transfer_hs_remarks" class="godown_transfer_hs_remarks"><div class="ew-table-header-caption"><?php echo $godown_transfer_hs->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $godown_transfer_hs->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_hs->SortUrl($godown_transfer_hs->remarks) ?>',2);"><div id="elh_godown_transfer_hs_remarks" class="godown_transfer_hs_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_hs->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_hs->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_hs->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$godown_transfer_hs_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($godown_transfer_hs->ExportAll && $godown_transfer_hs->isExport()) {
	$godown_transfer_hs_list->StopRec = $godown_transfer_hs_list->TotalRecs;
} else {

	// Set the last record to display
	if ($godown_transfer_hs_list->TotalRecs > $godown_transfer_hs_list->StartRec + $godown_transfer_hs_list->DisplayRecs - 1)
		$godown_transfer_hs_list->StopRec = $godown_transfer_hs_list->StartRec + $godown_transfer_hs_list->DisplayRecs - 1;
	else
		$godown_transfer_hs_list->StopRec = $godown_transfer_hs_list->TotalRecs;
}
$godown_transfer_hs_list->RecCnt = $godown_transfer_hs_list->StartRec - 1;
if ($godown_transfer_hs_list->Recordset && !$godown_transfer_hs_list->Recordset->EOF) {
	$godown_transfer_hs_list->Recordset->moveFirst();
	$selectLimit = $godown_transfer_hs_list->UseSelectLimit;
	if (!$selectLimit && $godown_transfer_hs_list->StartRec > 1)
		$godown_transfer_hs_list->Recordset->move($godown_transfer_hs_list->StartRec - 1);
} elseif (!$godown_transfer_hs->AllowAddDeleteRow && $godown_transfer_hs_list->StopRec == 0) {
	$godown_transfer_hs_list->StopRec = $godown_transfer_hs->GridAddRowCount;
}

// Initialize aggregate
$godown_transfer_hs->RowType = ROWTYPE_AGGREGATEINIT;
$godown_transfer_hs->resetAttributes();
$godown_transfer_hs_list->renderRow();
while ($godown_transfer_hs_list->RecCnt < $godown_transfer_hs_list->StopRec) {
	$godown_transfer_hs_list->RecCnt++;
	if ($godown_transfer_hs_list->RecCnt >= $godown_transfer_hs_list->StartRec) {
		$godown_transfer_hs_list->RowCnt++;

		// Set up key count
		$godown_transfer_hs_list->KeyCount = $godown_transfer_hs_list->RowIndex;

		// Init row class and style
		$godown_transfer_hs->resetAttributes();
		$godown_transfer_hs->CssClass = "";
		if ($godown_transfer_hs->isGridAdd()) {
		} else {
			$godown_transfer_hs_list->loadRowValues($godown_transfer_hs_list->Recordset); // Load row values
		}
		$godown_transfer_hs->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$godown_transfer_hs->RowAttrs = array_merge($godown_transfer_hs->RowAttrs, array('data-rowindex'=>$godown_transfer_hs_list->RowCnt, 'id'=>'r' . $godown_transfer_hs_list->RowCnt . '_godown_transfer_hs', 'data-rowtype'=>$godown_transfer_hs->RowType));

		// Render row
		$godown_transfer_hs_list->renderRow();

		// Render list options
		$godown_transfer_hs_list->renderListOptions();
?>
	<tr<?php echo $godown_transfer_hs->rowAttributes() ?>>
<?php

// Render list options (body, left)
$godown_transfer_hs_list->ListOptions->render("body", "left", $godown_transfer_hs_list->RowCnt);
?>
	<?php if ($godown_transfer_hs->id->Visible) { // id ?>
		<td data-name="id"<?php echo $godown_transfer_hs->id->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_hs_list->RowCnt ?>_godown_transfer_hs_id" class="godown_transfer_hs_id">
<span<?php echo $godown_transfer_hs->id->viewAttributes() ?>>
<?php echo $godown_transfer_hs->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_hs->product->Visible) { // product ?>
		<td data-name="product"<?php echo $godown_transfer_hs->product->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_hs_list->RowCnt ?>_godown_transfer_hs_product" class="godown_transfer_hs_product">
<span<?php echo $godown_transfer_hs->product->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_hs->product->getViewValue())) && $godown_transfer_hs->product->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_hs->product->linkAttributes() ?>><?php echo $godown_transfer_hs->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_hs->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_hs->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $godown_transfer_hs->ref->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_hs_list->RowCnt ?>_godown_transfer_hs_ref" class="godown_transfer_hs_ref">
<span<?php echo $godown_transfer_hs->ref->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_hs->ref->getViewValue())) && $godown_transfer_hs->ref->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_hs->ref->linkAttributes() ?>><?php echo $godown_transfer_hs->ref->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_hs->ref->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_hs->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $godown_transfer_hs->packets->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_hs_list->RowCnt ?>_godown_transfer_hs_packets" class="godown_transfer_hs_packets">
<span<?php echo $godown_transfer_hs->packets->viewAttributes() ?>>
<?php echo $godown_transfer_hs->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_hs->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $godown_transfer_hs->quantity->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_hs_list->RowCnt ?>_godown_transfer_hs_quantity" class="godown_transfer_hs_quantity">
<span<?php echo $godown_transfer_hs->quantity->viewAttributes() ?>>
<?php echo $godown_transfer_hs->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_hs->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $godown_transfer_hs->packing_type->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_hs_list->RowCnt ?>_godown_transfer_hs_packing_type" class="godown_transfer_hs_packing_type">
<span<?php echo $godown_transfer_hs->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_hs->packing_type->getViewValue())) && $godown_transfer_hs->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_hs->packing_type->linkAttributes() ?>><?php echo $godown_transfer_hs->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_hs->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_hs->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $godown_transfer_hs->godown->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_hs_list->RowCnt ?>_godown_transfer_hs_godown" class="godown_transfer_hs_godown">
<span<?php echo $godown_transfer_hs->godown->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_hs->godown->getViewValue())) && $godown_transfer_hs->godown->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_hs->godown->linkAttributes() ?>><?php echo $godown_transfer_hs->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_hs->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_hs->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to"<?php echo $godown_transfer_hs->issue_to->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_hs_list->RowCnt ?>_godown_transfer_hs_issue_to" class="godown_transfer_hs_issue_to">
<span<?php echo $godown_transfer_hs->issue_to->viewAttributes() ?>>
<?php echo $godown_transfer_hs->issue_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_hs->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $godown_transfer_hs->dated->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_hs_list->RowCnt ?>_godown_transfer_hs_dated" class="godown_transfer_hs_dated">
<span<?php echo $godown_transfer_hs->dated->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_hs->dated->getViewValue())) && $godown_transfer_hs->dated->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_hs->dated->linkAttributes() ?>><?php echo $godown_transfer_hs->dated->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_hs->dated->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_hs->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $godown_transfer_hs->operator->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_hs_list->RowCnt ?>_godown_transfer_hs_operator" class="godown_transfer_hs_operator">
<span<?php echo $godown_transfer_hs->operator->viewAttributes() ?>>
<?php echo $godown_transfer_hs->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_hs->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $godown_transfer_hs->datetime->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_hs_list->RowCnt ?>_godown_transfer_hs_datetime" class="godown_transfer_hs_datetime">
<span<?php echo $godown_transfer_hs->datetime->viewAttributes() ?>>
<?php echo $godown_transfer_hs->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_hs->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $godown_transfer_hs->remarks->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_hs_list->RowCnt ?>_godown_transfer_hs_remarks" class="godown_transfer_hs_remarks">
<span<?php echo $godown_transfer_hs->remarks->viewAttributes() ?>>
<?php echo $godown_transfer_hs->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$godown_transfer_hs_list->ListOptions->render("body", "right", $godown_transfer_hs_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$godown_transfer_hs->isGridAdd())
		$godown_transfer_hs_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$godown_transfer_hs->RowType = ROWTYPE_AGGREGATE;
$godown_transfer_hs->resetAttributes();
$godown_transfer_hs_list->renderRow();
?>
<?php if ($godown_transfer_hs_list->TotalRecs > 0 && !$godown_transfer_hs->isGridAdd() && !$godown_transfer_hs->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$godown_transfer_hs_list->renderListOptions();

// Render list options (footer, left)
$godown_transfer_hs_list->ListOptions->render("footer", "left");
?>
	<?php if ($godown_transfer_hs->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $godown_transfer_hs->id->footerCellClass() ?>"><span id="elf_godown_transfer_hs_id" class="godown_transfer_hs_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_hs->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $godown_transfer_hs->product->footerCellClass() ?>"><span id="elf_godown_transfer_hs_product" class="godown_transfer_hs_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_hs->ref->Visible) { // ref ?>
		<td data-name="ref" class="<?php echo $godown_transfer_hs->ref->footerCellClass() ?>"><span id="elf_godown_transfer_hs_ref" class="godown_transfer_hs_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_hs->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $godown_transfer_hs->packets->footerCellClass() ?>"><span id="elf_godown_transfer_hs_packets" class="godown_transfer_hs_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_hs->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $godown_transfer_hs->quantity->footerCellClass() ?>"><span id="elf_godown_transfer_hs_quantity" class="godown_transfer_hs_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $godown_transfer_hs->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_hs->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $godown_transfer_hs->packing_type->footerCellClass() ?>"><span id="elf_godown_transfer_hs_packing_type" class="godown_transfer_hs_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_hs->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $godown_transfer_hs->godown->footerCellClass() ?>"><span id="elf_godown_transfer_hs_godown" class="godown_transfer_hs_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_hs->issue_to->Visible) { // issue_to ?>
		<td data-name="issue_to" class="<?php echo $godown_transfer_hs->issue_to->footerCellClass() ?>"><span id="elf_godown_transfer_hs_issue_to" class="godown_transfer_hs_issue_to">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_hs->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $godown_transfer_hs->dated->footerCellClass() ?>"><span id="elf_godown_transfer_hs_dated" class="godown_transfer_hs_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_hs->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $godown_transfer_hs->operator->footerCellClass() ?>"><span id="elf_godown_transfer_hs_operator" class="godown_transfer_hs_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_hs->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $godown_transfer_hs->datetime->footerCellClass() ?>"><span id="elf_godown_transfer_hs_datetime" class="godown_transfer_hs_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_hs->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $godown_transfer_hs->remarks->footerCellClass() ?>"><span id="elf_godown_transfer_hs_remarks" class="godown_transfer_hs_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$godown_transfer_hs_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$godown_transfer_hs->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($godown_transfer_hs_list->Recordset)
	$godown_transfer_hs_list->Recordset->Close();
?>
<?php if (!$godown_transfer_hs->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$godown_transfer_hs->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($godown_transfer_hs_list->Pager)) $godown_transfer_hs_list->Pager = new PrevNextPager($godown_transfer_hs_list->StartRec, $godown_transfer_hs_list->DisplayRecs, $godown_transfer_hs_list->TotalRecs, $godown_transfer_hs_list->AutoHidePager) ?>
<?php if ($godown_transfer_hs_list->Pager->RecordCount > 0 && $godown_transfer_hs_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($godown_transfer_hs_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $godown_transfer_hs_list->pageUrl() ?>start=<?php echo $godown_transfer_hs_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($godown_transfer_hs_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $godown_transfer_hs_list->pageUrl() ?>start=<?php echo $godown_transfer_hs_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $godown_transfer_hs_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($godown_transfer_hs_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $godown_transfer_hs_list->pageUrl() ?>start=<?php echo $godown_transfer_hs_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($godown_transfer_hs_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $godown_transfer_hs_list->pageUrl() ?>start=<?php echo $godown_transfer_hs_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $godown_transfer_hs_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($godown_transfer_hs_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $godown_transfer_hs_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $godown_transfer_hs_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $godown_transfer_hs_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($godown_transfer_hs_list->TotalRecs > 0 && (!$godown_transfer_hs_list->AutoHidePageSizeSelector || $godown_transfer_hs_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="godown_transfer_hs">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($godown_transfer_hs_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($godown_transfer_hs_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($godown_transfer_hs_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($godown_transfer_hs_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($godown_transfer_hs_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($godown_transfer_hs->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $godown_transfer_hs_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($godown_transfer_hs_list->TotalRecs == 0 && !$godown_transfer_hs->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $godown_transfer_hs_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$godown_transfer_hs_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$godown_transfer_hs->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$godown_transfer_hs->isExport()) { ?>
<script>
ew.scrollableTable("gmp_godown_transfer_hs", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$godown_transfer_hs_list->terminate();
?>