<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$godown_transfer_new_list = new godown_transfer_new_list();

// Run the page
$godown_transfer_new_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$godown_transfer_new_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$godown_transfer_new->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fgodown_transfer_newlist = currentForm = new ew.Form("fgodown_transfer_newlist", "list");
fgodown_transfer_newlist.formKeyCountName = '<?php echo $godown_transfer_new_list->FormKeyCountName ?>';

// Form_CustomValidate event
fgodown_transfer_newlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgodown_transfer_newlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgodown_transfer_newlist.lists["x_from"] = <?php echo $godown_transfer_new_list->from->Lookup->toClientList() ?>;
fgodown_transfer_newlist.lists["x_from"].options = <?php echo JsonEncode($godown_transfer_new_list->from->lookupOptions()) ?>;
fgodown_transfer_newlist.lists["x_to"] = <?php echo $godown_transfer_new_list->to->Lookup->toClientList() ?>;
fgodown_transfer_newlist.lists["x_to"].options = <?php echo JsonEncode($godown_transfer_new_list->to->lookupOptions()) ?>;
fgodown_transfer_newlist.lists["x_attention"] = <?php echo $godown_transfer_new_list->attention->Lookup->toClientList() ?>;
fgodown_transfer_newlist.lists["x_attention"].options = <?php echo JsonEncode($godown_transfer_new_list->attention->lookupOptions()) ?>;
fgodown_transfer_newlist.lists["x_transfer_nature"] = <?php echo $godown_transfer_new_list->transfer_nature->Lookup->toClientList() ?>;
fgodown_transfer_newlist.lists["x_transfer_nature"].options = <?php echo JsonEncode($godown_transfer_new_list->transfer_nature->options(FALSE, TRUE)) ?>;
fgodown_transfer_newlist.lists["x_group"] = <?php echo $godown_transfer_new_list->group->Lookup->toClientList() ?>;
fgodown_transfer_newlist.lists["x_group"].options = <?php echo JsonEncode($godown_transfer_new_list->group->options(FALSE, TRUE)) ?>;
fgodown_transfer_newlist.lists["x_t_mode"] = <?php echo $godown_transfer_new_list->t_mode->Lookup->toClientList() ?>;
fgodown_transfer_newlist.lists["x_t_mode"].options = <?php echo JsonEncode($godown_transfer_new_list->t_mode->options(FALSE, TRUE)) ?>;
fgodown_transfer_newlist.lists["x_purpose"] = <?php echo $godown_transfer_new_list->purpose->Lookup->toClientList() ?>;
fgodown_transfer_newlist.lists["x_purpose"].options = <?php echo JsonEncode($godown_transfer_new_list->purpose->options(FALSE, TRUE)) ?>;

// Form object for search
var fgodown_transfer_newlistsrch = currentSearchForm = new ew.Form("fgodown_transfer_newlistsrch");

// Filters
fgodown_transfer_newlistsrch.filterList = <?php echo $godown_transfer_new_list->getFilterList() ?>;

// Init search panel as collapsed
fgodown_transfer_newlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$godown_transfer_new->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($godown_transfer_new_list->TotalRecs > 0 && $godown_transfer_new_list->ExportOptions->visible()) { ?>
<?php $godown_transfer_new_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($godown_transfer_new_list->ImportOptions->visible()) { ?>
<?php $godown_transfer_new_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($godown_transfer_new_list->SearchOptions->visible()) { ?>
<?php $godown_transfer_new_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($godown_transfer_new_list->FilterOptions->visible()) { ?>
<?php $godown_transfer_new_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$godown_transfer_new_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$godown_transfer_new->isExport() && !$godown_transfer_new->CurrentAction) { ?>
<form name="fgodown_transfer_newlistsrch" id="fgodown_transfer_newlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($godown_transfer_new_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fgodown_transfer_newlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="godown_transfer_new">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($godown_transfer_new_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($godown_transfer_new_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $godown_transfer_new_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($godown_transfer_new_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($godown_transfer_new_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($godown_transfer_new_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($godown_transfer_new_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $godown_transfer_new_list->showPageHeader(); ?>
<?php
$godown_transfer_new_list->showMessage();
?>
<?php if ($godown_transfer_new_list->TotalRecs > 0 || $godown_transfer_new->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($godown_transfer_new_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> godown_transfer_new">
<?php if (!$godown_transfer_new->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$godown_transfer_new->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($godown_transfer_new_list->Pager)) $godown_transfer_new_list->Pager = new PrevNextPager($godown_transfer_new_list->StartRec, $godown_transfer_new_list->DisplayRecs, $godown_transfer_new_list->TotalRecs, $godown_transfer_new_list->AutoHidePager) ?>
<?php if ($godown_transfer_new_list->Pager->RecordCount > 0 && $godown_transfer_new_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($godown_transfer_new_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $godown_transfer_new_list->pageUrl() ?>start=<?php echo $godown_transfer_new_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($godown_transfer_new_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $godown_transfer_new_list->pageUrl() ?>start=<?php echo $godown_transfer_new_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $godown_transfer_new_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($godown_transfer_new_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $godown_transfer_new_list->pageUrl() ?>start=<?php echo $godown_transfer_new_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($godown_transfer_new_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $godown_transfer_new_list->pageUrl() ?>start=<?php echo $godown_transfer_new_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $godown_transfer_new_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($godown_transfer_new_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $godown_transfer_new_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $godown_transfer_new_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $godown_transfer_new_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($godown_transfer_new_list->TotalRecs > 0 && (!$godown_transfer_new_list->AutoHidePageSizeSelector || $godown_transfer_new_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="godown_transfer_new">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($godown_transfer_new_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($godown_transfer_new_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($godown_transfer_new_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($godown_transfer_new_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($godown_transfer_new_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($godown_transfer_new->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $godown_transfer_new_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fgodown_transfer_newlist" id="fgodown_transfer_newlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($godown_transfer_new_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $godown_transfer_new_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="godown_transfer_new">
<div id="gmp_godown_transfer_new" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($godown_transfer_new_list->TotalRecs > 0 || $godown_transfer_new->isGridEdit()) { ?>
<table id="tbl_godown_transfer_newlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$godown_transfer_new_list->RowType = ROWTYPE_HEADER;

// Render list options
$godown_transfer_new_list->renderListOptions();

// Render list options (header, left)
$godown_transfer_new_list->ListOptions->render("header", "left");
?>
<?php if ($godown_transfer_new->gp_no->Visible) { // gp_no ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->gp_no) == "") { ?>
		<th data-name="gp_no" class="<?php echo $godown_transfer_new->gp_no->headerCellClass() ?>"><div id="elh_godown_transfer_new_gp_no" class="godown_transfer_new_gp_no"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->gp_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gp_no" class="<?php echo $godown_transfer_new->gp_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->gp_no) ?>',2);"><div id="elh_godown_transfer_new_gp_no" class="godown_transfer_new_gp_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->gp_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->gp_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->gp_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->from->Visible) { // from ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->from) == "") { ?>
		<th data-name="from" class="<?php echo $godown_transfer_new->from->headerCellClass() ?>"><div id="elh_godown_transfer_new_from" class="godown_transfer_new_from"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->from->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="from" class="<?php echo $godown_transfer_new->from->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->from) ?>',2);"><div id="elh_godown_transfer_new_from" class="godown_transfer_new_from">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->from->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->from->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->from->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->to->Visible) { // to ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->to) == "") { ?>
		<th data-name="to" class="<?php echo $godown_transfer_new->to->headerCellClass() ?>"><div id="elh_godown_transfer_new_to" class="godown_transfer_new_to"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="to" class="<?php echo $godown_transfer_new->to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->to) ?>',2);"><div id="elh_godown_transfer_new_to" class="godown_transfer_new_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->to->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->attention->Visible) { // attention ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->attention) == "") { ?>
		<th data-name="attention" class="<?php echo $godown_transfer_new->attention->headerCellClass() ?>"><div id="elh_godown_transfer_new_attention" class="godown_transfer_new_attention"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->attention->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="attention" class="<?php echo $godown_transfer_new->attention->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->attention) ?>',2);"><div id="elh_godown_transfer_new_attention" class="godown_transfer_new_attention">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->attention->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->attention->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->attention->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->transfer_nature->Visible) { // transfer_nature ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->transfer_nature) == "") { ?>
		<th data-name="transfer_nature" class="<?php echo $godown_transfer_new->transfer_nature->headerCellClass() ?>"><div id="elh_godown_transfer_new_transfer_nature" class="godown_transfer_new_transfer_nature"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->transfer_nature->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="transfer_nature" class="<?php echo $godown_transfer_new->transfer_nature->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->transfer_nature) ?>',2);"><div id="elh_godown_transfer_new_transfer_nature" class="godown_transfer_new_transfer_nature">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->transfer_nature->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->transfer_nature->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->transfer_nature->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->due_date->Visible) { // due_date ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->due_date) == "") { ?>
		<th data-name="due_date" class="<?php echo $godown_transfer_new->due_date->headerCellClass() ?>"><div id="elh_godown_transfer_new_due_date" class="godown_transfer_new_due_date"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->due_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="due_date" class="<?php echo $godown_transfer_new->due_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->due_date) ?>',2);"><div id="elh_godown_transfer_new_due_date" class="godown_transfer_new_due_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->due_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->due_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->due_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->group->Visible) { // group ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->group) == "") { ?>
		<th data-name="group" class="<?php echo $godown_transfer_new->group->headerCellClass() ?>"><div id="elh_godown_transfer_new_group" class="godown_transfer_new_group"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->group->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="group" class="<?php echo $godown_transfer_new->group->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->group) ?>',2);"><div id="elh_godown_transfer_new_group" class="godown_transfer_new_group">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->group->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->group->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->group->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->item->Visible) { // item ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->item) == "") { ?>
		<th data-name="item" class="<?php echo $godown_transfer_new->item->headerCellClass() ?>"><div id="elh_godown_transfer_new_item" class="godown_transfer_new_item"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $godown_transfer_new->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->item) ?>',2);"><div id="elh_godown_transfer_new_item" class="godown_transfer_new_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->item->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->quantity->Visible) { // quantity ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $godown_transfer_new->quantity->headerCellClass() ?>"><div id="elh_godown_transfer_new_quantity" class="godown_transfer_new_quantity"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $godown_transfer_new->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->quantity) ?>',2);"><div id="elh_godown_transfer_new_quantity" class="godown_transfer_new_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->despatch_details->Visible) { // despatch details ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->despatch_details) == "") { ?>
		<th data-name="despatch_details" class="<?php echo $godown_transfer_new->despatch_details->headerCellClass() ?>"><div id="elh_godown_transfer_new_despatch_details" class="godown_transfer_new_despatch_details"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->despatch_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_details" class="<?php echo $godown_transfer_new->despatch_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->despatch_details) ?>',2);"><div id="elh_godown_transfer_new_despatch_details" class="godown_transfer_new_despatch_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->despatch_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->despatch_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->despatch_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->sender_comments->Visible) { // sender_comments ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->sender_comments) == "") { ?>
		<th data-name="sender_comments" class="<?php echo $godown_transfer_new->sender_comments->headerCellClass() ?>"><div id="elh_godown_transfer_new_sender_comments" class="godown_transfer_new_sender_comments"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->sender_comments->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sender_comments" class="<?php echo $godown_transfer_new->sender_comments->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->sender_comments) ?>',2);"><div id="elh_godown_transfer_new_sender_comments" class="godown_transfer_new_sender_comments">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->sender_comments->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->sender_comments->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->sender_comments->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->t_mode->Visible) { // t_mode ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->t_mode) == "") { ?>
		<th data-name="t_mode" class="<?php echo $godown_transfer_new->t_mode->headerCellClass() ?>"><div id="elh_godown_transfer_new_t_mode" class="godown_transfer_new_t_mode"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->t_mode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_mode" class="<?php echo $godown_transfer_new->t_mode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->t_mode) ?>',2);"><div id="elh_godown_transfer_new_t_mode" class="godown_transfer_new_t_mode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->t_mode->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->t_mode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->t_mode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->t_distance->Visible) { // t_distance ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->t_distance) == "") { ?>
		<th data-name="t_distance" class="<?php echo $godown_transfer_new->t_distance->headerCellClass() ?>"><div id="elh_godown_transfer_new_t_distance" class="godown_transfer_new_t_distance"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->t_distance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_distance" class="<?php echo $godown_transfer_new->t_distance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->t_distance) ?>',2);"><div id="elh_godown_transfer_new_t_distance" class="godown_transfer_new_t_distance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->t_distance->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->t_distance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->t_distance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->t_v_no->Visible) { // t_v_no ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->t_v_no) == "") { ?>
		<th data-name="t_v_no" class="<?php echo $godown_transfer_new->t_v_no->headerCellClass() ?>"><div id="elh_godown_transfer_new_t_v_no" class="godown_transfer_new_t_v_no"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->t_v_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="t_v_no" class="<?php echo $godown_transfer_new->t_v_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->t_v_no) ?>',2);"><div id="elh_godown_transfer_new_t_v_no" class="godown_transfer_new_t_v_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->t_v_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->t_v_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->t_v_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->purpose->Visible) { // purpose ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->purpose) == "") { ?>
		<th data-name="purpose" class="<?php echo $godown_transfer_new->purpose->headerCellClass() ?>"><div id="elh_godown_transfer_new_purpose" class="godown_transfer_new_purpose"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->purpose->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="purpose" class="<?php echo $godown_transfer_new->purpose->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->purpose) ?>',2);"><div id="elh_godown_transfer_new_purpose" class="godown_transfer_new_purpose">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->purpose->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->purpose->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->purpose->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->user_id->Visible) { // user_id ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->user_id) == "") { ?>
		<th data-name="user_id" class="<?php echo $godown_transfer_new->user_id->headerCellClass() ?>"><div id="elh_godown_transfer_new_user_id" class="godown_transfer_new_user_id"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->user_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="user_id" class="<?php echo $godown_transfer_new->user_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->user_id) ?>',2);"><div id="elh_godown_transfer_new_user_id" class="godown_transfer_new_user_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->user_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->user_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->user_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->datetime->Visible) { // datetime ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $godown_transfer_new->datetime->headerCellClass() ?>"><div id="elh_godown_transfer_new_datetime" class="godown_transfer_new_datetime"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $godown_transfer_new->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->datetime) ?>',2);"><div id="elh_godown_transfer_new_datetime" class="godown_transfer_new_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->e_user_id->Visible) { // e_user_id ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->e_user_id) == "") { ?>
		<th data-name="e_user_id" class="<?php echo $godown_transfer_new->e_user_id->headerCellClass() ?>"><div id="elh_godown_transfer_new_e_user_id" class="godown_transfer_new_e_user_id"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->e_user_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="e_user_id" class="<?php echo $godown_transfer_new->e_user_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->e_user_id) ?>',2);"><div id="elh_godown_transfer_new_e_user_id" class="godown_transfer_new_e_user_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->e_user_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->e_user_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->e_user_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->e_datetime->Visible) { // e_datetime ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->e_datetime) == "") { ?>
		<th data-name="e_datetime" class="<?php echo $godown_transfer_new->e_datetime->headerCellClass() ?>"><div id="elh_godown_transfer_new_e_datetime" class="godown_transfer_new_e_datetime"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->e_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="e_datetime" class="<?php echo $godown_transfer_new->e_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->e_datetime) ?>',2);"><div id="elh_godown_transfer_new_e_datetime" class="godown_transfer_new_e_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->e_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->e_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->e_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->receiving_condition->Visible) { // receiving_condition ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->receiving_condition) == "") { ?>
		<th data-name="receiving_condition" class="<?php echo $godown_transfer_new->receiving_condition->headerCellClass() ?>"><div id="elh_godown_transfer_new_receiving_condition" class="godown_transfer_new_receiving_condition"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->receiving_condition->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="receiving_condition" class="<?php echo $godown_transfer_new->receiving_condition->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->receiving_condition) ?>',2);"><div id="elh_godown_transfer_new_receiving_condition" class="godown_transfer_new_receiving_condition">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->receiving_condition->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->receiving_condition->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->receiving_condition->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->receiver_comments->Visible) { // receiver_comments ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->receiver_comments) == "") { ?>
		<th data-name="receiver_comments" class="<?php echo $godown_transfer_new->receiver_comments->headerCellClass() ?>"><div id="elh_godown_transfer_new_receiver_comments" class="godown_transfer_new_receiver_comments"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->receiver_comments->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="receiver_comments" class="<?php echo $godown_transfer_new->receiver_comments->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->receiver_comments) ?>',2);"><div id="elh_godown_transfer_new_receiver_comments" class="godown_transfer_new_receiver_comments">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->receiver_comments->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->receiver_comments->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->receiver_comments->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->r_user_id->Visible) { // r_user_id ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->r_user_id) == "") { ?>
		<th data-name="r_user_id" class="<?php echo $godown_transfer_new->r_user_id->headerCellClass() ?>"><div id="elh_godown_transfer_new_r_user_id" class="godown_transfer_new_r_user_id"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->r_user_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_user_id" class="<?php echo $godown_transfer_new->r_user_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->r_user_id) ?>',2);"><div id="elh_godown_transfer_new_r_user_id" class="godown_transfer_new_r_user_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->r_user_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->r_user_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->r_user_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->r_datetime->Visible) { // r_datetime ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->r_datetime) == "") { ?>
		<th data-name="r_datetime" class="<?php echo $godown_transfer_new->r_datetime->headerCellClass() ?>"><div id="elh_godown_transfer_new_r_datetime" class="godown_transfer_new_r_datetime"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->r_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_datetime" class="<?php echo $godown_transfer_new->r_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->r_datetime) ?>',2);"><div id="elh_godown_transfer_new_r_datetime" class="godown_transfer_new_r_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->r_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->r_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->r_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->updated->Visible) { // updated ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->updated) == "") { ?>
		<th data-name="updated" class="<?php echo $godown_transfer_new->updated->headerCellClass() ?>"><div id="elh_godown_transfer_new_updated" class="godown_transfer_new_updated"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->updated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="updated" class="<?php echo $godown_transfer_new->updated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->updated) ?>',2);"><div id="elh_godown_transfer_new_updated" class="godown_transfer_new_updated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->updated->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->updated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->updated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->r_e_user_id->Visible) { // r_e_user_id ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->r_e_user_id) == "") { ?>
		<th data-name="r_e_user_id" class="<?php echo $godown_transfer_new->r_e_user_id->headerCellClass() ?>"><div id="elh_godown_transfer_new_r_e_user_id" class="godown_transfer_new_r_e_user_id"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->r_e_user_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_e_user_id" class="<?php echo $godown_transfer_new->r_e_user_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->r_e_user_id) ?>',2);"><div id="elh_godown_transfer_new_r_e_user_id" class="godown_transfer_new_r_e_user_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->r_e_user_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->r_e_user_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->r_e_user_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->r_e_datetime->Visible) { // r_e_datetime ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->r_e_datetime) == "") { ?>
		<th data-name="r_e_datetime" class="<?php echo $godown_transfer_new->r_e_datetime->headerCellClass() ?>"><div id="elh_godown_transfer_new_r_e_datetime" class="godown_transfer_new_r_e_datetime"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->r_e_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="r_e_datetime" class="<?php echo $godown_transfer_new->r_e_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->r_e_datetime) ?>',2);"><div id="elh_godown_transfer_new_r_e_datetime" class="godown_transfer_new_r_e_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->r_e_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->r_e_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->r_e_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->jc_no->Visible) { // jc_no ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $godown_transfer_new->jc_no->headerCellClass() ?>"><div id="elh_godown_transfer_new_jc_no" class="godown_transfer_new_jc_no"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $godown_transfer_new->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->jc_no) ?>',2);"><div id="elh_godown_transfer_new_jc_no" class="godown_transfer_new_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->jc_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->product->Visible) { // product ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->product) == "") { ?>
		<th data-name="product" class="<?php echo $godown_transfer_new->product->headerCellClass() ?>"><div id="elh_godown_transfer_new_product" class="godown_transfer_new_product"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $godown_transfer_new->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->product) ?>',2);"><div id="elh_godown_transfer_new_product" class="godown_transfer_new_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_new->count_received->Visible) { // count_received ?>
	<?php if ($godown_transfer_new->sortUrl($godown_transfer_new->count_received) == "") { ?>
		<th data-name="count_received" class="<?php echo $godown_transfer_new->count_received->headerCellClass() ?>"><div id="elh_godown_transfer_new_count_received" class="godown_transfer_new_count_received"><div class="ew-table-header-caption"><?php echo $godown_transfer_new->count_received->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="count_received" class="<?php echo $godown_transfer_new->count_received->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_new->SortUrl($godown_transfer_new->count_received) ?>',2);"><div id="elh_godown_transfer_new_count_received" class="godown_transfer_new_count_received">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_new->count_received->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_new->count_received->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_new->count_received->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$godown_transfer_new_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($godown_transfer_new->ExportAll && $godown_transfer_new->isExport()) {
	$godown_transfer_new_list->StopRec = $godown_transfer_new_list->TotalRecs;
} else {

	// Set the last record to display
	if ($godown_transfer_new_list->TotalRecs > $godown_transfer_new_list->StartRec + $godown_transfer_new_list->DisplayRecs - 1)
		$godown_transfer_new_list->StopRec = $godown_transfer_new_list->StartRec + $godown_transfer_new_list->DisplayRecs - 1;
	else
		$godown_transfer_new_list->StopRec = $godown_transfer_new_list->TotalRecs;
}
$godown_transfer_new_list->RecCnt = $godown_transfer_new_list->StartRec - 1;
if ($godown_transfer_new_list->Recordset && !$godown_transfer_new_list->Recordset->EOF) {
	$godown_transfer_new_list->Recordset->moveFirst();
	$selectLimit = $godown_transfer_new_list->UseSelectLimit;
	if (!$selectLimit && $godown_transfer_new_list->StartRec > 1)
		$godown_transfer_new_list->Recordset->move($godown_transfer_new_list->StartRec - 1);
} elseif (!$godown_transfer_new->AllowAddDeleteRow && $godown_transfer_new_list->StopRec == 0) {
	$godown_transfer_new_list->StopRec = $godown_transfer_new->GridAddRowCount;
}

// Initialize aggregate
$godown_transfer_new->RowType = ROWTYPE_AGGREGATEINIT;
$godown_transfer_new->resetAttributes();
$godown_transfer_new_list->renderRow();
while ($godown_transfer_new_list->RecCnt < $godown_transfer_new_list->StopRec) {
	$godown_transfer_new_list->RecCnt++;
	if ($godown_transfer_new_list->RecCnt >= $godown_transfer_new_list->StartRec) {
		$godown_transfer_new_list->RowCnt++;

		// Set up key count
		$godown_transfer_new_list->KeyCount = $godown_transfer_new_list->RowIndex;

		// Init row class and style
		$godown_transfer_new->resetAttributes();
		$godown_transfer_new->CssClass = "";
		if ($godown_transfer_new->isGridAdd()) {
		} else {
			$godown_transfer_new_list->loadRowValues($godown_transfer_new_list->Recordset); // Load row values
		}
		$godown_transfer_new->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$godown_transfer_new->RowAttrs = array_merge($godown_transfer_new->RowAttrs, array('data-rowindex'=>$godown_transfer_new_list->RowCnt, 'id'=>'r' . $godown_transfer_new_list->RowCnt . '_godown_transfer_new', 'data-rowtype'=>$godown_transfer_new->RowType));

		// Render row
		$godown_transfer_new_list->renderRow();

		// Render list options
		$godown_transfer_new_list->renderListOptions();
?>
	<tr<?php echo $godown_transfer_new->rowAttributes() ?>>
<?php

// Render list options (body, left)
$godown_transfer_new_list->ListOptions->render("body", "left", $godown_transfer_new_list->RowCnt);
?>
	<?php if ($godown_transfer_new->gp_no->Visible) { // gp_no ?>
		<td data-name="gp_no"<?php echo $godown_transfer_new->gp_no->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_gp_no" class="godown_transfer_new_gp_no">
<span<?php echo $godown_transfer_new->gp_no->viewAttributes() ?>>
<?php echo $godown_transfer_new->gp_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->from->Visible) { // from ?>
		<td data-name="from"<?php echo $godown_transfer_new->from->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_from" class="godown_transfer_new_from">
<span<?php echo $godown_transfer_new->from->viewAttributes() ?>>
<?php echo $godown_transfer_new->from->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->to->Visible) { // to ?>
		<td data-name="to"<?php echo $godown_transfer_new->to->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_to" class="godown_transfer_new_to">
<span<?php echo $godown_transfer_new->to->viewAttributes() ?>>
<?php echo $godown_transfer_new->to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->attention->Visible) { // attention ?>
		<td data-name="attention"<?php echo $godown_transfer_new->attention->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_attention" class="godown_transfer_new_attention">
<span<?php echo $godown_transfer_new->attention->viewAttributes() ?>>
<?php echo $godown_transfer_new->attention->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->transfer_nature->Visible) { // transfer_nature ?>
		<td data-name="transfer_nature"<?php echo $godown_transfer_new->transfer_nature->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_transfer_nature" class="godown_transfer_new_transfer_nature">
<span<?php echo $godown_transfer_new->transfer_nature->viewAttributes() ?>>
<?php echo $godown_transfer_new->transfer_nature->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->due_date->Visible) { // due_date ?>
		<td data-name="due_date"<?php echo $godown_transfer_new->due_date->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_due_date" class="godown_transfer_new_due_date">
<span<?php echo $godown_transfer_new->due_date->viewAttributes() ?>>
<?php echo $godown_transfer_new->due_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->group->Visible) { // group ?>
		<td data-name="group"<?php echo $godown_transfer_new->group->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_group" class="godown_transfer_new_group">
<span<?php echo $godown_transfer_new->group->viewAttributes() ?>>
<?php echo $godown_transfer_new->group->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->item->Visible) { // item ?>
		<td data-name="item"<?php echo $godown_transfer_new->item->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_item" class="godown_transfer_new_item">
<span<?php echo $godown_transfer_new->item->viewAttributes() ?>>
<?php echo $godown_transfer_new->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $godown_transfer_new->quantity->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_quantity" class="godown_transfer_new_quantity">
<span<?php echo $godown_transfer_new->quantity->viewAttributes() ?>>
<?php echo $godown_transfer_new->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->despatch_details->Visible) { // despatch details ?>
		<td data-name="despatch_details"<?php echo $godown_transfer_new->despatch_details->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_despatch_details" class="godown_transfer_new_despatch_details">
<span<?php echo $godown_transfer_new->despatch_details->viewAttributes() ?>>
<?php echo $godown_transfer_new->despatch_details->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->sender_comments->Visible) { // sender_comments ?>
		<td data-name="sender_comments"<?php echo $godown_transfer_new->sender_comments->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_sender_comments" class="godown_transfer_new_sender_comments">
<span<?php echo $godown_transfer_new->sender_comments->viewAttributes() ?>>
<?php echo $godown_transfer_new->sender_comments->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->t_mode->Visible) { // t_mode ?>
		<td data-name="t_mode"<?php echo $godown_transfer_new->t_mode->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_t_mode" class="godown_transfer_new_t_mode">
<span<?php echo $godown_transfer_new->t_mode->viewAttributes() ?>>
<?php echo $godown_transfer_new->t_mode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->t_distance->Visible) { // t_distance ?>
		<td data-name="t_distance"<?php echo $godown_transfer_new->t_distance->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_t_distance" class="godown_transfer_new_t_distance">
<span<?php echo $godown_transfer_new->t_distance->viewAttributes() ?>>
<?php echo $godown_transfer_new->t_distance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->t_v_no->Visible) { // t_v_no ?>
		<td data-name="t_v_no"<?php echo $godown_transfer_new->t_v_no->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_t_v_no" class="godown_transfer_new_t_v_no">
<span<?php echo $godown_transfer_new->t_v_no->viewAttributes() ?>>
<?php echo $godown_transfer_new->t_v_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->purpose->Visible) { // purpose ?>
		<td data-name="purpose"<?php echo $godown_transfer_new->purpose->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_purpose" class="godown_transfer_new_purpose">
<span<?php echo $godown_transfer_new->purpose->viewAttributes() ?>>
<?php echo $godown_transfer_new->purpose->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->user_id->Visible) { // user_id ?>
		<td data-name="user_id"<?php echo $godown_transfer_new->user_id->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_user_id" class="godown_transfer_new_user_id">
<span<?php echo $godown_transfer_new->user_id->viewAttributes() ?>>
<?php echo $godown_transfer_new->user_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $godown_transfer_new->datetime->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_datetime" class="godown_transfer_new_datetime">
<span<?php echo $godown_transfer_new->datetime->viewAttributes() ?>>
<?php echo $godown_transfer_new->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->e_user_id->Visible) { // e_user_id ?>
		<td data-name="e_user_id"<?php echo $godown_transfer_new->e_user_id->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_e_user_id" class="godown_transfer_new_e_user_id">
<span<?php echo $godown_transfer_new->e_user_id->viewAttributes() ?>>
<?php echo $godown_transfer_new->e_user_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->e_datetime->Visible) { // e_datetime ?>
		<td data-name="e_datetime"<?php echo $godown_transfer_new->e_datetime->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_e_datetime" class="godown_transfer_new_e_datetime">
<span<?php echo $godown_transfer_new->e_datetime->viewAttributes() ?>>
<?php echo $godown_transfer_new->e_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->receiving_condition->Visible) { // receiving_condition ?>
		<td data-name="receiving_condition"<?php echo $godown_transfer_new->receiving_condition->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_receiving_condition" class="godown_transfer_new_receiving_condition">
<span<?php echo $godown_transfer_new->receiving_condition->viewAttributes() ?>>
<?php echo $godown_transfer_new->receiving_condition->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->receiver_comments->Visible) { // receiver_comments ?>
		<td data-name="receiver_comments"<?php echo $godown_transfer_new->receiver_comments->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_receiver_comments" class="godown_transfer_new_receiver_comments">
<span<?php echo $godown_transfer_new->receiver_comments->viewAttributes() ?>>
<?php echo $godown_transfer_new->receiver_comments->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->r_user_id->Visible) { // r_user_id ?>
		<td data-name="r_user_id"<?php echo $godown_transfer_new->r_user_id->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_r_user_id" class="godown_transfer_new_r_user_id">
<span<?php echo $godown_transfer_new->r_user_id->viewAttributes() ?>>
<?php echo $godown_transfer_new->r_user_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->r_datetime->Visible) { // r_datetime ?>
		<td data-name="r_datetime"<?php echo $godown_transfer_new->r_datetime->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_r_datetime" class="godown_transfer_new_r_datetime">
<span<?php echo $godown_transfer_new->r_datetime->viewAttributes() ?>>
<?php echo $godown_transfer_new->r_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->updated->Visible) { // updated ?>
		<td data-name="updated"<?php echo $godown_transfer_new->updated->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_updated" class="godown_transfer_new_updated">
<span<?php echo $godown_transfer_new->updated->viewAttributes() ?>>
<?php echo $godown_transfer_new->updated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->r_e_user_id->Visible) { // r_e_user_id ?>
		<td data-name="r_e_user_id"<?php echo $godown_transfer_new->r_e_user_id->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_r_e_user_id" class="godown_transfer_new_r_e_user_id">
<span<?php echo $godown_transfer_new->r_e_user_id->viewAttributes() ?>>
<?php echo $godown_transfer_new->r_e_user_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->r_e_datetime->Visible) { // r_e_datetime ?>
		<td data-name="r_e_datetime"<?php echo $godown_transfer_new->r_e_datetime->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_r_e_datetime" class="godown_transfer_new_r_e_datetime">
<span<?php echo $godown_transfer_new->r_e_datetime->viewAttributes() ?>>
<?php echo $godown_transfer_new->r_e_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $godown_transfer_new->jc_no->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_jc_no" class="godown_transfer_new_jc_no">
<span<?php echo $godown_transfer_new->jc_no->viewAttributes() ?>>
<?php echo $godown_transfer_new->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->product->Visible) { // product ?>
		<td data-name="product"<?php echo $godown_transfer_new->product->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_product" class="godown_transfer_new_product">
<span<?php echo $godown_transfer_new->product->viewAttributes() ?>>
<?php echo $godown_transfer_new->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_new->count_received->Visible) { // count_received ?>
		<td data-name="count_received"<?php echo $godown_transfer_new->count_received->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_new_list->RowCnt ?>_godown_transfer_new_count_received" class="godown_transfer_new_count_received">
<span<?php echo $godown_transfer_new->count_received->viewAttributes() ?>>
<?php echo $godown_transfer_new->count_received->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$godown_transfer_new_list->ListOptions->render("body", "right", $godown_transfer_new_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$godown_transfer_new->isGridAdd())
		$godown_transfer_new_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$godown_transfer_new->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($godown_transfer_new_list->Recordset)
	$godown_transfer_new_list->Recordset->Close();
?>
<?php if (!$godown_transfer_new->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$godown_transfer_new->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($godown_transfer_new_list->Pager)) $godown_transfer_new_list->Pager = new PrevNextPager($godown_transfer_new_list->StartRec, $godown_transfer_new_list->DisplayRecs, $godown_transfer_new_list->TotalRecs, $godown_transfer_new_list->AutoHidePager) ?>
<?php if ($godown_transfer_new_list->Pager->RecordCount > 0 && $godown_transfer_new_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($godown_transfer_new_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $godown_transfer_new_list->pageUrl() ?>start=<?php echo $godown_transfer_new_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($godown_transfer_new_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $godown_transfer_new_list->pageUrl() ?>start=<?php echo $godown_transfer_new_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $godown_transfer_new_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($godown_transfer_new_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $godown_transfer_new_list->pageUrl() ?>start=<?php echo $godown_transfer_new_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($godown_transfer_new_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $godown_transfer_new_list->pageUrl() ?>start=<?php echo $godown_transfer_new_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $godown_transfer_new_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($godown_transfer_new_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $godown_transfer_new_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $godown_transfer_new_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $godown_transfer_new_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($godown_transfer_new_list->TotalRecs > 0 && (!$godown_transfer_new_list->AutoHidePageSizeSelector || $godown_transfer_new_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="godown_transfer_new">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($godown_transfer_new_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($godown_transfer_new_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($godown_transfer_new_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($godown_transfer_new_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($godown_transfer_new_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($godown_transfer_new->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $godown_transfer_new_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($godown_transfer_new_list->TotalRecs == 0 && !$godown_transfer_new->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $godown_transfer_new_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$godown_transfer_new_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$godown_transfer_new->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$godown_transfer_new->isExport()) { ?>
<script>
ew.scrollableTable("gmp_godown_transfer_new", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$godown_transfer_new_list->terminate();
?>