<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$godown_transfer_table_list = new godown_transfer_table_list();

// Run the page
$godown_transfer_table_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$godown_transfer_table_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$godown_transfer_table->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fgodown_transfer_tablelist = currentForm = new ew.Form("fgodown_transfer_tablelist", "list");
fgodown_transfer_tablelist.formKeyCountName = '<?php echo $godown_transfer_table_list->FormKeyCountName ?>';

// Form_CustomValidate event
fgodown_transfer_tablelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgodown_transfer_tablelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgodown_transfer_tablelist.lists["x_grp"] = <?php echo $godown_transfer_table_list->grp->Lookup->toClientList() ?>;
fgodown_transfer_tablelist.lists["x_grp"].options = <?php echo JsonEncode($godown_transfer_table_list->grp->options(FALSE, TRUE)) ?>;
fgodown_transfer_tablelist.lists["x_rid"] = <?php echo $godown_transfer_table_list->rid->Lookup->toClientList() ?>;
fgodown_transfer_tablelist.lists["x_rid"].options = <?php echo JsonEncode($godown_transfer_table_list->rid->lookupOptions()) ?>;
fgodown_transfer_tablelist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fgodown_transfer_tablelist.lists["x_quantity_avg_act"] = <?php echo $godown_transfer_table_list->quantity_avg_act->Lookup->toClientList() ?>;
fgodown_transfer_tablelist.lists["x_quantity_avg_act"].options = <?php echo JsonEncode($godown_transfer_table_list->quantity_avg_act->options(FALSE, TRUE)) ?>;
fgodown_transfer_tablelist.lists["x_packing_type"] = <?php echo $godown_transfer_table_list->packing_type->Lookup->toClientList() ?>;
fgodown_transfer_tablelist.lists["x_packing_type"].options = <?php echo JsonEncode($godown_transfer_table_list->packing_type->lookupOptions()) ?>;
fgodown_transfer_tablelist.lists["x_godown"] = <?php echo $godown_transfer_table_list->godown->Lookup->toClientList() ?>;
fgodown_transfer_tablelist.lists["x_godown"].options = <?php echo JsonEncode($godown_transfer_table_list->godown->lookupOptions()) ?>;
fgodown_transfer_tablelist.lists["x_employee_id[]"] = <?php echo $godown_transfer_table_list->employee_id->Lookup->toClientList() ?>;
fgodown_transfer_tablelist.lists["x_employee_id[]"].options = <?php echo JsonEncode($godown_transfer_table_list->employee_id->lookupOptions()) ?>;
fgodown_transfer_tablelist.lists["x_next_process"] = <?php echo $godown_transfer_table_list->next_process->Lookup->toClientList() ?>;
fgodown_transfer_tablelist.lists["x_next_process"].options = <?php echo JsonEncode($godown_transfer_table_list->next_process->lookupOptions()) ?>;
fgodown_transfer_tablelist.lists["x_next_godown"] = <?php echo $godown_transfer_table_list->next_godown->Lookup->toClientList() ?>;
fgodown_transfer_tablelist.lists["x_next_godown"].options = <?php echo JsonEncode($godown_transfer_table_list->next_godown->lookupOptions()) ?>;
fgodown_transfer_tablelist.lists["x_operator"] = <?php echo $godown_transfer_table_list->operator->Lookup->toClientList() ?>;
fgodown_transfer_tablelist.lists["x_operator"].options = <?php echo JsonEncode($godown_transfer_table_list->operator->lookupOptions()) ?>;
fgodown_transfer_tablelist.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var fgodown_transfer_tablelistsrch = currentSearchForm = new ew.Form("fgodown_transfer_tablelistsrch");

// Filters
fgodown_transfer_tablelistsrch.filterList = <?php echo $godown_transfer_table_list->getFilterList() ?>;

// Init search panel as collapsed
fgodown_transfer_tablelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$godown_transfer_table->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($godown_transfer_table_list->TotalRecs > 0 && $godown_transfer_table_list->ExportOptions->visible()) { ?>
<?php $godown_transfer_table_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($godown_transfer_table_list->ImportOptions->visible()) { ?>
<?php $godown_transfer_table_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($godown_transfer_table_list->SearchOptions->visible()) { ?>
<?php $godown_transfer_table_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($godown_transfer_table_list->FilterOptions->visible()) { ?>
<?php $godown_transfer_table_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$godown_transfer_table_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$godown_transfer_table->isExport() && !$godown_transfer_table->CurrentAction) { ?>
<form name="fgodown_transfer_tablelistsrch" id="fgodown_transfer_tablelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($godown_transfer_table_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fgodown_transfer_tablelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="godown_transfer_table">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($godown_transfer_table_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($godown_transfer_table_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $godown_transfer_table_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($godown_transfer_table_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($godown_transfer_table_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($godown_transfer_table_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($godown_transfer_table_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $godown_transfer_table_list->showPageHeader(); ?>
<?php
$godown_transfer_table_list->showMessage();
?>
<?php if ($godown_transfer_table_list->TotalRecs > 0 || $godown_transfer_table->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($godown_transfer_table_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> godown_transfer_table">
<?php if (!$godown_transfer_table->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$godown_transfer_table->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($godown_transfer_table_list->Pager)) $godown_transfer_table_list->Pager = new PrevNextPager($godown_transfer_table_list->StartRec, $godown_transfer_table_list->DisplayRecs, $godown_transfer_table_list->TotalRecs, $godown_transfer_table_list->AutoHidePager) ?>
<?php if ($godown_transfer_table_list->Pager->RecordCount > 0 && $godown_transfer_table_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($godown_transfer_table_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $godown_transfer_table_list->pageUrl() ?>start=<?php echo $godown_transfer_table_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($godown_transfer_table_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $godown_transfer_table_list->pageUrl() ?>start=<?php echo $godown_transfer_table_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $godown_transfer_table_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($godown_transfer_table_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $godown_transfer_table_list->pageUrl() ?>start=<?php echo $godown_transfer_table_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($godown_transfer_table_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $godown_transfer_table_list->pageUrl() ?>start=<?php echo $godown_transfer_table_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $godown_transfer_table_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($godown_transfer_table_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $godown_transfer_table_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $godown_transfer_table_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $godown_transfer_table_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($godown_transfer_table_list->TotalRecs > 0 && (!$godown_transfer_table_list->AutoHidePageSizeSelector || $godown_transfer_table_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="godown_transfer_table">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($godown_transfer_table_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($godown_transfer_table_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($godown_transfer_table_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($godown_transfer_table_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($godown_transfer_table_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($godown_transfer_table->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $godown_transfer_table_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fgodown_transfer_tablelist" id="fgodown_transfer_tablelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($godown_transfer_table_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $godown_transfer_table_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="godown_transfer_table">
<div id="gmp_godown_transfer_table" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($godown_transfer_table_list->TotalRecs > 0 || $godown_transfer_table->isGridEdit()) { ?>
<table id="tbl_godown_transfer_tablelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$godown_transfer_table_list->RowType = ROWTYPE_HEADER;

// Render list options
$godown_transfer_table_list->renderListOptions();

// Render list options (header, left)
$godown_transfer_table_list->ListOptions->render("header", "left");
?>
<?php if ($godown_transfer_table->id->Visible) { // id ?>
	<?php if ($godown_transfer_table->sortUrl($godown_transfer_table->id) == "") { ?>
		<th data-name="id" class="<?php echo $godown_transfer_table->id->headerCellClass() ?>"><div id="elh_godown_transfer_table_id" class="godown_transfer_table_id"><div class="ew-table-header-caption"><?php echo $godown_transfer_table->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $godown_transfer_table->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_table->SortUrl($godown_transfer_table->id) ?>',2);"><div id="elh_godown_transfer_table_id" class="godown_transfer_table_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_table->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_table->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_table->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_table->grp->Visible) { // grp ?>
	<?php if ($godown_transfer_table->sortUrl($godown_transfer_table->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $godown_transfer_table->grp->headerCellClass() ?>"><div id="elh_godown_transfer_table_grp" class="godown_transfer_table_grp"><div class="ew-table-header-caption"><?php echo $godown_transfer_table->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $godown_transfer_table->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_table->SortUrl($godown_transfer_table->grp) ?>',2);"><div id="elh_godown_transfer_table_grp" class="godown_transfer_table_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_table->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_table->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_table->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_table->rid->Visible) { // rid ?>
	<?php if ($godown_transfer_table->sortUrl($godown_transfer_table->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $godown_transfer_table->rid->headerCellClass() ?>"><div id="elh_godown_transfer_table_rid" class="godown_transfer_table_rid"><div class="ew-table-header-caption"><?php echo $godown_transfer_table->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $godown_transfer_table->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_table->SortUrl($godown_transfer_table->rid) ?>',2);"><div id="elh_godown_transfer_table_rid" class="godown_transfer_table_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_table->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_table->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_table->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_table->packets->Visible) { // packets ?>
	<?php if ($godown_transfer_table->sortUrl($godown_transfer_table->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $godown_transfer_table->packets->headerCellClass() ?>"><div id="elh_godown_transfer_table_packets" class="godown_transfer_table_packets"><div class="ew-table-header-caption"><?php echo $godown_transfer_table->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $godown_transfer_table->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_table->SortUrl($godown_transfer_table->packets) ?>',2);"><div id="elh_godown_transfer_table_packets" class="godown_transfer_table_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_table->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_table->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_table->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_table->quantity_avg_act->Visible) { // quantity_avg_act ?>
	<?php if ($godown_transfer_table->sortUrl($godown_transfer_table->quantity_avg_act) == "") { ?>
		<th data-name="quantity_avg_act" class="<?php echo $godown_transfer_table->quantity_avg_act->headerCellClass() ?>"><div id="elh_godown_transfer_table_quantity_avg_act" class="godown_transfer_table_quantity_avg_act"><div class="ew-table-header-caption"><?php echo $godown_transfer_table->quantity_avg_act->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity_avg_act" class="<?php echo $godown_transfer_table->quantity_avg_act->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_table->SortUrl($godown_transfer_table->quantity_avg_act) ?>',2);"><div id="elh_godown_transfer_table_quantity_avg_act" class="godown_transfer_table_quantity_avg_act">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_table->quantity_avg_act->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_table->quantity_avg_act->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_table->quantity_avg_act->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_table->quantity->Visible) { // quantity ?>
	<?php if ($godown_transfer_table->sortUrl($godown_transfer_table->quantity) == "") { ?>
		<th data-name="quantity" class="<?php echo $godown_transfer_table->quantity->headerCellClass() ?>"><div id="elh_godown_transfer_table_quantity" class="godown_transfer_table_quantity"><div class="ew-table-header-caption"><?php echo $godown_transfer_table->quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="quantity" class="<?php echo $godown_transfer_table->quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_table->SortUrl($godown_transfer_table->quantity) ?>',2);"><div id="elh_godown_transfer_table_quantity" class="godown_transfer_table_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_table->quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_table->quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_table->quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_table->packing_type->Visible) { // packing_type ?>
	<?php if ($godown_transfer_table->sortUrl($godown_transfer_table->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $godown_transfer_table->packing_type->headerCellClass() ?>"><div id="elh_godown_transfer_table_packing_type" class="godown_transfer_table_packing_type"><div class="ew-table-header-caption"><?php echo $godown_transfer_table->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $godown_transfer_table->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_table->SortUrl($godown_transfer_table->packing_type) ?>',2);"><div id="elh_godown_transfer_table_packing_type" class="godown_transfer_table_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_table->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_table->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_table->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_table->godown->Visible) { // godown ?>
	<?php if ($godown_transfer_table->sortUrl($godown_transfer_table->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $godown_transfer_table->godown->headerCellClass() ?>"><div id="elh_godown_transfer_table_godown" class="godown_transfer_table_godown"><div class="ew-table-header-caption"><?php echo $godown_transfer_table->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $godown_transfer_table->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_table->SortUrl($godown_transfer_table->godown) ?>',2);"><div id="elh_godown_transfer_table_godown" class="godown_transfer_table_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_table->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_table->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_table->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_table->dated->Visible) { // dated ?>
	<?php if ($godown_transfer_table->sortUrl($godown_transfer_table->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $godown_transfer_table->dated->headerCellClass() ?>"><div id="elh_godown_transfer_table_dated" class="godown_transfer_table_dated"><div class="ew-table-header-caption"><?php echo $godown_transfer_table->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $godown_transfer_table->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_table->SortUrl($godown_transfer_table->dated) ?>',2);"><div id="elh_godown_transfer_table_dated" class="godown_transfer_table_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_table->dated->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_table->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_table->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_table->employee_id->Visible) { // employee_id ?>
	<?php if ($godown_transfer_table->sortUrl($godown_transfer_table->employee_id) == "") { ?>
		<th data-name="employee_id" class="<?php echo $godown_transfer_table->employee_id->headerCellClass() ?>"><div id="elh_godown_transfer_table_employee_id" class="godown_transfer_table_employee_id"><div class="ew-table-header-caption"><?php echo $godown_transfer_table->employee_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="employee_id" class="<?php echo $godown_transfer_table->employee_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_table->SortUrl($godown_transfer_table->employee_id) ?>',2);"><div id="elh_godown_transfer_table_employee_id" class="godown_transfer_table_employee_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_table->employee_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_table->employee_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_table->employee_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_table->next_process->Visible) { // next_process ?>
	<?php if ($godown_transfer_table->sortUrl($godown_transfer_table->next_process) == "") { ?>
		<th data-name="next_process" class="<?php echo $godown_transfer_table->next_process->headerCellClass() ?>"><div id="elh_godown_transfer_table_next_process" class="godown_transfer_table_next_process"><div class="ew-table-header-caption"><?php echo $godown_transfer_table->next_process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="next_process" class="<?php echo $godown_transfer_table->next_process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_table->SortUrl($godown_transfer_table->next_process) ?>',2);"><div id="elh_godown_transfer_table_next_process" class="godown_transfer_table_next_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_table->next_process->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_table->next_process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_table->next_process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_table->next_godown->Visible) { // next_godown ?>
	<?php if ($godown_transfer_table->sortUrl($godown_transfer_table->next_godown) == "") { ?>
		<th data-name="next_godown" class="<?php echo $godown_transfer_table->next_godown->headerCellClass() ?>"><div id="elh_godown_transfer_table_next_godown" class="godown_transfer_table_next_godown"><div class="ew-table-header-caption"><?php echo $godown_transfer_table->next_godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="next_godown" class="<?php echo $godown_transfer_table->next_godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_table->SortUrl($godown_transfer_table->next_godown) ?>',2);"><div id="elh_godown_transfer_table_next_godown" class="godown_transfer_table_next_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_table->next_godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_table->next_godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_table->next_godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_table->operator->Visible) { // operator ?>
	<?php if ($godown_transfer_table->sortUrl($godown_transfer_table->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $godown_transfer_table->operator->headerCellClass() ?>"><div id="elh_godown_transfer_table_operator" class="godown_transfer_table_operator"><div class="ew-table-header-caption"><?php echo $godown_transfer_table->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $godown_transfer_table->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_table->SortUrl($godown_transfer_table->operator) ?>',2);"><div id="elh_godown_transfer_table_operator" class="godown_transfer_table_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_table->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_table->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_table->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_table->datetime->Visible) { // datetime ?>
	<?php if ($godown_transfer_table->sortUrl($godown_transfer_table->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $godown_transfer_table->datetime->headerCellClass() ?>"><div id="elh_godown_transfer_table_datetime" class="godown_transfer_table_datetime"><div class="ew-table-header-caption"><?php echo $godown_transfer_table->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $godown_transfer_table->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_table->SortUrl($godown_transfer_table->datetime) ?>',2);"><div id="elh_godown_transfer_table_datetime" class="godown_transfer_table_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_table->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_table->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_table->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown_transfer_table->remarks->Visible) { // remarks ?>
	<?php if ($godown_transfer_table->sortUrl($godown_transfer_table->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $godown_transfer_table->remarks->headerCellClass() ?>"><div id="elh_godown_transfer_table_remarks" class="godown_transfer_table_remarks"><div class="ew-table-header-caption"><?php echo $godown_transfer_table->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $godown_transfer_table->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown_transfer_table->SortUrl($godown_transfer_table->remarks) ?>',2);"><div id="elh_godown_transfer_table_remarks" class="godown_transfer_table_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown_transfer_table->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($godown_transfer_table->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown_transfer_table->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$godown_transfer_table_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($godown_transfer_table->ExportAll && $godown_transfer_table->isExport()) {
	$godown_transfer_table_list->StopRec = $godown_transfer_table_list->TotalRecs;
} else {

	// Set the last record to display
	if ($godown_transfer_table_list->TotalRecs > $godown_transfer_table_list->StartRec + $godown_transfer_table_list->DisplayRecs - 1)
		$godown_transfer_table_list->StopRec = $godown_transfer_table_list->StartRec + $godown_transfer_table_list->DisplayRecs - 1;
	else
		$godown_transfer_table_list->StopRec = $godown_transfer_table_list->TotalRecs;
}
$godown_transfer_table_list->RecCnt = $godown_transfer_table_list->StartRec - 1;
if ($godown_transfer_table_list->Recordset && !$godown_transfer_table_list->Recordset->EOF) {
	$godown_transfer_table_list->Recordset->moveFirst();
	$selectLimit = $godown_transfer_table_list->UseSelectLimit;
	if (!$selectLimit && $godown_transfer_table_list->StartRec > 1)
		$godown_transfer_table_list->Recordset->move($godown_transfer_table_list->StartRec - 1);
} elseif (!$godown_transfer_table->AllowAddDeleteRow && $godown_transfer_table_list->StopRec == 0) {
	$godown_transfer_table_list->StopRec = $godown_transfer_table->GridAddRowCount;
}

// Initialize aggregate
$godown_transfer_table->RowType = ROWTYPE_AGGREGATEINIT;
$godown_transfer_table->resetAttributes();
$godown_transfer_table_list->renderRow();
while ($godown_transfer_table_list->RecCnt < $godown_transfer_table_list->StopRec) {
	$godown_transfer_table_list->RecCnt++;
	if ($godown_transfer_table_list->RecCnt >= $godown_transfer_table_list->StartRec) {
		$godown_transfer_table_list->RowCnt++;

		// Set up key count
		$godown_transfer_table_list->KeyCount = $godown_transfer_table_list->RowIndex;

		// Init row class and style
		$godown_transfer_table->resetAttributes();
		$godown_transfer_table->CssClass = "";
		if ($godown_transfer_table->isGridAdd()) {
		} else {
			$godown_transfer_table_list->loadRowValues($godown_transfer_table_list->Recordset); // Load row values
		}
		$godown_transfer_table->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$godown_transfer_table->RowAttrs = array_merge($godown_transfer_table->RowAttrs, array('data-rowindex'=>$godown_transfer_table_list->RowCnt, 'id'=>'r' . $godown_transfer_table_list->RowCnt . '_godown_transfer_table', 'data-rowtype'=>$godown_transfer_table->RowType));

		// Render row
		$godown_transfer_table_list->renderRow();

		// Render list options
		$godown_transfer_table_list->renderListOptions();
?>
	<tr<?php echo $godown_transfer_table->rowAttributes() ?>>
<?php

// Render list options (body, left)
$godown_transfer_table_list->ListOptions->render("body", "left", $godown_transfer_table_list->RowCnt);
?>
	<?php if ($godown_transfer_table->id->Visible) { // id ?>
		<td data-name="id"<?php echo $godown_transfer_table->id->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_table_list->RowCnt ?>_godown_transfer_table_id" class="godown_transfer_table_id">
<span<?php echo $godown_transfer_table->id->viewAttributes() ?>>
<?php echo $godown_transfer_table->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_table->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $godown_transfer_table->grp->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_table_list->RowCnt ?>_godown_transfer_table_grp" class="godown_transfer_table_grp">
<span<?php echo $godown_transfer_table->grp->viewAttributes() ?>>
<?php echo $godown_transfer_table->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_table->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $godown_transfer_table->rid->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_table_list->RowCnt ?>_godown_transfer_table_rid" class="godown_transfer_table_rid">
<span<?php echo $godown_transfer_table->rid->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_table->rid->getViewValue())) && $godown_transfer_table->rid->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_table->rid->linkAttributes() ?>><?php echo $godown_transfer_table->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_table->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_table->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $godown_transfer_table->packets->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_table_list->RowCnt ?>_godown_transfer_table_packets" class="godown_transfer_table_packets">
<span<?php echo $godown_transfer_table->packets->viewAttributes() ?>>
<?php echo $godown_transfer_table->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_table->quantity_avg_act->Visible) { // quantity_avg_act ?>
		<td data-name="quantity_avg_act"<?php echo $godown_transfer_table->quantity_avg_act->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_table_list->RowCnt ?>_godown_transfer_table_quantity_avg_act" class="godown_transfer_table_quantity_avg_act">
<span<?php echo $godown_transfer_table->quantity_avg_act->viewAttributes() ?>>
<?php echo $godown_transfer_table->quantity_avg_act->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_table->quantity->Visible) { // quantity ?>
		<td data-name="quantity"<?php echo $godown_transfer_table->quantity->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_table_list->RowCnt ?>_godown_transfer_table_quantity" class="godown_transfer_table_quantity">
<span<?php echo $godown_transfer_table->quantity->viewAttributes() ?>>
<?php echo $godown_transfer_table->quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_table->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $godown_transfer_table->packing_type->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_table_list->RowCnt ?>_godown_transfer_table_packing_type" class="godown_transfer_table_packing_type">
<span<?php echo $godown_transfer_table->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_table->packing_type->getViewValue())) && $godown_transfer_table->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_table->packing_type->linkAttributes() ?>><?php echo $godown_transfer_table->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_table->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_table->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $godown_transfer_table->godown->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_table_list->RowCnt ?>_godown_transfer_table_godown" class="godown_transfer_table_godown">
<span<?php echo $godown_transfer_table->godown->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_table->godown->getViewValue())) && $godown_transfer_table->godown->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_table->godown->linkAttributes() ?>><?php echo $godown_transfer_table->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_table->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_table->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $godown_transfer_table->dated->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_table_list->RowCnt ?>_godown_transfer_table_dated" class="godown_transfer_table_dated">
<span<?php echo $godown_transfer_table->dated->viewAttributes() ?>>
<?php echo $godown_transfer_table->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_table->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id"<?php echo $godown_transfer_table->employee_id->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_table_list->RowCnt ?>_godown_transfer_table_employee_id" class="godown_transfer_table_employee_id">
<span<?php echo $godown_transfer_table->employee_id->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_table->employee_id->getViewValue())) && $godown_transfer_table->employee_id->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_table->employee_id->linkAttributes() ?>><?php echo $godown_transfer_table->employee_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_table->employee_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_table->next_process->Visible) { // next_process ?>
		<td data-name="next_process"<?php echo $godown_transfer_table->next_process->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_table_list->RowCnt ?>_godown_transfer_table_next_process" class="godown_transfer_table_next_process">
<span<?php echo $godown_transfer_table->next_process->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_table->next_process->getViewValue())) && $godown_transfer_table->next_process->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_table->next_process->linkAttributes() ?>><?php echo $godown_transfer_table->next_process->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_table->next_process->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_table->next_godown->Visible) { // next_godown ?>
		<td data-name="next_godown"<?php echo $godown_transfer_table->next_godown->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_table_list->RowCnt ?>_godown_transfer_table_next_godown" class="godown_transfer_table_next_godown">
<span<?php echo $godown_transfer_table->next_godown->viewAttributes() ?>>
<?php if ((!EmptyString($godown_transfer_table->next_godown->getViewValue())) && $godown_transfer_table->next_godown->linkAttributes() <> "") { ?>
<a<?php echo $godown_transfer_table->next_godown->linkAttributes() ?>><?php echo $godown_transfer_table->next_godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $godown_transfer_table->next_godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_table->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $godown_transfer_table->operator->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_table_list->RowCnt ?>_godown_transfer_table_operator" class="godown_transfer_table_operator">
<span<?php echo $godown_transfer_table->operator->viewAttributes() ?>>
<?php echo $godown_transfer_table->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_table->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $godown_transfer_table->datetime->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_table_list->RowCnt ?>_godown_transfer_table_datetime" class="godown_transfer_table_datetime">
<span<?php echo $godown_transfer_table->datetime->viewAttributes() ?>>
<?php echo $godown_transfer_table->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown_transfer_table->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $godown_transfer_table->remarks->cellAttributes() ?>>
<span id="el<?php echo $godown_transfer_table_list->RowCnt ?>_godown_transfer_table_remarks" class="godown_transfer_table_remarks">
<span<?php echo $godown_transfer_table->remarks->viewAttributes() ?>>
<?php echo $godown_transfer_table->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$godown_transfer_table_list->ListOptions->render("body", "right", $godown_transfer_table_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$godown_transfer_table->isGridAdd())
		$godown_transfer_table_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$godown_transfer_table->RowType = ROWTYPE_AGGREGATE;
$godown_transfer_table->resetAttributes();
$godown_transfer_table_list->renderRow();
?>
<?php if ($godown_transfer_table_list->TotalRecs > 0 && !$godown_transfer_table->isGridAdd() && !$godown_transfer_table->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$godown_transfer_table_list->renderListOptions();

// Render list options (footer, left)
$godown_transfer_table_list->ListOptions->render("footer", "left");
?>
	<?php if ($godown_transfer_table->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $godown_transfer_table->id->footerCellClass() ?>"><span id="elf_godown_transfer_table_id" class="godown_transfer_table_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_table->grp->Visible) { // grp ?>
		<td data-name="grp" class="<?php echo $godown_transfer_table->grp->footerCellClass() ?>"><span id="elf_godown_transfer_table_grp" class="godown_transfer_table_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_table->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $godown_transfer_table->rid->footerCellClass() ?>"><span id="elf_godown_transfer_table_rid" class="godown_transfer_table_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_table->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $godown_transfer_table->packets->footerCellClass() ?>"><span id="elf_godown_transfer_table_packets" class="godown_transfer_table_packets">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_table->quantity_avg_act->Visible) { // quantity_avg_act ?>
		<td data-name="quantity_avg_act" class="<?php echo $godown_transfer_table->quantity_avg_act->footerCellClass() ?>"><span id="elf_godown_transfer_table_quantity_avg_act" class="godown_transfer_table_quantity_avg_act">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_table->quantity->Visible) { // quantity ?>
		<td data-name="quantity" class="<?php echo $godown_transfer_table->quantity->footerCellClass() ?>"><span id="elf_godown_transfer_table_quantity" class="godown_transfer_table_quantity">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $godown_transfer_table->quantity->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_table->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $godown_transfer_table->packing_type->footerCellClass() ?>"><span id="elf_godown_transfer_table_packing_type" class="godown_transfer_table_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_table->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $godown_transfer_table->godown->footerCellClass() ?>"><span id="elf_godown_transfer_table_godown" class="godown_transfer_table_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_table->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $godown_transfer_table->dated->footerCellClass() ?>"><span id="elf_godown_transfer_table_dated" class="godown_transfer_table_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_table->employee_id->Visible) { // employee_id ?>
		<td data-name="employee_id" class="<?php echo $godown_transfer_table->employee_id->footerCellClass() ?>"><span id="elf_godown_transfer_table_employee_id" class="godown_transfer_table_employee_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_table->next_process->Visible) { // next_process ?>
		<td data-name="next_process" class="<?php echo $godown_transfer_table->next_process->footerCellClass() ?>"><span id="elf_godown_transfer_table_next_process" class="godown_transfer_table_next_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_table->next_godown->Visible) { // next_godown ?>
		<td data-name="next_godown" class="<?php echo $godown_transfer_table->next_godown->footerCellClass() ?>"><span id="elf_godown_transfer_table_next_godown" class="godown_transfer_table_next_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_table->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $godown_transfer_table->operator->footerCellClass() ?>"><span id="elf_godown_transfer_table_operator" class="godown_transfer_table_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_table->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $godown_transfer_table->datetime->footerCellClass() ?>"><span id="elf_godown_transfer_table_datetime" class="godown_transfer_table_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($godown_transfer_table->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $godown_transfer_table->remarks->footerCellClass() ?>"><span id="elf_godown_transfer_table_remarks" class="godown_transfer_table_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$godown_transfer_table_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$godown_transfer_table->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($godown_transfer_table_list->Recordset)
	$godown_transfer_table_list->Recordset->Close();
?>
<?php if (!$godown_transfer_table->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$godown_transfer_table->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($godown_transfer_table_list->Pager)) $godown_transfer_table_list->Pager = new PrevNextPager($godown_transfer_table_list->StartRec, $godown_transfer_table_list->DisplayRecs, $godown_transfer_table_list->TotalRecs, $godown_transfer_table_list->AutoHidePager) ?>
<?php if ($godown_transfer_table_list->Pager->RecordCount > 0 && $godown_transfer_table_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($godown_transfer_table_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $godown_transfer_table_list->pageUrl() ?>start=<?php echo $godown_transfer_table_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($godown_transfer_table_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $godown_transfer_table_list->pageUrl() ?>start=<?php echo $godown_transfer_table_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $godown_transfer_table_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($godown_transfer_table_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $godown_transfer_table_list->pageUrl() ?>start=<?php echo $godown_transfer_table_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($godown_transfer_table_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $godown_transfer_table_list->pageUrl() ?>start=<?php echo $godown_transfer_table_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $godown_transfer_table_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($godown_transfer_table_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $godown_transfer_table_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $godown_transfer_table_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $godown_transfer_table_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($godown_transfer_table_list->TotalRecs > 0 && (!$godown_transfer_table_list->AutoHidePageSizeSelector || $godown_transfer_table_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="godown_transfer_table">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($godown_transfer_table_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($godown_transfer_table_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($godown_transfer_table_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($godown_transfer_table_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($godown_transfer_table_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($godown_transfer_table->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $godown_transfer_table_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($godown_transfer_table_list->TotalRecs == 0 && !$godown_transfer_table->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $godown_transfer_table_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$godown_transfer_table_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$godown_transfer_table->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$godown_transfer_table->isExport()) { ?>
<script>
ew.scrollableTable("gmp_godown_transfer_table", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$godown_transfer_table_list->terminate();
?>