<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$godown_addopt = new godown_addopt();

// Run the page
$godown_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$godown_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fgodownaddopt = currentForm = new ew.Form("fgodownaddopt", "addopt");

// Validate form
fgodownaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($godown_addopt->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown->name->caption(), $godown->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_addopt->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown->location->caption(), $godown->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_addopt->incharge->Required) { ?>
			elm = this.getElements("x" + infix + "_incharge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown->incharge->caption(), $godown->incharge->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_addopt->capacity->Required) { ?>
			elm = this.getElements("x" + infix + "_capacity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown->capacity->caption(), $godown->capacity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_capacity");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($godown->capacity->errorMessage()) ?>");
		<?php if ($godown_addopt->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown->code->caption(), $godown->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($godown->code->errorMessage()) ?>");
		<?php if ($godown_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown->status->caption(), $godown->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown->operator->caption(), $godown->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown->datetime->caption(), $godown->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($godown_addopt->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $godown->company_id->caption(), $godown->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($godown->company_id->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fgodownaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgodownaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgodownaddopt.lists["x_incharge"] = <?php echo $godown_addopt->incharge->Lookup->toClientList() ?>;
fgodownaddopt.lists["x_incharge"].options = <?php echo JsonEncode($godown_addopt->incharge->lookupOptions()) ?>;
fgodownaddopt.lists["x_status"] = <?php echo $godown_addopt->status->Lookup->toClientList() ?>;
fgodownaddopt.lists["x_status"].options = <?php echo JsonEncode($godown_addopt->status->options(FALSE, TRUE)) ?>;
fgodownaddopt.lists["x_operator"] = <?php echo $godown_addopt->operator->Lookup->toClientList() ?>;
fgodownaddopt.lists["x_operator"].options = <?php echo JsonEncode($godown_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $godown_addopt->showPageHeader(); ?>
<?php
$godown_addopt->showMessage();
?>
<form name="fgodownaddopt" id="fgodownaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($godown_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $godown_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $godown_addopt->TableVar ?>">
<?php if ($godown->name->Visible) { // name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_name"><?php echo $godown->name->caption() ?><?php echo ($godown->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="godown" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($godown->name->getPlaceHolder()) ?>" value="<?php echo $godown->name->EditValue ?>"<?php echo $godown->name->editAttributes() ?>>
<?php echo $godown->name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($godown->location->Visible) { // location ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_location"><?php echo $godown->location->caption() ?><?php echo ($godown->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="godown" data-field="x_location" name="x_location" id="x_location" cols="30" rows="4" placeholder="<?php echo HtmlEncode($godown->location->getPlaceHolder()) ?>"<?php echo $godown->location->editAttributes() ?>><?php echo $godown->location->EditValue ?></textarea>
<?php echo $godown->location->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($godown->incharge->Visible) { // incharge ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_incharge"><?php echo $godown->incharge->caption() ?><?php echo ($godown->incharge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="godown" data-field="x_incharge" data-value-separator="<?php echo $godown->incharge->displayValueSeparatorAttribute() ?>" id="x_incharge" name="x_incharge"<?php echo $godown->incharge->editAttributes() ?>>
		<?php echo $godown->incharge->selectOptionListHtml("x_incharge") ?>
	</select>
</div>
<?php echo $godown->incharge->Lookup->getParamTag("p_x_incharge") ?>
<?php echo $godown->incharge->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($godown->capacity->Visible) { // capacity ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_capacity"><?php echo $godown->capacity->caption() ?><?php echo ($godown->capacity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="godown" data-field="x_capacity" name="x_capacity" id="x_capacity" size="30" placeholder="<?php echo HtmlEncode($godown->capacity->getPlaceHolder()) ?>" value="<?php echo $godown->capacity->EditValue ?>"<?php echo $godown->capacity->editAttributes() ?>>
<?php echo $godown->capacity->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($godown->code->Visible) { // code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_code"><?php echo $godown->code->caption() ?><?php echo ($godown->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="godown" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($godown->code->getPlaceHolder()) ?>" value="<?php echo $godown->code->EditValue ?>"<?php echo $godown->code->editAttributes() ?>>
<?php echo $godown->code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($godown->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $godown->status->caption() ?><?php echo ($godown->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="godown" data-field="x_status" data-value-separator="<?php echo $godown->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $godown->status->editAttributes() ?>>
		<?php echo $godown->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $godown->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($godown->operator->Visible) { // operator ?>
	<input type="hidden" data-table="godown" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($godown->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($godown->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="godown" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($godown->datetime->CurrentValue) ?>">
	<?php if (!$godown->datetime->ReadOnly && !$godown->datetime->Disabled && !isset($godown->datetime->EditAttrs["readonly"]) && !isset($godown->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fgodownaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
<?php if ($godown->company_id->Visible) { // company_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_company_id"><?php echo $godown->company_id->caption() ?><?php echo ($godown->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="godown" data-field="x_company_id" name="x_company_id" id="x_company_id" size="30" placeholder="<?php echo HtmlEncode($godown->company_id->getPlaceHolder()) ?>" value="<?php echo $godown->company_id->EditValue ?>"<?php echo $godown->company_id->editAttributes() ?>>
<?php echo $godown->company_id->CustomMsg ?></div>
	</div>
<?php } ?>
</form>
<?php
$godown_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$godown_addopt->terminate();
?>