<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$godown_list = new godown_list();

// Run the page
$godown_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$godown_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$godown->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fgodownlist = currentForm = new ew.Form("fgodownlist", "list");
fgodownlist.formKeyCountName = '<?php echo $godown_list->FormKeyCountName ?>';

// Form_CustomValidate event
fgodownlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgodownlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgodownlist.lists["x_incharge"] = <?php echo $godown_list->incharge->Lookup->toClientList() ?>;
fgodownlist.lists["x_incharge"].options = <?php echo JsonEncode($godown_list->incharge->lookupOptions()) ?>;
fgodownlist.lists["x_status"] = <?php echo $godown_list->status->Lookup->toClientList() ?>;
fgodownlist.lists["x_status"].options = <?php echo JsonEncode($godown_list->status->options(FALSE, TRUE)) ?>;
fgodownlist.lists["x_operator"] = <?php echo $godown_list->operator->Lookup->toClientList() ?>;
fgodownlist.lists["x_operator"].options = <?php echo JsonEncode($godown_list->operator->lookupOptions()) ?>;

// Form object for search
var fgodownlistsrch = currentSearchForm = new ew.Form("fgodownlistsrch");

// Filters
fgodownlistsrch.filterList = <?php echo $godown_list->getFilterList() ?>;

// Init search panel as collapsed
fgodownlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$godown->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($godown_list->TotalRecs > 0 && $godown_list->ExportOptions->visible()) { ?>
<?php $godown_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($godown_list->ImportOptions->visible()) { ?>
<?php $godown_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($godown_list->SearchOptions->visible()) { ?>
<?php $godown_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($godown_list->FilterOptions->visible()) { ?>
<?php $godown_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$godown_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$godown->isExport() && !$godown->CurrentAction) { ?>
<form name="fgodownlistsrch" id="fgodownlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($godown_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fgodownlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="godown">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($godown_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($godown_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $godown_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($godown_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($godown_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($godown_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($godown_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $godown_list->showPageHeader(); ?>
<?php
$godown_list->showMessage();
?>
<?php if ($godown_list->TotalRecs > 0 || $godown->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($godown_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> godown">
<?php if (!$godown->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$godown->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($godown_list->Pager)) $godown_list->Pager = new PrevNextPager($godown_list->StartRec, $godown_list->DisplayRecs, $godown_list->TotalRecs, $godown_list->AutoHidePager) ?>
<?php if ($godown_list->Pager->RecordCount > 0 && $godown_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($godown_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $godown_list->pageUrl() ?>start=<?php echo $godown_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($godown_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $godown_list->pageUrl() ?>start=<?php echo $godown_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $godown_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($godown_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $godown_list->pageUrl() ?>start=<?php echo $godown_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($godown_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $godown_list->pageUrl() ?>start=<?php echo $godown_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $godown_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($godown_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $godown_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $godown_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $godown_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($godown_list->TotalRecs > 0 && (!$godown_list->AutoHidePageSizeSelector || $godown_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="godown">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($godown_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($godown_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($godown_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($godown_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($godown_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($godown->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $godown_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fgodownlist" id="fgodownlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($godown_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $godown_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="godown">
<div id="gmp_godown" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($godown_list->TotalRecs > 0 || $godown->isGridEdit()) { ?>
<table id="tbl_godownlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$godown_list->RowType = ROWTYPE_HEADER;

// Render list options
$godown_list->renderListOptions();

// Render list options (header, left)
$godown_list->ListOptions->render("header", "left");
?>
<?php if ($godown->id->Visible) { // id ?>
	<?php if ($godown->sortUrl($godown->id) == "") { ?>
		<th data-name="id" class="<?php echo $godown->id->headerCellClass() ?>"><div id="elh_godown_id" class="godown_id"><div class="ew-table-header-caption"><?php echo $godown->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $godown->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown->SortUrl($godown->id) ?>',2);"><div id="elh_godown_id" class="godown_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown->grp->Visible) { // grp ?>
	<?php if ($godown->sortUrl($godown->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $godown->grp->headerCellClass() ?>"><div id="elh_godown_grp" class="godown_grp"><div class="ew-table-header-caption"><?php echo $godown->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $godown->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown->SortUrl($godown->grp) ?>',2);"><div id="elh_godown_grp" class="godown_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown->name->Visible) { // name ?>
	<?php if ($godown->sortUrl($godown->name) == "") { ?>
		<th data-name="name" class="<?php echo $godown->name->headerCellClass() ?>"><div id="elh_godown_name" class="godown_name"><div class="ew-table-header-caption"><?php echo $godown->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $godown->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown->SortUrl($godown->name) ?>',2);"><div id="elh_godown_name" class="godown_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($godown->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown->location->Visible) { // location ?>
	<?php if ($godown->sortUrl($godown->location) == "") { ?>
		<th data-name="location" class="<?php echo $godown->location->headerCellClass() ?>"><div id="elh_godown_location" class="godown_location"><div class="ew-table-header-caption"><?php echo $godown->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $godown->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown->SortUrl($godown->location) ?>',2);"><div id="elh_godown_location" class="godown_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown->location->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($godown->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown->incharge->Visible) { // incharge ?>
	<?php if ($godown->sortUrl($godown->incharge) == "") { ?>
		<th data-name="incharge" class="<?php echo $godown->incharge->headerCellClass() ?>"><div id="elh_godown_incharge" class="godown_incharge"><div class="ew-table-header-caption"><?php echo $godown->incharge->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="incharge" class="<?php echo $godown->incharge->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown->SortUrl($godown->incharge) ?>',2);"><div id="elh_godown_incharge" class="godown_incharge">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown->incharge->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown->incharge->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown->incharge->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown->capacity->Visible) { // capacity ?>
	<?php if ($godown->sortUrl($godown->capacity) == "") { ?>
		<th data-name="capacity" class="<?php echo $godown->capacity->headerCellClass() ?>"><div id="elh_godown_capacity" class="godown_capacity"><div class="ew-table-header-caption"><?php echo $godown->capacity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="capacity" class="<?php echo $godown->capacity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown->SortUrl($godown->capacity) ?>',2);"><div id="elh_godown_capacity" class="godown_capacity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown->capacity->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown->capacity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown->capacity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown->code->Visible) { // code ?>
	<?php if ($godown->sortUrl($godown->code) == "") { ?>
		<th data-name="code" class="<?php echo $godown->code->headerCellClass() ?>"><div id="elh_godown_code" class="godown_code"><div class="ew-table-header-caption"><?php echo $godown->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $godown->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown->SortUrl($godown->code) ?>',2);"><div id="elh_godown_code" class="godown_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($godown->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown->status->Visible) { // status ?>
	<?php if ($godown->sortUrl($godown->status) == "") { ?>
		<th data-name="status" class="<?php echo $godown->status->headerCellClass() ?>"><div id="elh_godown_status" class="godown_status"><div class="ew-table-header-caption"><?php echo $godown->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $godown->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown->SortUrl($godown->status) ?>',2);"><div id="elh_godown_status" class="godown_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown->operator->Visible) { // operator ?>
	<?php if ($godown->sortUrl($godown->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $godown->operator->headerCellClass() ?>"><div id="elh_godown_operator" class="godown_operator"><div class="ew-table-header-caption"><?php echo $godown->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $godown->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown->SortUrl($godown->operator) ?>',2);"><div id="elh_godown_operator" class="godown_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown->datetime->Visible) { // datetime ?>
	<?php if ($godown->sortUrl($godown->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $godown->datetime->headerCellClass() ?>"><div id="elh_godown_datetime" class="godown_datetime"><div class="ew-table-header-caption"><?php echo $godown->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $godown->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown->SortUrl($godown->datetime) ?>',2);"><div id="elh_godown_datetime" class="godown_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown->type->Visible) { // type ?>
	<?php if ($godown->sortUrl($godown->type) == "") { ?>
		<th data-name="type" class="<?php echo $godown->type->headerCellClass() ?>"><div id="elh_godown_type" class="godown_type"><div class="ew-table-header-caption"><?php echo $godown->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $godown->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown->SortUrl($godown->type) ?>',2);"><div id="elh_godown_type" class="godown_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($godown->company_id->Visible) { // company_id ?>
	<?php if ($godown->sortUrl($godown->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $godown->company_id->headerCellClass() ?>"><div id="elh_godown_company_id" class="godown_company_id"><div class="ew-table-header-caption"><?php echo $godown->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $godown->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $godown->SortUrl($godown->company_id) ?>',2);"><div id="elh_godown_company_id" class="godown_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $godown->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($godown->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($godown->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$godown_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($godown->ExportAll && $godown->isExport()) {
	$godown_list->StopRec = $godown_list->TotalRecs;
} else {

	// Set the last record to display
	if ($godown_list->TotalRecs > $godown_list->StartRec + $godown_list->DisplayRecs - 1)
		$godown_list->StopRec = $godown_list->StartRec + $godown_list->DisplayRecs - 1;
	else
		$godown_list->StopRec = $godown_list->TotalRecs;
}
$godown_list->RecCnt = $godown_list->StartRec - 1;
if ($godown_list->Recordset && !$godown_list->Recordset->EOF) {
	$godown_list->Recordset->moveFirst();
	$selectLimit = $godown_list->UseSelectLimit;
	if (!$selectLimit && $godown_list->StartRec > 1)
		$godown_list->Recordset->move($godown_list->StartRec - 1);
} elseif (!$godown->AllowAddDeleteRow && $godown_list->StopRec == 0) {
	$godown_list->StopRec = $godown->GridAddRowCount;
}

// Initialize aggregate
$godown->RowType = ROWTYPE_AGGREGATEINIT;
$godown->resetAttributes();
$godown_list->renderRow();
while ($godown_list->RecCnt < $godown_list->StopRec) {
	$godown_list->RecCnt++;
	if ($godown_list->RecCnt >= $godown_list->StartRec) {
		$godown_list->RowCnt++;

		// Set up key count
		$godown_list->KeyCount = $godown_list->RowIndex;

		// Init row class and style
		$godown->resetAttributes();
		$godown->CssClass = "";
		if ($godown->isGridAdd()) {
		} else {
			$godown_list->loadRowValues($godown_list->Recordset); // Load row values
		}
		$godown->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$godown->RowAttrs = array_merge($godown->RowAttrs, array('data-rowindex'=>$godown_list->RowCnt, 'id'=>'r' . $godown_list->RowCnt . '_godown', 'data-rowtype'=>$godown->RowType));

		// Render row
		$godown_list->renderRow();

		// Render list options
		$godown_list->renderListOptions();
?>
	<tr<?php echo $godown->rowAttributes() ?>>
<?php

// Render list options (body, left)
$godown_list->ListOptions->render("body", "left", $godown_list->RowCnt);
?>
	<?php if ($godown->id->Visible) { // id ?>
		<td data-name="id"<?php echo $godown->id->cellAttributes() ?>>
<span id="el<?php echo $godown_list->RowCnt ?>_godown_id" class="godown_id">
<span<?php echo $godown->id->viewAttributes() ?>>
<?php echo $godown->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $godown->grp->cellAttributes() ?>>
<span id="el<?php echo $godown_list->RowCnt ?>_godown_grp" class="godown_grp">
<span<?php echo $godown->grp->viewAttributes() ?>>
<?php echo $godown->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown->name->Visible) { // name ?>
		<td data-name="name"<?php echo $godown->name->cellAttributes() ?>>
<span id="el<?php echo $godown_list->RowCnt ?>_godown_name" class="godown_name">
<span<?php echo $godown->name->viewAttributes() ?>>
<?php echo $godown->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown->location->Visible) { // location ?>
		<td data-name="location"<?php echo $godown->location->cellAttributes() ?>>
<span id="el<?php echo $godown_list->RowCnt ?>_godown_location" class="godown_location">
<span<?php echo $godown->location->viewAttributes() ?>>
<?php echo $godown->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown->incharge->Visible) { // incharge ?>
		<td data-name="incharge"<?php echo $godown->incharge->cellAttributes() ?>>
<span id="el<?php echo $godown_list->RowCnt ?>_godown_incharge" class="godown_incharge">
<span<?php echo $godown->incharge->viewAttributes() ?>>
<?php echo $godown->incharge->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown->capacity->Visible) { // capacity ?>
		<td data-name="capacity"<?php echo $godown->capacity->cellAttributes() ?>>
<span id="el<?php echo $godown_list->RowCnt ?>_godown_capacity" class="godown_capacity">
<span<?php echo $godown->capacity->viewAttributes() ?>>
<?php echo $godown->capacity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown->code->Visible) { // code ?>
		<td data-name="code"<?php echo $godown->code->cellAttributes() ?>>
<span id="el<?php echo $godown_list->RowCnt ?>_godown_code" class="godown_code">
<span<?php echo $godown->code->viewAttributes() ?>>
<?php echo $godown->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown->status->Visible) { // status ?>
		<td data-name="status"<?php echo $godown->status->cellAttributes() ?>>
<span id="el<?php echo $godown_list->RowCnt ?>_godown_status" class="godown_status">
<span<?php echo $godown->status->viewAttributes() ?>>
<?php echo $godown->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $godown->operator->cellAttributes() ?>>
<span id="el<?php echo $godown_list->RowCnt ?>_godown_operator" class="godown_operator">
<span<?php echo $godown->operator->viewAttributes() ?>>
<?php echo $godown->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $godown->datetime->cellAttributes() ?>>
<span id="el<?php echo $godown_list->RowCnt ?>_godown_datetime" class="godown_datetime">
<span<?php echo $godown->datetime->viewAttributes() ?>>
<?php echo $godown->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown->type->Visible) { // type ?>
		<td data-name="type"<?php echo $godown->type->cellAttributes() ?>>
<span id="el<?php echo $godown_list->RowCnt ?>_godown_type" class="godown_type">
<span<?php echo $godown->type->viewAttributes() ?>>
<?php echo $godown->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($godown->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $godown->company_id->cellAttributes() ?>>
<span id="el<?php echo $godown_list->RowCnt ?>_godown_company_id" class="godown_company_id">
<span<?php echo $godown->company_id->viewAttributes() ?>>
<?php echo $godown->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$godown_list->ListOptions->render("body", "right", $godown_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$godown->isGridAdd())
		$godown_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$godown->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($godown_list->Recordset)
	$godown_list->Recordset->Close();
?>
<?php if (!$godown->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$godown->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($godown_list->Pager)) $godown_list->Pager = new PrevNextPager($godown_list->StartRec, $godown_list->DisplayRecs, $godown_list->TotalRecs, $godown_list->AutoHidePager) ?>
<?php if ($godown_list->Pager->RecordCount > 0 && $godown_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($godown_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $godown_list->pageUrl() ?>start=<?php echo $godown_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($godown_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $godown_list->pageUrl() ?>start=<?php echo $godown_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $godown_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($godown_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $godown_list->pageUrl() ?>start=<?php echo $godown_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($godown_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $godown_list->pageUrl() ?>start=<?php echo $godown_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $godown_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($godown_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $godown_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $godown_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $godown_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($godown_list->TotalRecs > 0 && (!$godown_list->AutoHidePageSizeSelector || $godown_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="godown">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($godown_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($godown_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($godown_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($godown_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($godown_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($godown->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $godown_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($godown_list->TotalRecs == 0 && !$godown->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $godown_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$godown_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$godown->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$godown->isExport()) { ?>
<script>
ew.scrollableTable("gmp_godown", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$godown_list->terminate();
?>