<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$godown_view = new godown_view();

// Run the page
$godown_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$godown_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$godown->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fgodownview = currentForm = new ew.Form("fgodownview", "view");

// Form_CustomValidate event
fgodownview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fgodownview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fgodownview.lists["x_incharge"] = <?php echo $godown_view->incharge->Lookup->toClientList() ?>;
fgodownview.lists["x_incharge"].options = <?php echo JsonEncode($godown_view->incharge->lookupOptions()) ?>;
fgodownview.lists["x_status"] = <?php echo $godown_view->status->Lookup->toClientList() ?>;
fgodownview.lists["x_status"].options = <?php echo JsonEncode($godown_view->status->options(FALSE, TRUE)) ?>;
fgodownview.lists["x_operator"] = <?php echo $godown_view->operator->Lookup->toClientList() ?>;
fgodownview.lists["x_operator"].options = <?php echo JsonEncode($godown_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$godown->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $godown_view->ExportOptions->render("body") ?>
<?php $godown_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $godown_view->showPageHeader(); ?>
<?php
$godown_view->showMessage();
?>
<form name="fgodownview" id="fgodownview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($godown_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $godown_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="godown">
<input type="hidden" name="modal" value="<?php echo (int)$godown_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($godown->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $godown_view->TableLeftColumnClass ?>"><span id="elh_godown_id"><?php echo $godown->id->caption() ?></span></td>
		<td data-name="id"<?php echo $godown->id->cellAttributes() ?>>
<span id="el_godown_id">
<span<?php echo $godown->id->viewAttributes() ?>>
<?php echo $godown->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $godown_view->TableLeftColumnClass ?>"><span id="elh_godown_grp"><?php echo $godown->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $godown->grp->cellAttributes() ?>>
<span id="el_godown_grp">
<span<?php echo $godown->grp->viewAttributes() ?>>
<?php echo $godown->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $godown_view->TableLeftColumnClass ?>"><span id="elh_godown_name"><?php echo $godown->name->caption() ?></span></td>
		<td data-name="name"<?php echo $godown->name->cellAttributes() ?>>
<span id="el_godown_name">
<span<?php echo $godown->name->viewAttributes() ?>>
<?php echo $godown->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown->location->Visible) { // location ?>
	<tr id="r_location">
		<td class="<?php echo $godown_view->TableLeftColumnClass ?>"><span id="elh_godown_location"><?php echo $godown->location->caption() ?></span></td>
		<td data-name="location"<?php echo $godown->location->cellAttributes() ?>>
<span id="el_godown_location">
<span<?php echo $godown->location->viewAttributes() ?>>
<?php echo $godown->location->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown->incharge->Visible) { // incharge ?>
	<tr id="r_incharge">
		<td class="<?php echo $godown_view->TableLeftColumnClass ?>"><span id="elh_godown_incharge"><?php echo $godown->incharge->caption() ?></span></td>
		<td data-name="incharge"<?php echo $godown->incharge->cellAttributes() ?>>
<span id="el_godown_incharge">
<span<?php echo $godown->incharge->viewAttributes() ?>>
<?php echo $godown->incharge->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown->capacity->Visible) { // capacity ?>
	<tr id="r_capacity">
		<td class="<?php echo $godown_view->TableLeftColumnClass ?>"><span id="elh_godown_capacity"><?php echo $godown->capacity->caption() ?></span></td>
		<td data-name="capacity"<?php echo $godown->capacity->cellAttributes() ?>>
<span id="el_godown_capacity">
<span<?php echo $godown->capacity->viewAttributes() ?>>
<?php echo $godown->capacity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $godown_view->TableLeftColumnClass ?>"><span id="elh_godown_code"><?php echo $godown->code->caption() ?></span></td>
		<td data-name="code"<?php echo $godown->code->cellAttributes() ?>>
<span id="el_godown_code">
<span<?php echo $godown->code->viewAttributes() ?>>
<?php echo $godown->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $godown_view->TableLeftColumnClass ?>"><span id="elh_godown_status"><?php echo $godown->status->caption() ?></span></td>
		<td data-name="status"<?php echo $godown->status->cellAttributes() ?>>
<span id="el_godown_status">
<span<?php echo $godown->status->viewAttributes() ?>>
<?php echo $godown->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $godown_view->TableLeftColumnClass ?>"><span id="elh_godown_operator"><?php echo $godown->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $godown->operator->cellAttributes() ?>>
<span id="el_godown_operator">
<span<?php echo $godown->operator->viewAttributes() ?>>
<?php echo $godown->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $godown_view->TableLeftColumnClass ?>"><span id="elh_godown_datetime"><?php echo $godown->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $godown->datetime->cellAttributes() ?>>
<span id="el_godown_datetime">
<span<?php echo $godown->datetime->viewAttributes() ?>>
<?php echo $godown->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $godown_view->TableLeftColumnClass ?>"><span id="elh_godown_type"><?php echo $godown->type->caption() ?></span></td>
		<td data-name="type"<?php echo $godown->type->cellAttributes() ?>>
<span id="el_godown_type">
<span<?php echo $godown->type->viewAttributes() ?>>
<?php echo $godown->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($godown->company_id->Visible) { // company_id ?>
	<tr id="r_company_id">
		<td class="<?php echo $godown_view->TableLeftColumnClass ?>"><span id="elh_godown_company_id"><?php echo $godown->company_id->caption() ?></span></td>
		<td data-name="company_id"<?php echo $godown->company_id->cellAttributes() ?>>
<span id="el_godown_company_id">
<span<?php echo $godown->company_id->viewAttributes() ?>>
<?php echo $godown->company_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$godown_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$godown->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$godown_view->terminate();
?>